import datetime
import enum
import os
import pathlib
from collections.abc import Callable, Iterable, Iterator, Mapping, Sequence
from typing import Annotated, Any, Generic, Literal, Optional, Protocol, TypeVar, Union, overload

import dimod.sampleset
import numpy
import numpy.typing
import typing_extensions
from typing_extensions import Buffer, TypeAlias

from . import _backward as _backward
from ._backward import BinaryIntMatrix as BinaryIntMatrix
from ._backward import BinaryIntPoly as BinaryIntPoly
from ._backward import BinaryIntPolyArray as BinaryIntPolyArray
from ._backward import BinaryIntQuadraticModel as BinaryIntQuadraticModel
from ._backward import BinaryIntSymbolGenerator as BinaryIntSymbolGenerator
from ._backward import BinaryMatrix as BinaryMatrix
from ._backward import BinaryPoly as BinaryPoly
from ._backward import BinaryPolyArray as BinaryPolyArray
from ._backward import BinaryQuadraticModel as BinaryQuadraticModel
from ._backward import BinarySymbolGenerator as BinarySymbolGenerator
from ._backward import InequalityFormulation as InequalityFormulation
from ._backward import IsingIntMatrix as IsingIntMatrix
from ._backward import IsingIntPoly as IsingIntPoly
from ._backward import IsingIntPolyArray as IsingIntPolyArray
from ._backward import IsingIntQuadraticModel as IsingIntQuadraticModel
from ._backward import IsingIntSymbolGenerator as IsingIntSymbolGenerator
from ._backward import IsingMatrix as IsingMatrix
from ._backward import IsingPoly as IsingPoly
from ._backward import IsingPolyArray as IsingPolyArray
from ._backward import IsingQuadraticModel as IsingQuadraticModel
from ._backward import IsingSymbolGenerator as IsingSymbolGenerator
from ._backward import QuadraticModel as QuadraticModel
from ._backward import Solver as Solver
from ._backward import SolverResult as SolverResult
from ._backward import SolverSolution as SolverSolution
from ._backward import SymbolGenerator as SymbolGenerator
from ._backward import convert_to_matrix as convert_to_matrix
from ._backward import decode_solution as decode_solution
from ._backward import gen_symbols as gen_symbols
from ._backward import intersection as intersection
from ._backward import pair_sum as pair_sum
from ._backward import product as product
from ._backward import replace_all as replace_all
from ._backward import sum_poly as sum_poly
from ._backward import symmetric_difference as symmetric_difference
from ._backward import union as union

class DLPackBuffer(Protocol):
    def __dlpack__(self) -> object: ...

NDArray: TypeAlias = Union[Buffer, DLPackBuffer]

EllipsisType = type(...)

class AcceptableDegrees:
    def __init__(
        self,
        objective: dict[
            Union[VariableType, Literal["Binary", "Ising", "Integer", "Real"]],
            Union[Degree, Literal["Zero", "Linear", "Quadratic", "Cubic", "Quartic", "HighOrder"], int],
        ] = ...,
        equality_constraints: dict[
            Union[VariableType, Literal["Binary", "Ising", "Integer", "Real"]],
            Union[Degree, Literal["Zero", "Linear", "Quadratic", "Cubic", "Quartic", "HighOrder"], int],
        ] = ...,
        inequality_constraints: dict[
            Union[VariableType, Literal["Binary", "Ising", "Integer", "Real"]],
            Union[Degree, Literal["Zero", "Linear", "Quadratic", "Cubic", "Quartic", "HighOrder"], int],
        ] = ...,
    ) -> None: ...
    @property
    def objective(self) -> dict[VariableType, Degree]:
        """objective

        Returns:
            dict[amplify.VariableType, amplify.Degree]:
        """

    @property
    def equality_constraints(self) -> dict[VariableType, Degree]:
        """equality_constraints

        Returns:
            dict[amplify.VariableType, amplify.Degree]:
        """

    @property
    def inequality_constraints(self) -> dict[VariableType, Degree]:
        """inequality_constraints

        Returns:
            dict[amplify.VariableType, amplify.Degree]:
        """

class AmplifyClient:
    """Base class of all clients in the Amplify SDK"""

class Constraint:
    @overload
    def __init__(
        self, left: Poly, bounds: tuple[Optional[float], Optional[float]], penalty: Poly, label: str = ""
    ) -> None: ...
    @overload
    def __init__(self, left: Poly, eq: float, penalty: Poly, label: str = "") -> None: ...
    @overload
    def __init__(self, left: Poly, le: float, penalty: Poly, label: str = "") -> None: ...
    @overload
    def __init__(self, left: Poly, ge: float, penalty: Poly, label: str = "") -> None: ...
    @property
    def weight(self) -> float:
        """weight

        Returns:
            float:
        """

    @weight.setter
    def weight(self, arg: float, /) -> None:
        """
        Args:
            arg (float)
        """

    @property
    def label(self) -> str:
        """label

        Returns:
            str:
        """

    @label.setter
    def label(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    def __eq__(self, arg: object, /) -> bool: ...
    def __ne__(self, arg: object, /) -> bool: ...
    def __mul__(self, arg: float, /) -> Constraint: ...
    def __rmul__(self, arg: float, /) -> Constraint: ...
    def __imul__(self, arg: float, /) -> Constraint: ...
    def __truediv__(self, arg: float, /) -> Constraint: ...
    def __itruediv__(self, arg: float, /) -> Constraint: ...
    def __add__(self, arg: Constraint, /) -> ConstraintList: ...
    def __radd__(self, arg: int, /) -> Constraint: ...
    @property
    def penalty(self) -> Poly:
        """penalty

        Returns:
            amplify.Poly:
        """

    @property
    def conditional(
        self,
    ) -> tuple[Poly, Literal["EQ", "GE", "GT", "LE", "LT", "BW"], Union[float, tuple[float, float]]]:
        """conditional

        Returns:
            tuple[amplify.Poly, typing.Literal['EQ', 'GE', 'GT', 'LE', 'LT', 'BW'], typing.Union[float, tuple[float, float]]]:
        """

    @overload
    def is_satisfied(self, values: Values) -> bool: ...
    @overload
    def is_satisfied(self, mapping: Union[Mapping[Poly, Union[float]], Mapping[Variable, Union[float]]]) -> bool:
        """is_satisfied

        .. admonition:: Overload 1.

            Args:
                * values (amplify.Values)

            Returns:
                bool:

        .. admonition:: Overload 2.

            Args:
                * mapping (typing.Union[collections.abc.Mapping[amplify.Poly, typing.Union[float]], collections.abc.Mapping[amplify.Variable, typing.Union[float]]])

            Returns:
                bool:
        """

class ConstraintList:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg: Sequence[Constraint]) -> None: ...
    @overload
    def __init__(self, arg: Iterable[Constraint]) -> None: ...
    def __eq__(self, arg: object, /) -> bool: ...
    def __ne__(self, arg: object, /) -> bool: ...
    @overload
    def __add__(self, arg: ConstraintList, /) -> ConstraintList: ...
    @overload
    def __add__(self, arg: Constraint, /) -> ConstraintList: ...
    @overload
    def __radd__(self, arg: Constraint, /) -> ConstraintList: ...
    @overload
    def __radd__(self, arg: int, /) -> ConstraintList: ...
    @overload
    def __iadd__(self, arg: ConstraintList, /) -> ConstraintList: ...
    @overload
    def __iadd__(self, arg: Constraint, /) -> ConstraintList: ...
    def __mul__(self, arg: float, /) -> ConstraintList: ...
    def __rmul__(self, arg: float, /) -> ConstraintList: ...
    def __imul__(self, arg: float, /) -> ConstraintList: ...
    def __truediv__(self, arg: float, /) -> ConstraintList: ...
    def __itruediv__(self, arg: float, /) -> ConstraintList: ...
    def __len__(self) -> int: ...
    def __getitem__(self, key: int) -> Constraint: ...
    def __setitem__(self, key: int, value: Constraint) -> None: ...
    def __copy__(self) -> ConstraintList: ...
    def __deepcopy__(self, memo: Optional[object] = None) -> ConstraintList: ...

    class Iterator:
        def __iter__(self) -> ConstraintList.Iterator: ...
        def __next__(self) -> Constraint: ...

    def __iter__(self) -> ConstraintList.Iterator: ...
    def append(self, value: Constraint) -> None:
        """append

        Args:
            value (amplify.Constraint)
        """

    def clear(self) -> None:
        """clear"""

    def extend(self, sequence: Sequence[Constraint]) -> None:
        """extend

        Args:
            sequence (collections.abc.Sequence[amplify.Constraint])
        """

    def insert(self, index: int, value: Constraint) -> None:
        """insert

        Args:
            index (int)
            value (amplify.Constraint)
        """

    def remove(self, value: Constraint) -> None:
        """remove

        Args:
            value (amplify.Constraint)
        """

    def pop(self, index: Optional[int] = None) -> Constraint:
        """pop

        Args:
            index (typing.Optional[int]): Defaults to ``None``.

        Returns:
            amplify.Constraint:
        """

    def count(self, value: Constraint) -> int:
        """count

        Args:
            value (amplify.Constraint)

        Returns:
            int:
        """

    @overload
    def index(self, value: Constraint) -> int: ...
    @overload
    def index(self, value: Constraint, start: int) -> int: ...
    @overload
    def index(self, value: Constraint, start: int, end: int) -> int:
        """index

        .. admonition:: Overload 1.

            Args:
                * value (amplify.Constraint)

            Returns:
                int:

        .. admonition:: Overload 2.

            Args:
                * value (amplify.Constraint)
                * start (int)

            Returns:
                int:

        .. admonition:: Overload 3.

            Args:
                * value (amplify.Constraint)
                * start (int)
                * end (int)

            Returns:
                int:
        """

    def reverse(self) -> None:
        """reverse"""

    def copy(self) -> ConstraintList:
        """copy

        Returns:
            amplify.ConstraintList:
        """

class DASClient(AmplifyClient):
    def __init__(self) -> None: ...

    class Parameters:
        class Schedule:
            @property
            def algorithm(self) -> Optional[DASClient.Algorithm]:
                """algorithm

                Returns:
                    typing.Optional[amplify.DASClient.Algorithm]:
                """

            @algorithm.setter
            def algorithm(self, arg: Optional[Union[Literal["ALL", "SA", "QMC", "PT"], DASClient.Algorithm]]) -> None:
                """
                Args:
                    arg (typing.Optional[typing.Union[typing.Literal['ALL', 'SA', 'QMC', 'PT'], amplify.DASClient.Algorithm]])
                """

            @property
            def anneal_time(self) -> Optional[int]:
                """anneal_time

                Returns:
                    typing.Optional[int]:
                """

            @anneal_time.setter
            def anneal_time(self, arg: Optional[int]) -> None:
                """
                Args:
                    arg (typing.Optional[int])
                """

            @property
            def temper(self) -> Optional[list[float]]:
                """temper

                Returns:
                    typing.Optional[list[float]]:
                """

            @temper.setter
            def temper(self, arg: Optional[Sequence[float]]) -> None:
                """
                Args:
                    arg (typing.Optional[collections.abc.Sequence[float]])
                """

            @property
            def gamma(self) -> Optional[list[float]]:
                """gamma

                Returns:
                    typing.Optional[list[float]]:
                """

            @gamma.setter
            def gamma(self, arg: Optional[Sequence[float]]) -> None:
                """
                Args:
                    arg (typing.Optional[collections.abc.Sequence[float]])
                """

        @property
        def auto(self) -> Optional[bool]:
            """auto

            Returns:
                typing.Optional[bool]:
            """

        @auto.setter
        def auto(self, arg: Optional[bool]) -> None:
            """
            Args:
                arg (typing.Optional[bool])
            """

        @property
        def algorithm(self) -> Optional[DASClient.Algorithm]:
            """algorithm

            Returns:
                typing.Optional[amplify.DASClient.Algorithm]:
            """

        @algorithm.setter
        def algorithm(self, arg: Optional[Union[str, DASClient.Algorithm]]) -> None:
            """
            Args:
                arg (typing.Optional[typing.Union[str, amplify.DASClient.Algorithm]])
            """

        @property
        def trotter(self) -> Optional[int]:
            """trotter

            Returns:
                typing.Optional[int]:
            """

        @trotter.setter
        def trotter(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def anneal_time(self) -> Optional[int]:
            """anneal_time

            Returns:
                typing.Optional[int]:
            """

        @anneal_time.setter
        def anneal_time(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def repetition(self) -> Optional[int]:
            """repetition

            Returns:
                typing.Optional[int]:
            """

        @repetition.setter
        def repetition(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def proc(self) -> Optional[DASClient.Proc]:
            """proc

            Returns:
                typing.Optional[amplify.DASClient.Proc]:
            """

        @proc.setter
        def proc(self, arg: Optional[Union[Literal["CPU", "GPU"], DASClient.Proc]]) -> None:
            """
            Args:
                arg (typing.Optional[typing.Union[typing.Literal['CPU', 'GPU'], amplify.DASClient.Proc]])
            """

        @property
        def schedule_type(self) -> Optional[DASClient.ScheduleType]:
            """schedule_type

            Returns:
                typing.Optional[amplify.DASClient.ScheduleType]:
            """

        @schedule_type.setter
        def schedule_type(
            self, arg: Optional[Union[Literal["Linear", "Power", "Expo"], DASClient.ScheduleType]]
        ) -> None:
            """
            Args:
                arg (typing.Optional[typing.Union[typing.Literal['Linear', 'Power', 'Expo'], amplify.DASClient.ScheduleType]])
            """

        @property
        def sa_temper(self) -> Optional[float]:
            """sa_temper

            Returns:
                typing.Optional[float]:
            """

        @sa_temper.setter
        def sa_temper(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def qmc_gamma(self) -> Optional[float]:
            """qmc_gamma

            Returns:
                typing.Optional[float]:
            """

        @qmc_gamma.setter
        def qmc_gamma(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def qmc_temper(self) -> Optional[float]:
            """qmc_temper

            Returns:
                typing.Optional[float]:
            """

        @qmc_temper.setter
        def qmc_temper(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def decrease_factor(self) -> Optional[float]:
            """decrease_factor

            Returns:
                typing.Optional[float]:
            """

        @decrease_factor.setter
        def decrease_factor(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def pt_temper(self) -> Optional[float]:
            """pt_temper

            Returns:
                typing.Optional[float]:
            """

        @pt_temper.setter
        def pt_temper(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def pt_factor(self) -> Optional[float]:
            """pt_factor

            Returns:
                typing.Optional[float]:
            """

        @pt_factor.setter
        def pt_factor(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def schedule(self) -> DASClient.Parameters.Schedule:
            """schedule

            Returns:
                amplify.DASClient.Parameters.Schedule:
            """

    class Algorithm(enum.Enum):
        ALL = 0
        SA = 1
        QMC = 2
        PT = 3

    class ScheduleType(enum.Enum):
        Linear = 0
        Power = 1
        Expo = 2

    class Proc(enum.Enum):
        CPU = 0
        GPU = 1

    class Result:
        @property
        def execution_time(self) -> datetime.timedelta:
            """execution_time

            Returns:
                datetime.timedelta:
            """

        @property
        def energy(self) -> float:
            """energy

            Returns:
                float:
            """

        @property
        def spins(self) -> list[int]:
            """spins

            Returns:
                list[int]:
            """

    @property
    def write_request_data(self) -> Optional[pathlib.Path]:
        """write_request_data

        Returns:
            typing.Optional[pathlib.Path]:
        """

    @write_request_data.setter
    def write_request_data(self, arg: Optional[str | os.PathLike]) -> None:
        """
        Args:
            arg (typing.Optional[str | os.PathLike])
        """

    @property
    def write_response_data(self) -> Optional[pathlib.Path]:
        """write_response_data

        Returns:
            typing.Optional[pathlib.Path]:
        """

    @write_response_data.setter
    def write_response_data(self, arg: Optional[str | os.PathLike]) -> None:
        """
        Args:
            arg (typing.Optional[str | os.PathLike])
        """

    @property
    def library_path(self) -> Optional[str]:
        """library_path

        Returns:
            typing.Optional[str]:
        """

    @property
    def parameters(self) -> DASClient.Parameters:
        """parameters

        Returns:
            amplify.DASClient.Parameters:
        """

    @property
    def version(self) -> str:
        """version

        Returns:
            str:
        """

    @property
    def acceptable_degrees(self) -> AcceptableDegrees:
        """acceptable_degrees

        Returns:
            amplify.AcceptableDegrees:
        """

    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[False] = False) -> DASClient.Result: ...
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[True]) -> None:
        """solve

        .. admonition:: Overload 1.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * dry_run (typing.Literal[False]): Defaults to ``False``.

            Returns:
                amplify.DASClient.Result:

        .. admonition:: Overload 2.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * dry_run (typing.Literal[True])
        """

class DWaveClientParameters:
    def __init__(self) -> None: ...
    def __getattr__(self, arg: object, /) -> Any: ...
    def __setattr__(self, arg0: object, arg1: object, /) -> None: ...

class DWaveSamplerClient(AmplifyClient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, token: str = "", solver: str = "", url: str = "", proxy: Optional[str] = None) -> None: ...
    @property
    def url(self) -> str:
        """url

        Returns:
            str:
        """

    @url.setter
    def url(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def token(self) -> str:
        """token

        Returns:
            str:
        """

    @token.setter
    def token(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def solver(self) -> str:
        """solver

        Returns:
            str:
        """

    @solver.setter
    def solver(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def proxy(self) -> Optional[str]:
        """proxy

        Returns:
            typing.Optional[str]:
        """

    @proxy.setter
    def proxy(self, arg: Optional[str]) -> None:
        """
        Args:
            arg (typing.Optional[str])
        """

    @property
    def compress_qpu_problem_data(self) -> Optional[bool]:
        """compress_qpu_problem_data

        Returns:
            typing.Optional[bool]:
        """

    @compress_qpu_problem_data.setter
    def compress_qpu_problem_data(self, arg: Optional[bool]) -> None:
        """
        Args:
            arg (typing.Optional[bool])
        """

    @property
    def write_request_data(self) -> Optional[pathlib.Path]:
        """write_request_data

        Returns:
            typing.Optional[pathlib.Path]:
        """

    @write_request_data.setter
    def write_request_data(self, arg: Optional[str | os.PathLike]) -> None:
        """
        Args:
            arg (typing.Optional[str | os.PathLike])
        """

    @property
    def write_response_data(self) -> Optional[pathlib.Path]:
        """write_response_data

        Returns:
            typing.Optional[pathlib.Path]:
        """

    @write_response_data.setter
    def write_response_data(self, arg: Optional[str | os.PathLike]) -> None:
        """
        Args:
            arg (typing.Optional[str | os.PathLike])
        """

    @property
    def parameters(self) -> DWaveClientParameters:
        """parameters

        Returns:
            amplify.DWaveClientParameters:
        """

    @property
    def solver_names(self) -> list[str]:
        """solver_names

        Returns:
            list[str]:
        """

    @property
    def properties(self) -> dict[str, Any]:
        """properties

        Returns:
            dict[str, typing.Any]:
        """

    @property
    def version(self) -> str:
        """version

        Returns:
            str:
        """

    @property
    def acceptable_degrees(self) -> AcceptableDegrees:
        """acceptable_degrees

        Returns:
            amplify.AcceptableDegrees:
        """

    @overload
    def solve(self, objective: Poly, dry_run: Literal[False] = False) -> dimod.sampleset.SampleSet: ...
    @overload
    def solve(self, objective: Poly, dry_run: Literal[True]) -> None:
        """solve

        .. admonition:: Overload 1.

            Args:
                * objective (amplify.Poly)
                * dry_run (typing.Literal[False]): Defaults to ``False``.

            Returns:
                dimod.sampleset.SampleSet:

        .. admonition:: Overload 2.

            Args:
                * objective (amplify.Poly)
                * dry_run (typing.Literal[True])
        """

    @property
    def graph(self) -> Graph:
        """graph

        Returns:
            amplify.Graph:
        """

class Degree(enum.Enum):
    Zero = 0
    Linear = 1
    Quadratic = 2
    Cubic = 3
    Quartic = 4
    HighOrder = 5

class Dim:
    """Base class of dimension type of PolyArray"""

class Dim0(Dim):
    """0D PolyArray"""

class Dim1(Dim):
    """1D PolyArray"""

class Dim2(Dim):
    """2D PolyArray"""

class Dim3(Dim):
    """3D PolyArray"""

class Dim4(Dim):
    """4D PolyArray"""

class EmbeddingMethod(enum.Enum):
    Default = 0
    Minor = 1
    Clique = 2
    Parallel = 3

class FixstarsClient(AmplifyClient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, token: str = "", url: str = "", proxy: Optional[str] = None) -> None: ...

    class Parameters:
        class Outputs:
            @property
            def spins(self) -> Optional[bool]:
                """spins

                Returns:
                    typing.Optional[bool]:
                """

            @spins.setter
            def spins(self, arg: Optional[bool]) -> None:
                """
                Args:
                    arg (typing.Optional[bool])
                """

            @property
            def energies(self) -> Optional[bool]:
                """energies

                Returns:
                    typing.Optional[bool]:
                """

            @energies.setter
            def energies(self, arg: Optional[bool]) -> None:
                """
                Args:
                    arg (typing.Optional[bool])
                """

            @property
            def sort(self) -> Optional[bool]:
                """sort

                Returns:
                    typing.Optional[bool]:
                """

            @sort.setter
            def sort(self, arg: Optional[bool]) -> None:
                """
                Args:
                    arg (typing.Optional[bool])
                """

            @property
            def duplicate(self) -> Optional[bool]:
                """duplicate

                Returns:
                    typing.Optional[bool]:
                """

            @duplicate.setter
            def duplicate(self, arg: Optional[bool]) -> None:
                """
                Args:
                    arg (typing.Optional[bool])
                """

            @property
            def feasibilities(self) -> Optional[bool]:
                """feasibilities

                Returns:
                    typing.Optional[bool]:
                """

            @feasibilities.setter
            def feasibilities(self, arg: Optional[bool]) -> None:
                """
                Args:
                    arg (typing.Optional[bool])
                """

            @property
            def num_outputs(self) -> Optional[int]:
                """num_outputs

                Returns:
                    typing.Optional[int]:
                """

            @num_outputs.setter
            def num_outputs(self, arg: Optional[int]) -> None:
                """
                Args:
                    arg (typing.Optional[int])
                """

        @property
        def timeout(self) -> Optional[datetime.timedelta]:
            """timeout

            Returns:
                typing.Optional[datetime.timedelta]:
            """

        @timeout.setter
        def timeout(self, arg: Optional[Union[int, datetime.timedelta]]) -> None:
            """
            Args:
                arg (typing.Optional[typing.Union[int, datetime.timedelta]])
            """

        @property
        def num_gpus(self) -> Optional[int]:
            """num_gpus

            Returns:
                typing.Optional[int]:
            """

        @num_gpus.setter
        def num_gpus(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def penalty_calibration(self) -> Optional[bool]:
            """penalty_calibration

            Returns:
                typing.Optional[bool]:
            """

        @penalty_calibration.setter
        def penalty_calibration(self, arg: Optional[bool]) -> None:
            """
            Args:
                arg (typing.Optional[bool])
            """

        @property
        def outputs(self) -> FixstarsClient.Parameters.Outputs:
            """outputs

            Returns:
                amplify.FixstarsClient.Parameters.Outputs:
            """

    class Result:
        class ExecutionTime:
            @property
            def annealing_time(self) -> datetime.timedelta:
                """annealing_time

                Returns:
                    datetime.timedelta:
                """

            @property
            def queue_time(self) -> datetime.timedelta:
                """queue_time

                Returns:
                    datetime.timedelta:
                """

            @property
            def cpu_time(self) -> datetime.timedelta:
                """cpu_time

                Returns:
                    datetime.timedelta:
                """

            @property
            def time_stamps(self) -> list[datetime.timedelta]:
                """time_stamps

                Returns:
                    list[datetime.timedelta]:
                """

        class ExecutionParameters:
            @property
            def num_gpus(self) -> int:
                """num_gpus

                Returns:
                    int:
                """

            @property
            def timeout(self) -> datetime.timedelta:
                """timeout

                Returns:
                    datetime.timedelta:
                """

            @property
            def num_iterations(self) -> int:
                """num_iterations

                Returns:
                    int:
                """

            @property
            def penalty_calibration(self) -> bool:
                """penalty_calibration

                Returns:
                    bool:
                """

            @property
            def penalty_multipliers(
                self,
            ) -> Annotated[numpy.typing.NDArray[numpy.float64], {"dtype": "float64", "writable": False}]:
                """penalty_multipliers

                Returns:
                    numpy.ndarray:
                """

            @property
            def version(self) -> str:
                """version

                Returns:
                    str:
                """

        @property
        def execution_time(self) -> FixstarsClient.Result.ExecutionTime:
            """execution_time

            Returns:
                amplify.FixstarsClient.Result.ExecutionTime:
            """

        @property
        def energies(self) -> Annotated[numpy.typing.NDArray[numpy.float64], {"dtype": "float64", "writable": False}]:
            """energies

            Returns:
                numpy.ndarray:
            """

        @property
        def spins(self) -> list[Annotated[numpy.typing.NDArray[numpy.int8], {"dtype": "int8", "writable": False}]]:
            """spins

            Returns:
                list[numpy.ndarray[dtype=int8, writable=False]]:
            """

        @property
        def feasibilities(self) -> Annotated[numpy.typing.NDArray[numpy.bool_], {"dtype": "bool", "writable": False}]:
            """feasibilities

            Returns:
                numpy.ndarray:
            """

        @property
        def execution_parameters(self) -> FixstarsClient.Result.ExecutionParameters:
            """execution_parameters

            Returns:
                amplify.FixstarsClient.Result.ExecutionParameters:
            """

        @property
        def message(self) -> str:
            """message

            Returns:
                str:
            """

    @property
    def url(self) -> str:
        """url

        Returns:
            str:
        """

    @url.setter
    def url(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def token(self) -> str:
        """token

        Returns:
            str:
        """

    @token.setter
    def token(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def proxy(self) -> Optional[str]:
        """proxy

        Returns:
            typing.Optional[str]:
        """

    @proxy.setter
    def proxy(self, arg: Optional[str]) -> None:
        """
        Args:
            arg (typing.Optional[str])
        """

    @property
    def compression(self) -> bool:
        """compression

        Returns:
            bool:
        """

    @compression.setter
    def compression(self, arg: bool, /) -> None:
        """
        Args:
            arg (bool)
        """

    @property
    def write_request_data(self) -> Optional[pathlib.Path]:
        """write_request_data

        Returns:
            typing.Optional[pathlib.Path]:
        """

    @write_request_data.setter
    def write_request_data(self, arg: Optional[str | os.PathLike]) -> None:
        """
        Args:
            arg (typing.Optional[str | os.PathLike])
        """

    @property
    def write_response_data(self) -> Optional[pathlib.Path]:
        """write_response_data

        Returns:
            typing.Optional[pathlib.Path]:
        """

    @write_response_data.setter
    def write_response_data(self, arg: Optional[str | os.PathLike]) -> None:
        """
        Args:
            arg (typing.Optional[str | os.PathLike])
        """

    @property
    def parameters(self) -> FixstarsClient.Parameters:
        """parameters

        Returns:
            amplify.FixstarsClient.Parameters:
        """

    @property
    def version(self) -> str:
        """version

        Returns:
            str:
        """

    @property
    def acceptable_degrees(self) -> AcceptableDegrees:
        """acceptable_degrees

        Returns:
            amplify.AcceptableDegrees:
        """

    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[False] = False) -> FixstarsClient.Result: ...
    @overload
    def solve(
        self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[False] = False
    ) -> FixstarsClient.Result: ...
    @overload
    def solve(
        self,
        objective: Union[Poly, Matrix],
        constraint: Union[Constraint, ConstraintList],
        dry_run: Literal[False] = False,
    ) -> FixstarsClient.Result: ...
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(
        self, objective: Union[Poly, Matrix], constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]
    ) -> None:
        """solve

        .. admonition:: Overload 1.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * dry_run (typing.Literal[False]): Defaults to ``False``.

            Returns:
                amplify.FixstarsClient.Result:

        .. admonition:: Overload 2.

            Args:
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[False]): Defaults to ``False``.

            Returns:
                amplify.FixstarsClient.Result:

        .. admonition:: Overload 3.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[False]): Defaults to ``False``.

            Returns:
                amplify.FixstarsClient.Result:

        .. admonition:: Overload 4.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * dry_run (typing.Literal[True])

        .. admonition:: Overload 5.

            Args:
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[True])

        .. admonition:: Overload 6.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[True])
        """

class FujitsuDA3cClient(FujitsuDA4Client):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(
        self, token: str = "", type_id: Optional[str] = None, url: str = "", proxy: Optional[str] = None
    ) -> None: ...

class FujitsuDA4Client(AmplifyClient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(
        self, token: str = "", type_id: Optional[str] = None, url: str = "", proxy: Optional[str] = None
    ) -> None: ...

    class Progress:
        @property
        def energy(self) -> float:
            """energy

            Returns:
                float:
            """

        @property
        def penalty_energy(self) -> float:
            """penalty_energy

            Returns:
                float:
            """

        @property
        def time(self) -> datetime.timedelta:
            """time

            Returns:
                datetime.timedelta:
            """

    class QuboSolution:
        @property
        def energy(self) -> float:
            """energy

            Returns:
                float:
            """

        @property
        def penalty_energy(self) -> float:
            """penalty_energy

            Returns:
                float:
            """

        @property
        def frequency(self) -> int:
            """frequency

            Returns:
                int:
            """

        @property
        def configuration(self) -> dict[str, bool]:
            """configuration

            Returns:
                dict[str, bool]:
            """

    class SolverTiming:
        @property
        def solve_time(self) -> datetime.timedelta:
            """solve_time

            Returns:
                datetime.timedelta:
            """

        @property
        def total_elapsed_time(self) -> datetime.timedelta:
            """total_elapsed_time

            Returns:
                datetime.timedelta:
            """

    class QuboSolutionList:
        @property
        def progress(self) -> list[FujitsuDA4Client.Progress]:
            """progress

            Returns:
                list[amplify.FujitsuDA4Client.Progress]:
            """

        @property
        def result_status(self) -> bool:
            """result_status

            Returns:
                bool:
            """

        @property
        def solutions(self) -> list[FujitsuDA4Client.QuboSolution]:
            """solutions

            Returns:
                list[amplify.FujitsuDA4Client.QuboSolution]:
            """

        @property
        def timing(self) -> FujitsuDA4Client.SolverTiming:
            """timing

            Returns:
                amplify.FujitsuDA4Client.SolverTiming:
            """

    class JobStatus(enum.Enum):
        Done = 0
        Running = 1
        Waiting = 2
        Canceled = 3
        Error = 4
        Deleted = 5

    class Result:
        @property
        def qubo_solution(self) -> FujitsuDA4Client.QuboSolutionList:
            """qubo_solution

            Returns:
                amplify.FujitsuDA4Client.QuboSolutionList:
            """

        @property
        def status(self) -> FujitsuDA4Client.JobStatus:
            """status

            Returns:
                amplify.FujitsuDA4Client.JobStatus:
            """

        @property
        def message(self) -> str:
            """message

            Returns:
                str:
            """

    QuboResponse: TypeAlias = FujitsuDA4Client.Result

    class CommonError:
        @property
        def code(self) -> int:
            """code

            Returns:
                int:
            """

        @property
        def title(self) -> str:
            """title

            Returns:
                str:
            """

        @property
        def message(self) -> str:
            """message

            Returns:
                str:
            """

    class JobStatusInfo:
        @property
        def job_id(self) -> str:
            """job_id

            Returns:
                str:
            """

        @property
        def job_status(self) -> FujitsuDA4Client.JobStatus:
            """job_status

            Returns:
                amplify.FujitsuDA4Client.JobStatus:
            """

        @property
        def start_time(self) -> datetime.datetime:
            """start_time

            Returns:
                datetime.datetime:
            """

    class Parameters:
        @property
        def time_limit_sec(self) -> Optional[datetime.timedelta]:
            """time_limit_sec

            Returns:
                typing.Optional[datetime.timedelta]:
            """

        @time_limit_sec.setter
        def time_limit_sec(self, arg: Optional[Union[int, datetime.timedelta]]) -> None:
            """
            Args:
                arg (typing.Optional[typing.Union[int, datetime.timedelta]])
            """

        @property
        def target_energy(self) -> Optional[float]:
            """target_energy

            Returns:
                typing.Optional[float]:
            """

        @target_energy.setter
        def target_energy(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def num_run(self) -> Optional[int]:
            """num_run

            Returns:
                typing.Optional[int]:
            """

        @num_run.setter
        def num_run(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def num_group(self) -> Optional[int]:
            """num_group

            Returns:
                typing.Optional[int]:
            """

        @num_group.setter
        def num_group(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def num_output_solution(self) -> Optional[int]:
            """num_output_solution

            Returns:
                typing.Optional[int]:
            """

        @num_output_solution.setter
        def num_output_solution(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def gs_level(self) -> Optional[int]:
            """gs_level

            Returns:
                typing.Optional[int]:
            """

        @gs_level.setter
        def gs_level(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def gs_cutoff(self) -> Optional[int]:
            """gs_cutoff

            Returns:
                typing.Optional[int]:
            """

        @gs_cutoff.setter
        def gs_cutoff(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def one_hot_level(self) -> Optional[int]:
            """one_hot_level

            Returns:
                typing.Optional[int]:
            """

        @one_hot_level.setter
        def one_hot_level(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def one_hot_cutoff(self) -> Optional[int]:
            """one_hot_cutoff

            Returns:
                typing.Optional[int]:
            """

        @one_hot_cutoff.setter
        def one_hot_cutoff(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def internal_penalty(self) -> Optional[int]:
            """internal_penalty

            Returns:
                typing.Optional[int]:
            """

        @internal_penalty.setter
        def internal_penalty(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def penalty_auto_mode(self) -> Optional[int]:
            """penalty_auto_mode

            Returns:
                typing.Optional[int]:
            """

        @penalty_auto_mode.setter
        def penalty_auto_mode(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def penalty_coef(self) -> Optional[int]:
            """penalty_coef

            Returns:
                typing.Optional[int]:
            """

        @penalty_coef.setter
        def penalty_coef(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def penalty_inc_rate(self) -> Optional[int]:
            """penalty_inc_rate

            Returns:
                typing.Optional[int]:
            """

        @penalty_inc_rate.setter
        def penalty_inc_rate(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def max_penalty_coef(self) -> Optional[int]:
            """max_penalty_coef

            Returns:
                typing.Optional[int]:
            """

        @max_penalty_coef.setter
        def max_penalty_coef(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

    @property
    def url(self) -> str:
        """url

        Returns:
            str:
        """

    @url.setter
    def url(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def token(self) -> str:
        """token

        Returns:
            str:
        """

    @token.setter
    def token(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def type_id(self) -> Optional[str]:
        """type_id

        Returns:
            typing.Optional[str]:
        """

    @type_id.setter
    def type_id(self, arg: Optional[str]) -> None:
        """
        Args:
            arg (typing.Optional[str])
        """

    @property
    def proxy(self) -> Optional[str]:
        """proxy

        Returns:
            typing.Optional[str]:
        """

    @proxy.setter
    def proxy(self, arg: Optional[str]) -> None:
        """
        Args:
            arg (typing.Optional[str])
        """

    @property
    def write_request_data(self) -> Optional[pathlib.Path]:
        """write_request_data

        Returns:
            typing.Optional[pathlib.Path]:
        """

    @write_request_data.setter
    def write_request_data(self, arg: Optional[str | os.PathLike]) -> None:
        """
        Args:
            arg (typing.Optional[str | os.PathLike])
        """

    @property
    def write_response_data(self) -> Optional[pathlib.Path]:
        """write_response_data

        Returns:
            typing.Optional[pathlib.Path]:
        """

    @write_response_data.setter
    def write_response_data(self, arg: Optional[str | os.PathLike]) -> None:
        """
        Args:
            arg (typing.Optional[str | os.PathLike])
        """

    @property
    def set_penalty_binary_polynomial(self) -> bool:
        """set_penalty_binary_polynomial

        Returns:
            bool:
        """

    @set_penalty_binary_polynomial.setter
    def set_penalty_binary_polynomial(self, arg: bool, /) -> None:
        """
        Args:
            arg (bool)
        """

    @property
    def set_one_way_one_hot_groups(self) -> bool:
        """set_one_way_one_hot_groups

        Returns:
            bool:
        """

    @set_one_way_one_hot_groups.setter
    def set_one_way_one_hot_groups(self, arg: bool, /) -> None:
        """
        Args:
            arg (bool)
        """

    @property
    def set_two_way_one_hot_groups(self) -> bool:
        """set_two_way_one_hot_groups

        Returns:
            bool:
        """

    @set_two_way_one_hot_groups.setter
    def set_two_way_one_hot_groups(self, arg: bool, /) -> None:
        """
        Args:
            arg (bool)
        """

    @property
    def set_inequalities(self) -> bool:
        """set_inequalities

        Returns:
            bool:
        """

    @set_inequalities.setter
    def set_inequalities(self, arg: bool, /) -> None:
        """
        Args:
            arg (bool)
        """

    @property
    def parameters(self) -> FujitsuDA4Client.Parameters:
        """parameters

        Returns:
            amplify.FujitsuDA4Client.Parameters:
        """

    @property
    def version(self) -> str:
        """version

        Returns:
            str:
        """

    @property
    def acceptable_degrees(self) -> AcceptableDegrees:
        """acceptable_degrees

        Returns:
            amplify.AcceptableDegrees:
        """

    def health_check(self) -> Optional[FujitsuDA4Client.CommonError]:
        """health_check

        Returns:
            typing.Optional[amplify.FujitsuDA4Client.CommonError]:
        """

    def get_jobs(self) -> list[FujitsuDA4Client.JobStatusInfo]:
        """get_jobs

        Returns:
            list[amplify.FujitsuDA4Client.JobStatusInfo]:
        """

    def get_job_result(self, job_id: str) -> FujitsuDA4Client.Result:
        """get_job_result

        Args:
            job_id (str)

        Returns:
            amplify.FujitsuDA4Client.Result:
        """

    def delete_job_result(self, job_id: str) -> FujitsuDA4Client.Result:
        """delete_job_result

        Args:
            job_id (str)

        Returns:
            amplify.FujitsuDA4Client.Result:
        """

    def cancel_job(self, job_id: str) -> FujitsuDA4Client.JobStatus:
        """cancel_job

        Args:
            job_id (str)

        Returns:
            amplify.FujitsuDA4Client.JobStatus:
        """

    @overload
    def async_solve(self, objective: Poly) -> str: ...
    @overload
    def async_solve(self, constraint: Union[Constraint, ConstraintList]) -> str: ...
    @overload
    def async_solve(self, objective: Poly, constraint: Union[Constraint, ConstraintList]) -> str:
        """async_solve

        .. admonition:: Overload 1.

            Args:
                * objective (amplify.Poly)

            Returns:
                str:

        .. admonition:: Overload 2.

            Args:
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])

            Returns:
                str:

        .. admonition:: Overload 3.

            Args:
                * objective (amplify.Poly)
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])

            Returns:
                str:
        """

    @overload
    def solve(
        self,
        objective: Union[Poly, Matrix],
        dry_run: Literal[False] = False,
        retry_after_delete: bool = True,
        delete_after_solve: bool = True,
    ) -> FujitsuDA4Client.Result: ...
    @overload
    def solve(
        self,
        constraint: Union[Constraint, ConstraintList],
        dry_run: Literal[False] = False,
        retry_after_delete: bool = True,
        delete_after_solve: bool = True,
    ) -> FujitsuDA4Client.Result: ...
    @overload
    def solve(
        self,
        objective: Union[Poly, Matrix],
        constraint: Union[Constraint, ConstraintList],
        dry_run: Literal[False] = False,
        retry_after_delete: bool = True,
        delete_after_solve: bool = True,
    ) -> FujitsuDA4Client.Result: ...
    @overload
    def solve(
        self,
        objective: Union[Poly, Matrix],
        dry_run: Literal[True],
        retry_after_delete: bool = True,
        delete_after_solve: bool = True,
    ) -> None: ...
    @overload
    def solve(
        self,
        constraint: Union[Constraint, ConstraintList],
        dry_run: Literal[True],
        retry_after_delete: bool = True,
        delete_after_solve: bool = True,
    ) -> None: ...
    @overload
    def solve(
        self,
        objective: Union[Poly, Matrix],
        constraint: Union[Constraint, ConstraintList],
        dry_run: Literal[True],
        retry_after_delete: bool = True,
        delete_after_solve: bool = True,
    ) -> None:
        """solve

        .. admonition:: Overload 1.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * dry_run (typing.Literal[False]): Defaults to ``False``.
                * retry_after_delete (bool): Defaults to ``True``.
                * delete_after_solve (bool): Defaults to ``True``.

            Returns:
                amplify.FujitsuDA4Client.Result:

        .. admonition:: Overload 2.

            Args:
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[False]): Defaults to ``False``.
                * retry_after_delete (bool): Defaults to ``True``.
                * delete_after_solve (bool): Defaults to ``True``.

            Returns:
                amplify.FujitsuDA4Client.Result:

        .. admonition:: Overload 3.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[False]): Defaults to ``False``.
                * retry_after_delete (bool): Defaults to ``True``.
                * delete_after_solve (bool): Defaults to ``True``.

            Returns:
                amplify.FujitsuDA4Client.Result:

        .. admonition:: Overload 4.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * dry_run (typing.Literal[True])
                * retry_after_delete (bool): Defaults to ``True``.
                * delete_after_solve (bool): Defaults to ``True``.

        .. admonition:: Overload 5.

            Args:
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[True])
                * retry_after_delete (bool): Defaults to ``True``.
                * delete_after_solve (bool): Defaults to ``True``.

        .. admonition:: Overload 6.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[True])
                * retry_after_delete (bool): Defaults to ``True``.
                * delete_after_solve (bool): Defaults to ``True``.
        """

class Graph:
    @property
    def type(self) -> str:
        """type

        Returns:
            str:
        """

    @property
    def shape(self) -> list[int]:
        """shape

        Returns:
            list[int]:
        """

    @property
    def nodes(self) -> list[int]:
        """nodes

        Returns:
            list[int]:
        """

    @property
    def edges(self) -> list[tuple[int, int]]:
        """edges

        Returns:
            list[tuple[int, int]]:
        """

    @property
    def adjacency(self) -> list[list[int]]:
        """adjacency

        Returns:
            list[list[int]]:
        """

class GurobiClient(AmplifyClient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, library_path: str) -> None: ...

    class Parameters:
        @property
        def log_to_console(self) -> Optional[bool]:
            """log_to_console

            Returns:
                typing.Optional[bool]:
            """

        @log_to_console.setter
        def log_to_console(self, arg: Optional[bool]) -> None:
            """
            Args:
                arg (typing.Optional[bool])
            """

        @property
        def agg_fill(self) -> Optional[int]:
            """agg_fill

            Returns:
                typing.Optional[int]:
            """

        @agg_fill.setter
        def agg_fill(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def aggregate(self) -> Optional[int]:
            """aggregate

            Returns:
                typing.Optional[int]:
            """

        @aggregate.setter
        def aggregate(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def bar_conv_tol(self) -> Optional[float]:
            """bar_conv_tol

            Returns:
                typing.Optional[float]:
            """

        @bar_conv_tol.setter
        def bar_conv_tol(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def bar_correctors(self) -> Optional[int]:
            """bar_correctors

            Returns:
                typing.Optional[int]:
            """

        @bar_correctors.setter
        def bar_correctors(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def bar_homogeneous(self) -> Optional[int]:
            """bar_homogeneous

            Returns:
                typing.Optional[int]:
            """

        @bar_homogeneous.setter
        def bar_homogeneous(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def bar_iter_limit(self) -> Optional[int]:
            """bar_iter_limit

            Returns:
                typing.Optional[int]:
            """

        @bar_iter_limit.setter
        def bar_iter_limit(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def bar_order(self) -> Optional[int]:
            """bar_order

            Returns:
                typing.Optional[int]:
            """

        @bar_order.setter
        def bar_order(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def bar_qcp_conv_tol(self) -> Optional[float]:
            """bar_qcp_conv_tol

            Returns:
                typing.Optional[float]:
            """

        @bar_qcp_conv_tol.setter
        def bar_qcp_conv_tol(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def best_bd_stop(self) -> Optional[float]:
            """best_bd_stop

            Returns:
                typing.Optional[float]:
            """

        @best_bd_stop.setter
        def best_bd_stop(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def best_obj_stop(self) -> Optional[float]:
            """best_obj_stop

            Returns:
                typing.Optional[float]:
            """

        @best_obj_stop.setter
        def best_obj_stop(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def bqp_cuts(self) -> Optional[int]:
            """bqp_cuts

            Returns:
                typing.Optional[int]:
            """

        @bqp_cuts.setter
        def bqp_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def branch_dir(self) -> Optional[int]:
            """branch_dir

            Returns:
                typing.Optional[int]:
            """

        @branch_dir.setter
        def branch_dir(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def clique_cuts(self) -> Optional[int]:
            """clique_cuts

            Returns:
                typing.Optional[int]:
            """

        @clique_cuts.setter
        def clique_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def cloud_access_id(self) -> Optional[str]:
            """cloud_access_id

            Returns:
                typing.Optional[str]:
            """

        @cloud_access_id.setter
        def cloud_access_id(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def cloud_host(self) -> Optional[str]:
            """cloud_host

            Returns:
                typing.Optional[str]:
            """

        @cloud_host.setter
        def cloud_host(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def cloud_pool(self) -> Optional[str]:
            """cloud_pool

            Returns:
                typing.Optional[str]:
            """

        @cloud_pool.setter
        def cloud_pool(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def cloud_secret_key(self) -> Optional[str]:
            """cloud_secret_key

            Returns:
                typing.Optional[str]:
            """

        @cloud_secret_key.setter
        def cloud_secret_key(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def compute_server(self) -> Optional[str]:
            """compute_server

            Returns:
                typing.Optional[str]:
            """

        @compute_server.setter
        def compute_server(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def concurrent_jobs(self) -> Optional[int]:
            """concurrent_jobs

            Returns:
                typing.Optional[int]:
            """

        @concurrent_jobs.setter
        def concurrent_jobs(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def concurrent_method(self) -> Optional[int]:
            """concurrent_method

            Returns:
                typing.Optional[int]:
            """

        @concurrent_method.setter
        def concurrent_method(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def concurrent_mip(self) -> Optional[int]:
            """concurrent_mip

            Returns:
                typing.Optional[int]:
            """

        @concurrent_mip.setter
        def concurrent_mip(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def cover_cuts(self) -> Optional[int]:
            """cover_cuts

            Returns:
                typing.Optional[int]:
            """

        @cover_cuts.setter
        def cover_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def crossover(self) -> Optional[int]:
            """crossover

            Returns:
                typing.Optional[int]:
            """

        @crossover.setter
        def crossover(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def crossover_basis(self) -> Optional[int]:
            """crossover_basis

            Returns:
                typing.Optional[int]:
            """

        @crossover_basis.setter
        def crossover_basis(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def cs_app_name(self) -> Optional[str]:
            """cs_app_name

            Returns:
                typing.Optional[str]:
            """

        @cs_app_name.setter
        def cs_app_name(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def cs_auth_token(self) -> Optional[str]:
            """cs_auth_token

            Returns:
                typing.Optional[str]:
            """

        @cs_auth_token.setter
        def cs_auth_token(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def cs_batch_mode(self) -> Optional[int]:
            """cs_batch_mode

            Returns:
                typing.Optional[int]:
            """

        @cs_batch_mode.setter
        def cs_batch_mode(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def cs_client_log(self) -> Optional[int]:
            """cs_client_log

            Returns:
                typing.Optional[int]:
            """

        @cs_client_log.setter
        def cs_client_log(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def cs_group(self) -> Optional[str]:
            """cs_group

            Returns:
                typing.Optional[str]:
            """

        @cs_group.setter
        def cs_group(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def cs_idle_timeout(self) -> Optional[int]:
            """cs_idle_timeout

            Returns:
                typing.Optional[int]:
            """

        @cs_idle_timeout.setter
        def cs_idle_timeout(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def cs_manager(self) -> Optional[str]:
            """cs_manager

            Returns:
                typing.Optional[str]:
            """

        @cs_manager.setter
        def cs_manager(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def cs_priority(self) -> Optional[int]:
            """cs_priority

            Returns:
                typing.Optional[int]:
            """

        @cs_priority.setter
        def cs_priority(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def cs_queue_timeout(self) -> Optional[float]:
            """cs_queue_timeout

            Returns:
                typing.Optional[float]:
            """

        @cs_queue_timeout.setter
        def cs_queue_timeout(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def cs_router(self) -> Optional[str]:
            """cs_router

            Returns:
                typing.Optional[str]:
            """

        @cs_router.setter
        def cs_router(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def csapi_access_id(self) -> Optional[str]:
            """csapi_access_id

            Returns:
                typing.Optional[str]:
            """

        @csapi_access_id.setter
        def csapi_access_id(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def csapi_secret(self) -> Optional[str]:
            """csapi_secret

            Returns:
                typing.Optional[str]:
            """

        @csapi_secret.setter
        def csapi_secret(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def cstls_insecure(self) -> Optional[int]:
            """cstls_insecure

            Returns:
                typing.Optional[int]:
            """

        @cstls_insecure.setter
        def cstls_insecure(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def cut_agg_passes(self) -> Optional[int]:
            """cut_agg_passes

            Returns:
                typing.Optional[int]:
            """

        @cut_agg_passes.setter
        def cut_agg_passes(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def cut_passes(self) -> Optional[int]:
            """cut_passes

            Returns:
                typing.Optional[int]:
            """

        @cut_passes.setter
        def cut_passes(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def cutoff(self) -> Optional[float]:
            """cutoff

            Returns:
                typing.Optional[float]:
            """

        @cutoff.setter
        def cutoff(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def cuts(self) -> Optional[int]:
            """cuts

            Returns:
                typing.Optional[int]:
            """

        @cuts.setter
        def cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def degen_moves(self) -> Optional[int]:
            """degen_moves

            Returns:
                typing.Optional[int]:
            """

        @degen_moves.setter
        def degen_moves(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def disconnected(self) -> Optional[int]:
            """disconnected

            Returns:
                typing.Optional[int]:
            """

        @disconnected.setter
        def disconnected(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def display_interval(self) -> Optional[int]:
            """display_interval

            Returns:
                typing.Optional[int]:
            """

        @display_interval.setter
        def display_interval(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def distributed_mip_jobs(self) -> Optional[int]:
            """distributed_mip_jobs

            Returns:
                typing.Optional[int]:
            """

        @distributed_mip_jobs.setter
        def distributed_mip_jobs(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def dual_reductions(self) -> Optional[int]:
            """dual_reductions

            Returns:
                typing.Optional[int]:
            """

        @dual_reductions.setter
        def dual_reductions(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def feas_relax_big_m(self) -> Optional[float]:
            """feas_relax_big_m

            Returns:
                typing.Optional[float]:
            """

        @feas_relax_big_m.setter
        def feas_relax_big_m(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def feasibility_tol(self) -> Optional[float]:
            """feasibility_tol

            Returns:
                typing.Optional[float]:
            """

        @feasibility_tol.setter
        def feasibility_tol(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def flow_cover_cuts(self) -> Optional[int]:
            """flow_cover_cuts

            Returns:
                typing.Optional[int]:
            """

        @flow_cover_cuts.setter
        def flow_cover_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def flow_path_cuts(self) -> Optional[int]:
            """flow_path_cuts

            Returns:
                typing.Optional[int]:
            """

        @flow_path_cuts.setter
        def flow_path_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def func_max_val(self) -> Optional[float]:
            """func_max_val

            Returns:
                typing.Optional[float]:
            """

        @func_max_val.setter
        def func_max_val(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def func_nonlinear(self) -> Optional[int]:
            """func_nonlinear

            Returns:
                typing.Optional[int]:
            """

        @func_nonlinear.setter
        def func_nonlinear(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def func_piece_error(self) -> Optional[float]:
            """func_piece_error

            Returns:
                typing.Optional[float]:
            """

        @func_piece_error.setter
        def func_piece_error(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def func_piece_length(self) -> Optional[float]:
            """func_piece_length

            Returns:
                typing.Optional[float]:
            """

        @func_piece_length.setter
        def func_piece_length(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def func_piece_ratio(self) -> Optional[float]:
            """func_piece_ratio

            Returns:
                typing.Optional[float]:
            """

        @func_piece_ratio.setter
        def func_piece_ratio(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def func_pieces(self) -> Optional[int]:
            """func_pieces

            Returns:
                typing.Optional[int]:
            """

        @func_pieces.setter
        def func_pieces(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def gomory_passes(self) -> Optional[int]:
            """gomory_passes

            Returns:
                typing.Optional[int]:
            """

        @gomory_passes.setter
        def gomory_passes(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def gub_cover_cuts(self) -> Optional[int]:
            """gub_cover_cuts

            Returns:
                typing.Optional[int]:
            """

        @gub_cover_cuts.setter
        def gub_cover_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def heuristics(self) -> Optional[float]:
            """heuristics

            Returns:
                typing.Optional[float]:
            """

        @heuristics.setter
        def heuristics(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def ignore_names(self) -> Optional[int]:
            """ignore_names

            Returns:
                typing.Optional[int]:
            """

        @ignore_names.setter
        def ignore_names(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def iis_method(self) -> Optional[int]:
            """iis_method

            Returns:
                typing.Optional[int]:
            """

        @iis_method.setter
        def iis_method(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def implied_cuts(self) -> Optional[int]:
            """implied_cuts

            Returns:
                typing.Optional[int]:
            """

        @implied_cuts.setter
        def implied_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def improve_start_gap(self) -> Optional[float]:
            """improve_start_gap

            Returns:
                typing.Optional[float]:
            """

        @improve_start_gap.setter
        def improve_start_gap(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def improve_start_nodes(self) -> Optional[float]:
            """improve_start_nodes

            Returns:
                typing.Optional[float]:
            """

        @improve_start_nodes.setter
        def improve_start_nodes(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def improve_start_time(self) -> Optional[float]:
            """improve_start_time

            Returns:
                typing.Optional[float]:
            """

        @improve_start_time.setter
        def improve_start_time(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def inf_proof_cuts(self) -> Optional[int]:
            """inf_proof_cuts

            Returns:
                typing.Optional[int]:
            """

        @inf_proof_cuts.setter
        def inf_proof_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def inf_unbd_info(self) -> Optional[int]:
            """inf_unbd_info

            Returns:
                typing.Optional[int]:
            """

        @inf_unbd_info.setter
        def inf_unbd_info(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def int_feas_tol(self) -> Optional[float]:
            """int_feas_tol

            Returns:
                typing.Optional[float]:
            """

        @int_feas_tol.setter
        def int_feas_tol(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def integrality_focus(self) -> Optional[int]:
            """integrality_focus

            Returns:
                typing.Optional[int]:
            """

        @integrality_focus.setter
        def integrality_focus(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def iteration_limit(self) -> Optional[float]:
            """iteration_limit

            Returns:
                typing.Optional[float]:
            """

        @iteration_limit.setter
        def iteration_limit(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def job_id(self) -> Optional[str]:
            """job_id

            Returns:
                typing.Optional[str]:
            """

        @job_id.setter
        def job_id(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def json_sol_detail(self) -> Optional[int]:
            """json_sol_detail

            Returns:
                typing.Optional[int]:
            """

        @json_sol_detail.setter
        def json_sol_detail(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def lazy_constraints(self) -> Optional[int]:
            """lazy_constraints

            Returns:
                typing.Optional[int]:
            """

        @lazy_constraints.setter
        def lazy_constraints(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def license_id(self) -> Optional[int]:
            """license_id

            Returns:
                typing.Optional[int]:
            """

        @license_id.setter
        def license_id(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def lift_project_cuts(self) -> Optional[int]:
            """lift_project_cuts

            Returns:
                typing.Optional[int]:
            """

        @lift_project_cuts.setter
        def lift_project_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def log_file(self) -> Optional[pathlib.Path]:
            """log_file

            Returns:
                typing.Optional[pathlib.Path]:
            """

        @log_file.setter
        def log_file(self, arg: Optional[str | os.PathLike]) -> None:
            """
            Args:
                arg (typing.Optional[str | os.PathLike])
            """

        @property
        def lp_warm_start(self) -> Optional[int]:
            """lp_warm_start

            Returns:
                typing.Optional[int]:
            """

        @lp_warm_start.setter
        def lp_warm_start(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def markowitz_tol(self) -> Optional[float]:
            """markowitz_tol

            Returns:
                typing.Optional[float]:
            """

        @markowitz_tol.setter
        def markowitz_tol(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def mem_limit(self) -> Optional[float]:
            """mem_limit

            Returns:
                typing.Optional[float]:
            """

        @mem_limit.setter
        def mem_limit(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def method(self) -> Optional[int]:
            """method

            Returns:
                typing.Optional[int]:
            """

        @method.setter
        def method(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def min_rel_nodes(self) -> Optional[int]:
            """min_rel_nodes

            Returns:
                typing.Optional[int]:
            """

        @min_rel_nodes.setter
        def min_rel_nodes(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def mip_focus(self) -> Optional[int]:
            """mip_focus

            Returns:
                typing.Optional[int]:
            """

        @mip_focus.setter
        def mip_focus(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def mip_gap(self) -> Optional[float]:
            """mip_gap

            Returns:
                typing.Optional[float]:
            """

        @mip_gap.setter
        def mip_gap(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def mip_gap_abs(self) -> Optional[float]:
            """mip_gap_abs

            Returns:
                typing.Optional[float]:
            """

        @mip_gap_abs.setter
        def mip_gap_abs(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def mip_sep_cuts(self) -> Optional[int]:
            """mip_sep_cuts

            Returns:
                typing.Optional[int]:
            """

        @mip_sep_cuts.setter
        def mip_sep_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def miqcp_method(self) -> Optional[int]:
            """miqcp_method

            Returns:
                typing.Optional[int]:
            """

        @miqcp_method.setter
        def miqcp_method(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def mir_cuts(self) -> Optional[int]:
            """mir_cuts

            Returns:
                typing.Optional[int]:
            """

        @mir_cuts.setter
        def mir_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def mixing_cuts(self) -> Optional[int]:
            """mixing_cuts

            Returns:
                typing.Optional[int]:
            """

        @mixing_cuts.setter
        def mixing_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def mod_k_cuts(self) -> Optional[int]:
            """mod_k_cuts

            Returns:
                typing.Optional[int]:
            """

        @mod_k_cuts.setter
        def mod_k_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def multi_obj_method(self) -> Optional[int]:
            """multi_obj_method

            Returns:
                typing.Optional[int]:
            """

        @multi_obj_method.setter
        def multi_obj_method(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def multi_obj_pre(self) -> Optional[int]:
            """multi_obj_pre

            Returns:
                typing.Optional[int]:
            """

        @multi_obj_pre.setter
        def multi_obj_pre(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def network_alg(self) -> Optional[int]:
            """network_alg

            Returns:
                typing.Optional[int]:
            """

        @network_alg.setter
        def network_alg(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def network_cuts(self) -> Optional[int]:
            """network_cuts

            Returns:
                typing.Optional[int]:
            """

        @network_cuts.setter
        def network_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def nlp_heur(self) -> Optional[int]:
            """nlp_heur

            Returns:
                typing.Optional[int]:
            """

        @nlp_heur.setter
        def nlp_heur(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def no_rel_heur_time(self) -> Optional[float]:
            """no_rel_heur_time

            Returns:
                typing.Optional[float]:
            """

        @no_rel_heur_time.setter
        def no_rel_heur_time(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def no_rel_heur_work(self) -> Optional[float]:
            """no_rel_heur_work

            Returns:
                typing.Optional[float]:
            """

        @no_rel_heur_work.setter
        def no_rel_heur_work(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def no_rel_heuristic(self) -> Optional[int]:
            """no_rel_heuristic

            Returns:
                typing.Optional[int]:
            """

        @no_rel_heuristic.setter
        def no_rel_heuristic(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def node_limit(self) -> Optional[float]:
            """node_limit

            Returns:
                typing.Optional[float]:
            """

        @node_limit.setter
        def node_limit(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def node_method(self) -> Optional[int]:
            """node_method

            Returns:
                typing.Optional[int]:
            """

        @node_method.setter
        def node_method(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def nodefile_dir(self) -> Optional[pathlib.Path]:
            """nodefile_dir

            Returns:
                typing.Optional[pathlib.Path]:
            """

        @nodefile_dir.setter
        def nodefile_dir(self, arg: Optional[str | os.PathLike]) -> None:
            """
            Args:
                arg (typing.Optional[str | os.PathLike])
            """

        @property
        def nodefile_start(self) -> Optional[float]:
            """nodefile_start

            Returns:
                typing.Optional[float]:
            """

        @nodefile_start.setter
        def nodefile_start(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def non_convex(self) -> Optional[int]:
            """non_convex

            Returns:
                typing.Optional[int]:
            """

        @non_convex.setter
        def non_convex(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def norm_adjust(self) -> Optional[int]:
            """norm_adjust

            Returns:
                typing.Optional[int]:
            """

        @norm_adjust.setter
        def norm_adjust(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def numeric_focus(self) -> Optional[int]:
            """numeric_focus

            Returns:
                typing.Optional[int]:
            """

        @numeric_focus.setter
        def numeric_focus(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def obbt(self) -> Optional[int]:
            """obbt

            Returns:
                typing.Optional[int]:
            """

        @obbt.setter
        def obbt(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def obj_number(self) -> Optional[int]:
            """obj_number

            Returns:
                typing.Optional[int]:
            """

        @obj_number.setter
        def obj_number(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def obj_scale(self) -> Optional[float]:
            """obj_scale

            Returns:
                typing.Optional[float]:
            """

        @obj_scale.setter
        def obj_scale(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def optimality_tol(self) -> Optional[float]:
            """optimality_tol

            Returns:
                typing.Optional[float]:
            """

        @optimality_tol.setter
        def optimality_tol(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def output_flag(self) -> Optional[int]:
            """output_flag

            Returns:
                typing.Optional[int]:
            """

        @output_flag.setter
        def output_flag(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def partition_place(self) -> Optional[int]:
            """partition_place

            Returns:
                typing.Optional[int]:
            """

        @partition_place.setter
        def partition_place(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def perturb_value(self) -> Optional[float]:
            """perturb_value

            Returns:
                typing.Optional[float]:
            """

        @perturb_value.setter
        def perturb_value(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def pool_gap(self) -> Optional[float]:
            """pool_gap

            Returns:
                typing.Optional[float]:
            """

        @pool_gap.setter
        def pool_gap(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def pool_gap_abs(self) -> Optional[float]:
            """pool_gap_abs

            Returns:
                typing.Optional[float]:
            """

        @pool_gap_abs.setter
        def pool_gap_abs(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def pool_search_mode(self) -> Optional[int]:
            """pool_search_mode

            Returns:
                typing.Optional[int]:
            """

        @pool_search_mode.setter
        def pool_search_mode(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def pool_solutions(self) -> Optional[int]:
            """pool_solutions

            Returns:
                typing.Optional[int]:
            """

        @pool_solutions.setter
        def pool_solutions(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def pre_crush(self) -> Optional[int]:
            """pre_crush

            Returns:
                typing.Optional[int]:
            """

        @pre_crush.setter
        def pre_crush(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def pre_dep_row(self) -> Optional[int]:
            """pre_dep_row

            Returns:
                typing.Optional[int]:
            """

        @pre_dep_row.setter
        def pre_dep_row(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def pre_dual(self) -> Optional[int]:
            """pre_dual

            Returns:
                typing.Optional[int]:
            """

        @pre_dual.setter
        def pre_dual(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def pre_miqcp_form(self) -> Optional[int]:
            """pre_miqcp_form

            Returns:
                typing.Optional[int]:
            """

        @pre_miqcp_form.setter
        def pre_miqcp_form(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def pre_passes(self) -> Optional[int]:
            """pre_passes

            Returns:
                typing.Optional[int]:
            """

        @pre_passes.setter
        def pre_passes(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def pre_q_linearize(self) -> Optional[int]:
            """pre_q_linearize

            Returns:
                typing.Optional[int]:
            """

        @pre_q_linearize.setter
        def pre_q_linearize(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def pre_sparsify(self) -> Optional[int]:
            """pre_sparsify

            Returns:
                typing.Optional[int]:
            """

        @pre_sparsify.setter
        def pre_sparsify(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def presolve(self) -> Optional[int]:
            """presolve

            Returns:
                typing.Optional[int]:
            """

        @presolve.setter
        def presolve(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def proj_implied_cuts(self) -> Optional[int]:
            """proj_implied_cuts

            Returns:
                typing.Optional[int]:
            """

        @proj_implied_cuts.setter
        def proj_implied_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def psd_cuts(self) -> Optional[int]:
            """psd_cuts

            Returns:
                typing.Optional[int]:
            """

        @psd_cuts.setter
        def psd_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def psd_tol(self) -> Optional[float]:
            """psd_tol

            Returns:
                typing.Optional[float]:
            """

        @psd_tol.setter
        def psd_tol(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def pump_passes(self) -> Optional[int]:
            """pump_passes

            Returns:
                typing.Optional[int]:
            """

        @pump_passes.setter
        def pump_passes(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def qcp_dual(self) -> Optional[int]:
            """qcp_dual

            Returns:
                typing.Optional[int]:
            """

        @qcp_dual.setter
        def qcp_dual(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def quad(self) -> Optional[int]:
            """quad

            Returns:
                typing.Optional[int]:
            """

        @quad.setter
        def quad(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def record(self) -> Optional[int]:
            """record

            Returns:
                typing.Optional[int]:
            """

        @record.setter
        def record(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def relax_lift_cuts(self) -> Optional[int]:
            """relax_lift_cuts

            Returns:
                typing.Optional[int]:
            """

        @relax_lift_cuts.setter
        def relax_lift_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def result_file(self) -> Optional[pathlib.Path]:
            """result_file

            Returns:
                typing.Optional[pathlib.Path]:
            """

        @result_file.setter
        def result_file(self, arg: Optional[str | os.PathLike]) -> None:
            """
            Args:
                arg (typing.Optional[str | os.PathLike])
            """

        @property
        def rins(self) -> Optional[int]:
            """rins

            Returns:
                typing.Optional[int]:
            """

        @rins.setter
        def rins(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def rlt_cuts(self) -> Optional[int]:
            """rlt_cuts

            Returns:
                typing.Optional[int]:
            """

        @rlt_cuts.setter
        def rlt_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def scale_flag(self) -> Optional[int]:
            """scale_flag

            Returns:
                typing.Optional[int]:
            """

        @scale_flag.setter
        def scale_flag(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def scenario_number(self) -> Optional[int]:
            """scenario_number

            Returns:
                typing.Optional[int]:
            """

        @scenario_number.setter
        def scenario_number(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def seed(self) -> Optional[int]:
            """seed

            Returns:
                typing.Optional[int]:
            """

        @seed.setter
        def seed(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def server_password(self) -> Optional[str]:
            """server_password

            Returns:
                typing.Optional[str]:
            """

        @server_password.setter
        def server_password(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def server_timeout(self) -> Optional[int]:
            """server_timeout

            Returns:
                typing.Optional[int]:
            """

        @server_timeout.setter
        def server_timeout(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def sift_method(self) -> Optional[int]:
            """sift_method

            Returns:
                typing.Optional[int]:
            """

        @sift_method.setter
        def sift_method(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def sifting(self) -> Optional[int]:
            """sifting

            Returns:
                typing.Optional[int]:
            """

        @sifting.setter
        def sifting(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def simplex_pricing(self) -> Optional[int]:
            """simplex_pricing

            Returns:
                typing.Optional[int]:
            """

        @simplex_pricing.setter
        def simplex_pricing(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def soft_mem_limit(self) -> Optional[float]:
            """soft_mem_limit

            Returns:
                typing.Optional[float]:
            """

        @soft_mem_limit.setter
        def soft_mem_limit(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def sol_files(self) -> Optional[str]:
            """sol_files

            Returns:
                typing.Optional[str]:
            """

        @sol_files.setter
        def sol_files(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def solution_limit(self) -> Optional[int]:
            """solution_limit

            Returns:
                typing.Optional[int]:
            """

        @solution_limit.setter
        def solution_limit(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def solution_number(self) -> Optional[int]:
            """solution_number

            Returns:
                typing.Optional[int]:
            """

        @solution_number.setter
        def solution_number(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def solution_target(self) -> Optional[int]:
            """solution_target

            Returns:
                typing.Optional[int]:
            """

        @solution_target.setter
        def solution_target(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def start_node_limit(self) -> Optional[int]:
            """start_node_limit

            Returns:
                typing.Optional[int]:
            """

        @start_node_limit.setter
        def start_node_limit(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def start_number(self) -> Optional[int]:
            """start_number

            Returns:
                typing.Optional[int]:
            """

        @start_number.setter
        def start_number(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def strong_cg_cuts(self) -> Optional[int]:
            """strong_cg_cuts

            Returns:
                typing.Optional[int]:
            """

        @strong_cg_cuts.setter
        def strong_cg_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def sub_mip_cuts(self) -> Optional[int]:
            """sub_mip_cuts

            Returns:
                typing.Optional[int]:
            """

        @sub_mip_cuts.setter
        def sub_mip_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def sub_mip_nodes(self) -> Optional[int]:
            """sub_mip_nodes

            Returns:
                typing.Optional[int]:
            """

        @sub_mip_nodes.setter
        def sub_mip_nodes(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def symmetry(self) -> Optional[int]:
            """symmetry

            Returns:
                typing.Optional[int]:
            """

        @symmetry.setter
        def symmetry(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def threads(self) -> Optional[int]:
            """threads

            Returns:
                typing.Optional[int]:
            """

        @threads.setter
        def threads(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def time_limit(self) -> Optional[datetime.timedelta]:
            """time_limit

            Returns:
                typing.Optional[datetime.timedelta]:
            """

        @time_limit.setter
        def time_limit(self, arg: Optional[Union[float, datetime.timedelta]]) -> None:
            """
            Args:
                arg (typing.Optional[typing.Union[float, datetime.timedelta]])
            """

        @property
        def token_server(self) -> Optional[str]:
            """token_server

            Returns:
                typing.Optional[str]:
            """

        @token_server.setter
        def token_server(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def ts_port(self) -> Optional[int]:
            """ts_port

            Returns:
                typing.Optional[int]:
            """

        @ts_port.setter
        def ts_port(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def tune_cleanup(self) -> Optional[float]:
            """tune_cleanup

            Returns:
                typing.Optional[float]:
            """

        @tune_cleanup.setter
        def tune_cleanup(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def tune_criterion(self) -> Optional[int]:
            """tune_criterion

            Returns:
                typing.Optional[int]:
            """

        @tune_criterion.setter
        def tune_criterion(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def tune_dynamic_jobs(self) -> Optional[int]:
            """tune_dynamic_jobs

            Returns:
                typing.Optional[int]:
            """

        @tune_dynamic_jobs.setter
        def tune_dynamic_jobs(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def tune_jobs(self) -> Optional[int]:
            """tune_jobs

            Returns:
                typing.Optional[int]:
            """

        @tune_jobs.setter
        def tune_jobs(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def tune_metric(self) -> Optional[int]:
            """tune_metric

            Returns:
                typing.Optional[int]:
            """

        @tune_metric.setter
        def tune_metric(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def tune_output(self) -> Optional[int]:
            """tune_output

            Returns:
                typing.Optional[int]:
            """

        @tune_output.setter
        def tune_output(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def tune_results(self) -> Optional[int]:
            """tune_results

            Returns:
                typing.Optional[int]:
            """

        @tune_results.setter
        def tune_results(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def tune_target_mip_gap(self) -> Optional[float]:
            """tune_target_mip_gap

            Returns:
                typing.Optional[float]:
            """

        @tune_target_mip_gap.setter
        def tune_target_mip_gap(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def tune_target_time(self) -> Optional[float]:
            """tune_target_time

            Returns:
                typing.Optional[float]:
            """

        @tune_target_time.setter
        def tune_target_time(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def tune_time_limit(self) -> Optional[datetime.timedelta]:
            """tune_time_limit

            Returns:
                typing.Optional[datetime.timedelta]:
            """

        @tune_time_limit.setter
        def tune_time_limit(self, arg: Optional[Union[float, datetime.timedelta]]) -> None:
            """
            Args:
                arg (typing.Optional[typing.Union[float, datetime.timedelta]])
            """

        @property
        def tune_trials(self) -> Optional[int]:
            """tune_trials

            Returns:
                typing.Optional[int]:
            """

        @tune_trials.setter
        def tune_trials(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def update_mode(self) -> Optional[int]:
            """update_mode

            Returns:
                typing.Optional[int]:
            """

        @update_mode.setter
        def update_mode(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def username(self) -> Optional[str]:
            """username

            Returns:
                typing.Optional[str]:
            """

        @username.setter
        def username(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def var_branch(self) -> Optional[int]:
            """var_branch

            Returns:
                typing.Optional[int]:
            """

        @var_branch.setter
        def var_branch(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def wls_access_id(self) -> Optional[str]:
            """wls_access_id

            Returns:
                typing.Optional[str]:
            """

        @wls_access_id.setter
        def wls_access_id(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def wls_secret(self) -> Optional[str]:
            """wls_secret

            Returns:
                typing.Optional[str]:
            """

        @wls_secret.setter
        def wls_secret(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def wls_token(self) -> Optional[str]:
            """wls_token

            Returns:
                typing.Optional[str]:
            """

        @wls_token.setter
        def wls_token(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def wls_token_duration(self) -> Optional[int]:
            """wls_token_duration

            Returns:
                typing.Optional[int]:
            """

        @wls_token_duration.setter
        def wls_token_duration(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def wls_token_refresh(self) -> Optional[float]:
            """wls_token_refresh

            Returns:
                typing.Optional[float]:
            """

        @wls_token_refresh.setter
        def wls_token_refresh(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def work_limit(self) -> Optional[float]:
            """work_limit

            Returns:
                typing.Optional[float]:
            """

        @work_limit.setter
        def work_limit(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def worker_password(self) -> Optional[str]:
            """worker_password

            Returns:
                typing.Optional[str]:
            """

        @worker_password.setter
        def worker_password(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def worker_pool(self) -> Optional[str]:
            """worker_pool

            Returns:
                typing.Optional[str]:
            """

        @worker_pool.setter
        def worker_pool(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def zero_half_cuts(self) -> Optional[int]:
            """zero_half_cuts

            Returns:
                typing.Optional[int]:
            """

        @zero_half_cuts.setter
        def zero_half_cuts(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def zero_obj_nodes(self) -> Optional[int]:
            """zero_obj_nodes

            Returns:
                typing.Optional[int]:
            """

        @zero_obj_nodes.setter
        def zero_obj_nodes(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

    class Result:
        class OptimizationStatusCode(enum.Enum):
            Unknown = 0
            Loaded = 1
            Optimal = 2
            Infeasible = 3
            InfOrUnbd = 4
            Unbounded = 5
            Cutoff = 6
            IterationLimit = 7
            NodeLimit = 8
            TimeLimit = 9
            SolutionLimit = 10
            Interrupted = 11
            Numeric = 12
            Suboptimal = 13
            Inprogress = 14
            UserObjLimit = 15
            WorkLimit = 16
            MemLimit = 17

        @property
        def status(self) -> GurobiClient.Result.OptimizationStatusCode:
            """status

            Returns:
                amplify.GurobiClient.Result.OptimizationStatusCode:
            """

        @property
        def runtime(self) -> datetime.timedelta:
            """runtime

            Returns:
                datetime.timedelta:
            """

        @property
        def obj_val(self) -> Optional[float]:
            """obj_val

            Returns:
                typing.Optional[float]:
            """

        @property
        def obj_bound(self) -> Optional[float]:
            """obj_bound

            Returns:
                typing.Optional[float]:
            """

        @property
        def obj_bound_c(self) -> Optional[float]:
            """obj_bound_c

            Returns:
                typing.Optional[float]:
            """

        @property
        def mip_gap(self) -> Optional[float]:
            """mip_gap

            Returns:
                typing.Optional[float]:
            """

        @property
        def int_vio(self) -> Optional[float]:
            """int_vio

            Returns:
                typing.Optional[float]:
            """

        @property
        def bound_vio(self) -> Optional[float]:
            """bound_vio

            Returns:
                typing.Optional[float]:
            """

        @property
        def constr_vio(self) -> Optional[float]:
            """constr_vio

            Returns:
                typing.Optional[float]:
            """

        @property
        def iter_count(self) -> Optional[float]:
            """iter_count

            Returns:
                typing.Optional[float]:
            """

        @property
        def bar_iter_count(self) -> Optional[int]:
            """bar_iter_count

            Returns:
                typing.Optional[int]:
            """

        @property
        def node_count(self) -> Optional[float]:
            """node_count

            Returns:
                typing.Optional[float]:
            """

        @property
        def farkas_proof(self) -> Optional[float]:
            """farkas_proof

            Returns:
                typing.Optional[float]:
            """

        @property
        def sol_count(self) -> Optional[int]:
            """sol_count

            Returns:
                typing.Optional[int]:
            """

        @property
        def pool_obj_bound(self) -> Optional[float]:
            """pool_obj_bound

            Returns:
                typing.Optional[float]:
            """

        @property
        def pool_obj_val(
            self,
        ) -> Optional[Annotated[numpy.typing.NDArray[numpy.float64], {"dtype": "float64", "writable": False}]]:
            """pool_obj_val

            Returns:
                typing.Optional[numpy.ndarray[dtype=float64, writable=False]]:
            """

        @property
        def var_names(self) -> Optional[list[str]]:
            """var_names

            Returns:
                typing.Optional[list[str]]:
            """

        @property
        def x(
            self,
        ) -> Optional[Annotated[numpy.typing.NDArray[numpy.float64], {"dtype": "float64", "writable": False}]]:
            """x

            Returns:
                typing.Optional[numpy.ndarray[dtype=float64, writable=False]]:
            """

        @property
        def xn(
            self,
        ) -> Optional[list[Annotated[numpy.typing.NDArray[numpy.float64], {"dtype": "float64", "writable": False}]]]:
            """xn

            Returns:
                typing.Optional[list[numpy.ndarray[dtype=float64, writable=False]]]:
            """

        @property
        def time_stamps(self) -> list[tuple[float, datetime.timedelta]]:
            """time_stamps

            Returns:
                list[tuple[float, datetime.timedelta]]:
            """

    @property
    def library_path(self) -> Optional[str]:
        """library_path

        Returns:
            typing.Optional[str]:
        """

    @library_path.setter
    def library_path(self, arg: Optional[str]) -> None:
        """
        Args:
            arg (typing.Optional[str])
        """

    @property
    def write_request_data(self) -> Optional[str]:
        """write_request_data

        Returns:
            typing.Optional[str]:
        """

    @write_request_data.setter
    def write_request_data(self, arg: Optional[str]) -> None:
        """
        Args:
            arg (typing.Optional[str])
        """

    @property
    def write_response_data(self) -> Optional[str]:
        """write_response_data

        Returns:
            typing.Optional[str]:
        """

    @write_response_data.setter
    def write_response_data(self, arg: Optional[str]) -> None:
        """
        Args:
            arg (typing.Optional[str])
        """

    @property
    def parameters(self) -> GurobiClient.Parameters:
        """parameters

        Returns:
            amplify.GurobiClient.Parameters:
        """

    @property
    def version(self) -> str:
        """version

        Returns:
            str:
        """

    @property
    def acceptable_degrees(self) -> AcceptableDegrees:
        """acceptable_degrees

        Returns:
            amplify.AcceptableDegrees:
        """

    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[False] = False) -> GurobiClient.Result: ...
    @overload
    def solve(
        self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[False] = False
    ) -> GurobiClient.Result: ...
    @overload
    def solve(
        self,
        objective: Union[Poly, Matrix],
        constraint: Union[Constraint, ConstraintList],
        dry_run: Literal[False] = False,
    ) -> GurobiClient.Result: ...
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(
        self, objective: Union[Poly, Matrix], constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]
    ) -> None:
        """solve

        .. admonition:: Overload 1.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * dry_run (typing.Literal[False]): Defaults to ``False``.

            Returns:
                amplify.GurobiClient.Result:

        .. admonition:: Overload 2.

            Args:
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[False]): Defaults to ``False``.

            Returns:
                amplify.GurobiClient.Result:

        .. admonition:: Overload 3.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[False]): Defaults to ``False``.

            Returns:
                amplify.GurobiClient.Result:

        .. admonition:: Overload 4.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * dry_run (typing.Literal[True])

        .. admonition:: Overload 5.

            Args:
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[True])

        .. admonition:: Overload 6.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[True])
        """

    @overload
    def tune(self, objective: Union[Poly, Matrix]) -> None: ...
    @overload
    def tune(self, constraint: Union[Constraint, ConstraintList]) -> None: ...
    @overload
    def tune(self, objective: Union[Poly, Matrix], constraint: Union[Constraint, ConstraintList]) -> None:
        """tune

        .. admonition:: Overload 1.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])

        .. admonition:: Overload 2.

            Args:
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])

        .. admonition:: Overload 3.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
        """

class HitachiClient(AmplifyClient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, token: str = "", url: str = "", proxy: Optional[str] = None) -> None: ...

    class Parameters:
        class Outputs:
            @property
            def energies(self) -> Optional[bool]:
                """energies

                Returns:
                    typing.Optional[bool]:
                """

            @energies.setter
            def energies(self, arg: Optional[bool]) -> None:
                """
                Args:
                    arg (typing.Optional[bool])
                """

            @property
            def spins(self) -> Optional[bool]:
                """spins

                Returns:
                    typing.Optional[bool]:
                """

            @spins.setter
            def spins(self, arg: Optional[bool]) -> None:
                """
                Args:
                    arg (typing.Optional[bool])
                """

            @property
            def execution_time(self) -> Optional[bool]:
                """execution_time

                Returns:
                    typing.Optional[bool]:
                """

            @execution_time.setter
            def execution_time(self, arg: Optional[bool]) -> None:
                """
                Args:
                    arg (typing.Optional[bool])
                """

            @property
            def num_outputs(self) -> Optional[int]:
                """num_outputs

                Returns:
                    typing.Optional[int]:
                """

            @num_outputs.setter
            def num_outputs(self, arg: Optional[int]) -> None:
                """
                Args:
                    arg (typing.Optional[int])
                """

            @property
            def averaged_spins(self) -> Optional[bool]:
                """averaged_spins

                Returns:
                    typing.Optional[bool]:
                """

            @averaged_spins.setter
            def averaged_spins(self, arg: Optional[bool]) -> None:
                """
                Args:
                    arg (typing.Optional[bool])
                """

            @property
            def averaged_energy(self) -> Optional[bool]:
                """averaged_energy

                Returns:
                    typing.Optional[bool]:
                """

            @averaged_energy.setter
            def averaged_energy(self, arg: Optional[bool]) -> None:
                """
                Args:
                    arg (typing.Optional[bool])
                """

        class TemperatureParameters:
            @property
            def temperature_num_steps(self) -> Optional[int]:
                """temperature_num_steps

                Returns:
                    typing.Optional[int]:
                """

            @temperature_num_steps.setter
            def temperature_num_steps(self, arg: Optional[int]) -> None:
                """
                Args:
                    arg (typing.Optional[int])
                """

            @property
            def temperature_step_length(self) -> Optional[int]:
                """temperature_step_length

                Returns:
                    typing.Optional[int]:
                """

            @temperature_step_length.setter
            def temperature_step_length(self, arg: Optional[int]) -> None:
                """
                Args:
                    arg (typing.Optional[int])
                """

            @property
            def temperature_initial(self) -> Optional[float]:
                """temperature_initial

                Returns:
                    typing.Optional[float]:
                """

            @temperature_initial.setter
            def temperature_initial(self, arg: Optional[float]) -> None:
                """
                Args:
                    arg (typing.Optional[float])
                """

            @property
            def temperature_target(self) -> Optional[float]:
                """temperature_target

                Returns:
                    typing.Optional[float]:
                """

            @temperature_target.setter
            def temperature_target(self, arg: Optional[float]) -> None:
                """
                Args:
                    arg (typing.Optional[float])
                """

        @property
        def type(self) -> int:
            """type

            Returns:
                int:
            """

        @type.setter
        def type(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def num_executions(self) -> Optional[int]:
            """num_executions

            Returns:
                typing.Optional[int]:
            """

        @num_executions.setter
        def num_executions(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def outputs(self) -> HitachiClient.Parameters.Outputs:
            """outputs

            Returns:
                amplify.HitachiClient.Parameters.Outputs:
            """

        @property
        def parameters(self) -> HitachiClient.Parameters.TemperatureParameters:
            """parameters

            Returns:
                amplify.HitachiClient.Parameters.TemperatureParameters:
            """

    class Result:
        class Result:
            @property
            def execution_time(self) -> datetime.timedelta:
                """execution_time

                Returns:
                    datetime.timedelta:
                """

            @property
            def energies(
                self,
            ) -> Annotated[numpy.typing.NDArray[numpy.float64], {"dtype": "float64", "writable": False}]:
                """energies

                Returns:
                    numpy.ndarray:
                """

            @property
            def spins(self) -> list[list[tuple[int, int, int]]]:
                """spins

                Returns:
                    list[list[tuple[int, int, int]]]:
                """

            @property
            def averaged_energy(self) -> Optional[float]:
                """averaged_energy

                Returns:
                    typing.Optional[float]:
                """

            @property
            def averaged_spins(self) -> Optional[list[tuple[int, int, float]]]:
                """averaged_spins

                Returns:
                    typing.Optional[list[tuple[int, int, float]]]:
                """

        @property
        def status(self) -> int:
            """status

            Returns:
                int:
            """

        @property
        def message(self) -> Optional[str]:
            """message

            Returns:
                typing.Optional[str]:
            """

        @property
        def job_id(self) -> str:
            """job_id

            Returns:
                str:
            """

        @property
        def result(self) -> HitachiClient.Result.Result:
            """result

            Returns:
                amplify.HitachiClient.Result.Result:
            """

    @property
    def url(self) -> str:
        """url

        Returns:
            str:
        """

    @url.setter
    def url(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def token(self) -> str:
        """token

        Returns:
            str:
        """

    @token.setter
    def token(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def proxy(self) -> Optional[str]:
        """proxy

        Returns:
            typing.Optional[str]:
        """

    @proxy.setter
    def proxy(self, arg: Optional[str]) -> None:
        """
        Args:
            arg (typing.Optional[str])
        """

    @property
    def write_request_data(self) -> Optional[pathlib.Path]:
        """write_request_data

        Returns:
            typing.Optional[pathlib.Path]:
        """

    @write_request_data.setter
    def write_request_data(self, arg: Optional[str | os.PathLike]) -> None:
        """
        Args:
            arg (typing.Optional[str | os.PathLike])
        """

    @property
    def write_response_data(self) -> Optional[pathlib.Path]:
        """write_response_data

        Returns:
            typing.Optional[pathlib.Path]:
        """

    @write_response_data.setter
    def write_response_data(self, arg: Optional[str | os.PathLike]) -> None:
        """
        Args:
            arg (typing.Optional[str | os.PathLike])
        """

    @property
    def parameters(self) -> HitachiClient.Parameters:
        """parameters

        Returns:
            amplify.HitachiClient.Parameters:
        """

    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[False] = False) -> HitachiClient.Result: ...
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[True]) -> None:
        """solve

        .. admonition:: Overload 1.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * dry_run (typing.Literal[False]): Defaults to ``False``.

            Returns:
                amplify.HitachiClient.Result:

        .. admonition:: Overload 2.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * dry_run (typing.Literal[True])
        """

    @property
    def graph(self) -> Graph:
        """graph

        Returns:
            amplify.Graph:
        """

    @property
    def version(self) -> str:
        """version

        Returns:
            str:
        """

    @property
    def acceptable_degrees(self) -> AcceptableDegrees:
        """acceptable_degrees

        Returns:
            amplify.AcceptableDegrees:
        """

class IntegerEncodingMethod(enum.Enum):
    Unary = 0
    Linear = 1
    Binary = 2
    Default = 3

class LeapHybridCQMSamplerClient(AmplifyClient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, token: str = "", solver: str = "", url: str = "", proxy: Optional[str] = None) -> None: ...
    @property
    def url(self) -> str:
        """url

        Returns:
            str:
        """

    @url.setter
    def url(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def token(self) -> str:
        """token

        Returns:
            str:
        """

    @token.setter
    def token(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def solver(self) -> str:
        """solver

        Returns:
            str:
        """

    @solver.setter
    def solver(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def proxy(self) -> Optional[str]:
        """proxy

        Returns:
            typing.Optional[str]:
        """

    @proxy.setter
    def proxy(self, arg: Optional[str]) -> None:
        """
        Args:
            arg (typing.Optional[str])
        """

    @property
    def compress_qpu_problem_data(self) -> Optional[bool]:
        """compress_qpu_problem_data

        Returns:
            typing.Optional[bool]:
        """

    @compress_qpu_problem_data.setter
    def compress_qpu_problem_data(self, arg: Optional[bool]) -> None:
        """
        Args:
            arg (typing.Optional[bool])
        """

    @property
    def write_request_data(self) -> Optional[pathlib.Path]:
        """write_request_data

        Returns:
            typing.Optional[pathlib.Path]:
        """

    @write_request_data.setter
    def write_request_data(self, arg: Optional[str | os.PathLike]) -> None:
        """
        Args:
            arg (typing.Optional[str | os.PathLike])
        """

    @property
    def write_response_data(self) -> Optional[pathlib.Path]:
        """write_response_data

        Returns:
            typing.Optional[pathlib.Path]:
        """

    @write_response_data.setter
    def write_response_data(self, arg: Optional[str | os.PathLike]) -> None:
        """
        Args:
            arg (typing.Optional[str | os.PathLike])
        """

    @property
    def parameters(self) -> DWaveClientParameters:
        """parameters

        Returns:
            amplify.DWaveClientParameters:
        """

    @property
    def solver_names(self) -> list[str]:
        """solver_names

        Returns:
            list[str]:
        """

    @property
    def properties(self) -> dict[str, Any]:
        """properties

        Returns:
            dict[str, typing.Any]:
        """

    @property
    def version(self) -> str:
        """version

        Returns:
            str:
        """

    @property
    def acceptable_degrees(self) -> AcceptableDegrees:
        """acceptable_degrees

        Returns:
            amplify.AcceptableDegrees:
        """

    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[False] = False) -> dimod.sampleset.SampleSet: ...
    @overload
    def solve(
        self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[False] = False
    ) -> dimod.sampleset.SampleSet: ...
    @overload
    def solve(
        self,
        objective: Union[Poly, Matrix],
        constraint: Union[Constraint, ConstraintList],
        dry_run: Literal[False] = False,
    ) -> dimod.sampleset.SampleSet: ...
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(
        self, objective: Union[Poly, Matrix], constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]
    ) -> None:
        """solve

        .. admonition:: Overload 1.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * dry_run (typing.Literal[False]): Defaults to ``False``.

            Returns:
                dimod.sampleset.SampleSet:

        .. admonition:: Overload 2.

            Args:
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[False]): Defaults to ``False``.

            Returns:
                dimod.sampleset.SampleSet:

        .. admonition:: Overload 3.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[False]): Defaults to ``False``.

            Returns:
                dimod.sampleset.SampleSet:

        .. admonition:: Overload 4.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * dry_run (typing.Literal[True])

        .. admonition:: Overload 5.

            Args:
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[True])

        .. admonition:: Overload 6.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[True])
        """

class LeapHybridSamplerClient(AmplifyClient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, token: str = "", solver: str = "", url: str = "", proxy: Optional[str] = None) -> None: ...
    @property
    def url(self) -> str:
        """url

        Returns:
            str:
        """

    @url.setter
    def url(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def token(self) -> str:
        """token

        Returns:
            str:
        """

    @token.setter
    def token(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def solver(self) -> str:
        """solver

        Returns:
            str:
        """

    @solver.setter
    def solver(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def proxy(self) -> Optional[str]:
        """proxy

        Returns:
            typing.Optional[str]:
        """

    @proxy.setter
    def proxy(self, arg: Optional[str]) -> None:
        """
        Args:
            arg (typing.Optional[str])
        """

    @property
    def compress_qpu_problem_data(self) -> Optional[bool]:
        """compress_qpu_problem_data

        Returns:
            typing.Optional[bool]:
        """

    @compress_qpu_problem_data.setter
    def compress_qpu_problem_data(self, arg: Optional[bool]) -> None:
        """
        Args:
            arg (typing.Optional[bool])
        """

    @property
    def write_request_data(self) -> Optional[pathlib.Path]:
        """write_request_data

        Returns:
            typing.Optional[pathlib.Path]:
        """

    @write_request_data.setter
    def write_request_data(self, arg: Optional[str | os.PathLike]) -> None:
        """
        Args:
            arg (typing.Optional[str | os.PathLike])
        """

    @property
    def write_response_data(self) -> Optional[pathlib.Path]:
        """write_response_data

        Returns:
            typing.Optional[pathlib.Path]:
        """

    @write_response_data.setter
    def write_response_data(self, arg: Optional[str | os.PathLike]) -> None:
        """
        Args:
            arg (typing.Optional[str | os.PathLike])
        """

    @property
    def parameters(self) -> DWaveClientParameters:
        """parameters

        Returns:
            amplify.DWaveClientParameters:
        """

    @property
    def solver_names(self) -> list[str]:
        """solver_names

        Returns:
            list[str]:
        """

    @property
    def properties(self) -> dict[str, Any]:
        """properties

        Returns:
            dict[str, typing.Any]:
        """

    @property
    def version(self) -> str:
        """version

        Returns:
            str:
        """

    @property
    def acceptable_degrees(self) -> AcceptableDegrees:
        """acceptable_degrees

        Returns:
            amplify.AcceptableDegrees:
        """

    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[False] = False) -> dimod.sampleset.SampleSet: ...
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[True]) -> None:
        """solve

        .. admonition:: Overload 1.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * dry_run (typing.Literal[False]): Defaults to ``False``.

            Returns:
                dimod.sampleset.SampleSet:

        .. admonition:: Overload 2.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * dry_run (typing.Literal[True])
        """

class Matrix:
    def __eq__(self, arg: object, /) -> bool: ...
    def __ne__(self, arg: object, /) -> bool: ...
    @property
    def quadratic(self) -> Annotated[numpy.typing.NDArray[numpy.float64], {"dtype": "float64"}]:
        """quadratic

        Returns:
            numpy.ndarray:
        """

    @quadratic.setter
    def quadratic(self, arg: Annotated[NDArray, {"dtype": "float64"}], /) -> None:
        """
        Args:
            arg (ndarray)
        """

    @property
    def linear(self) -> Annotated[numpy.typing.NDArray[numpy.float64], {"dtype": "float64"}]:
        """linear

        Returns:
            numpy.ndarray:
        """

    @linear.setter
    def linear(self, arg: Annotated[NDArray, {"dtype": "float64"}], /) -> None:
        """
        Args:
            arg (ndarray)
        """

    @property
    def constant(self) -> float:
        """constant

        Returns:
            float:
        """

    @constant.setter
    def constant(self, arg: float, /) -> None:
        """
        Args:
            arg (float)
        """

    @property
    def variable_array(self) -> PolyArray[Dim]:
        """variable_array

        Returns:
            amplify.PolyArray[Dim]:
        """

    def to_poly(self) -> Poly:
        """to_poly

        Returns:
            amplify.Poly:
        """

    def __add__(self, arg: Union[Constraint, ConstraintList], /) -> Model: ...
    def __radd__(self, arg: Union[Constraint, ConstraintList], /) -> Model: ...
    @overload
    def evaluate(self, values: Values) -> float: ...
    @overload
    def evaluate(self, values: Values, default: float) -> float:
        """evaluate

        .. admonition:: Overload 1.

            Args:
                * values (amplify.Values)

            Returns:
                float:

        .. admonition:: Overload 2.

            Args:
                * values (amplify.Values)
                * default (float)

            Returns:
                float:
        """

class Model:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, objective: Union[Poly, Matrix]) -> None: ...
    @overload
    def __init__(self, constraint: Union[Constraint, ConstraintList]) -> None: ...
    @overload
    def __init__(self, objective: Union[Poly, Matrix], constraint: Union[Constraint, ConstraintList]) -> None: ...
    def __eq__(self, arg: object, /) -> bool: ...
    def __ne__(self, arg: object, /) -> bool: ...
    def __iadd__(self, arg: Union[Poly, Constraint, ConstraintList], /) -> Model: ...
    def __add__(self, arg: Union[Poly, Constraint, ConstraintList], /) -> Model: ...
    def __radd__(self, arg: Union[Poly, Constraint, ConstraintList], /) -> Model: ...
    def __isub__(self, arg: Poly, /) -> Model: ...
    def __sub__(self, arg: Poly, /) -> Model: ...
    @property
    def objective(self) -> Union[Poly, Matrix]:
        """objective

        Returns:
            typing.Union[amplify.Poly, amplify.Matrix]:
        """

    @objective.setter
    def objective(self, arg: Union[Poly, Matrix], /) -> None:
        """
        Args:
            arg (typing.Union[amplify.Poly, amplify.Matrix])
        """

    @property
    def constraints(self) -> ConstraintList:
        """constraints

        Returns:
            amplify.ConstraintList:
        """

    @constraints.setter
    def constraints(self, arg: Union[Constraint, ConstraintList], /) -> None:
        """
        Args:
            arg (typing.Union[amplify.Constraint, amplify.ConstraintList])
        """

    @property
    def variables(self) -> list[Variable]:
        """alias of `~amplify.Model.get_variables`

        Returns:
            list[amplify.Variable]:
        """

    def get_variables(self, with_penalty: bool = False) -> list[Variable]:
        """get_variables

        Args:
            with_penalty (bool): Defaults to ``False``.

        Returns:
            list[amplify.Variable]:
        """

    def to_intermediate_model(
        self,
        acceptable_degrees: AcceptableDegrees,
        integer_encoding_method: Union[
            Literal["Unary", "Linear", "Binary", "Default"], IntegerEncodingMethod
        ] = IntegerEncodingMethod.Default,
        real_encoding_method: Union[
            Literal["Random4", "Random8", "Random16", "Random32"], RealEncodingMethod
        ] = RealEncodingMethod.Random16,
        quadratization_method: Union[
            Literal["IshikawaKZFD", "Substitute"], QuadratizationMethod
        ] = QuadratizationMethod.IshikawaKZFD,
        substitution_multiplier: float = 1.0,
    ) -> tuple[Model, Result.ModelConversion.IntermediateMapping]:
        """to_intermediate_model

        Args:
            acceptable_degrees (amplify.AcceptableDegrees)
            integer_encoding_method (typing.Union[typing.Literal['Unary', 'Linear', 'Binary', 'Default'], amplify.IntegerEncodingMethod]): Defaults to ``IntegerEncodingMethod.Default``.
            real_encoding_method (typing.Union[typing.Literal['Random4', 'Random8', 'Random16', 'Random32'], amplify.RealEncodingMethod]): Defaults to ``RealEncodingMethod.Random16``.
            quadratization_method (typing.Union[typing.Literal['IshikawaKZFD', 'Substitute'], amplify.QuadratizationMethod]): Defaults to ``QuadratizationMethod.IshikawaKZFD``.
            substitution_multiplier (float): Defaults to ``1.0``.

        Returns:
            tuple[amplify.Model, amplify.Result.ModelConversion.IntermediateMapping]:
        """

    def to_unconstrained_poly(self) -> Poly:
        """to_unconstrained_poly

        Returns:
            amplify.Poly:
        """

    def copy(self) -> Model:
        """copy

        Returns:
            amplify.Model:
        """

class NECVA2Client(AmplifyClient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, token: str = "", url: str = "", proxy: Optional[str] = None) -> None: ...

    class Parameters:
        @property
        def num_reads(self) -> Optional[int]:
            """num_reads

            Returns:
                typing.Optional[int]:
            """

        @num_reads.setter
        def num_reads(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def num_results(self) -> Optional[int]:
            """num_results

            Returns:
                typing.Optional[int]:
            """

        @num_results.setter
        def num_results(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def num_sweeps(self) -> Optional[int]:
            """num_sweeps

            Returns:
                typing.Optional[int]:
            """

        @num_sweeps.setter
        def num_sweeps(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def beta_range(self) -> Optional[tuple[float, float, int]]:
            """beta_range

            Returns:
                typing.Optional[tuple[float, float, int]]:
            """

        @beta_range.setter
        def beta_range(self, arg: Optional[tuple[float, float, int]]) -> None:
            """
            Args:
                arg (typing.Optional[tuple[float, float, int]])
            """

        @property
        def beta_list(self) -> Optional[list[float]]:
            """beta_list

            Returns:
                typing.Optional[list[float]]:
            """

        @beta_list.setter
        def beta_list(self, arg: Optional[Sequence[float]]) -> None:
            """
            Args:
                arg (typing.Optional[collections.abc.Sequence[float]])
            """

        @property
        def dense(self) -> Optional[bool]:
            """dense

            Returns:
                typing.Optional[bool]:
            """

        @dense.setter
        def dense(self, arg: Optional[bool]) -> None:
            """
            Args:
                arg (typing.Optional[bool])
            """

        @property
        def vector_mode(self) -> Optional[NECVA2Client.VectorMode]:
            """vector_mode

            Returns:
                typing.Optional[amplify.NECVA2Client.VectorMode]:
            """

        @vector_mode.setter
        def vector_mode(self, arg: Optional[Union[Literal["Accuracy", "Speed"], NECVA2Client.VectorMode]]) -> None:
            """
            Args:
                arg (typing.Optional[typing.Union[typing.Literal['Accuracy', 'Speed'], amplify.NECVA2Client.VectorMode]])
            """

        @property
        def timeout(self) -> Optional[datetime.timedelta]:
            """timeout

            Returns:
                typing.Optional[datetime.timedelta]:
            """

        @timeout.setter
        def timeout(self, arg: Optional[Union[int, datetime.timedelta]]) -> None:
            """
            Args:
                arg (typing.Optional[typing.Union[int, datetime.timedelta]])
            """

        @property
        def ve_num(self) -> Optional[int]:
            """ve_num

            Returns:
                typing.Optional[int]:
            """

        @ve_num.setter
        def ve_num(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

    class Result:
        class Timing:
            @property
            def execution_time(self) -> datetime.timedelta:
                """execution_time

                Returns:
                    datetime.timedelta:
                """

            @property
            def solve_qubo_time(self) -> datetime.timedelta:
                """solve_qubo_time

                Returns:
                    datetime.timedelta:
                """

            @property
            def queue_time(self) -> datetime.timedelta:
                """queue_time

                Returns:
                    datetime.timedelta:
                """

        class Result:
            @property
            def constraint(self) -> bool:
                """constraint

                Returns:
                    bool:
                """

            @property
            def energy(self) -> float:
                """energy

                Returns:
                    float:
                """

            @property
            def memory_usage(self) -> float:
                """memory_usage

                Returns:
                    float:
                """

            @property
            def spin(self) -> dict[str, int]:
                """spin

                Returns:
                    dict[str, int]:
                """

            @property
            def time(self) -> datetime.timedelta:
                """time

                Returns:
                    datetime.timedelta:
                """

        @property
        def result(self) -> list[NECVA2Client.Result.Result]:
            """result

            Returns:
                list[amplify.NECVA2Client.Result.Result]:
            """

        @property
        def timing(self) -> NECVA2Client.Result.Timing:
            """timing

            Returns:
                amplify.NECVA2Client.Result.Timing:
            """

    class VectorMode(enum.Enum):
        Accuracy = 0
        Speed = 1

    @property
    def url(self) -> str:
        """url

        Returns:
            str:
        """

    @url.setter
    def url(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def token(self) -> str:
        """token

        Returns:
            str:
        """

    @token.setter
    def token(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def proxy(self) -> Optional[str]:
        """proxy

        Returns:
            typing.Optional[str]:
        """

    @proxy.setter
    def proxy(self, arg: Optional[str]) -> None:
        """
        Args:
            arg (typing.Optional[str])
        """

    @property
    def write_request_data(self) -> Optional[pathlib.Path]:
        """write_request_data

        Returns:
            typing.Optional[pathlib.Path]:
        """

    @write_request_data.setter
    def write_request_data(self, arg: Optional[str | os.PathLike]) -> None:
        """
        Args:
            arg (typing.Optional[str | os.PathLike])
        """

    @property
    def write_response_data(self) -> Optional[pathlib.Path]:
        """write_response_data

        Returns:
            typing.Optional[pathlib.Path]:
        """

    @write_response_data.setter
    def write_response_data(self, arg: Optional[str | os.PathLike]) -> None:
        """
        Args:
            arg (typing.Optional[str | os.PathLike])
        """

    @property
    def set_onehot(self) -> bool:
        """set_onehot

        Returns:
            bool:
        """

    @set_onehot.setter
    def set_onehot(self, arg: bool, /) -> None:
        """
        Args:
            arg (bool)
        """

    @property
    def set_fixed(self) -> bool:
        """set_fixed

        Returns:
            bool:
        """

    @set_fixed.setter
    def set_fixed(self, arg: bool, /) -> None:
        """
        Args:
            arg (bool)
        """

    @property
    def set_andzero(self) -> bool:
        """set_andzero

        Returns:
            bool:
        """

    @set_andzero.setter
    def set_andzero(self, arg: bool, /) -> None:
        """
        Args:
            arg (bool)
        """

    @property
    def set_orone(self) -> bool:
        """set_orone

        Returns:
            bool:
        """

    @set_orone.setter
    def set_orone(self, arg: bool, /) -> None:
        """
        Args:
            arg (bool)
        """

    @property
    def set_supplement(self) -> bool:
        """set_supplement

        Returns:
            bool:
        """

    @set_supplement.setter
    def set_supplement(self, arg: bool, /) -> None:
        """
        Args:
            arg (bool)
        """

    @property
    def set_maxone(self) -> bool:
        """set_maxone

        Returns:
            bool:
        """

    @set_maxone.setter
    def set_maxone(self, arg: bool, /) -> None:
        """
        Args:
            arg (bool)
        """

    @property
    def set_minmaxone(self) -> bool:
        """set_minmaxone

        Returns:
            bool:
        """

    @set_minmaxone.setter
    def set_minmaxone(self, arg: bool, /) -> None:
        """
        Args:
            arg (bool)
        """

    @property
    def parameters(self) -> NECVA2Client.Parameters:
        """parameters

        Returns:
            amplify.NECVA2Client.Parameters:
        """

    @property
    def version(self) -> str:
        """version

        Returns:
            str:
        """

    @property
    def acceptable_degrees(self) -> AcceptableDegrees:
        """acceptable_degrees

        Returns:
            amplify.AcceptableDegrees:
        """

    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[False] = False) -> NECVA2Client.Result: ...
    @overload
    def solve(
        self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[False] = False
    ) -> NECVA2Client.Result: ...
    @overload
    def solve(
        self,
        objective: Union[Poly, Matrix],
        constraint: Union[Constraint, ConstraintList],
        dry_run: Literal[False] = False,
    ) -> NECVA2Client.Result: ...
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(
        self, objective: Union[Poly, Matrix], constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]
    ) -> None:
        """solve

        .. admonition:: Overload 1.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * dry_run (typing.Literal[False]): Defaults to ``False``.

            Returns:
                amplify.NECVA2Client.Result:

        .. admonition:: Overload 2.

            Args:
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[False]): Defaults to ``False``.

            Returns:
                amplify.NECVA2Client.Result:

        .. admonition:: Overload 3.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[False]): Defaults to ``False``.

            Returns:
                amplify.NECVA2Client.Result:

        .. admonition:: Overload 4.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * dry_run (typing.Literal[True])

        .. admonition:: Overload 5.

            Args:
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[True])

        .. admonition:: Overload 6.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[True])
        """

class PenaltyFormulation(enum.Enum):
    Default = 0
    IntegerVariable = 1
    RealVariable = 2
    Relaxation = 3
    LinearRelaxation = 4
    QuadraticRelaxation = 5

class Poly:
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg: float, /) -> None: ...
    @overload
    def __init__(self, arg: Variable, /) -> None: ...
    @overload
    def __add__(self, arg: Union[Poly, float], /) -> Poly: ...
    @overload
    def __add__(self, arg: NDArray, /) -> PolyArray[Dim]: ...
    @overload
    def __add__(self, arg: Union[Constraint, ConstraintList], /) -> Model: ...
    @overload
    def __radd__(self, arg: float, /) -> Poly: ...
    @overload
    def __radd__(self, arg: NDArray, /) -> PolyArray[Dim]: ...
    @overload
    def __radd__(self, arg: Union[Constraint, ConstraintList], /) -> Model: ...
    def __iadd__(self, arg: Union[Poly, float], /) -> Poly: ...
    @overload
    def __sub__(self, arg: Union[Poly, float], /) -> Poly: ...
    @overload
    def __sub__(self, arg: NDArray, /) -> PolyArray[Dim]: ...
    @overload
    def __rsub__(self, arg: float, /) -> Poly: ...
    @overload
    def __rsub__(self, arg: NDArray, /) -> PolyArray[Dim]: ...
    def __isub__(self, arg: Union[Poly, float], /) -> Poly: ...
    @overload
    def __mul__(self, arg: Union[Poly, float], /) -> Poly: ...
    @overload
    def __mul__(self, arg: NDArray, /) -> PolyArray[Dim]: ...
    @overload
    def __rmul__(self, arg: float, /) -> Poly: ...
    @overload
    def __rmul__(self, arg: NDArray, /) -> PolyArray[Dim]: ...
    def __imul__(self, arg: Union[Poly, float], /) -> Poly: ...
    @overload
    def __truediv__(self, arg: float, /) -> Poly: ...
    @overload
    def __truediv__(self, arg: NDArray, /) -> PolyArray[Dim]: ...
    def __itruediv__(self, arg: float, /) -> Poly: ...
    def __eq__(self, arg: object, /) -> bool: ...
    def __ne__(self, arg: object, /) -> bool: ...
    def __pos__(self) -> Poly: ...
    def __neg__(self) -> Poly: ...
    @overload
    def __and__(self, arg: Union[Poly, bool], /) -> Poly: ...
    @overload
    def __and__(self, arg: Annotated[NDArray, {"dtype": "bool"}], /) -> PolyArray[Dim]: ...
    @overload
    def __rand__(self, arg: bool, /) -> Poly: ...
    @overload
    def __rand__(self, arg: Annotated[NDArray, {"dtype": "bool"}], /) -> PolyArray[Dim]: ...
    def __iand__(self, arg: Union[Poly, bool], /) -> Poly: ...
    @overload
    def __or__(self, arg: Union[Poly, bool], /) -> Poly: ...
    @overload
    def __or__(self, arg: Annotated[NDArray, {"dtype": "bool"}], /) -> PolyArray[Dim]: ...
    @overload
    def __ror__(self, arg: bool, /) -> Poly: ...
    @overload
    def __ror__(self, arg: Annotated[NDArray, {"dtype": "bool"}], /) -> PolyArray[Dim]: ...
    def __ior__(self, arg: Union[Poly, bool], /) -> Poly: ...
    @overload
    def __xor__(self, arg: Union[Poly, bool], /) -> Poly: ...
    @overload
    def __xor__(self, arg: Annotated[NDArray, {"dtype": "bool"}], /) -> PolyArray[Dim]: ...
    @overload
    def __rxor__(self, arg: bool, /) -> Poly: ...
    @overload
    def __rxor__(self, arg: Annotated[NDArray, {"dtype": "bool"}], /) -> PolyArray[Dim]: ...
    def __ixor__(self, arg: Union[Poly, bool], /) -> Poly: ...
    def __invert__(self) -> Poly: ...
    def __len__(self) -> int: ...
    def __pow__(self, arg: int, /) -> Poly: ...
    def __ipow__(self, arg: int, /) -> Poly: ...
    def __int__(self) -> int: ...
    def __index__(self) -> int: ...
    def __float__(self) -> float: ...
    def __bool__(self) -> bool: ...

    class Iterator:
        def __iter__(self) -> Poly.Iterator: ...
        def __next__(self) -> tuple[tuple[Poly, ...], float]: ...

    def __iter__(self) -> Poly.Iterator: ...
    @property
    def id(self) -> int:
        """id

        Returns:
            int:
        """

    @property
    def type(self) -> VariableType:
        """type

        Returns:
            amplify.VariableType:
        """

    @property
    def name(self) -> str:
        """name

        Returns:
            str:
        """

    @name.setter
    def name(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def lower_bound(self) -> Optional[float]:
        """lower_bound

        Returns:
            typing.Optional[float]:
        """

    @lower_bound.setter
    def lower_bound(self, arg: Optional[float]) -> None:
        """
        Args:
            arg (typing.Optional[float])
        """

    @property
    def upper_bound(self) -> Optional[float]:
        """upper_bound

        Returns:
            typing.Optional[float]:
        """

    @upper_bound.setter
    def upper_bound(self, arg: Optional[float]) -> None:
        """
        Args:
            arg (typing.Optional[float])
        """

    def as_variable(self) -> Variable:
        """as_variable

        Returns:
            amplify.Variable:
        """

    @property
    def variables(self) -> list[Variable]:
        """variables

        Returns:
            list[amplify.Variable]:
        """

    @overload
    def evaluate(self, values: Values) -> float: ...
    @overload
    def evaluate(self, values: Values, default: float) -> float: ...
    @overload
    def evaluate(self, values: Values, default: Literal[None]) -> Poly:
        """evaluate

        .. admonition:: Overload 1.

            Args:
                * values (amplify.Values)

            Returns:
                float:

        .. admonition:: Overload 2.

            Args:
                * values (amplify.Values)
                * default (float)

            Returns:
                float:

        .. admonition:: Overload 3.

            Args:
                * values (amplify.Values)
                * default (typing.Literal[None])

            Returns:
                amplify.Poly:
        """

    @overload
    def decode(self, values: Values) -> float: ...
    @overload
    def decode(self, values: Values, default: float) -> float: ...
    @overload
    def decode(self, values: Values, default: Literal[None]) -> Poly:
        """decode

        .. admonition:: Overload 1.

            Args:
                * values (amplify.Values)

            Returns:
                float:

        .. admonition:: Overload 2.

            Args:
                * values (amplify.Values)
                * default (float)

            Returns:
                float:

        .. admonition:: Overload 3.

            Args:
                * values (amplify.Values)
                * default (typing.Literal[None])

            Returns:
                amplify.Poly:
        """

    def substitute(
        self, mapping: Union[Mapping[Poly, Union[Poly, float]], Mapping[Variable, Union[Poly, float]]]
    ) -> Poly:
        """substitute

        Args:
            mapping (typing.Union[collections.abc.Mapping[amplify.Poly, typing.Union[amplify.Poly, float]], collections.abc.Mapping[amplify.Variable, typing.Union[amplify.Poly, float]]])

        Returns:
            amplify.Poly:
        """

    def is_number(self) -> bool:
        """is_number

        Returns:
            bool:
        """

    def is_variable(self) -> bool:
        """is_variable

        Returns:
            bool:
        """

    def is_linear(self) -> bool:
        """is_linear

        Returns:
            bool:
        """

    def is_quadratic(self) -> bool:
        """is_quadratic

        Returns:
            bool:
        """

    def degree(self) -> int:
        """degree

        Returns:
            int:
        """

    def as_dict(self) -> dict[tuple[int, ...], float]:
        """as_dict

        Returns:
            dict[tuple[int, ...], float]:
        """

    def asdict(self) -> dict[tuple[int, ...], float]:
        """alias of :meth:`~amplify.Poly.as_dict`

        Returns:
            dict[tuple[int, ...], float]:
        """

class PolyArray(Generic[_Dim]):
    def __init__(self, object: Union[NDArray, list, Poly]) -> None: ...

    __Dim = TypeVar("__Dim", bound=Dim)

    @overload
    def __add__(self, arg: Union[Poly, float], /) -> PolyArray[_Dim]: ...
    @overload
    def __add__(self, arg: Union[list, NDArray], /) -> PolyArray[Dim]: ...
    @overload
    def __add__(self, arg: PolyArray[Dim]) -> PolyArray[Dim]: ...
    @overload
    def __add__(self: PolyArray[Dim0], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __add__(self, arg: PolyArray[Dim0]) -> PolyArray[_Dim]: ...
    @overload
    def __add__(self: PolyArray[Dim1], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __add__(self, arg: PolyArray[Dim1]) -> PolyArray[_Dim]: ...
    @overload
    def __add__(self: PolyArray[Dim2], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __add__(self, arg: PolyArray[Dim2]) -> PolyArray[_Dim]: ...
    @overload
    def __add__(self: PolyArray[Dim3], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __add__(self, arg: PolyArray[Dim3]) -> PolyArray[_Dim]: ...
    @overload
    def __add__(self: PolyArray[Dim4], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __add__(self, arg: PolyArray[Dim4]) -> PolyArray[_Dim]: ...
    @overload
    def __radd__(self, arg: Union[Poly, float], /) -> PolyArray[_Dim]: ...
    @overload
    def __radd__(self, arg: Union[list, NDArray], /) -> PolyArray[Dim]: ...
    @overload
    def __iadd__(self, arg: Union[Poly, float], /) -> PolyArray[_Dim]: ...
    @overload
    def __iadd__(self, arg: Union[list, NDArray], /) -> PolyArray[_Dim]: ...
    @overload
    def __iadd__(self: PolyArray[Dim], arg: PolyArray[__Dim]) -> PolyArray[Dim]: ...
    @overload
    def __iadd__(self: PolyArray[Dim0], arg: PolyArray[Dim0]) -> PolyArray[Dim0]: ...
    @overload
    def __iadd__(self: PolyArray[Dim1], arg: PolyArray[Union[Dim0, Dim1]]) -> PolyArray[Dim1]: ...
    @overload
    def __iadd__(self: PolyArray[Dim2], arg: PolyArray[Union[Dim0, Dim1, Dim2]]) -> PolyArray[Dim2]: ...
    @overload
    def __iadd__(self: PolyArray[Dim3], arg: PolyArray[Union[Dim0, Dim1, Dim2, Dim3]]) -> PolyArray[Dim3]: ...
    @overload
    def __iadd__(self: PolyArray[Dim4], arg: PolyArray[Union[Dim0, Dim1, Dim2, Dim3, Dim4]]) -> PolyArray[Dim4]: ...
    @overload
    def __sub__(self, arg: Union[Poly, float], /) -> PolyArray[_Dim]: ...
    @overload
    def __sub__(self, arg: Union[list, NDArray], /) -> PolyArray[Dim]: ...
    @overload
    def __sub__(self, arg: PolyArray[Dim]) -> PolyArray[Dim]: ...
    @overload
    def __sub__(self: PolyArray[Dim0], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __sub__(self, arg: PolyArray[Dim0]) -> PolyArray[_Dim]: ...
    @overload
    def __sub__(self: PolyArray[Dim1], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __sub__(self, arg: PolyArray[Dim1]) -> PolyArray[_Dim]: ...
    @overload
    def __sub__(self: PolyArray[Dim2], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __sub__(self, arg: PolyArray[Dim2]) -> PolyArray[_Dim]: ...
    @overload
    def __sub__(self: PolyArray[Dim3], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __sub__(self, arg: PolyArray[Dim3]) -> PolyArray[_Dim]: ...
    @overload
    def __sub__(self: PolyArray[Dim4], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __sub__(self, arg: PolyArray[Dim4]) -> PolyArray[_Dim]: ...
    @overload
    def __rsub__(self, arg: Union[Poly, float], /) -> PolyArray[_Dim]: ...
    @overload
    def __rsub__(self, arg: Union[list, NDArray], /) -> PolyArray[Dim]: ...
    @overload
    def __isub__(self, arg: Union[Poly, float], /) -> PolyArray[_Dim]: ...
    @overload
    def __isub__(self, arg: Union[list, NDArray], /) -> PolyArray[_Dim]: ...
    @overload
    def __isub__(self: PolyArray[Dim], arg: PolyArray[__Dim]) -> PolyArray[Dim]: ...
    @overload
    def __isub__(self: PolyArray[Dim0], arg: PolyArray[Dim0]) -> PolyArray[Dim0]: ...
    @overload
    def __isub__(self: PolyArray[Dim1], arg: PolyArray[Union[Dim0, Dim1]]) -> PolyArray[Dim1]: ...
    @overload
    def __isub__(self: PolyArray[Dim2], arg: PolyArray[Union[Dim0, Dim1, Dim2]]) -> PolyArray[Dim2]: ...
    @overload
    def __isub__(self: PolyArray[Dim3], arg: PolyArray[Union[Dim0, Dim1, Dim2, Dim3]]) -> PolyArray[Dim3]: ...
    @overload
    def __isub__(self: PolyArray[Dim4], arg: PolyArray[Union[Dim0, Dim1, Dim2, Dim3, Dim4]]) -> PolyArray[Dim4]: ...
    @overload
    def __mul__(self, arg: Union[Poly, float], /) -> PolyArray[_Dim]: ...
    @overload
    def __mul__(self, arg: Union[list, NDArray], /) -> PolyArray[Dim]: ...
    @overload
    def __mul__(self, arg: PolyArray[Dim]) -> PolyArray[Dim]: ...
    @overload
    def __mul__(self: PolyArray[Dim0], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __mul__(self, arg: PolyArray[Dim0]) -> PolyArray[_Dim]: ...
    @overload
    def __mul__(self: PolyArray[Dim1], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __mul__(self, arg: PolyArray[Dim1]) -> PolyArray[_Dim]: ...
    @overload
    def __mul__(self: PolyArray[Dim2], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __mul__(self, arg: PolyArray[Dim2]) -> PolyArray[_Dim]: ...
    @overload
    def __mul__(self: PolyArray[Dim3], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __mul__(self, arg: PolyArray[Dim3]) -> PolyArray[_Dim]: ...
    @overload
    def __mul__(self: PolyArray[Dim4], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __mul__(self, arg: PolyArray[Dim4]) -> PolyArray[_Dim]: ...
    @overload
    def __rmul__(self, arg: Union[Poly, float], /) -> PolyArray[_Dim]: ...
    @overload
    def __rmul__(self, arg: Union[list, NDArray], /) -> PolyArray[Dim]: ...
    @overload
    def __imul__(self, arg: Union[Poly, float], /) -> PolyArray[_Dim]: ...
    @overload
    def __imul__(self, arg: Union[list, NDArray], /) -> PolyArray[_Dim]: ...
    @overload
    def __imul__(self: PolyArray[Dim], arg: PolyArray[__Dim]) -> PolyArray[Dim]: ...
    @overload
    def __imul__(self: PolyArray[Dim0], arg: PolyArray[Dim0]) -> PolyArray[Dim0]: ...
    @overload
    def __imul__(self: PolyArray[Dim1], arg: PolyArray[Union[Dim0, Dim1]]) -> PolyArray[Dim1]: ...
    @overload
    def __imul__(self: PolyArray[Dim2], arg: PolyArray[Union[Dim0, Dim1, Dim2]]) -> PolyArray[Dim2]: ...
    @overload
    def __imul__(self: PolyArray[Dim3], arg: PolyArray[Union[Dim0, Dim1, Dim2, Dim3]]) -> PolyArray[Dim3]: ...
    @overload
    def __imul__(self: PolyArray[Dim4], arg: PolyArray[Union[Dim0, Dim1, Dim2, Dim3, Dim4]]) -> PolyArray[Dim4]: ...
    @overload
    def __truediv__(self, arg: Union[float], /) -> PolyArray[_Dim]: ...
    @overload
    def __truediv__(self, arg: Union[list, NDArray], /) -> PolyArray[Dim]: ...
    def __itruediv__(self, arg: Union[float, list, NDArray], /) -> PolyArray[_Dim]: ...
    def __matmul__(self, arg: Union[PolyArray, NDArray], /) -> Union[Poly, PolyArray[_Dim]]: ...
    def __rmatmul__(self, arg: Union[NDArray, PolyArray[__Dim]]) -> Union[Poly, PolyArray[__Dim]]: ...
    @overload
    def __eq__(
        self, arg: Union[PolyArray, Poly, float, list, NDArray], /
    ) -> Annotated[numpy.typing.NDArray[numpy.bool_], {"dtype": "bool"}]: ...
    @overload
    def __eq__(self, arg: object, /) -> bool: ...
    @overload
    def __ne__(
        self, arg: Union[PolyArray, Poly, float, list, NDArray], /
    ) -> Annotated[numpy.typing.NDArray[numpy.bool_], {"dtype": "bool"}]: ...
    @overload
    def __ne__(self, arg: object, /) -> bool: ...
    def __pos__(self) -> PolyArray[_Dim]: ...
    def __neg__(self) -> PolyArray[_Dim]: ...
    @overload
    def __and__(self, arg: Union[Poly, bool], /) -> PolyArray[_Dim]: ...
    @overload
    def __and__(self, arg: Union[list, Annotated[NDArray, {"dtype": "bool"}]], /) -> PolyArray[Dim]: ...
    @overload
    def __and__(self, arg: PolyArray[Dim]) -> PolyArray[Dim]: ...
    @overload
    def __and__(self: PolyArray[Dim0], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __and__(self, arg: PolyArray[Dim0]) -> PolyArray[_Dim]: ...
    @overload
    def __and__(self: PolyArray[Dim1], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __and__(self, arg: PolyArray[Dim1]) -> PolyArray[_Dim]: ...
    @overload
    def __and__(self: PolyArray[Dim2], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __and__(self, arg: PolyArray[Dim2]) -> PolyArray[_Dim]: ...
    @overload
    def __and__(self: PolyArray[Dim3], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __and__(self, arg: PolyArray[Dim3]) -> PolyArray[_Dim]: ...
    @overload
    def __and__(self: PolyArray[Dim4], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __and__(self, arg: PolyArray[Dim4]) -> PolyArray[_Dim]: ...
    @overload
    def __rand__(self, arg: Union[Poly, bool], /) -> PolyArray[_Dim]: ...
    @overload
    def __rand__(self, arg: Union[list, Annotated[NDArray, {"dtype": "bool"}]], /) -> PolyArray[Dim]: ...
    @overload
    def __iand__(self, arg: Union[Poly, bool], /) -> PolyArray[_Dim]: ...
    @overload
    def __iand__(self, arg: Union[list, Annotated[NDArray, {"dtype": "bool"}]], /) -> PolyArray[Dim]: ...
    @overload
    def __iand__(self, arg: PolyArray[Dim]) -> PolyArray[Dim]: ...
    @overload
    def __iand__(self: PolyArray[Dim0], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __iand__(self, arg: PolyArray[Dim0]) -> PolyArray[_Dim]: ...
    @overload
    def __iand__(self: PolyArray[Dim1], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __iand__(self, arg: PolyArray[Dim1]) -> PolyArray[_Dim]: ...
    @overload
    def __iand__(self: PolyArray[Dim2], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __iand__(self, arg: PolyArray[Dim2]) -> PolyArray[_Dim]: ...
    @overload
    def __iand__(self: PolyArray[Dim3], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __iand__(self, arg: PolyArray[Dim3]) -> PolyArray[_Dim]: ...
    @overload
    def __iand__(self: PolyArray[Dim4], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __iand__(self, arg: PolyArray[Dim4]) -> PolyArray[_Dim]: ...
    @overload
    def __or__(self, arg: Union[Poly, bool], /) -> PolyArray[_Dim]: ...
    @overload
    def __or__(self, arg: Union[list, Annotated[NDArray, {"dtype": "bool"}]], /) -> PolyArray[Dim]: ...
    @overload
    def __or__(self, arg: PolyArray[Dim]) -> PolyArray[Dim]: ...
    @overload
    def __or__(self: PolyArray[Dim0], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __or__(self, arg: PolyArray[Dim0]) -> PolyArray[_Dim]: ...
    @overload
    def __or__(self: PolyArray[Dim1], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __or__(self, arg: PolyArray[Dim1]) -> PolyArray[_Dim]: ...
    @overload
    def __or__(self: PolyArray[Dim2], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __or__(self, arg: PolyArray[Dim2]) -> PolyArray[_Dim]: ...
    @overload
    def __or__(self: PolyArray[Dim3], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __or__(self, arg: PolyArray[Dim3]) -> PolyArray[_Dim]: ...
    @overload
    def __or__(self: PolyArray[Dim4], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __or__(self, arg: PolyArray[Dim4]) -> PolyArray[_Dim]: ...
    @overload
    def __ror__(self, arg: Union[Poly, bool], /) -> PolyArray[_Dim]: ...
    @overload
    def __ror__(self, arg: Union[list, Annotated[NDArray, {"dtype": "bool"}]], /) -> PolyArray[Dim]: ...
    @overload
    def __ior__(self, arg: Union[Poly, bool], /) -> PolyArray[_Dim]: ...
    @overload
    def __ior__(self, arg: Union[list, Annotated[NDArray, {"dtype": "bool"}]], /) -> PolyArray[Dim]: ...
    @overload
    def __ior__(self, arg: PolyArray[Dim]) -> PolyArray[Dim]: ...
    @overload
    def __ior__(self: PolyArray[Dim0], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __ior__(self, arg: PolyArray[Dim0]) -> PolyArray[_Dim]: ...
    @overload
    def __ior__(self: PolyArray[Dim1], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __ior__(self, arg: PolyArray[Dim1]) -> PolyArray[_Dim]: ...
    @overload
    def __ior__(self: PolyArray[Dim2], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __ior__(self, arg: PolyArray[Dim2]) -> PolyArray[_Dim]: ...
    @overload
    def __ior__(self: PolyArray[Dim3], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __ior__(self, arg: PolyArray[Dim3]) -> PolyArray[_Dim]: ...
    @overload
    def __ior__(self: PolyArray[Dim4], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __ior__(self, arg: PolyArray[Dim4]) -> PolyArray[_Dim]: ...
    @overload
    def __xor__(self, arg: Union[Poly, bool], /) -> PolyArray[_Dim]: ...
    @overload
    def __xor__(self, arg: Union[list, Annotated[NDArray, {"dtype": "bool"}]], /) -> PolyArray[Dim]: ...
    @overload
    def __xor__(self, arg: PolyArray[Dim]) -> PolyArray[Dim]: ...
    @overload
    def __xor__(self: PolyArray[Dim0], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __xor__(self, arg: PolyArray[Dim0]) -> PolyArray[_Dim]: ...
    @overload
    def __xor__(self: PolyArray[Dim1], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __xor__(self, arg: PolyArray[Dim1]) -> PolyArray[_Dim]: ...
    @overload
    def __xor__(self: PolyArray[Dim2], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __xor__(self, arg: PolyArray[Dim2]) -> PolyArray[_Dim]: ...
    @overload
    def __xor__(self: PolyArray[Dim3], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __xor__(self, arg: PolyArray[Dim3]) -> PolyArray[_Dim]: ...
    @overload
    def __xor__(self: PolyArray[Dim4], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __xor__(self, arg: PolyArray[Dim4]) -> PolyArray[_Dim]: ...
    @overload
    def __rxor__(self, arg: Union[Poly, bool], /) -> PolyArray[_Dim]: ...
    @overload
    def __rxor__(self, arg: Union[list, Annotated[NDArray, {"dtype": "bool"}]], /) -> PolyArray[Dim]: ...
    @overload
    def __ixor__(self, arg: Union[Poly, bool], /) -> PolyArray[_Dim]: ...
    @overload
    def __ixor__(self, arg: Union[list, Annotated[NDArray, {"dtype": "bool"}]], /) -> PolyArray[Dim]: ...
    @overload
    def __ixor__(self, arg: PolyArray[Dim]) -> PolyArray[Dim]: ...
    @overload
    def __ixor__(self: PolyArray[Dim0], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __ixor__(self, arg: PolyArray[Dim0]) -> PolyArray[_Dim]: ...
    @overload
    def __ixor__(self: PolyArray[Dim1], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __ixor__(self, arg: PolyArray[Dim1]) -> PolyArray[_Dim]: ...
    @overload
    def __ixor__(self: PolyArray[Dim2], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __ixor__(self, arg: PolyArray[Dim2]) -> PolyArray[_Dim]: ...
    @overload
    def __ixor__(self: PolyArray[Dim3], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __ixor__(self, arg: PolyArray[Dim3]) -> PolyArray[_Dim]: ...
    @overload
    def __ixor__(self: PolyArray[Dim4], arg: PolyArray[__Dim]) -> PolyArray[__Dim]: ...
    @overload
    def __ixor__(self, arg: PolyArray[Dim4]) -> PolyArray[_Dim]: ...
    def __pow__(self, arg: int, /) -> PolyArray[_Dim]: ...
    def __ipow__(self, arg: int, /) -> PolyArray[_Dim]: ...
    def __index__(self) -> int: ...
    def __int__(self) -> int: ...
    def __float__(self) -> float: ...
    def __bool__(self) -> bool: ...
    def __invert__(self) -> PolyArray[_Dim]: ...
    @overload
    def __getitem__(self: PolyArray[Dim0], arg: tuple[()]) -> Poly: ...
    @overload
    def __getitem__(self: PolyArray[Dim0], arg: EllipsisType) -> PolyArray[Dim0]: ...
    @overload
    def __getitem__(self: PolyArray[Dim1], arg: Union[tuple[int], int]) -> Poly: ...
    @overload
    def __getitem__(
        self: PolyArray[Dim1], arg: Union[EllipsisType, tuple[()], slice, tuple[slice]]
    ) -> PolyArray[Dim1]: ...
    @overload
    def __getitem__(self: PolyArray[Dim2], arg: tuple[int, int]) -> Poly: ...
    @overload
    def __getitem__(
        self: PolyArray[Dim2], arg: Union[int, tuple[int], tuple[slice, int], tuple[int, slice]]
    ) -> PolyArray[Dim1]: ...
    @overload
    def __getitem__(
        self: PolyArray[Dim2], arg: Union[EllipsisType, tuple[()], slice, tuple[slice], tuple[slice, slice]]
    ) -> PolyArray[Dim2]: ...
    @overload
    def __getitem__(self: PolyArray[Dim3], arg: tuple[int, int, int]) -> Poly: ...
    @overload
    def __getitem__(
        self: PolyArray[Dim3],
        arg: Union[tuple[int, int], tuple[slice, int, int], tuple[int, slice, int], tuple[int, int, slice]],
    ) -> PolyArray[Dim1]: ...
    @overload
    def __getitem__(
        self: PolyArray[Dim3],
        arg: Union[
            int,
            tuple[int],
            tuple[slice, int],
            tuple[int, slice],
            tuple[slice, slice, int],
            tuple[slice, int, slice],
            tuple[int, slice, slice],
        ],
    ) -> PolyArray[Dim2]: ...
    @overload
    def __getitem__(
        self: PolyArray[Dim3],
        arg: Union[EllipsisType, tuple[()], slice, tuple[slice], tuple[slice, slice], tuple[slice, slice, slice]],
    ) -> PolyArray[Dim3]: ...
    @overload
    def __getitem__(self: PolyArray[Dim4], arg: tuple[int, int, int, int]) -> Poly: ...
    @overload
    def __getitem__(
        self: PolyArray[Dim4],
        arg: Union[
            tuple[int, int, int],
            tuple[slice, int, int, int],
            tuple[int, slice, int, int],
            tuple[int, int, slice, int],
            tuple[int, int, int, slice],
        ],
    ) -> PolyArray[Dim1]: ...
    @overload
    def __getitem__(
        self: PolyArray[Dim4],
        arg: Union[
            tuple[int, int],
            tuple[slice, int, int],
            tuple[int, slice, int],
            tuple[int, int, slice],
            tuple[slice, slice, int, int],
            tuple[slice, int, slice, int],
            tuple[slice, int, int, slice],
            tuple[int, slice, slice, int],
            tuple[int, slice, int, slice],
            tuple[int, int, slice, slice],
        ],
    ) -> PolyArray[Dim2]: ...
    @overload
    def __getitem__(
        self: PolyArray[Dim4],
        arg: Union[
            int,
            tuple[int],
            tuple[slice, int],
            tuple[int, slice],
            tuple[slice, slice, int],
            tuple[int, slice, slice],
            tuple[slice, int, slice],
            tuple[slice, slice, slice, int],
            tuple[slice, slice, int, slice],
            tuple[slice, int, slice, slice],
            tuple[int, slice, slice, slice],
        ],
    ) -> PolyArray[Dim3]: ...
    @overload
    def __getitem__(
        self: PolyArray[Dim4],
        arg: Union[
            EllipsisType,
            tuple[()],
            slice,
            tuple[slice],
            tuple[slice, slice],
            tuple[slice, slice, slice],
            tuple[slice, slice, slice, slice],
        ],
    ) -> PolyArray[Dim4]: ...
    @overload
    def __getitem__(self: PolyArray[Dim], arg: Optional[Union[tuple, slice, EllipsisType, int]]) -> PolyArray[Dim]: ...
    def __setitem__(
        self, arg: Optional[Union[tuple, slice, EllipsisType, int]], value: Union[Poly, float, list, NDArray, PolyArray]
    ) -> None: ...
    def __copy__(self) -> PolyArray[_Dim]: ...
    def __deepcopy__(self, arg: dict, /) -> PolyArray[_Dim]: ...

    class Iterator:
        def __iter__(self) -> PolyArray.Iterator: ...
        def __next__(self) -> Union[Poly, PolyArray[Dim]]: ...

    def __iter__(self) -> PolyArray.Iterator: ...
    def __len__(self) -> int: ...
    @property
    def size(self) -> int:
        """size

        Returns:
            int:
        """

    @property
    def ndim(self) -> int:
        """ndim

        Returns:
            int:
        """

    @property
    def flat(self) -> PolyArray[Dim1]:
        """flat

        Returns:
            amplify.PolyArray[Dim1]:
        """

    @property
    def shape(self) -> tuple[int, ...]:
        """shape

        Returns:
            tuple[int, ...]:
        """

    @shape.setter
    def shape(self, arg: Union[int, tuple[int, ...]], /) -> None:
        """
        Args:
            arg (typing.Union[int, tuple[int, ...]])
        """

    @property
    def T(self) -> PolyArray[_Dim]:
        """T

        Returns:
            amplify.PolyArray[_Dim]:
        """

    def copy(self) -> PolyArray[_Dim]:
        """copy

        Returns:
            amplify.PolyArray[_Dim]:
        """

    def view(self) -> PolyArray[_Dim]:
        """view

        Returns:
            amplify.PolyArray[_Dim]:
        """

    @overload
    def transpose(self, axes: Optional[tuple[int, ...]] = None) -> PolyArray[_Dim]: ...
    @overload
    def transpose(self, *axes: int) -> PolyArray[_Dim]:
        r"""transpose

        .. admonition:: Overload 1.

            Args:
                * axes (typing.Optional[tuple[int, ...]]): Defaults to ``None``.

            Returns:
                amplify.PolyArray[_Dim]:

        .. admonition:: Overload 2.

            Args:
                * \*axes (int)

            Returns:
                amplify.PolyArray[_Dim]:
        """

    def swapaxes(self, axis1: int, axis2: int) -> PolyArray[_Dim]:
        """swapaxes

        Args:
            axis1 (int)
            axis2 (int)

        Returns:
            amplify.PolyArray[_Dim]:
        """

    @overload
    def diagonal(self: PolyArray[Dim], offset: int = 0, axis1: int = 0, axis2: int = 1) -> PolyArray[Dim]: ...
    @overload
    def diagonal(self: PolyArray[Dim2], offset: int = 0, axis1: int = 0, axis2: int = 1) -> PolyArray[Dim1]: ...
    @overload
    def diagonal(self: PolyArray[Dim3], offset: int = 0, axis1: int = 0, axis2: int = 1) -> PolyArray[Dim2]: ...
    @overload
    def diagonal(self: PolyArray[Dim4], offset: int = 0, axis1: int = 0, axis2: int = 1) -> PolyArray[Dim3]:
        """diagonal

        .. admonition:: Overload 1.

            Args:
                * self (amplify.PolyArray[Dim])
                * offset (int): Defaults to ``0``.
                * axis1 (int): Defaults to ``0``.
                * axis2 (int): Defaults to ``1``.

            Returns:
                amplify.PolyArray[Dim]:

        .. admonition:: Overload 2.

            Args:
                * self (amplify.PolyArray[Dim2])
                * offset (int): Defaults to ``0``.
                * axis1 (int): Defaults to ``0``.
                * axis2 (int): Defaults to ``1``.

            Returns:
                amplify.PolyArray[Dim1]:

        .. admonition:: Overload 3.

            Args:
                * self (amplify.PolyArray[Dim3])
                * offset (int): Defaults to ``0``.
                * axis1 (int): Defaults to ``0``.
                * axis2 (int): Defaults to ``1``.

            Returns:
                amplify.PolyArray[Dim2]:

        .. admonition:: Overload 4.

            Args:
                * self (amplify.PolyArray[Dim4])
                * offset (int): Defaults to ``0``.
                * axis1 (int): Defaults to ``0``.
                * axis2 (int): Defaults to ``1``.

            Returns:
                amplify.PolyArray[Dim3]:
        """

    def fill(self, value: Union[Poly, float]) -> None:
        """fill

        Args:
            value (typing.Union[amplify.Poly, float])
        """

    def flatten(self) -> PolyArray[Dim1]:
        """flatten

        Returns:
            amplify.PolyArray[Dim1]:
        """

    def ravel(self) -> PolyArray[Dim1]:
        """ravel

        Returns:
            amplify.PolyArray[Dim1]:
        """

    def roll(self, shift: int, axis: Optional[int] = None) -> PolyArray[_Dim]:
        """roll

        Args:
            shift (int)
            axis (typing.Optional[int]): Defaults to ``None``.

        Returns:
            amplify.PolyArray[_Dim]:
        """

    @overload
    def repeat(self, repeats: Union[int, list[int]], axis: Optional[Literal[None]] = None) -> PolyArray[Dim1]: ...
    @overload
    def repeat(self, repeats: Union[int, list[int]], axis: int) -> PolyArray[_Dim]:
        """repeat

        .. admonition:: Overload 1.

            Args:
                * repeats (typing.Union[int, list[int]])
                * axis (typing.Optional[typing.Literal[None]]): Defaults to ``None``.

            Returns:
                amplify.PolyArray[Dim1]:

        .. admonition:: Overload 2.

            Args:
                * repeats (typing.Union[int, list[int]])
                * axis (int)

            Returns:
                amplify.PolyArray[_Dim]:
        """

    @overload
    def reshape(self, shape: Union[int, tuple[int]]) -> PolyArray[Dim1]: ...
    @overload
    def reshape(self, shape: tuple[int, int]) -> PolyArray[Dim2]: ...
    @overload
    def reshape(self, shape: tuple[int, int, int]) -> PolyArray[Dim3]: ...
    @overload
    def reshape(self, shape: tuple[int, int, int, int]) -> PolyArray[Dim4]: ...
    @overload
    def reshape(self, arg0: int, arg1: int) -> PolyArray[Dim2]: ...
    @overload
    def reshape(self, arg0: int, arg1: int, arg2: int) -> PolyArray[Dim3]: ...
    @overload
    def reshape(self, arg0: int, arg1: int, arg2: int, arg3: int) -> PolyArray[Dim4]: ...
    @overload
    def reshape(
        self, shape: tuple[int, int, int, int, int, typing_extensions.Unpack[tuple[int, ...]]]
    ) -> PolyArray[Dim]: ...
    @overload
    def reshape(self, *shape: int) -> PolyArray[Dim]:
        r"""reshape

        .. admonition:: Overload 1.

            Args:
                * shape (typing.Union[int, tuple[int]])

            Returns:
                amplify.PolyArray[Dim1]:

        .. admonition:: Overload 2.

            Args:
                * shape (tuple[int, int])

            Returns:
                amplify.PolyArray[Dim2]:

        .. admonition:: Overload 3.

            Args:
                * shape (tuple[int, int, int])

            Returns:
                amplify.PolyArray[Dim3]:

        .. admonition:: Overload 4.

            Args:
                * shape (tuple[int, int, int, int])

            Returns:
                amplify.PolyArray[Dim4]:

        .. admonition:: Overload 5.

            Args:
                * arg0 (int)
                * arg1 (int)

            Returns:
                amplify.PolyArray[Dim2]:

        .. admonition:: Overload 6.

            Args:
                * arg0 (int)
                * arg1 (int)
                * arg2 (int)

            Returns:
                amplify.PolyArray[Dim3]:

        .. admonition:: Overload 7.

            Args:
                * arg0 (int)
                * arg1 (int)
                * arg2 (int)
                * arg3 (int)

            Returns:
                amplify.PolyArray[Dim4]:

        .. admonition:: Overload 8.

            Args:
                * shape (tuple[int, int, int, int, int, typing_extensions.Unpack[tuple[int, ...]]])

            Returns:
                amplify.PolyArray[Dim]:

        .. admonition:: Overload 9.

            Args:
                * \*shape (int)

            Returns:
                amplify.PolyArray[Dim]:
        """

    @overload
    def sum(self: PolyArray[Dim], axis: Optional[Literal[None]] = None) -> Poly: ...
    @overload
    def sum(self: PolyArray[Dim1], axis: Union[int, tuple[int]]) -> Poly: ...
    @overload
    def sum(self: PolyArray[Dim2], axis: tuple[int, int]) -> Poly: ...
    @overload
    def sum(self: PolyArray[Dim2], axis: Union[int, tuple[int]]) -> PolyArray[Dim1]: ...
    @overload
    def sum(self: PolyArray[Dim3], axis: tuple[int, int, int]) -> Poly: ...
    @overload
    def sum(self: PolyArray[Dim3], axis: tuple[int, int]) -> PolyArray[Dim1]: ...
    @overload
    def sum(self: PolyArray[Dim3], axis: Union[int, tuple[int]]) -> PolyArray[Dim2]: ...
    @overload
    def sum(self: PolyArray[Dim4], axis: tuple[int, int, int, int]) -> Poly: ...
    @overload
    def sum(self: PolyArray[Dim4], axis: tuple[int, int, int]) -> PolyArray[Dim1]: ...
    @overload
    def sum(self: PolyArray[Dim4], axis: tuple[int, int]) -> PolyArray[Dim2]: ...
    @overload
    def sum(self: PolyArray[Dim4], axis: Union[int, tuple[int]]) -> PolyArray[Dim3]: ...
    @overload
    def sum(self: PolyArray[_Dim], axis: tuple[()]) -> PolyArray[_Dim]: ...
    @overload
    def sum(self: PolyArray[Dim], axis: Union[int, tuple[int, ...]]) -> Union[Poly, PolyArray[Dim]]:
        """sum

        .. admonition:: Overload 1.

            Args:
                * self (amplify.PolyArray[Dim])
                * axis (typing.Optional[typing.Literal[None]]): Defaults to ``None``.

            Returns:
                amplify.Poly:

        .. admonition:: Overload 2.

            Args:
                * self (amplify.PolyArray[Dim1])
                * axis (typing.Union[int, tuple[int]])

            Returns:
                amplify.Poly:

        .. admonition:: Overload 3.

            Args:
                * self (amplify.PolyArray[Dim2])
                * axis (tuple[int, int])

            Returns:
                amplify.Poly:

        .. admonition:: Overload 4.

            Args:
                * self (amplify.PolyArray[Dim2])
                * axis (typing.Union[int, tuple[int]])

            Returns:
                amplify.PolyArray[Dim1]:

        .. admonition:: Overload 5.

            Args:
                * self (amplify.PolyArray[Dim3])
                * axis (tuple[int, int, int])

            Returns:
                amplify.Poly:

        .. admonition:: Overload 6.

            Args:
                * self (amplify.PolyArray[Dim3])
                * axis (tuple[int, int])

            Returns:
                amplify.PolyArray[Dim1]:

        .. admonition:: Overload 7.

            Args:
                * self (amplify.PolyArray[Dim3])
                * axis (typing.Union[int, tuple[int]])

            Returns:
                amplify.PolyArray[Dim2]:

        .. admonition:: Overload 8.

            Args:
                * self (amplify.PolyArray[Dim4])
                * axis (tuple[int, int, int, int])

            Returns:
                amplify.Poly:

        .. admonition:: Overload 9.

            Args:
                * self (amplify.PolyArray[Dim4])
                * axis (tuple[int, int, int])

            Returns:
                amplify.PolyArray[Dim1]:

        .. admonition:: Overload 10.

            Args:
                * self (amplify.PolyArray[Dim4])
                * axis (tuple[int, int])

            Returns:
                amplify.PolyArray[Dim2]:

        .. admonition:: Overload 11.

            Args:
                * self (amplify.PolyArray[Dim4])
                * axis (typing.Union[int, tuple[int]])

            Returns:
                amplify.PolyArray[Dim3]:

        .. admonition:: Overload 12.

            Args:
                * self (amplify.PolyArray[_Dim])
                * axis (tuple[()])

            Returns:
                amplify.PolyArray[_Dim]:

        .. admonition:: Overload 13.

            Args:
                * self (amplify.PolyArray[Dim])
                * axis (typing.Union[int, tuple[int, ...]])

            Returns:
                typing.Union[Poly, PolyArray[Dim]]:
        """

    @overload
    def take(self, indices: int, axis: Optional[Literal[None]] = None) -> Poly: ...
    @overload
    def take(self, indices: list[int], axis: Optional[Literal[None]] = None) -> PolyArray[Dim1]: ...
    @overload
    def take(self: PolyArray[Dim], indices: Union[int, list[int]], axis: Optional[int] = None) -> PolyArray[Dim]: ...
    @overload
    def take(self: PolyArray[Dim2], indices: int, axis: int) -> PolyArray[Dim1]: ...
    @overload
    def take(self: PolyArray[Dim2], indices: list[int], axis: int) -> PolyArray[Dim2]: ...
    @overload
    def take(self: PolyArray[Dim3], indices: int, axis: int) -> PolyArray[Dim2]: ...
    @overload
    def take(self: PolyArray[Dim3], indices: list[int], axis: int) -> PolyArray[Dim3]: ...
    @overload
    def take(self: PolyArray[Dim4], indices: int, axis: int) -> PolyArray[Dim3]: ...
    @overload
    def take(self: PolyArray[Dim4], indices: list[int], axis: int) -> PolyArray[Dim4]:
        """take

        .. admonition:: Overload 1.

            Args:
                * indices (int)
                * axis (typing.Optional[typing.Literal[None]]): Defaults to ``None``.

            Returns:
                amplify.Poly:

        .. admonition:: Overload 2.

            Args:
                * indices (list[int])
                * axis (typing.Optional[typing.Literal[None]]): Defaults to ``None``.

            Returns:
                amplify.PolyArray[Dim1]:

        .. admonition:: Overload 3.

            Args:
                * self (amplify.PolyArray[Dim])
                * indices (typing.Union[int, list[int]])
                * axis (typing.Optional[int]): Defaults to ``None``.

            Returns:
                amplify.PolyArray[Dim]:

        .. admonition:: Overload 4.

            Args:
                * self (amplify.PolyArray[Dim2])
                * indices (int)
                * axis (int)

            Returns:
                amplify.PolyArray[Dim1]:

        .. admonition:: Overload 5.

            Args:
                * self (amplify.PolyArray[Dim2])
                * indices (list[int])
                * axis (int)

            Returns:
                amplify.PolyArray[Dim2]:

        .. admonition:: Overload 6.

            Args:
                * self (amplify.PolyArray[Dim3])
                * indices (int)
                * axis (int)

            Returns:
                amplify.PolyArray[Dim2]:

        .. admonition:: Overload 7.

            Args:
                * self (amplify.PolyArray[Dim3])
                * indices (list[int])
                * axis (int)

            Returns:
                amplify.PolyArray[Dim3]:

        .. admonition:: Overload 8.

            Args:
                * self (amplify.PolyArray[Dim4])
                * indices (int)
                * axis (int)

            Returns:
                amplify.PolyArray[Dim3]:

        .. admonition:: Overload 9.

            Args:
                * self (amplify.PolyArray[Dim4])
                * indices (list[int])
                * axis (int)

            Returns:
                amplify.PolyArray[Dim4]:
        """

    def nonzero(self) -> tuple[Annotated[numpy.typing.NDArray[numpy.uint64], {"dtype": "uint64"}], ...]:
        """nonzero

        Returns:
            tuple[numpy.ndarray[dtype=uint64], ...]:
        """

    @overload
    def evaluate(self, values: Values) -> Annotated[numpy.typing.NDArray[numpy.float64], {"dtype": "float64"}]: ...
    @overload
    def evaluate(
        self, values: Values, default: float
    ) -> Annotated[numpy.typing.NDArray[numpy.float64], {"dtype": "float64"}]: ...
    @overload
    def evaluate(self, values: Values, default: Literal[None]) -> PolyArray[_Dim]:
        """evaluate

        .. admonition:: Overload 1.

            Args:
                * values (amplify.Values)

            Returns:
                numpy.ndarray:

        .. admonition:: Overload 2.

            Args:
                * values (amplify.Values)
                * default (float)

            Returns:
                numpy.ndarray:

        .. admonition:: Overload 3.

            Args:
                * values (amplify.Values)
                * default (typing.Literal[None])

            Returns:
                amplify.PolyArray[_Dim]:
        """

    @overload
    def decode(self, values: Values) -> Annotated[numpy.typing.NDArray[numpy.float64], {"dtype": "float64"}]: ...
    @overload
    def decode(
        self, values: Values, default: float
    ) -> Annotated[numpy.typing.NDArray[numpy.float64], {"dtype": "float64"}]: ...
    @overload
    def decode(self, values: Values, default: Literal[None]) -> PolyArray[_Dim]:
        """decode

        .. admonition:: Overload 1.

            Args:
                * values (amplify.Values)

            Returns:
                numpy.ndarray:

        .. admonition:: Overload 2.

            Args:
                * values (amplify.Values)
                * default (float)

            Returns:
                numpy.ndarray:

        .. admonition:: Overload 3.

            Args:
                * values (amplify.Values)
                * default (typing.Literal[None])

            Returns:
                amplify.PolyArray[_Dim]:
        """

    def substitute(
        self, mapping: Union[Mapping[Poly, Union[Poly, float]], Mapping[Variable, Union[Poly, float]]]
    ) -> PolyArray[_Dim]:
        """substitute

        Args:
            mapping (typing.Union[collections.abc.Mapping[amplify.Poly, typing.Union[amplify.Poly, float]], collections.abc.Mapping[amplify.Variable, typing.Union[amplify.Poly, float]]])

        Returns:
            amplify.PolyArray[_Dim]:
        """

    @overload
    def to_list(self: PolyArray[Dim0]) -> Poly: ...
    @overload
    def to_list(self: PolyArray[Dim1]) -> list[Poly]: ...
    @overload
    def to_list(self: PolyArray[Dim2]) -> list[list[Poly]]: ...
    @overload
    def to_list(self: PolyArray[Dim3]) -> list[list[list[Poly]]]: ...
    @overload
    def to_list(self: PolyArray[Dim4]) -> list[list[list[list[Poly]]]]: ...
    @overload
    def to_list(self: PolyArray[Dim]) -> list:
        """to_list

        .. admonition:: Overload 1.

            Args:
                * self (amplify.PolyArray[Dim0])

            Returns:
                amplify.Poly:

        .. admonition:: Overload 2.

            Args:
                * self (amplify.PolyArray[Dim1])

            Returns:
                list[amplify.Poly]:

        .. admonition:: Overload 3.

            Args:
                * self (amplify.PolyArray[Dim2])

            Returns:
                list[list[amplify.Poly]]:

        .. admonition:: Overload 4.

            Args:
                * self (amplify.PolyArray[Dim3])

            Returns:
                list[list[list[amplify.Poly]]]:

        .. admonition:: Overload 5.

            Args:
                * self (amplify.PolyArray[Dim4])

            Returns:
                list[list[list[list[amplify.Poly]]]]:

        .. admonition:: Overload 6.

            Args:
                * self (amplify.PolyArray[Dim])

            Returns:
                list:
        """

    @overload
    def tolist(self: PolyArray[Dim0]) -> Poly: ...
    @overload
    def tolist(self: PolyArray[Dim1]) -> list[Poly]: ...
    @overload
    def tolist(self: PolyArray[Dim2]) -> list[list[Poly]]: ...
    @overload
    def tolist(self: PolyArray[Dim3]) -> list[list[list[Poly]]]: ...
    @overload
    def tolist(self: PolyArray[Dim4]) -> list[list[list[list[Poly]]]]: ...
    @overload
    def tolist(self: PolyArray[Dim]) -> list:
        """tolist alias of :meth:`~amplify.PolyArray.to_list`

        .. admonition:: Overload 1.

            Args:
                * self (amplify.PolyArray[Dim0])

            Returns:
                amplify.Poly:

        .. admonition:: Overload 2.

            Args:
                * self (amplify.PolyArray[Dim1])

            Returns:
                list[amplify.Poly]:

        .. admonition:: Overload 3.

            Args:
                * self (amplify.PolyArray[Dim2])

            Returns:
                list[list[amplify.Poly]]:

        .. admonition:: Overload 4.

            Args:
                * self (amplify.PolyArray[Dim3])

            Returns:
                list[list[list[amplify.Poly]]]:

        .. admonition:: Overload 5.

            Args:
                * self (amplify.PolyArray[Dim4])

            Returns:
                list[list[list[list[amplify.Poly]]]]:

        .. admonition:: Overload 6.

            Args:
                * self (amplify.PolyArray[Dim])

            Returns:
                list:
        """

    def to_numpy(self) -> Annotated[numpy.typing.NDArray[numpy.float64], {"dtype": "float64"}]:
        """to_numpy

        Returns:
            numpy.ndarray:
        """

    def tonumpy(self) -> Annotated[numpy.typing.NDArray[numpy.float64], {"dtype": "float64"}]:
        """alias of :meth:`~amplify.PolyArray.to_numpy`

        Returns:
            numpy.ndarray:
        """

class QuadratizationMethod(enum.Enum):
    IshikawaKZFD = 0
    Substitute = 1
    ISHIKAWA_KZFD = 0
    """deprecated, use IshikawaKZFD"""

    SUBSTITUTION = 1
    """deprecated, use Substitute"""

class RealEncodingMethod(enum.Enum):
    Random4 = 260
    Random8 = 264
    Random16 = 272
    Random32 = 288

class Result(Generic[_AmplifyClient]):
    class Solution:
        @property
        def values(self) -> Values:
            """values

            Returns:
                amplify.Values:
            """

        @property
        def feasible(self) -> bool:
            """feasible

            Returns:
                bool:
            """

        @property
        def objective(self) -> float:
            """objective

            Returns:
                float:
            """

        @property
        def time(self) -> datetime.timedelta:
            """time

            Returns:
                datetime.timedelta:
            """

    class SolutionList:
        class Iterator:
            def __iter__(self) -> Result.SolutionList.Iterator: ...
            def __next__(self) -> Result.Solution: ...

        def __iter__(self) -> Result.SolutionList.Iterator: ...
        def __len__(self) -> int: ...
        def __bool__(self) -> bool: ...
        def __getitem__(self, key: int) -> Result.Solution: ...

    class ValuesList:
        class Iterator:
            def __iter__(self) -> Result.ValuesList.Iterator: ...
            def __next__(self) -> Values: ...

        def __iter__(self) -> Result.ValuesList.Iterator: ...
        def __len__(self) -> int: ...
        def __bool__(self) -> bool: ...
        def __getitem__(self, key: int) -> Values: ...

    class SplitView:
        def __iter__(self) -> Result.SplitView: ...
        def __next__(self) -> Result: ...
        def __getitem__(self, key: int) -> Result: ...
        def __len__(self) -> int: ...
        def __bool__(self) -> bool: ...

    class ModelConversion:
        class IntermediateMapping:
            class KeysView:
                @overload
                def __contains__(self, arg: Poly, /) -> bool: ...
                @overload
                def __contains__(self, arg: object, /) -> bool: ...
                def __len__(self) -> int: ...
                def __bool__(self) -> bool: ...
                def __iter__(self) -> Result.ModelConversion.IntermediateMapping.KeysView: ...
                def __next__(self) -> Poly: ...

            class ValuesView:
                def __len__(self) -> int: ...
                def __bool__(self) -> bool: ...
                def __iter__(self) -> Result.ModelConversion.IntermediateMapping.ValuesView: ...
                def __next__(self) -> Poly: ...

            class ItemsView:
                def __len__(self) -> int: ...
                def __bool__(self) -> bool: ...
                def __iter__(self) -> Result.ModelConversion.IntermediateMapping.ItemsView: ...
                def __next__(self) -> tuple[Poly, Poly]: ...

            def __len__(self) -> int: ...
            def __bool__(self) -> bool: ...
            @overload
            def __contains__(self, arg: Poly, /) -> bool: ...
            @overload
            def __contains__(self, arg: object, /) -> bool: ...
            def __iter__(self) -> Result.ModelConversion.IntermediateMapping.KeysView: ...
            def __getitem__(self, arg: Poly, /) -> Poly: ...
            def keys(self) -> Result.ModelConversion.IntermediateMapping.KeysView:
                """keys

                Returns:
                    amplify.Result.ModelConversion.IntermediateMapping.KeysView:
                """

            def values(self) -> Result.ModelConversion.IntermediateMapping.ValuesView:
                """values

                Returns:
                    amplify.Result.ModelConversion.IntermediateMapping.ValuesView:
                """

            def items(self) -> Result.ModelConversion.IntermediateMapping.ItemsView:
                """items

                Returns:
                    amplify.Result.ModelConversion.IntermediateMapping.ItemsView:
                """

        @property
        def model(self) -> Model:
            """model

            Returns:
                amplify.Model:
            """

        @property
        def mapping(self) -> Result.ModelConversion.IntermediateMapping:
            """mapping

            Returns:
                amplify.Result.ModelConversion.IntermediateMapping:
            """

        @property
        def values_list(self) -> Result.ValuesList:
            """values_list

            Returns:
                amplify.Result.ValuesList:
            """

        @property
        def num_variables(self) -> int:
            """num_variables

            Returns:
                int:
            """

    class GraphConversion:
        class ChainBreakFractions:
            class Iterator:
                def __iter__(self) -> Result.GraphConversion.ChainBreakFractions.Iterator: ...
                def __next__(self) -> float: ...

            def __iter__(self) -> Result.GraphConversion.ChainBreakFractions.Iterator: ...
            def __len__(self) -> int: ...
            def __bool__(self) -> bool: ...
            def __getitem__(self, key: int) -> float: ...

        @property
        def src_graph(self) -> list[tuple[int, int]]:
            """src_graph

            Returns:
                list[tuple[int, int]]:
            """

        @property
        def dst_graph(self) -> Graph:
            """dst_graph

            Returns:
                amplify.Graph:
            """

        @property
        def chains(self) -> list[Annotated[numpy.typing.NDArray[numpy.uint32], {"dtype": "uint32", "writable": False}]]:
            """chains

            Returns:
                list[numpy.ndarray[dtype=uint32, writable=False]]:
            """

        @property
        def poly(self) -> Poly:
            """poly

            Returns:
                amplify.Poly:
            """

        @property
        def values_list(self) -> Result.ValuesList:
            """values_list

            Returns:
                amplify.Result.ValuesList:
            """

        @property
        def chain_break_fractions(self) -> Result.GraphConversion.ChainBreakFractions:
            """chain_break_fractions

            Returns:
                amplify.Result.GraphConversion.ChainBreakFractions:
            """

        @property
        def num_variables(self) -> int:
            """num_variables

            Returns:
                int:
            """

    class _ClientResultDescriptor:
        @overload
        def __get__(self, instance: Result[FixstarsClient], owner: Any) -> FixstarsClient.Result: ...
        @overload
        def __get__(self, instance: Result[DWaveSamplerClient], owner: Any) -> dimod.sampleset.SampleSet: ...
        @overload
        def __get__(self, instance: Result[LeapHybridSamplerClient], owner: Any) -> dimod.sampleset.SampleSet: ...
        @overload
        def __get__(self, instance: Result[LeapHybridCQMSamplerClient], owner: Any) -> dimod.sampleset.SampleSet: ...
        @overload
        def __get__(self, instance: Result[FujitsuDA4Client], owner: Any) -> FujitsuDA4Client.Result: ...
        @overload
        def __get__(self, instance: Result[ToshibaSQBM2Client], owner: Any) -> ToshibaSQBM2Client.Result: ...
        @overload
        def __get__(self, instance: Result[GurobiClient], owner: Any) -> GurobiClient.Result: ...
        @overload
        def __get__(self, instance: Result[NECVA2Client], owner: Any) -> NECVA2Client.Result: ...
        @overload
        def __get__(self, instance: Result[DASClient], owner: Any) -> DASClient.Result: ...
        @overload
        def __get__(self, instance: Result[HitachiClient], owner: Any) -> HitachiClient.Result: ...
        @overload
        def __get__(self, instance: Any, owner: Any) -> None: ...

    class _EmbeddingDescriptor:
        @overload
        def __get__(
            self, instance: Union[Result[DWaveSamplerClient], Result[HitachiClient]], owner: Any
        ) -> Result.GraphConversion: ...
        @overload
        def __get__(self, instance: Any, owner: Any) -> None: ...

    def __iter__(self) -> Result.SolutionList.Iterator: ...
    def __len__(self) -> int: ...
    def __getitem__(self, key: int) -> Result.Solution: ...
    def sort(self) -> None:
        """sort"""

    @property
    def best(self) -> Result.Solution:
        """best

        Returns:
            amplify.Result.Solution:
        """

    @property
    def solutions(self) -> Result.SolutionList:
        """solutions

        Returns:
            amplify.Result.SolutionList:
        """

    @property
    def filter_solution(self) -> bool:
        """filter_solution

        Returns:
            bool:
        """

    @filter_solution.setter
    def filter_solution(self, arg: bool, /) -> None:
        """
        Args:
            arg (bool)
        """

    @property
    def num_solves(self) -> int:
        """num_solves

        Returns:
            int:
        """

    @property
    def split(self) -> Result.SplitView:
        """split

        Returns:
            amplify.Result.SplitView:
        """

    @property
    def intermediate(self) -> Result.ModelConversion:
        """intermediate

        Returns:
            amplify.Result.ModelConversion:
        """

    embedding: Result._EmbeddingDescriptor
    """embedding

    Returns:
        typing.Optional[amplify.Result.GraphConversion]:
    """

    client_result: Result._ClientResultDescriptor
    """client_result

    Returns:
        typing.Optional[typing.Union[amplify.FixstarsClient.Result, dimod.sampleset.SampleSet, amplify.FujitsuDA4Client.Result, amplify.ToshibaSQBM2Client.Result, amplify.GurobiClient.Result, amplify.NECVA2Client.Result, amplify.DASClient.Result, amplify.HitachiClient.Result]]:
    """

    @property
    def total_time(self) -> datetime.timedelta:
        """total_time

        Returns:
            datetime.timedelta:
        """

    @property
    def execution_time(self) -> datetime.timedelta:
        """execution_time

        Returns:
            datetime.timedelta:
        """

    @property
    def response_time(self) -> datetime.timedelta:
        """response_time

        Returns:
            datetime.timedelta:
        """

class ToshibaSQBM2Client(AmplifyClient):
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, token: str = "", url: str = "", proxy: Optional[str] = None) -> None: ...

    class Parameters:
        @property
        def steps(self) -> Optional[int]:
            """steps

            Returns:
                typing.Optional[int]:
            """

        @steps.setter
        def steps(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def loops(self) -> Optional[int]:
            """loops

            Returns:
                typing.Optional[int]:
            """

        @loops.setter
        def loops(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def timeout(self) -> Optional[datetime.timedelta]:
            """timeout

            Returns:
                typing.Optional[datetime.timedelta]:
            """

        @timeout.setter
        def timeout(self, arg: Optional[Union[float, datetime.timedelta]]) -> None:
            """
            Args:
                arg (typing.Optional[typing.Union[float, datetime.timedelta]])
            """

        @property
        def maxwait(self) -> Optional[datetime.timedelta]:
            """maxwait

            Returns:
                typing.Optional[datetime.timedelta]:
            """

        @maxwait.setter
        def maxwait(self, arg: Optional[Union[float, datetime.timedelta]]) -> None:
            """
            Args:
                arg (typing.Optional[typing.Union[float, datetime.timedelta]])
            """

        @property
        def target(self) -> Optional[float]:
            """target

            Returns:
                typing.Optional[float]:
            """

        @target.setter
        def target(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def maxout(self) -> Optional[int]:
            """maxout

            Returns:
                typing.Optional[int]:
            """

        @maxout.setter
        def maxout(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def dt(self) -> Optional[float]:
            """dt

            Returns:
                typing.Optional[float]:
            """

        @dt.setter
        def dt(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def C(self) -> Optional[float]:
            """C

            Returns:
                typing.Optional[float]:
            """

        @C.setter
        def C(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def algo(self) -> Optional[int]:
            """algo

            Returns:
                typing.Optional[int]:
            """

        @algo.setter
        def algo(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def algos(self) -> Optional[str]:
            """algos

            Returns:
                typing.Optional[str]:
            """

        @algos.setter
        def algos(self, arg: Optional[str]) -> None:
            """
            Args:
                arg (typing.Optional[str])
            """

        @property
        def blocks(self) -> Optional[int]:
            """blocks

            Returns:
                typing.Optional[int]:
            """

        @blocks.setter
        def blocks(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def multishot(self) -> Optional[int]:
            """multishot

            Returns:
                typing.Optional[int]:
            """

        @multishot.setter
        def multishot(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def PD3Orate(self) -> Optional[int]:
            """PD3Orate

            Returns:
                typing.Optional[int]:
            """

        @PD3Orate.setter
        def PD3Orate(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def phi(self) -> Optional[float]:
            """phi

            Returns:
                typing.Optional[float]:
            """

        @phi.setter
        def phi(self, arg: Optional[float]) -> None:
            """
            Args:
                arg (typing.Optional[float])
            """

        @property
        def detail_level(self) -> Optional[int]:
            """detail_level

            Returns:
                typing.Optional[int]:
            """

        @detail_level.setter
        def detail_level(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def detail_log(self) -> Optional[int]:
            """detail_log

            Returns:
                typing.Optional[int]:
            """

        @detail_log.setter
        def detail_log(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def HMCweight(self) -> Optional[int]:
            """HMCweight

            Returns:
                typing.Optional[int]:
            """

        @HMCweight.setter
        def HMCweight(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

        @property
        def HMCsteps(self) -> Optional[int]:
            """HMCsteps

            Returns:
                typing.Optional[int]:
            """

        @HMCsteps.setter
        def HMCsteps(self, arg: Optional[int]) -> None:
            """
            Args:
                arg (typing.Optional[int])
            """

    class Solution:
        @property
        def value(self) -> float:
            """value

            Returns:
                float:
            """

        @property
        def result(self) -> Annotated[numpy.typing.NDArray[numpy.float64], {"dtype": "float64"}]:
            """result

            Returns:
                numpy.ndarray:
            """

        @property
        def param(self) -> ToshibaSQBM2Client.Parameters:
            """param

            Returns:
                amplify.ToshibaSQBM2Client.Parameters:
            """

        @property
        def count(self) -> int:
            """count

            Returns:
                int:
            """

    class Result(ToshibaSQBM2Client.Solution):
        @property
        def id(self) -> str:
            """id

            Returns:
                str:
            """

        @property
        def time(self) -> datetime.timedelta:
            """time

            Returns:
                datetime.timedelta:
            """

        @property
        def wait(self) -> datetime.timedelta:
            """wait

            Returns:
                datetime.timedelta:
            """

        @property
        def message(self) -> str:
            """message

            Returns:
                str:
            """

        @property
        def runs(self) -> int:
            """runs

            Returns:
                int:
            """

        @property
        def others(self) -> list[ToshibaSQBM2Client.Solution]:
            """others

            Returns:
                list[amplify.ToshibaSQBM2Client.Solution]:
            """

    class Solver(enum.Enum):
        Qubo = 0
        Qplib = 1
        Pubo = 2

    @property
    def url(self) -> str:
        """url

        Returns:
            str:
        """

    @url.setter
    def url(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def token(self) -> str:
        """token

        Returns:
            str:
        """

    @token.setter
    def token(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def proxy(self) -> Optional[str]:
        """proxy

        Returns:
            typing.Optional[str]:
        """

    @proxy.setter
    def proxy(self, arg: Optional[str]) -> None:
        """
        Args:
            arg (typing.Optional[str])
        """

    @property
    def compression(self) -> bool:
        """compression

        Returns:
            bool:
        """

    @compression.setter
    def compression(self, arg: bool, /) -> None:
        """
        Args:
            arg (bool)
        """

    @property
    def solver(self) -> ToshibaSQBM2Client.Solver:
        """solver

        Returns:
            amplify.ToshibaSQBM2Client.Solver:
        """

    @solver.setter
    def solver(self, arg: Union[Literal["Qubo", "Qplib", "Pubo"], ToshibaSQBM2Client.Solver], /) -> None:
        """
        Args:
            arg (typing.Union[typing.Literal['Qubo', 'Qplib', 'Pubo'], amplify.ToshibaSQBM2Client.Solver])
        """

    @property
    def write_request_data(self) -> Optional[pathlib.Path]:
        """write_request_data

        Returns:
            typing.Optional[pathlib.Path]:
        """

    @write_request_data.setter
    def write_request_data(self, arg: Optional[str | os.PathLike]) -> None:
        """
        Args:
            arg (typing.Optional[str | os.PathLike])
        """

    @property
    def write_response_data(self) -> Optional[pathlib.Path]:
        """write_response_data

        Returns:
            typing.Optional[pathlib.Path]:
        """

    @write_response_data.setter
    def write_response_data(self, arg: Optional[str | os.PathLike]) -> None:
        """
        Args:
            arg (typing.Optional[str | os.PathLike])
        """

    @property
    def parameters(self) -> ToshibaSQBM2Client.Parameters:
        """parameters

        Returns:
            amplify.ToshibaSQBM2Client.Parameters:
        """

    @property
    def version(self) -> str:
        """version

        Returns:
            str:
        """

    @property
    def acceptable_degrees(self) -> AcceptableDegrees:
        """acceptable_degrees

        Returns:
            amplify.AcceptableDegrees:
        """

    def health_check(self) -> bool:
        """health_check

        Returns:
            bool:
        """

    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[False] = False) -> ToshibaSQBM2Client.Result: ...
    @overload
    def solve(
        self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[False] = False
    ) -> ToshibaSQBM2Client.Result: ...
    @overload
    def solve(
        self,
        objective: Union[Poly, Matrix],
        constraint: Union[Constraint, ConstraintList],
        dry_run: Literal[False] = False,
    ) -> ToshibaSQBM2Client.Result: ...
    @overload
    def solve(self, objective: Union[Poly, Matrix], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(self, constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]) -> None: ...
    @overload
    def solve(
        self, objective: Union[Poly, Matrix], constraint: Union[Constraint, ConstraintList], dry_run: Literal[True]
    ) -> None:
        """solve

        .. admonition:: Overload 1.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * dry_run (typing.Literal[False]): Defaults to ``False``.

            Returns:
                amplify.ToshibaSQBM2Client.Result:

        .. admonition:: Overload 2.

            Args:
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[False]): Defaults to ``False``.

            Returns:
                amplify.ToshibaSQBM2Client.Result:

        .. admonition:: Overload 3.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[False]): Defaults to ``False``.

            Returns:
                amplify.ToshibaSQBM2Client.Result:

        .. admonition:: Overload 4.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * dry_run (typing.Literal[True])

        .. admonition:: Overload 5.

            Args:
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[True])

        .. admonition:: Overload 6.

            Args:
                * objective (typing.Union[amplify.Poly, amplify.Matrix])
                * constraint (typing.Union[amplify.Constraint, amplify.ConstraintList])
                * dry_run (typing.Literal[True])
        """

class Values:
    class KeysView:
        @overload
        def __contains__(self, arg: Poly, /) -> bool: ...
        @overload
        def __contains__(self, arg: object, /) -> bool: ...
        def __len__(self) -> int: ...
        def __bool__(self) -> bool: ...
        def __iter__(self) -> Values.KeysView: ...
        def __next__(self) -> Poly: ...

    class ValuesView:
        def __len__(self) -> int: ...
        def __bool__(self) -> bool: ...
        def __iter__(self) -> Values.ValuesView: ...
        def __next__(self) -> float: ...

    class ItemsView:
        def __len__(self) -> int: ...
        def __bool__(self) -> bool: ...
        def __iter__(self) -> Values.ItemsView: ...
        def __next__(self) -> tuple[Poly, float]: ...

    def __len__(self) -> int: ...
    def __bool__(self) -> bool: ...
    @overload
    def __contains__(self, arg: Poly, /) -> bool: ...
    @overload
    def __contains__(self, arg: object, /) -> bool: ...
    def __iter__(self) -> Values.KeysView: ...
    def __getitem__(self, arg: Poly, /) -> float: ...
    def keys(self) -> Values.KeysView:
        """keys

        Returns:
            amplify.Values.KeysView:
        """

    def values(self) -> Values.ValuesView:
        """values

        Returns:
            amplify.Values.ValuesView:
        """

    def items(self) -> Values.ItemsView:
        """items

        Returns:
            amplify.Values.ItemsView:
        """

class Variable:
    @property
    def id(self) -> int:
        """id

        Returns:
            int:
        """

    @property
    def type(self) -> VariableType:
        """type

        Returns:
            amplify.VariableType:
        """

    @property
    def name(self) -> str:
        """name

        Returns:
            str:
        """

    @name.setter
    def name(self, arg: str, /) -> None:
        """
        Args:
            arg (str)
        """

    @property
    def lower_bound(self) -> Optional[float]:
        """lower_bound

        Returns:
            typing.Optional[float]:
        """

    @lower_bound.setter
    def lower_bound(self, arg: Optional[float]) -> None:
        """
        Args:
            arg (typing.Optional[float])
        """

    @property
    def upper_bound(self) -> Optional[float]:
        """upper_bound

        Returns:
            typing.Optional[float]:
        """

    @upper_bound.setter
    def upper_bound(self, arg: Optional[float]) -> None:
        """
        Args:
            arg (typing.Optional[float])
        """

    def __eq__(self, arg: object, /) -> bool: ...
    def __ne__(self, arg: object, /) -> bool: ...

class VariableGenerator:
    def __init__(self) -> None: ...
    @property
    def variables(self) -> list[Variable]:
        """variables

        Returns:
            list[amplify.Variable]:
        """

    def scalar(
        self,
        type: Union[Literal["Binary", "Ising", "Integer", "Real"], VariableType],
        bounds: tuple[Optional[float], ...] = (None, None),
        name: str = "",
    ) -> Poly:
        r"""scalar

        Args:
            type (typing.Union[typing.Literal['Binary', 'Ising', 'Integer', 'Real'], amplify.VariableType])
            bounds (tuple[typing.Optional[float], ...]): Defaults to ``(None, None)``.
            name (str): Defaults to ``\'\'``.

        Returns:
            amplify.Poly:
        """

    @overload
    def array(
        self,
        type: Union[Literal["Binary", "Ising", "Integer", "Real"], VariableType],
        shape: tuple[()],
        bounds: tuple[Optional[float], ...] = (None, None),
        name: str = "",
    ) -> PolyArray[Dim0]: ...
    @overload
    def array(
        self,
        type: Union[Literal["Binary", "Ising", "Integer", "Real"], VariableType],
        shape: Union[tuple[int], int],
        bounds: tuple[Optional[float], ...] = (None, None),
        name: str = "",
    ) -> PolyArray[Dim1]: ...
    @overload
    def array(
        self,
        type: Union[Literal["Binary", "Ising", "Integer", "Real"], VariableType],
        shape: tuple[int, int],
        bounds: tuple[Optional[float], ...] = (None, None),
        name: str = "",
    ) -> PolyArray[Dim2]: ...
    @overload
    def array(
        self,
        type: Union[Literal["Binary", "Ising", "Integer", "Real"], VariableType],
        shape: tuple[int, int, int],
        bounds: tuple[Optional[float], ...] = (None, None),
        name: str = "",
    ) -> PolyArray[Dim3]: ...
    @overload
    def array(
        self,
        type: Union[Literal["Binary", "Ising", "Integer", "Real"], VariableType],
        shape: tuple[int, int, int, int],
        bounds: tuple[Optional[float], ...] = (None, None),
        name: str = "",
    ) -> PolyArray[Dim4]: ...
    @overload
    def array(
        self, type: Union[Literal["Binary", "Ising", "Integer", "Real"], VariableType], arg0: int
    ) -> PolyArray[Dim1]: ...
    @overload
    def array(
        self, type: Union[Literal["Binary", "Ising", "Integer", "Real"], VariableType], arg0: int, arg1: int
    ) -> PolyArray[Dim2]: ...
    @overload
    def array(
        self, type: Union[Literal["Binary", "Ising", "Integer", "Real"], VariableType], arg0: int, arg1: int, arg2: int
    ) -> PolyArray[Dim3]: ...
    @overload
    def array(
        self,
        type: Union[Literal["Binary", "Ising", "Integer", "Real"], VariableType],
        arg0: int,
        arg1: int,
        arg2: int,
        arg3: int,
    ) -> PolyArray[Dim4]: ...
    @overload
    def array(
        self,
        type: Union[Literal["Binary", "Ising", "Integer", "Real"], VariableType],
        shape: tuple[int, int, int, int, int, typing_extensions.Unpack[tuple[int, ...]]],
        bounds: tuple[Optional[float], ...] = (None, None),
        name: str = "",
    ) -> PolyArray[Dim]: ...
    @overload
    def array(
        self, type: Union[Literal["Binary", "Ising", "Integer", "Real"], VariableType], *shape: int
    ) -> PolyArray[Dim]:
        r"""array

        .. admonition:: Overload 1.

            Args:
                * type (typing.Union[typing.Literal['Binary', 'Ising', 'Integer', 'Real'], amplify.VariableType])
                * shape (tuple[()])
                * bounds (tuple[typing.Optional[float], ...]): Defaults to ``(None, None)``.
                * name (str): Defaults to ``\'\'``.

            Returns:
                amplify.PolyArray[Dim0]:

        .. admonition:: Overload 2.

            Args:
                * type (typing.Union[typing.Literal['Binary', 'Ising', 'Integer', 'Real'], amplify.VariableType])
                * shape (typing.Union[tuple[int], int])
                * bounds (tuple[typing.Optional[float], ...]): Defaults to ``(None, None)``.
                * name (str): Defaults to ``\'\'``.

            Returns:
                amplify.PolyArray[Dim1]:

        .. admonition:: Overload 3.

            Args:
                * type (typing.Union[typing.Literal['Binary', 'Ising', 'Integer', 'Real'], amplify.VariableType])
                * shape (tuple[int, int])
                * bounds (tuple[typing.Optional[float], ...]): Defaults to ``(None, None)``.
                * name (str): Defaults to ``\'\'``.

            Returns:
                amplify.PolyArray[Dim2]:

        .. admonition:: Overload 4.

            Args:
                * type (typing.Union[typing.Literal['Binary', 'Ising', 'Integer', 'Real'], amplify.VariableType])
                * shape (tuple[int, int, int])
                * bounds (tuple[typing.Optional[float], ...]): Defaults to ``(None, None)``.
                * name (str): Defaults to ``\'\'``.

            Returns:
                amplify.PolyArray[Dim3]:

        .. admonition:: Overload 5.

            Args:
                * type (typing.Union[typing.Literal['Binary', 'Ising', 'Integer', 'Real'], amplify.VariableType])
                * shape (tuple[int, int, int, int])
                * bounds (tuple[typing.Optional[float], ...]): Defaults to ``(None, None)``.
                * name (str): Defaults to ``\'\'``.

            Returns:
                amplify.PolyArray[Dim4]:

        .. admonition:: Overload 6.

            Args:
                * type (typing.Union[typing.Literal['Binary', 'Ising', 'Integer', 'Real'], amplify.VariableType])
                * arg0 (int)

            Returns:
                amplify.PolyArray[Dim1]:

        .. admonition:: Overload 7.

            Args:
                * type (typing.Union[typing.Literal['Binary', 'Ising', 'Integer', 'Real'], amplify.VariableType])
                * arg0 (int)
                * arg1 (int)

            Returns:
                amplify.PolyArray[Dim2]:

        .. admonition:: Overload 8.

            Args:
                * type (typing.Union[typing.Literal['Binary', 'Ising', 'Integer', 'Real'], amplify.VariableType])
                * arg0 (int)
                * arg1 (int)
                * arg2 (int)

            Returns:
                amplify.PolyArray[Dim3]:

        .. admonition:: Overload 9.

            Args:
                * type (typing.Union[typing.Literal['Binary', 'Ising', 'Integer', 'Real'], amplify.VariableType])
                * arg0 (int)
                * arg1 (int)
                * arg2 (int)
                * arg3 (int)

            Returns:
                amplify.PolyArray[Dim4]:

        .. admonition:: Overload 10.

            Args:
                * type (typing.Union[typing.Literal['Binary', 'Ising', 'Integer', 'Real'], amplify.VariableType])
                * shape (tuple[int, int, int, int, int, typing_extensions.Unpack[tuple[int, ...]]])
                * bounds (tuple[typing.Optional[float], ...]): Defaults to ``(None, None)``.
                * name (str): Defaults to ``\'\'``.

            Returns:
                amplify.PolyArray[Dim]:

        .. admonition:: Overload 11.

            Args:
                * type (typing.Union[typing.Literal['Binary', 'Ising', 'Integer', 'Real'], amplify.VariableType])
                * \*shape (int)

            Returns:
                amplify.PolyArray[Dim]:
        """

    @overload
    def matrix(
        self,
        type: Union[Literal["Binary", "Ising", "Integer", "Real"], VariableType],
        shape: Union[int, tuple[int, ...]],
        bounds: tuple[Optional[float], ...] = (None, None),
        name: str = "",
    ) -> Matrix: ...
    @overload
    def matrix(self, type: Union[Literal["Binary", "Ising", "Integer", "Real"], VariableType], *shape: int) -> Matrix:
        r"""matrix

        .. admonition:: Overload 1.

            Args:
                * type (typing.Union[typing.Literal['Binary', 'Ising', 'Integer', 'Real'], amplify.VariableType])
                * shape (typing.Union[int, tuple[int, ...]])
                * bounds (tuple[typing.Optional[float], ...]): Defaults to ``(None, None)``.
                * name (str): Defaults to ``\'\'``.

            Returns:
                amplify.Matrix:

        .. admonition:: Overload 2.

            Args:
                * type (typing.Union[typing.Literal['Binary', 'Ising', 'Integer', 'Real'], amplify.VariableType])
                * \*shape (int)

            Returns:
                amplify.Matrix:
        """

class VariableType(enum.Enum):
    Binary = 0
    Ising = 1
    Integer = 2
    Real = 3

_AmplifyClient = TypeVar("_AmplifyClient", bound=AmplifyClient)

_Dim = TypeVar("_Dim", bound=Dim)

@overload
def clamp(
    poly: Poly,
    bounds: tuple[Optional[float], Optional[float]],
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
) -> Constraint: ...
@overload
def clamp(
    array: PolyArray[_Dim],
    bounds: tuple[Optional[float], Optional[float]],
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: Optional[Literal[None]] = None,
) -> Constraint: ...
@overload
def clamp(
    array: PolyArray[Dim],
    bounds: tuple[Optional[float], Optional[float]],
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: Union[int, tuple[int, ...]],
) -> Union[Constraint, ConstraintList]: ...
@overload
def clamp(
    array: PolyArray[Dim1],
    right: tuple[Optional[float], Optional[float]],
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: Union[int, tuple[int]],
) -> Constraint: ...
@overload
def clamp(
    array: PolyArray[Dim2],
    right: tuple[Optional[float], Optional[float]],
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: tuple[int, int],
) -> Constraint: ...
@overload
def clamp(
    array: PolyArray[Dim2],
    right: tuple[Optional[float], Optional[float]],
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: Union[int, tuple[int]],
) -> ConstraintList: ...
@overload
def clamp(
    array: PolyArray[Dim3],
    right: tuple[Optional[float], Optional[float]],
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: tuple[int, int, int],
) -> Constraint: ...
@overload
def clamp(
    array: PolyArray[Dim3],
    right: tuple[Optional[float], Optional[float]],
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: Union[int, tuple[int], tuple[int, int]],
) -> ConstraintList: ...
@overload
def clamp(
    array: PolyArray[Dim4],
    right: tuple[Optional[float], Optional[float]],
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: tuple[int, int, int, int],
) -> Constraint: ...
@overload
def clamp(
    array: PolyArray[Dim4],
    right: tuple[Optional[float], Optional[float]],
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: Union[int, tuple[int], tuple[int, int], tuple[int, int, int]],
) -> ConstraintList: ...
@overload
def clamp(
    array: PolyArray[_Dim],
    right: tuple[Optional[float], Optional[float]],
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: tuple[()],
) -> ConstraintList:
    r"""clamp

    .. admonition:: Overload 1.

        Args:
            * poly (amplify.Poly)
            * bounds (tuple[typing.Optional[float], typing.Optional[float]])
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 2.

        Args:
            * array (amplify.PolyArray[_Dim])
            * bounds (tuple[typing.Optional[float], typing.Optional[float]])
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (typing.Optional[typing.Literal[None]]): Defaults to ``None``.

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 3.

        Args:
            * array (amplify.PolyArray[Dim])
            * bounds (tuple[typing.Optional[float], typing.Optional[float]])
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (typing.Union[int, tuple[int, ...]])

        Returns:
            typing.Union[amplify.Constraint, amplify.ConstraintList]:

    .. admonition:: Overload 4.

        Args:
            * array (amplify.PolyArray[Dim1])
            * right (tuple[typing.Optional[float], typing.Optional[float]])
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (typing.Union[int, tuple[int]])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 5.

        Args:
            * array (amplify.PolyArray[Dim2])
            * right (tuple[typing.Optional[float], typing.Optional[float]])
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (tuple[int, int])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 6.

        Args:
            * array (amplify.PolyArray[Dim2])
            * right (tuple[typing.Optional[float], typing.Optional[float]])
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (typing.Union[int, tuple[int]])

        Returns:
            amplify.ConstraintList:

    .. admonition:: Overload 7.

        Args:
            * array (amplify.PolyArray[Dim3])
            * right (tuple[typing.Optional[float], typing.Optional[float]])
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (tuple[int, int, int])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 8.

        Args:
            * array (amplify.PolyArray[Dim3])
            * right (tuple[typing.Optional[float], typing.Optional[float]])
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (typing.Union[int, tuple[int], tuple[int, int]])

        Returns:
            amplify.ConstraintList:

    .. admonition:: Overload 9.

        Args:
            * array (amplify.PolyArray[Dim4])
            * right (tuple[typing.Optional[float], typing.Optional[float]])
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (tuple[int, int, int, int])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 10.

        Args:
            * array (amplify.PolyArray[Dim4])
            * right (tuple[typing.Optional[float], typing.Optional[float]])
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (typing.Union[int, tuple[int], tuple[int, int], tuple[int, int, int]])

        Returns:
            amplify.ConstraintList:

    .. admonition:: Overload 11.

        Args:
            * array (amplify.PolyArray[_Dim])
            * right (tuple[typing.Optional[float], typing.Optional[float]])
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (tuple[()])

        Returns:
            amplify.ConstraintList:
    """

@overload
def domain_wall(array: PolyArray[Dim1], label: str = "", *, ascending: bool = True) -> Constraint: ...
@overload
def domain_wall(array: PolyArray[_Dim], label: str = "", *, ascending: bool = True) -> ConstraintList:
    r"""domain_wall

    .. admonition:: Overload 1.

        Args:
            * array (amplify.PolyArray[Dim1])
            * label (str): Defaults to ``\'\'``.
            * ascending (bool): Defaults to ``True``.

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 2.

        Args:
            * array (amplify.PolyArray[_Dim])
            * label (str): Defaults to ``\'\'``.
            * ascending (bool): Defaults to ``True``.

        Returns:
            amplify.ConstraintList:
    """

@overload
def dot(arg0: PolyArray, arg1: Union[PolyArray, NDArray], /) -> Union[Poly, PolyArray[Dim]]: ...
@overload
def dot(arg0: NDArray, arg1: PolyArray, /) -> Union[Poly, PolyArray[Dim]]:
    """dot

    .. admonition:: Overload 1.

        Args:
            * arg0 (amplify.PolyArray)
            * arg1 (typing.Union[amplify.PolyArray, ndarray[]])

        Returns:
            typing.Union[amplify.Poly, amplify.PolyArray[Dim]]:

    .. admonition:: Overload 2.

        Args:
            * arg0 (ndarray)
            * arg1 (amplify.PolyArray)

        Returns:
            typing.Union[amplify.Poly, amplify.PolyArray[Dim]]:
    """

def einsum(subscripts: str, *operands: Union[PolyArray, numpy.ndarray]) -> Union[Poly, PolyArray[Dim]]:
    """einsum

    Args:
        subscripts (str)
        *operands (amplify.PolyArray | numpy.ndarray)

    Returns:
        typing.Union[amplify.Poly, amplify.PolyArray[Dim]]:
    """

def embed(
    poly: Poly,
    client_graph: Graph,
    embedding_method: Union[
        Literal["Default", "Minor", "Clique", "Parallel"], EmbeddingMethod
    ] = EmbeddingMethod.Default,
    embedding_timeout: datetime.timedelta = ...,
    chain_strength: float = 1.0,
) -> tuple[Poly, list[Annotated[numpy.typing.NDArray[numpy.uint32], {"dtype": "uint32"}]], list[tuple[int, int]]]:
    """embed

    Args:
        poly (amplify.Poly)
        client_graph (amplify.Graph)
        embedding_method (typing.Union[typing.Literal['Default', 'Minor', 'Clique', 'Parallel'], amplify.EmbeddingMethod]): Defaults to ``EmbeddingMethod.Default``.
        embedding_timeout (datetime.timedelta): Defaults to ``datetime.timedelta(seconds=10)``.
        chain_strength (float): Defaults to ``1.0``.

    Returns:
        tuple[amplify.Poly, list[numpy.ndarray[dtype=uint32]], list[tuple[int, int]]]:
    """

@overload
def equal_to(poly: Poly, right: float, label: str = "") -> Constraint: ...
@overload
def equal_to(
    array: PolyArray[_Dim], right: float, label: str = "", *, axis: Optional[Literal[None]] = None
) -> Constraint: ...
@overload
def equal_to(
    array: PolyArray[Dim], right: float, label: str = "", *, axis: Union[int, tuple[int, ...]]
) -> Union[Constraint, ConstraintList]: ...
@overload
def equal_to(array: PolyArray[_Dim], right: float, label: str = "", *, axis: tuple[()]) -> ConstraintList: ...
@overload
def equal_to(array: PolyArray[Dim1], right: float, label: str = "", *, axis: Union[int, tuple[int]]) -> Constraint: ...
@overload
def equal_to(array: PolyArray[Dim2], right: float, label: str = "", *, axis: tuple[int, int]) -> Constraint: ...
@overload
def equal_to(
    array: PolyArray[Dim2], right: float, label: str = "", *, axis: Union[int, tuple[int]]
) -> ConstraintList: ...
@overload
def equal_to(array: PolyArray[Dim3], right: float, label: str = "", *, axis: tuple[int, int, int]) -> Constraint: ...
@overload
def equal_to(
    array: PolyArray[Dim3], right: float, label: str = "", *, axis: Union[int, tuple[int], tuple[int, int]]
) -> ConstraintList: ...
@overload
def equal_to(
    array: PolyArray[Dim4], right: float, label: str = "", *, axis: tuple[int, int, int, int]
) -> Constraint: ...
@overload
def equal_to(
    array: PolyArray[Dim4],
    right: float,
    label: str = "",
    *,
    axis: Union[int, tuple[int], tuple[int, int], tuple[int, int, int]],
) -> ConstraintList:
    r"""equal_to

    .. admonition:: Overload 1.

        Args:
            * poly (amplify.Poly)
            * right (float)
            * label (str): Defaults to ``\'\'``.

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 2.

        Args:
            * array (amplify.PolyArray[_Dim])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * axis (typing.Optional[typing.Literal[None]]): Defaults to ``None``.

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 3.

        Args:
            * array (amplify.PolyArray[Dim])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * axis (typing.Union[int, tuple[int, ...]])

        Returns:
            typing.Union[amplify.Constraint, amplify.ConstraintList]:

    .. admonition:: Overload 4.

        Args:
            * array (amplify.PolyArray[_Dim])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * axis (tuple[()])

        Returns:
            amplify.ConstraintList:

    .. admonition:: Overload 5.

        Args:
            * array (amplify.PolyArray[Dim1])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * axis (typing.Union[int, tuple[int]])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 6.

        Args:
            * array (amplify.PolyArray[Dim2])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * axis (tuple[int, int])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 7.

        Args:
            * array (amplify.PolyArray[Dim2])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * axis (typing.Union[int, tuple[int]])

        Returns:
            amplify.ConstraintList:

    .. admonition:: Overload 8.

        Args:
            * array (amplify.PolyArray[Dim3])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * axis (tuple[int, int, int])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 9.

        Args:
            * array (amplify.PolyArray[Dim3])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * axis (typing.Union[int, tuple[int], tuple[int, int]])

        Returns:
            amplify.ConstraintList:

    .. admonition:: Overload 10.

        Args:
            * array (amplify.PolyArray[Dim4])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * axis (tuple[int, int, int, int])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 11.

        Args:
            * array (amplify.PolyArray[Dim4])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * axis (typing.Union[int, tuple[int], tuple[int, int], tuple[int, int, int]])

        Returns:
            amplify.ConstraintList:
    """

@overload
def greater_equal(
    poly: Poly,
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
) -> Constraint: ...
@overload
def greater_equal(
    array: PolyArray[_Dim],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: Optional[Literal[None]] = None,
) -> Constraint: ...
@overload
def greater_equal(
    array: PolyArray[Dim],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: Union[int, tuple[int, ...]],
) -> Union[Constraint, ConstraintList]: ...
@overload
def greater_equal(
    array: PolyArray[_Dim],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: tuple[()],
) -> ConstraintList: ...
@overload
def greater_equal(
    array: PolyArray[Dim1],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: Union[int, tuple[int]],
) -> Constraint: ...
@overload
def greater_equal(
    array: PolyArray[Dim2],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: tuple[int, int],
) -> Constraint: ...
@overload
def greater_equal(
    array: PolyArray[Dim2],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: Union[int, tuple[int]],
) -> ConstraintList: ...
@overload
def greater_equal(
    array: PolyArray[Dim3],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: tuple[int, int, int],
) -> Constraint: ...
@overload
def greater_equal(
    array: PolyArray[Dim3],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: Union[int, tuple[int], tuple[int, int]],
) -> ConstraintList: ...
@overload
def greater_equal(
    array: PolyArray[Dim4],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: tuple[int, int, int, int],
) -> Constraint: ...
@overload
def greater_equal(
    array: PolyArray[Dim4],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: Union[int, tuple[int], tuple[int, int], tuple[int, int, int]],
) -> ConstraintList:
    r"""greater_equal

    .. admonition:: Overload 1.

        Args:
            * poly (amplify.Poly)
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 2.

        Args:
            * array (amplify.PolyArray[_Dim])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (typing.Optional[typing.Literal[None]]): Defaults to ``None``.

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 3.

        Args:
            * array (amplify.PolyArray[Dim])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (typing.Union[int, tuple[int, ...]])

        Returns:
            typing.Union[amplify.Constraint, amplify.ConstraintList]:

    .. admonition:: Overload 4.

        Args:
            * array (amplify.PolyArray[_Dim])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (tuple[()])

        Returns:
            amplify.ConstraintList:

    .. admonition:: Overload 5.

        Args:
            * array (amplify.PolyArray[Dim1])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (typing.Union[int, tuple[int]])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 6.

        Args:
            * array (amplify.PolyArray[Dim2])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (tuple[int, int])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 7.

        Args:
            * array (amplify.PolyArray[Dim2])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (typing.Union[int, tuple[int]])

        Returns:
            amplify.ConstraintList:

    .. admonition:: Overload 8.

        Args:
            * array (amplify.PolyArray[Dim3])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (tuple[int, int, int])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 9.

        Args:
            * array (amplify.PolyArray[Dim3])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (typing.Union[int, tuple[int], tuple[int, int]])

        Returns:
            amplify.ConstraintList:

    .. admonition:: Overload 10.

        Args:
            * array (amplify.PolyArray[Dim4])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (tuple[int, int, int, int])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 11.

        Args:
            * array (amplify.PolyArray[Dim4])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (typing.Union[int, tuple[int], tuple[int, int], tuple[int, int, int]])

        Returns:
            amplify.ConstraintList:
    """

@overload
def less_equal(
    poly: Poly,
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
) -> Constraint: ...
@overload
def less_equal(
    array: PolyArray[_Dim],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: Optional[Literal[None]] = None,
) -> Constraint: ...
@overload
def less_equal(
    array: PolyArray[Dim],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: Union[int, tuple[int, ...]],
) -> Union[Constraint, ConstraintList]: ...
@overload
def less_equal(
    array: PolyArray[_Dim],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: tuple[()],
) -> ConstraintList: ...
@overload
def less_equal(
    array: PolyArray[Dim1],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: Union[int, tuple[int]],
) -> Constraint: ...
@overload
def less_equal(
    array: PolyArray[Dim2],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: tuple[int, int],
) -> Constraint: ...
@overload
def less_equal(
    array: PolyArray[Dim2],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: Union[int, tuple[int]],
) -> ConstraintList: ...
@overload
def less_equal(
    array: PolyArray[Dim3],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: tuple[int, int, int],
) -> Constraint: ...
@overload
def less_equal(
    array: PolyArray[Dim3],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: Union[int, tuple[int], tuple[int, int]],
) -> ConstraintList: ...
@overload
def less_equal(
    array: PolyArray[Dim4],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: tuple[int, int, int, int],
) -> Constraint: ...
@overload
def less_equal(
    array: PolyArray[Dim4],
    right: float,
    label: str = "",
    *,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
    axis: Union[int, tuple[int], tuple[int, int], tuple[int, int, int]],
) -> ConstraintList:
    r"""less_equal

    .. admonition:: Overload 1.

        Args:
            * poly (amplify.Poly)
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 2.

        Args:
            * array (amplify.PolyArray[_Dim])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (typing.Optional[typing.Literal[None]]): Defaults to ``None``.

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 3.

        Args:
            * array (amplify.PolyArray[Dim])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (typing.Union[int, tuple[int, ...]])

        Returns:
            typing.Union[amplify.Constraint, amplify.ConstraintList]:

    .. admonition:: Overload 4.

        Args:
            * array (amplify.PolyArray[_Dim])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (tuple[()])

        Returns:
            amplify.ConstraintList:

    .. admonition:: Overload 5.

        Args:
            * array (amplify.PolyArray[Dim1])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (typing.Union[int, tuple[int]])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 6.

        Args:
            * array (amplify.PolyArray[Dim2])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (tuple[int, int])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 7.

        Args:
            * array (amplify.PolyArray[Dim2])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (typing.Union[int, tuple[int]])

        Returns:
            amplify.ConstraintList:

    .. admonition:: Overload 8.

        Args:
            * array (amplify.PolyArray[Dim3])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (tuple[int, int, int])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 9.

        Args:
            * array (amplify.PolyArray[Dim3])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (typing.Union[int, tuple[int], tuple[int, int]])

        Returns:
            amplify.ConstraintList:

    .. admonition:: Overload 10.

        Args:
            * array (amplify.PolyArray[Dim4])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (tuple[int, int, int, int])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 11.

        Args:
            * array (amplify.PolyArray[Dim4])
            * right (float)
            * label (str): Defaults to ``\'\'``.
            * penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.
            * axis (typing.Union[int, tuple[int], tuple[int, int], tuple[int, int, int]])

        Returns:
            amplify.ConstraintList:
    """

def load_lp(
    filename: str | os.PathLike,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
) -> tuple[Model, VariableGenerator]:
    """load_lp

    Args:
        filename (str | os.PathLike)
        penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.

    Returns:
        tuple[amplify.Model, amplify.VariableGenerator]:
    """

def load_qplib(
    filename: str | os.PathLike,
    penalty_formulation: Union[
        Literal["Default", "IntegerVariable", "RealVariable", "Relaxation", "LinearRelaxation", "QuadraticRelaxation"],
        PenaltyFormulation,
    ] = PenaltyFormulation.Default,
) -> tuple[Model, VariableGenerator]:
    """load_qplib

    Args:
        filename (str | os.PathLike)
        penalty_formulation (typing.Union[typing.Literal['Default', 'IntegerVariable', 'RealVariable', 'Relaxation', 'LinearRelaxation', 'QuadraticRelaxation'], amplify.PenaltyFormulation]): Defaults to ``PenaltyFormulation.Default``.

    Returns:
        tuple[amplify.Model, amplify.VariableGenerator]:
    """

@overload
def matmul(arg0: PolyArray, arg1: Union[PolyArray, NDArray], /) -> Union[Poly, PolyArray[Dim]]: ...
@overload
def matmul(arg0: NDArray, arg1: PolyArray, /) -> Union[Poly, PolyArray[Dim]]:
    """matmul

    .. admonition:: Overload 1.

        Args:
            * arg0 (amplify.PolyArray)
            * arg1 (typing.Union[amplify.PolyArray, ndarray[]])

        Returns:
            typing.Union[amplify.Poly, amplify.PolyArray[Dim]]:

    .. admonition:: Overload 2.

        Args:
            * arg0 (ndarray)
            * arg1 (amplify.PolyArray)

        Returns:
            typing.Union[amplify.Poly, amplify.PolyArray[Dim]]:
    """

newaxis: None = None

@overload
def one_hot(poly: Poly, label: str = "") -> Constraint: ...
@overload
def one_hot(array: PolyArray[_Dim], label: str = "", *, axis: Optional[Literal[None]] = None) -> Constraint: ...
@overload
def one_hot(
    array: PolyArray[Dim], label: str = "", *, axis: Union[int, tuple[int, ...]]
) -> Union[Constraint, ConstraintList]: ...
@overload
def one_hot(array: PolyArray[_Dim], label: str = "", *, axis: tuple[()]) -> ConstraintList: ...
@overload
def one_hot(array: PolyArray[Dim1], label: str = "", *, axis: Union[int, tuple[int]]) -> Constraint: ...
@overload
def one_hot(array: PolyArray[Dim2], label: str = "", *, axis: tuple[int, int]) -> Constraint: ...
@overload
def one_hot(array: PolyArray[Dim2], label: str = "", *, axis: Union[int, tuple[int]]) -> ConstraintList: ...
@overload
def one_hot(array: PolyArray[Dim3], label: str = "", *, axis: tuple[int, int, int]) -> Constraint: ...
@overload
def one_hot(
    array: PolyArray[Dim3], label: str = "", *, axis: Union[int, tuple[int], tuple[int, int]]
) -> ConstraintList: ...
@overload
def one_hot(array: PolyArray[Dim4], label: str = "", *, axis: tuple[int, int, int, int]) -> Constraint: ...
@overload
def one_hot(
    array: PolyArray[Dim4], label: str = "", *, axis: Union[int, tuple[int], tuple[int, int], tuple[int, int, int]]
) -> ConstraintList:
    r"""one_hot

    .. admonition:: Overload 1.

        Args:
            * poly (amplify.Poly)
            * label (str): Defaults to ``\'\'``.

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 2.

        Args:
            * array (amplify.PolyArray[_Dim])
            * label (str): Defaults to ``\'\'``.
            * axis (typing.Optional[typing.Literal[None]]): Defaults to ``None``.

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 3.

        Args:
            * array (amplify.PolyArray[Dim])
            * label (str): Defaults to ``\'\'``.
            * axis (typing.Union[int, tuple[int, ...]])

        Returns:
            typing.Union[amplify.Constraint, amplify.ConstraintList]:

    .. admonition:: Overload 4.

        Args:
            * array (amplify.PolyArray[_Dim])
            * label (str): Defaults to ``\'\'``.
            * axis (tuple[()])

        Returns:
            amplify.ConstraintList:

    .. admonition:: Overload 5.

        Args:
            * array (amplify.PolyArray[Dim1])
            * label (str): Defaults to ``\'\'``.
            * axis (typing.Union[int, tuple[int]])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 6.

        Args:
            * array (amplify.PolyArray[Dim2])
            * label (str): Defaults to ``\'\'``.
            * axis (tuple[int, int])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 7.

        Args:
            * array (amplify.PolyArray[Dim2])
            * label (str): Defaults to ``\'\'``.
            * axis (typing.Union[int, tuple[int]])

        Returns:
            amplify.ConstraintList:

    .. admonition:: Overload 8.

        Args:
            * array (amplify.PolyArray[Dim3])
            * label (str): Defaults to ``\'\'``.
            * axis (tuple[int, int, int])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 9.

        Args:
            * array (amplify.PolyArray[Dim3])
            * label (str): Defaults to ``\'\'``.
            * axis (typing.Union[int, tuple[int], tuple[int, int]])

        Returns:
            amplify.ConstraintList:

    .. admonition:: Overload 10.

        Args:
            * array (amplify.PolyArray[Dim4])
            * label (str): Defaults to ``\'\'``.
            * axis (tuple[int, int, int, int])

        Returns:
            amplify.Constraint:

    .. admonition:: Overload 11.

        Args:
            * array (amplify.PolyArray[Dim4])
            * label (str): Defaults to ``\'\'``.
            * axis (typing.Union[int, tuple[int], tuple[int, int], tuple[int, int, int]])

        Returns:
            amplify.ConstraintList:
    """

def parallel_solve(
    model: Union[
        Union[Model, Poly, Matrix, Constraint, ConstraintList],
        Sequence[Union[Model, Poly, Matrix, Constraint, ConstraintList]],
    ],
    client: Union[AmplifyClient, Sequence[AmplifyClient]],
    *,
    dry_run: Union[bool, Sequence[bool]] = False,
    integer_encoding_method: Union[
        Literal["Unary", "Linear", "Binary", "Default"],
        IntegerEncodingMethod,
        Sequence[Union[Literal["Unary", "Linear", "Binary", "Default"], IntegerEncodingMethod]],
    ] = IntegerEncodingMethod.Default,
    quadratization_method: Union[
        Literal["IshikawaKZFD", "Substitute"],
        QuadratizationMethod,
        Sequence[Union[Literal["IshikawaKZFD", "Substitute"], QuadratizationMethod]],
    ] = QuadratizationMethod.IshikawaKZFD,
    substitution_multiplier: Union[float, Sequence[float]] = 1.0,
    embedding_method: Union[
        Literal["Default", "Minor", "Clique", "Parallel"],
        EmbeddingMethod,
        Sequence[Union[Literal["Default", "Minor", "Clique", "Parallel"], EmbeddingMethod]],
    ] = EmbeddingMethod.Default,
    embedding_timeout: Union[float, datetime.timedelta, Sequence[Union[float, datetime.timedelta]]] = 10.0,
    chain_strength: Union[float, Sequence[float]] = 1.0,
    num_solves: Union[int, Sequence[int]] = 1,
    filter_solution: Union[bool, Sequence[bool]] = True,
    sort_solution: Union[bool, Sequence[bool]] = True,
    concurrency: int = 0,
) -> list[Optional[Result]]:
    """parallel_solve

    Args:
        model (typing.Union[typing.Union[amplify.Model, amplify.Poly, amplify.Matrix, amplify.Constraint, amplify.ConstraintList], collections.abc.Sequence[typing.Union[amplify.Model, amplify.Poly, amplify.Matrix, amplify.Constraint, amplify.ConstraintList]]])
        client (amplify.AmplifyClient | collections.abc.Sequence[amplify.AmplifyClient])
        dry_run (typing.Union[bool, collections.abc.Sequence[bool]]): Defaults to ``False``.
        integer_encoding_method (typing.Union[typing.Literal['Unary', 'Linear', 'Binary', 'Default'], amplify.IntegerEncodingMethod, collections.abc.Sequence[typing.Union[typing.Literal['Unary', 'Linear', 'Binary', 'Default'], amplify.IntegerEncodingMethod]]]): Defaults to ``IntegerEncodingMethod.Default``.
        quadratization_method (typing.Union[typing.Literal['IshikawaKZFD', 'Substitute'], amplify.QuadratizationMethod, collections.abc.Sequence[typing.Union[typing.Literal['IshikawaKZFD', 'Substitute'], amplify.QuadratizationMethod]]]): Defaults to ``QuadratizationMethod.IshikawaKZFD``.
        substitution_multiplier (typing.Union[float, collections.abc.Sequence[float]]): Defaults to ``1.0``.
        embedding_method (typing.Union[typing.Literal['Default', 'Minor', 'Clique', 'Parallel'], amplify.EmbeddingMethod, collections.abc.Sequence[typing.Union[typing.Literal['Default', 'Minor', 'Clique', 'Parallel'], amplify.EmbeddingMethod]]]): Defaults to ``EmbeddingMethod.Default``.
        embedding_timeout (typing.Union[float, datetime.timedelta, collections.abc.Sequence[typing.Union[float, datetime.timedelta]]]): Defaults to ``10.0``.
        chain_strength (typing.Union[float, collections.abc.Sequence[float]]): Defaults to ``1.0``.
        num_solves (typing.Union[int, collections.abc.Sequence[int]]): Defaults to ``1``.
        filter_solution (typing.Union[bool, collections.abc.Sequence[bool]]): Defaults to ``True``.
        sort_solution (typing.Union[bool, collections.abc.Sequence[bool]]): Defaults to ``True``.
        concurrency (int): Defaults to ``0``.

    Returns:
        list[typing.Optional[amplify.Result]]:
    """

def save_lp(model: Model, filename: str | os.PathLike) -> None:
    """save_lp

    Args:
        model (amplify.Model)
        filename (str | os.PathLike)
    """

def save_qplib(model: Model, filename: str | os.PathLike) -> None:
    """save_qplib

    Args:
        model (amplify.Model)
        filename (str | os.PathLike)
    """

def set_num_threads(arg: int, /) -> None:
    """set_num_threads

    Args:
        arg (int)
    """

def set_seed(arg: int, /) -> None:
    """set_seed

    Args:
        arg (int)
    """

@overload
def solve(
    model: Union[Model, Poly, Matrix, Constraint, ConstraintList],
    client: _AmplifyClient,
    *,
    dry_run: Literal[False] = False,
    integer_encoding_method: Union[
        Literal["Unary", "Linear", "Binary", "Default"], IntegerEncodingMethod
    ] = IntegerEncodingMethod.Default,
    real_encoding_method: Union[
        Literal["Random4", "Random8", "Random16", "Random32"], RealEncodingMethod
    ] = RealEncodingMethod.Random16,
    quadratization_method: Union[
        Literal["IshikawaKZFD", "Substitute"], QuadratizationMethod
    ] = QuadratizationMethod.IshikawaKZFD,
    substitution_multiplier: float = 1.0,
    embedding_method: Union[
        Literal["Default", "Minor", "Clique", "Parallel"], EmbeddingMethod
    ] = EmbeddingMethod.Default,
    embedding_timeout: Union[float, datetime.timedelta] = 10.0,
    chain_strength: float = 1.0,
    num_solves: int = 1,
    filter_solution: bool = True,
    sort_solution: bool = True,
) -> Result[_AmplifyClient]: ...
@overload
def solve(
    model: Union[Model, Poly, Matrix, Constraint, ConstraintList],
    client: AmplifyClient,
    *,
    dry_run: Literal[True],
    integer_encoding_method: Union[
        Literal["Unary", "Linear", "Binary", "Default"], IntegerEncodingMethod
    ] = IntegerEncodingMethod.Default,
    real_encoding_method: Union[
        Literal["Random4", "Random8", "Random16", "Random32"], RealEncodingMethod
    ] = RealEncodingMethod.Random16,
    quadratization_method: Union[
        Literal["IshikawaKZFD", "Substitute"], QuadratizationMethod
    ] = QuadratizationMethod.IshikawaKZFD,
    substitution_multiplier: float = 1.0,
    embedding_method: Union[
        Literal["Default", "Minor", "Clique", "Parallel"], EmbeddingMethod
    ] = EmbeddingMethod.Default,
    embedding_timeout: Union[float, datetime.timedelta] = 10.0,
    chain_strength: float = 1.0,
    num_solves: int = 1,
    filter_solution: bool = True,
    sort_solution: bool = True,
) -> Result:
    """solve

    .. admonition:: Overload 1.

        Args:
            * model (typing.Union[amplify.Model, amplify.Poly, amplify.Matrix, amplify.Constraint, amplify.ConstraintList])
            * client (amplify._AmplifyClient)
            * dry_run (typing.Literal[False]): Defaults to ``False``.
            * integer_encoding_method (typing.Union[typing.Literal['Unary', 'Linear', 'Binary', 'Default'], amplify.IntegerEncodingMethod]): Defaults to ``IntegerEncodingMethod.Default``.
            * real_encoding_method (typing.Union[typing.Literal['Random4', 'Random8', 'Random16', 'Random32'], amplify.RealEncodingMethod]): Defaults to ``RealEncodingMethod.Random16``.
            * quadratization_method (typing.Union[typing.Literal['IshikawaKZFD', 'Substitute'], amplify.QuadratizationMethod]): Defaults to ``QuadratizationMethod.IshikawaKZFD``.
            * substitution_multiplier (float): Defaults to ``1.0``.
            * embedding_method (typing.Union[typing.Literal['Default', 'Minor', 'Clique', 'Parallel'], amplify.EmbeddingMethod]): Defaults to ``EmbeddingMethod.Default``.
            * embedding_timeout (typing.Union[float, datetime.timedelta]): Defaults to ``10.0``.
            * chain_strength (float): Defaults to ``1.0``.
            * num_solves (int): Defaults to ``1``.
            * filter_solution (bool): Defaults to ``True``.
            * sort_solution (bool): Defaults to ``True``.

        Returns:
            amplify.Result[amplify._AmplifyClient]:

    .. admonition:: Overload 2.

        Args:
            * model (typing.Union[amplify.Model, amplify.Poly, amplify.Matrix, amplify.Constraint, amplify.ConstraintList])
            * client (amplify.AmplifyClient)
            * dry_run (typing.Literal[True])
            * integer_encoding_method (typing.Union[typing.Literal['Unary', 'Linear', 'Binary', 'Default'], amplify.IntegerEncodingMethod]): Defaults to ``IntegerEncodingMethod.Default``.
            * real_encoding_method (typing.Union[typing.Literal['Random4', 'Random8', 'Random16', 'Random32'], amplify.RealEncodingMethod]): Defaults to ``RealEncodingMethod.Random16``.
            * quadratization_method (typing.Union[typing.Literal['IshikawaKZFD', 'Substitute'], amplify.QuadratizationMethod]): Defaults to ``QuadratizationMethod.IshikawaKZFD``.
            * substitution_multiplier (float): Defaults to ``1.0``.
            * embedding_method (typing.Union[typing.Literal['Default', 'Minor', 'Clique', 'Parallel'], amplify.EmbeddingMethod]): Defaults to ``EmbeddingMethod.Default``.
            * embedding_timeout (typing.Union[float, datetime.timedelta]): Defaults to ``10.0``.
            * chain_strength (float): Defaults to ``1.0``.
            * num_solves (int): Defaults to ``1``.
            * filter_solution (bool): Defaults to ``True``.
            * sort_solution (bool): Defaults to ``True``.

        Returns:
            amplify.Result:
    """

@overload
def sum(array: PolyArray[_Dim], axis: Optional[Literal[None]] = None) -> Poly: ...
@overload
def sum(array: PolyArray[Dim1], axis: Union[int, tuple[int]]) -> Poly: ...
@overload
def sum(array: PolyArray[Dim2], axis: tuple[int, int]) -> Poly: ...
@overload
def sum(array: PolyArray[Dim2], axis: Union[int, tuple[int]]) -> PolyArray[Dim1]: ...
@overload
def sum(array: PolyArray[Dim3], axis: tuple[int, int, int]) -> Poly: ...
@overload
def sum(array: PolyArray[Dim3], axis: tuple[int, int]) -> PolyArray[Dim1]: ...
@overload
def sum(array: PolyArray[Dim3], axis: Union[int, tuple[int]]) -> PolyArray[Dim2]: ...
@overload
def sum(array: PolyArray[Dim4], axis: tuple[int, int, int, int]) -> Poly: ...
@overload
def sum(array: PolyArray[Dim4], axis: tuple[int, int, int]) -> PolyArray[Dim1]: ...
@overload
def sum(array: PolyArray[Dim4], axis: tuple[int, int]) -> PolyArray[Dim2]: ...
@overload
def sum(array: PolyArray[Dim4], axis: Union[int, tuple[int]]) -> PolyArray[Dim3]: ...
@overload
def sum(array: PolyArray[_Dim], axis: tuple[()]) -> PolyArray[_Dim]: ...
@overload
def sum(array: PolyArray[Dim], axis: Union[int, tuple[int, ...]]) -> Union[Poly, PolyArray[Dim]]: ...
@overload
def sum(arg: Union[Sequence[Union[Poly, float]], Iterator[Union[Poly, float]]]) -> Poly: ...
@overload
def sum(
    arg: Union[Sequence[Union[Constraint, ConstraintList]], Iterator[Union[Constraint, ConstraintList]]],
) -> ConstraintList: ...
@overload
def sum(stop: int, func: Callable[[int], Poly]) -> Poly: ...
@overload
def sum(start: int, stop: int, func: Callable[[int], Poly]) -> Poly: ...
@overload
def sum(start: int, stop: int, step: int, func: Callable[[int], Poly]) -> Poly: ...
@overload
def sum(sequence: Sequence[object], func: Callable[[object], Poly]) -> Poly: ...
@overload
def sum(iterable: Iterable[object], func: Callable[[object], Poly]) -> Poly: ...
@overload
def sum(iterator: Iterator[object], func: Callable[[object], Poly]) -> Poly: ...
@overload
def sum(iterable: Iterable, /, start: object = 0) -> Any:
    """sum

    .. admonition:: Overload 1.

        Args:
            * array (amplify.PolyArray[_Dim])
            * axis (typing.Optional[typing.Literal[None]]): Defaults to ``None``.

        Returns:
            amplify.Poly:

    .. admonition:: Overload 2.

        Args:
            * array (amplify.PolyArray[Dim1])
            * axis (typing.Union[int, tuple[int]])

        Returns:
            amplify.Poly:

    .. admonition:: Overload 3.

        Args:
            * array (amplify.PolyArray[Dim2])
            * axis (tuple[int, int])

        Returns:
            amplify.Poly:

    .. admonition:: Overload 4.

        Args:
            * array (amplify.PolyArray[Dim2])
            * axis (typing.Union[int, tuple[int]])

        Returns:
            amplify.PolyArray[Dim1]:

    .. admonition:: Overload 5.

        Args:
            * array (amplify.PolyArray[Dim3])
            * axis (tuple[int, int, int])

        Returns:
            amplify.Poly:

    .. admonition:: Overload 6.

        Args:
            * array (amplify.PolyArray[Dim3])
            * axis (tuple[int, int])

        Returns:
            amplify.PolyArray[Dim1]:

    .. admonition:: Overload 7.

        Args:
            * array (amplify.PolyArray[Dim3])
            * axis (typing.Union[int, tuple[int]])

        Returns:
            amplify.PolyArray[Dim2]:

    .. admonition:: Overload 8.

        Args:
            * array (amplify.PolyArray[Dim4])
            * axis (tuple[int, int, int, int])

        Returns:
            amplify.Poly:

    .. admonition:: Overload 9.

        Args:
            * array (amplify.PolyArray[Dim4])
            * axis (tuple[int, int, int])

        Returns:
            amplify.PolyArray[Dim1]:

    .. admonition:: Overload 10.

        Args:
            * array (amplify.PolyArray[Dim4])
            * axis (tuple[int, int])

        Returns:
            amplify.PolyArray[Dim2]:

    .. admonition:: Overload 11.

        Args:
            * array (amplify.PolyArray[Dim4])
            * axis (typing.Union[int, tuple[int]])

        Returns:
            amplify.PolyArray[Dim3]:

    .. admonition:: Overload 12.

        Args:
            * array (amplify.PolyArray[_Dim])
            * axis (tuple[()])

        Returns:
            amplify.PolyArray[_Dim]:

    .. admonition:: Overload 13.

        Args:
            * array (amplify.PolyArray[Dim])
            * axis (typing.Union[int, tuple[int, ...]])

        Returns:
            typing.Union[amplify.Poly, amplify.PolyArray[Dim]]:

    .. admonition:: Overload 14.

        Args:
            * arg (collections.abc.Sequence[Union[amplify.Poly, float]] | collections.abc.Iterator[Union[amplify.Poly, float]])

        Returns:
            amplify.Poly:

    .. admonition:: Overload 15.

        Args:
            * arg (collections.abc.Sequence[Union[amplify.Constraint, amplify.ConstraintList]] | collections.abc.Iterator[Union[amplify.Constraint, amplify.ConstraintList]])

        Returns:
            amplify.ConstraintList:

    .. admonition:: Overload 16.

        Args:
            * stop (int)
            * func (collections.abc.Callable[[int], amplify.Poly])

        Returns:
            amplify.Poly:

    .. admonition:: Overload 17.

        Args:
            * start (int)
            * stop (int)
            * func (collections.abc.Callable[[int], amplify.Poly])

        Returns:
            amplify.Poly:

    .. admonition:: Overload 18.

        Args:
            * start (int)
            * stop (int)
            * step (int)
            * func (collections.abc.Callable[[int], amplify.Poly])

        Returns:
            amplify.Poly:

    .. admonition:: Overload 19.

        Args:
            * sequence (collections.abc.Sequence[object])
            * func (collections.abc.Callable[[object], amplify.Poly])

        Returns:
            amplify.Poly:

    .. admonition:: Overload 20.

        Args:
            * iterable (collections.abc.Iterable[object])
            * func (collections.abc.Callable[[object], amplify.Poly])

        Returns:
            amplify.Poly:

    .. admonition:: Overload 21.

        Args:
            * iterator (collections.abc.Iterator[object])
            * func (collections.abc.Callable[[object], amplify.Poly])

        Returns:
            amplify.Poly:

    .. admonition:: Overload 22.

        Args:
            * iterable (Iterable)
            * start (object): Defaults to ``0``.

        Returns:
            typing.Any:
    """

def to_edges(poly: Poly) -> list[tuple[int, int]]:
    """to_edges

    Args:
        poly (amplify.Poly)

    Returns:
        list[tuple[int, int]]:
    """

__version__: str
