# Generated by Django 4.2.13 on 2024-06-04 18:00

import django.contrib.postgres.fields
import django.db.models.deletion
import localized_fields.fields.char_field
import localized_fields.fields.file_field
import localized_fields.fields.text_field
import localized_fields.mixins
from django.db import migrations, models

import headless_cms.fields.url_field


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ("contenttypes", "0002_remove_content_type_name"),
        ("reversion", "0002_add_index_on_version_for_content_type_and_db"),
    ]

    operations = [
        migrations.CreateModel(
            name="AWAction",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "variant",
                    models.CharField(
                        choices=[
                            ("primary", "Primary"),
                            ("secondary", "Secondary"),
                            ("tertiary", "Tertiary"),
                            ("link", "Link"),
                        ],
                        default="secondary",
                    ),
                ),
                ("target", models.CharField(blank=True, default="")),
                (
                    "text",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "href",
                    headless_cms.fields.url_field.AutoLanguageUrlField(
                        blank=True, default=""
                    ),
                ),
                ("icon", models.CharField(blank=True, default="")),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWBrand",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "subtitle",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "tagline",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("html_id", models.CharField(blank=True, default="")),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWCallToAction",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "subtitle",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "tagline",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWFooter",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "foot_note",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWFooterLink",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, default=dict, null=True, required=[]
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWFooterLinkItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "text",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "href",
                    headless_cms.fields.url_field.AutoLanguageUrlField(
                        blank=True, default=""
                    ),
                ),
                (
                    "aria_label",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("icon", models.CharField(blank=True, default="")),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWHeader",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWHeaderLink",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "text",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "href",
                    headless_cms.fields.url_field.AutoLanguageUrlField(
                        blank=True, default=""
                    ),
                ),
                (
                    "aria_label",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("icon", models.CharField(blank=True, default="")),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWHero",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "subtitle",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "tagline",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("html_id", models.CharField(blank=True, default="")),
                (
                    "content",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWImage",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "src_file",
                    localized_fields.fields.file_field.LocalizedFileField(
                        blank=True, default=dict, null=True, required=[], upload_to=""
                    ),
                ),
                (
                    "src_url",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, default=dict, null=True, required=[]
                    ),
                ),
                (
                    "alt",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWPriceItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "subtitle",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "price",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "period",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("has_ribbon", models.BooleanField(default=False)),
                (
                    "ribbon_title",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "call_to_action",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="price_items",
                        to="astrowind_widgets.awaction",
                    ),
                ),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWPriceItemThrough",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("position", models.PositiveIntegerField(default=0)),
                (
                    "price_item",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awpriceitem",
                    ),
                ),
            ],
            options={
                "ordering": ["position"],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="AWStat",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "subtitle",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "tagline",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("html_id", models.CharField(blank=True, default="")),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWStatItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "amount",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("icon", models.CharField(blank=True, default="")),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWTestimonial",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "subtitle",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "tagline",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("html_id", models.CharField(blank=True, default="")),
                (
                    "call_to_action",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="testimonials",
                        to="astrowind_widgets.awaction",
                    ),
                ),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWTextArea",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(default="message")),
                (
                    "label",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("rows", models.IntegerField(default=4)),
                (
                    "placeholder",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWTestimonialItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "testimonial",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "name",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "job",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("position", models.PositiveIntegerField(default=0)),
                (
                    "image",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="testimonial_items",
                        to="astrowind_widgets.awimage",
                    ),
                ),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
                (
                    "testimonial_group",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="testimonials",
                        to="astrowind_widgets.awtestimonial",
                    ),
                ),
            ],
            options={
                "ordering": ["position"],
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWStep2",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "subtitle",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "tagline",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("html_id", models.CharField(blank=True, default="")),
                ("is_reversed", models.BooleanField(default=False)),
                (
                    "call_to_action",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="step2s",
                        to="astrowind_widgets.awaction",
                    ),
                ),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWStep",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "subtitle",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "tagline",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("html_id", models.CharField(blank=True, default="")),
                ("is_reversed", models.BooleanField(default=False)),
                (
                    "image",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="steps",
                        to="astrowind_widgets.awimage",
                    ),
                ),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWStatItemThrough",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("position", models.PositiveIntegerField(default=0)),
                (
                    "stat",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awstat",
                    ),
                ),
                (
                    "stat_item",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awstatitem",
                    ),
                ),
            ],
            options={
                "ordering": ["position"],
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="awstat",
            name="stats",
            field=models.ManyToManyField(
                blank=True,
                related_name="stat_groups",
                through="astrowind_widgets.AWStatItemThrough",
                to="astrowind_widgets.awstatitem",
            ),
        ),
        migrations.CreateModel(
            name="AWPricing",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "subtitle",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "tagline",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("html_id", models.CharField(blank=True, default="")),
                (
                    "prices",
                    models.ManyToManyField(
                        blank=True,
                        related_name="aw_pricing",
                        through="astrowind_widgets.AWPriceItemThrough",
                        to="astrowind_widgets.awpriceitem",
                    ),
                ),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.AddField(
            model_name="awpriceitemthrough",
            name="pricing",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                to="astrowind_widgets.awpricing",
            ),
        ),
        migrations.CreateModel(
            name="AWItem",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("object_id", models.PositiveIntegerField(blank=True, null=True)),
                ("position", models.PositiveIntegerField(default=0)),
                (
                    "title",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "description",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("icon", models.CharField(blank=True, default="")),
                (
                    "content_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "ordering": ["position"],
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWInput",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("object_id", models.PositiveIntegerField(blank=True, null=True)),
                ("position", models.PositiveIntegerField(default=0)),
                ("type", models.CharField(blank=True, default="text")),
                ("name", models.CharField()),
                (
                    "label",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("autocomplete", models.CharField(blank=True, default="on")),
                (
                    "placeholder",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "content_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "ordering": ["position"],
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWHeroText",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "subtitle",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "tagline",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("html_id", models.CharField(blank=True, default="")),
                (
                    "content",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "call_to_action",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="aw_cta1_hero_texts",
                        to="astrowind_widgets.awaction",
                    ),
                ),
                (
                    "call_to_action2",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="aw_cta2_hero_texts",
                        to="astrowind_widgets.awaction",
                    ),
                ),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWHeroActionThrough",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("position", models.PositiveIntegerField(default=0)),
                (
                    "action",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awaction",
                    ),
                ),
                (
                    "hero",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awhero",
                    ),
                ),
            ],
            options={
                "ordering": ["position"],
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="awhero",
            name="actions",
            field=models.ManyToManyField(
                blank=True,
                related_name="heroes",
                through="astrowind_widgets.AWHeroActionThrough",
                to="astrowind_widgets.awaction",
            ),
        ),
        migrations.AddField(
            model_name="awhero",
            name="image",
            field=models.ForeignKey(
                blank=True,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                related_name="aw_heroes",
                to="astrowind_widgets.awimage",
            ),
        ),
        migrations.AddField(
            model_name="awhero",
            name="published_version",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="reversion.version",
            ),
        ),
        migrations.CreateModel(
            name="AWHeaderLinkThrough",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("position", models.PositiveIntegerField(default=0)),
                (
                    "header",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awheader",
                    ),
                ),
                (
                    "header_link",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awheaderlink",
                    ),
                ),
            ],
            options={
                "ordering": ["position"],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="AWHeaderLinkSelfThrough",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("position", models.PositiveIntegerField(default=0)),
                (
                    "child_link",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="link_children",
                        to="astrowind_widgets.awheaderlink",
                    ),
                ),
                (
                    "parent_link",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="link_parents",
                        to="astrowind_widgets.awheaderlink",
                    ),
                ),
            ],
            options={
                "ordering": ["position"],
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="awheaderlink",
            name="links",
            field=models.ManyToManyField(
                through="astrowind_widgets.AWHeaderLinkSelfThrough",
                to="astrowind_widgets.awheaderlink",
            ),
        ),
        migrations.AddField(
            model_name="awheaderlink",
            name="published_version",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="reversion.version",
            ),
        ),
        migrations.CreateModel(
            name="AWHeaderActionThrough",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("position", models.PositiveIntegerField(default=0)),
                (
                    "action",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awaction",
                    ),
                ),
                (
                    "header",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awheader",
                    ),
                ),
            ],
            options={
                "ordering": ["position"],
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="awheader",
            name="actions",
            field=models.ManyToManyField(
                blank=True,
                related_name="actions_headers",
                through="astrowind_widgets.AWHeaderActionThrough",
                to="astrowind_widgets.awaction",
            ),
        ),
        migrations.AddField(
            model_name="awheader",
            name="links",
            field=models.ManyToManyField(
                blank=True,
                related_name="links_headers",
                through="astrowind_widgets.AWHeaderLinkThrough",
                to="astrowind_widgets.awheaderlink",
            ),
        ),
        migrations.AddField(
            model_name="awheader",
            name="published_version",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="reversion.version",
            ),
        ),
        migrations.CreateModel(
            name="AWFooterSocialLinksThrough",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("position", models.PositiveIntegerField(default=0)),
                (
                    "footer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awfooter",
                    ),
                ),
                (
                    "footer_link",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awfooterlink",
                    ),
                ),
            ],
            options={
                "ordering": ["position"],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="AWFooterSecondaryLinksThrough",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("position", models.PositiveIntegerField(default=0)),
                (
                    "footer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awfooter",
                    ),
                ),
                (
                    "footer_link",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awfooterlink",
                    ),
                ),
            ],
            options={
                "ordering": ["position"],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="AWFooterLinkThrough",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("position", models.PositiveIntegerField(default=0)),
                (
                    "footer_link",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awfooterlink",
                    ),
                ),
                (
                    "footer_link_item",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awfooterlinkitem",
                    ),
                ),
            ],
            options={
                "ordering": ["position"],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="AWFooterLinksThrough",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("position", models.PositiveIntegerField(default=0)),
                (
                    "footer",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awfooter",
                    ),
                ),
                (
                    "footer_link",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awfooterlink",
                    ),
                ),
            ],
            options={
                "ordering": ["position"],
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="awfooterlink",
            name="links",
            field=models.ManyToManyField(
                blank=True,
                related_name="links_footers",
                through="astrowind_widgets.AWFooterLinkThrough",
                to="astrowind_widgets.awfooterlinkitem",
            ),
        ),
        migrations.AddField(
            model_name="awfooterlink",
            name="published_version",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="reversion.version",
            ),
        ),
        migrations.AddField(
            model_name="awfooter",
            name="links",
            field=models.ManyToManyField(
                blank=True,
                related_name="links_footers",
                through="astrowind_widgets.AWFooterLinksThrough",
                to="astrowind_widgets.awfooterlink",
            ),
        ),
        migrations.AddField(
            model_name="awfooter",
            name="published_version",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="reversion.version",
            ),
        ),
        migrations.AddField(
            model_name="awfooter",
            name="secondary_links",
            field=models.ManyToManyField(
                blank=True,
                related_name="secondary_links_footers",
                through="astrowind_widgets.AWFooterSecondaryLinksThrough",
                to="astrowind_widgets.awfooterlink",
            ),
        ),
        migrations.AddField(
            model_name="awfooter",
            name="social_links",
            field=models.ManyToManyField(
                blank=True,
                related_name="social_links_footers",
                through="astrowind_widgets.AWFooterSocialLinksThrough",
                to="astrowind_widgets.awfooterlink",
            ),
        ),
        migrations.CreateModel(
            name="AWFeature3",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "subtitle",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "tagline",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("html_id", models.CharField(blank=True, default="")),
                ("columns", models.IntegerField(default=0)),
                ("default_icon", models.CharField(blank=True, default="")),
                ("is_before_content", models.BooleanField(default=False)),
                ("is_after_content", models.BooleanField(default=False)),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWFeature2",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "subtitle",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "tagline",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("html_id", models.CharField(blank=True, default="")),
                ("default_icon", models.CharField(blank=True, default="")),
                ("columns", models.IntegerField(default=3)),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWFeature",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "subtitle",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "tagline",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("html_id", models.CharField(blank=True, default="")),
                ("default_icon", models.CharField(blank=True, default="")),
                ("columns", models.IntegerField(default=2)),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWFaq",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "subtitle",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "tagline",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("html_id", models.CharField(blank=True, default="")),
                ("columns", models.IntegerField(default=2)),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWDisclaimer",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "label",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWCTAActionThrough",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("position", models.PositiveIntegerField(default=0)),
                (
                    "action",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awaction",
                    ),
                ),
                (
                    "cta",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awcalltoaction",
                    ),
                ),
            ],
            options={
                "ordering": ["position"],
                "abstract": False,
            },
        ),
        migrations.CreateModel(
            name="AWContent",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "subtitle",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "tagline",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("html_id", models.CharField(blank=True, default="")),
                (
                    "content",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("columns", models.IntegerField()),
                ("is_reversed", models.BooleanField(default=False)),
                ("is_after_content", models.BooleanField(default=False)),
                (
                    "call_to_action",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="aw_contents",
                        to="astrowind_widgets.awaction",
                    ),
                ),
                (
                    "image",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="aw_contents",
                        to="astrowind_widgets.awimage",
                    ),
                ),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWContact",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "subtitle",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "tagline",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("html_id", models.CharField(blank=True, default="")),
                (
                    "button",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "description",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "submit_url",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, default=dict, null=True, required=[]
                    ),
                ),
                (
                    "disclaimer",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="astrowind_widgets.awdisclaimer",
                    ),
                ),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
                (
                    "textarea",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="astrowind_widgets.awtextarea",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.AddField(
            model_name="awcalltoaction",
            name="actions",
            field=models.ManyToManyField(
                blank=True,
                related_name="ctas",
                through="astrowind_widgets.AWCTAActionThrough",
                to="astrowind_widgets.awaction",
            ),
        ),
        migrations.AddField(
            model_name="awcalltoaction",
            name="published_version",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="reversion.version",
            ),
        ),
        migrations.CreateModel(
            name="AWBrandImageThrough",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("position", models.PositiveIntegerField(default=0)),
                (
                    "brand",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awbrand",
                    ),
                ),
                (
                    "image",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="astrowind_widgets.awimage",
                    ),
                ),
            ],
            options={
                "ordering": ["position"],
                "abstract": False,
            },
        ),
        migrations.AddField(
            model_name="awbrand",
            name="images",
            field=models.ManyToManyField(
                blank=True,
                related_name="brands",
                through="astrowind_widgets.AWBrandImageThrough",
                to="astrowind_widgets.awimage",
            ),
        ),
        migrations.AddField(
            model_name="awbrand",
            name="published_version",
            field=models.ForeignKey(
                editable=False,
                null=True,
                on_delete=django.db.models.deletion.SET_NULL,
                to="reversion.version",
            ),
        ),
        migrations.CreateModel(
            name="AWBlogLatestPost",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "link_text",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "link_url",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "information",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                ("count", models.IntegerField(default=0)),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
        migrations.CreateModel(
            name="AWBlogHighlightedPost",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "title",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "link_text",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "link_url",
                    localized_fields.fields.char_field.LocalizedCharField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "information",
                    localized_fields.fields.text_field.LocalizedTextField(
                        blank=True, null=True, required=[]
                    ),
                ),
                (
                    "post_ids",
                    django.contrib.postgres.fields.ArrayField(
                        base_field=models.IntegerField(),
                        blank=True,
                        default=list,
                        size=None,
                    ),
                ),
                (
                    "published_version",
                    models.ForeignKey(
                        editable=False,
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        to="reversion.version",
                    ),
                ),
            ],
            options={
                "abstract": False,
            },
            bases=(localized_fields.mixins.AtomicSlugRetryMixin, models.Model),
        ),
    ]
