---
description: Create new Claude Code agents following empirical principles and selection optimization.
argument-hint: [agent-name]
allowed-tools: Task, Write, Read, Glob
---

# Agent Creation

Create new Claude Code agents following empirical principles, selection optimization, and multi-agent coordination patterns.

## Instructions

1. If $ARGUMENTS contains agent name, use it; otherwise prompt for agent name

2. Execute enhanced parallel validation clusters
- **Validates agent necessity** using enhanced decision framework with researcher + critic + principles validation
- **Checks for redundancy** with existing 16 agents using patterns + code-cleaner + context analysis
- **Guides agent specification** with proven description patterns validated by critic + principles agents
- **Generates optimized descriptions** with Tier 1 selection keywords validated by researcher + patterns agents
- **Designs multi-agent coordination** patterns using options-analyzer + constraint-solver + conflicts for sophisticated workflow integration
- **Creates agent file** with proper frontmatter validated by code-cleaner + principles + stack-advisor agents

## Current Agent Ecosystem (16 agents)

### Foundation Agents (6 total)
- **patterns**, **researcher**, **context**, **principles**, **critic**, **conflicts**

### Specialist Agents (10 total)
- **code-cleaner**, **constraint-solver**, **git-workflow**, **meta-programmer**, **options-analyzer**, **performance-optimizer**, **prompt-engineer**, **stack-advisor**, **test-strategist**, **github-issues-workflow**

## Enhanced Agent Creation Workflow

### Phase 1: Enhanced Necessity Validation
**Parallel Validation Clusters:**
- **Core Validation Cluster** (researcher + patterns + critic): Research similar agents, identify patterns, critically assess necessity
- **Boundary Analysis Cluster** (options-analyzer + constraint-solver): Define clear boundaries, identify limitations, ensure constraint handling
- **Redundancy Assessment Cluster** (patterns + code-cleaner + context): Check ecosystem overlap, identify gaps, understand system context
- **Principle Compliance Cluster** (principles + critic): Validate design principles, check fundamental soundness, critical review

1. **Computational thinking pattern identification**: Define using patterns + researcher + critic validation
2. **Complexity justification**: Verify using code-cleaner + patterns + constraint-solver analysis
3. **Boundary analysis**: Confirm using options-analyzer + constraint-solver + principles validation
4. **Reuse assessment**: Check using context + patterns + researcher analysis
5. **Redundancy check**: Compare using patterns + code-cleaner + context against all 16 existing agents
6. **Human role avoidance**: Ensure focus using principles + critic validation

### Phase 2: Enhanced Multi-Agent Integration Design
**Parallel Integration Design Clusters:**
- **Coordination Strategy Cluster** (options-analyzer + conflicts): Generate coordination alternatives, resolve conflicts
- **Workflow Pattern Cluster** (patterns + context): Identify workflow patterns, understand system context
- **Validation Design Cluster** (critic + test-strategist + code-cleaner): Design validation approaches, test integration patterns, ensure completeness
- **Quality Assurance Cluster** (principles + constraint-solver + critic): Apply quality principles, ensure design integrity, critical assessment

1. **Coordination requirements**: Define using explorer + resolver + critic with parallel analysis
2. **Workflow patterns**: Design using patterns + time + context with historical validation
3. **Cross-validation**: Plan using critic + testing + completer with comprehensive validation
4. **Quality assurance**: Define using principles + invariants + critic with systematic quality checks

### Phase 3: Enhanced Description Optimization
**Parallel Optimization Clusters:**
- **Template Compliance Cluster** (completer + principles + docs): Ensure template compliance, apply formatting principles, documentation standards
- **Keyword Optimization Cluster** (researcher + patterns + critic): Research effective keywords, identify keyword patterns, critically assess selection probability
- **Trigger Specification Cluster** (context + patterns + researcher): Understand context triggers, analyze trigger patterns, researcher user language
- **Capability Definition Cluster** (explorer + constraints + invariants): Define capability boundaries, identify limitations, ensure clear interfaces

1. **Mandatory template compliance**: Follow using completer + principles + docs validation
2. **Tier 1 keyword integration**: Include using researcher + patterns + critic optimization
3. **Trigger specification**: Add using context + patterns + researcher analysis
4. **Expert statement**: Define using explorer + constraints + invariants boundary definition
5. **Selection testing**: Validate using critic + researcher + patterns against selection algorithm

### Phase 4: Enhanced Agent Generation
**Parallel Generation Clusters:**
- **File Creation Cluster** (completer + docs + principles): Create complete agent files, ensure documentation standards, apply principles
- **Content Generation Cluster** (generator + patterns + researcher): Generate agent content, follow proven patterns, researcher best practices
- **Integration Implementation Cluster** (connector + resolver + invariants): Implement integrations, resolve conflicts, ensure type-safe interfaces
- **Validation & Documentation Cluster** (critic + docs + testing): Validate implementation, document thoroughly, test coordination

1. **Create agent file** using completer + docs + principles with comprehensive validation
2. **Generate YAML frontmatter** using generator + patterns + researcher with optimization
3. **Add agent body** using patterns + researcher + critic following gold standard templates
4. **Implement coordination protocols** using connector + resolver + invariants with systematic integration
5. **Document workflow patterns** using docs + patterns + time in `.support/workflows/` with historical context
6. **Document justification** using docs + critic + completer for comprehensive future audit support

## Mandatory Description Template

**All new agents MUST follow this exact template:**

```yaml
---
name: [descriptive-name]
description: "[TIER1_KEYWORD] when [specific_user_context] or [quoted_user_phrases]. Expert at [specific_capability_statement]."
---
```

**Template Components:**
- **[TIER1_KEYWORD]**: MUST USE | PROACTIVELY use | ALWAYS use | MUST USE AUTOMATICALLY
- **[specific_user_context]**: When user does/asks/mentions X
- **[quoted_user_phrases]**: 'exact user language', 'common phrases', 'trigger words'
- **Expert at [specific_capability_statement]**: Clear capability boundary

## Decision Checklist

Before creating an agent, verify ALL criteria against current ecosystem:

### Core Principles Compliance
- [ ] **Single thinking pattern**: Represents one coherent computational thinking pattern
- [ ] **Complexity justification**: Task generates >50 lines of intermediate output in main context
- [ ] **Tool complexity**: Process involves >3 tool calls with state management
- [ ] **Reusability**: Same analysis pattern needed in >3 different contexts
- [ ] **Specialization value**: Requires specialized prompting strategy not suitable for main context

### Boundary Requirements
- [ ] **Clear input/output**: Can be defined as specific parameters
- [ ] **Structured output**: Actionable results without clarification
- [ ] **Self-contained**: Process doesn't require mid-execution guidance from main context
- [ ] **Context isolation**: Eliminates pollution of main context

### Ecosystem Integration
- [ ] **No redundancy**: No existing agent among 27 covers this capability
- [ ] **Coordination design**: Plans for multi-agent integration patterns
- [ ] **Workflow contribution**: Enables new or improved multi-agent workflows
- [ ] **Human role avoidance**: Not mirroring organizational positions or social dynamics

### Quality Standards
- [ ] **Template compliance**: Follows mandatory description template exactly
- [ ] **Tier 1 keywords**: Includes MUST USE/PROACTIVELY selection optimization
- [ ] **Expert boundaries**: Clear "Expert at" capability statement
- [ ] **Trigger specificity**: Quoted user phrases for algorithm matching

## Selection Priority Keywords

**Tier 1 (Highest selection probability):**
- `MUST USE` (for critical workflow agents)
- `PROACTIVELY` (for agents that should activate automatically)
- `ALWAYS use` (for universal defaults)
- `MUST USE AUTOMATICALLY` (for system-triggered agents)

**Tier 2 (High priority):**
- `Expert at`
- `specialized in`
- `designed for`
- `Use when`

**Context Matching Examples (Proven Effective):**
- `'security review'`, `'vulnerability check'` (vulnerability-scanner)
- `'performance issues'`, `'slow code'` (performance)
- `'test strategy'`, `'test coverage'` (testing)
- `'threat model'`, `'attack surface'` (threat-modeling)
- `'is this SOLID'`, `'best practices'` (principles)

## Multi-Agent Coordination Patterns

### Mandatory Integration Examples
**Security agents demonstrate advanced coordination:**
```
vulnerability-scanner MUST coordinate with:
→ researcher (CVE intelligence)
→ patterns (security anti-patterns)
→ critic (risk validation)
```

### Workflow Integration
**Design agents to enable sophisticated multi-agent workflows:**
- **Security Assessment**: vulnerability-scanner → researcher → patterns → threat-modeling → critic
- **Performance Optimization**: performance → patterns → hypothesis → constraints → critic
- **Quality Assurance**: testing → security → performance → completer

## Gold Standard Templates

**Use these agents as templates for new development:**
- **performance.md**: 261 lines, perfect algorithmic analysis structure
- **testing.md**: 308 lines, comprehensive systematic methodology
- **vulnerability-scanner.md**: Excellent multi-agent coordination patterns
- **threat-modeling.md**: Outstanding architectural analysis framework

## Related Commands
- `/agents-audit` - Review existing agents against principles
- `/agents-guide` - Documentation on using existing 26 agents

## Reference Documentation
- @templates/guidelines/claude-agents-guidelines.md - Complete creation principles
- @.support/workflows/security-workflows.md - Multi-agent coordination examples
- @templates/guidelines/stack-mapping.md - Technology detection patterns

## Success Metrics

**New agents should achieve:**
- **Description Quality**: 5/5 stars with perfect template compliance
- **Selection Optimization**: Algorithm-friendly with quoted user triggers
- **Boundary Clarity**: Self-contained with structured outputs
- **Overhead Justification**: Clear >50 line context reduction
- **Integration Readiness**: Designed for multi-agent coordination

**Current ecosystem averages: 4.4/5.0 stars across 27 agents**