---
description: Comprehensive guide for effectively using all specialized AI agents in the current ecosystem.
argument-hint: Optional agent name to get specific guidance for.
allowed-tools: Task, Read, Glob
---

# Agent Usage Guide

Comprehensive guide for effectively using all specialized AI agents in the current ecosystem with multi-agent coordination patterns.

## Instructions

1. Parse $ARGUMENTS for guide parameters:
   - --agent [agent-name] (show specific agent usage)
   - --workflow [workflow-type] (show specific workflow patterns)
   - --examples (include usage examples)

2. Provide comprehensive agent ecosystem overview and usage patterns

## Current Agent Ecosystem (16 agents)

### Foundation Agents (6 total)
- **patterns**: Identify code patterns and anti-patterns at scale
- **researcher**: Parallel web researcher with latest information
- **context**: Deep system understanding across entire codebases
- **principles**: Apply fundamental software engineering principles
- **critic**: Risk analysis and constructive challenge of proposals
- **conflicts**: Navigate conflicts between competing approaches

### Specialist Agents (10 total)
- **code-cleaner**: Code style improvements and micro-optimizations
- **constraint-solver**: Navigate complex multi-dimensional limitations and design type-safe systems
- **git-workflow**: Autonomous git release management and systematic error resolution
- **meta-programmer**: Create code generators and domain-specific languages
- **options-analyzer**: Generate and evaluate multiple solution alternatives
- **performance-optimizer**: Algorithmic complexity analysis and optimization strategies
- **prompt-engineer**: AI agent prompt creation for user projects
- **stack-advisor**: Technology-specific guidance for files and architecture decisions
- **test-strategist**: Comprehensive test strategy development and coverage analysis
- **github-issues-workflow**: Specialized GitHub Issues management and planning (context-clean)

## Enhanced Multi-Agent Coordination Patterns

### Enhanced Security Assessment Workflow
**Trigger**: User mentions security review, vulnerabilities, compliance
**Enhanced Parallel Clusters** (CLAUDE.md compliant 3+ agents):
- **Primary Analysis**: patterns + principles + critic (3 agents)
- **Context & Research**: context + researcher + constraint-solver (3 agents)
- **Implementation Validation**: test-strategist + principles + stack-advisor (3 agents)

### Enhanced Performance Optimization Workflow  
**Trigger**: User reports performance issues, slow code, optimization needs
**Enhanced Parallel Clusters** (CLAUDE.md compliant 3+ agents):
- **Performance Analysis**: performance-optimizer + patterns + critic + constraint-solver (4 agents)
- **Architecture Quality**: principles + context + stack-advisor + conflicts (4 agents)
- **Implementation Excellence**: code-cleaner + patterns + test-strategist + principles (4 agents)
- **Validation**: options-analyzer + conflicts + test-strategist + critic (4 agents)

### Enhanced Architecture Design Workflow
**Trigger**: User asks about system design, architecture decisions
**Enhanced Parallel Clusters** (CLAUDE.md compliant 3+ agents):
- **Alternative Generation**: options-analyzer + constraint-solver + patterns + researcher (4 agents)
- **Critical Evaluation**: critic + principles + test-strategist + constraint-solver (4 agents)
- **Resolution Framework**: conflicts + principles + constraint-solver + context (4 agents)
- **Documentation**: stack-advisor + principles + context + code-cleaner (4 agents)

### Enhanced Quality Assurance Workflow
**Trigger**: User requests code review, quality improvement
**Enhanced Parallel Clusters** (CLAUDE.md compliant 3+ agents):
- **Pattern & Quality**: patterns + principles + code-cleaner + critic (4 agents)
- **Context & Research**: researcher + context + stack-advisor + patterns (4 agents)
- **Performance & Architecture**: performance-optimizer + constraint-solver + principles + critic (4 agents)
- **Testing & Validation**: test-strategist + patterns + critic + constraint-solver (4 agents)

### Enhanced Debugging Investigation Workflow
**Trigger**: Strange behavior, unexpected results, "why does this happen"
**Enhanced Parallel Clusters** (CLAUDE.md compliant 3+ agents):
- **Evidence Analysis**: researcher + context + patterns + options-analyzer (4 agents)
- **Critical Evaluation**: critic + principles + test-strategist + constraint-solver (4 agents)
- **Resolution Framework**: conflicts + principles + constraint-solver + context (4 agents)
- **Performance Impact**: performance-optimizer + constraint-solver + critic + patterns (4 agents)

## Agent Selection by Task Type

### Understanding Systems (CLAUDE.md compliant 3+ agents)
- **How does X work?** → context + patterns + researcher (3 agents)
- **Historical evolution** → context + patterns + researcher (3 agents)
- **Architecture flow** → context + options-analyzer + principles (3 agents)

### Finding Problems (CLAUDE.md compliant 3+ agents)
- **Performance bottlenecks** → performance-optimizer + patterns + critic (3 agents)
- **Code quality** → patterns + principles + critic (3 agents)
- **Test gaps** → test-strategist + patterns + critic (3 agents)
- **Architecture issues** → context + principles + stack-advisor (3 agents)

### Making Decisions (CLAUDE.md compliant 3+ agents)
- **Choose approach** → options-analyzer + constraint-solver + conflicts (3 agents)
- **Architecture design** → stack-advisor + options-analyzer + principles (3 agents)
- **Trade-off analysis** → constraint-solver + conflicts + critic (3 agents)

### Implementation Tasks (CLAUDE.md compliant 3+ agents)
- **Complete features** → code-cleaner + patterns + test-strategist (3 agents)
- **Refactor code** → patterns + principles + code-cleaner (3 agents)
- **Optimize performance** → performance-optimizer + patterns + constraint-solver (3 agents)
- **Architecture decisions** → context + principles + stack-advisor (3 agents)

## Proactive Agent Usage Protocol

**Claude Code automatically invokes enhanced multiple agent clusters based on context with universal agent integration. Users don't need to explicitly request agents - the system now provides comprehensive parallel analysis with researcher, critic, and principles agents integrated across all commands.**

### Automatic Agent Combinations (CLAUDE.md compliant 3+ agents)
- **"This code looks messy"** → patterns + code-cleaner + critic (3 agents)
- **"How should I structure this?"** → stack-advisor + options-analyzer + principles (3 agents)
- **Error messages shown** → researcher + options-analyzer + patterns (3 agents)
- **"Why is this slow?"** → performance-optimizer + patterns + critic (3 agents)

### Enhanced Advanced Multi-Agent Workflows

**Enhanced Security specialists demonstrate sophisticated coordination:**
- **Primary Security Analysis Cluster**: vulnerability-scanner + threat-modeling + compliance-checker + researcher (comprehensive security analysis with intelligence validation)
- **Threat Intelligence Cluster**: researcher + patterns + hypothesis + context + time (CVE intelligence, pattern recognition, threat modeling, system understanding, historical analysis)
- **Risk Assessment Cluster**: critic + completer + performance + time + resolver (risk validation, completeness assessment, performance impact, historical analysis, conflict resolution)

**Enhanced Performance analysis follows systematic patterns:**
- **Performance Analysis Cluster**: performance + hypothesis + patterns + critic + constraints (performance bottlenecks, optimization theories, pattern recognition, critical assessment, resource limitations)
- **Architecture Quality Cluster**: principles + invariants + axioms + completer + resolver (design principles, integrity validation, fundamental soundness, completeness assessment, conflict resolution)

**Enhanced Testing strategy employs comprehensive coordination:**
- **Coverage Analysis Cluster**: patterns + completer + whisper + critic + researcher (test patterns, coverage gaps, micro-improvements, critical assessment, researcher validation)
- **Security Testing Cluster**: vulnerability-scanner + threat-modeling + compliance-checker + researcher + patterns (security testing with comprehensive threat analysis)
- **Performance Testing Cluster**: performance + constraints + hypothesis + time + axioms (performance testing with resource analysis and fundamental principles)

## Gold Standard Agents (Excellence Examples)

**5-Star Rated Agents for Reference:**
- **performance.md**: 261 lines of algorithmic analysis perfection
- **testing.md**: 308 lines of systematic testing methodology
- **vulnerability-scanner.md**: Exemplary security pattern matching
- **threat-modeling.md**: Outstanding architectural security analysis
- **compliance-checker.md**: Comprehensive regulatory framework coverage

**Ecosystem Health: Current 16 agents (6 foundation + 10 specialist) following CLAUDE.md parallel execution protocols**

## Related Commands
- `/agents-audit` - Comprehensive ecosystem health analysis
- `/agents-create` - Create new agents following proven principles