---
description: Comprehensive multi-perspective analysis of ideas and proposals for decision support.
argument-hint: Topic or idea to analyze and discuss.
allowed-tools: Task, Read, Grep, WebSearch
---

# Discussion and Analysis

Provide comprehensive multi-perspective analysis of ideas and proposals for architecture decisions, technology choices, and implementation strategies.

## Instructions

1. Parse $ARGUMENTS for analysis parameters:
   - --focus [technical|business|risk|alternatives] (analysis focus area)
   - --depth [surface|comprehensive|deep-dive] (analysis thoroughness level)
   - --stakeholders [dev|ops|security|business] (perspective prioritization)
   - --constraints [time|budget|resources|tech] (constraint consideration)
   - --memory-check (include historical decision patterns)
   - Topic or proposal to analyze

2. Execute enhanced parallel analysis clusters
1. coordinate enhanced parallel analysis clusters for comprehensive evaluation with universal agent integration:
   - **Alternative Generation Cluster**: options-analyzer + constraint-solver + patterns + researcher (generate alternatives, identify limitations, recognize patterns, researcher validation)
   - **Evidence Analysis Cluster**: researcher + options-analyzer + context (evidence-based researcher, scenario modeling, system understanding)
   - **Critical Evaluation Cluster**: critic + principles + constraint-solver + code-cleaner (critical evaluation, best practices validation, design integrity, completeness assessment)
   - **Resolution Framework Cluster**: conflicts + principles + constraint-solver (conflict resolution, fundamental principles, design principles)
   - **Performance Impact Cluster**: performance-optimizer + constraint-solver + options-analyzer + critic (performance implications, resource limitations, optimization theories, critical assessment)
2. synthesize findings into balanced decision framework with multi-agent validated risk-benefit analysis
3. provide structured recommendations with implementation considerations validated by code-cleaner + stack-advisor + test-strategist agents

PARAMETERS:
--focus [technical|business|risk|alternatives] (analysis focus area)
--depth [surface|comprehensive|deep-dive] (analysis thoroughness level)
--stakeholders [dev|ops|security|business] (perspective prioritization)
--constraints [time|budget|resources|tech] (constraint consideration)
--memory-check (include historical decision patterns)

ENHANCED_AGENT_CLUSTERS:
Alternative Generation: options-analyzer + constraint-solver + patterns + researcher + stack-advisor
Evidence Analysis: researcher + options-analyzer + context + patterns
Critical Evaluation: critic + principles + constraint-solver + code-cleaner + test-strategist
Resolution Framework: conflicts + principles + constraint-solver
Performance Impact: performance-optimizer + constraint-solver + options-analyzer + critic
Documentation & Implementation: stack-advisor + code-cleaner + test-strategist
Coordination: All enhanced clusters execute in parallel for comprehensive multi-dimensional analysis

ENHANCED_OUTPUT:
- Multi-perspective analysis from enhanced specialized agent clusters with universal agent validation
- Alternative approaches with trade-off comparison researched by researcher + patterns + options-analyzer agents
- Evidence-based risk assessment with confidence levels validated by critic + principles + options-analyzer agents
- Structured decision framework with clear recommendations approved by conflicts + code-cleaner + stack-advisor agents
- Implementation considerations and potential obstacles analyzed by constraint-solver + test-strategist + performance-optimizer agents
- Memory-informed insights from similar historical decisions enhanced by context + researcher agents
- Comprehensive feasibility assessment validated by code-cleaner + constraint-solver + test-strategist agents

## Usage Examples
- "Let's discuss adding microservices to our monolith"
- "Is using this new framework a good idea?"
- "What about rewriting this in Rust?"
- "Should we implement our own authentication?"
- "I'm thinking of adding blockchain to our app"

## Analysis Framework

**Enhanced Multi-Cluster Coordination** ensures comprehensive coverage with universal agent integration:
- **Alternative Generation**: options-analyzer identifies options, constraint-solver maps limitations, patterns recognizes similarities, researcher validates alternatives
- **Evidence Analysis**: researcher provides data, options-analyzer models scenarios, context adds system understanding
- **Critical Evaluation**: critic challenges assumptions, principles validates approaches, constraint-solver ensures design integrity, code-cleaner identifies gaps
- **Resolution**: conflicts synthesizes findings, principles grounds in fundamentals and ensures sound approach
- **Performance Impact**: performance-optimizer analyzes implications, constraint-solver identifies limitations, options-analyzer tests scenarios, critic validates assessments

**Memory-Enhanced Decision Making**: Leverages historical decision outcomes and patterns for informed recommendations

## Memory Integration

**Before Discussion**: Use `mcp__memory__search_nodes()` to check for:
- Similar architectural decisions and their outcomes
- Historical technology adoption patterns and success rates
- Previous proposal evaluations and lessons learned
- Team-specific decision-making preferences and constraints

**After Discussion**: Store findings with `mcp__memory__create_entities()` and `mcp__memory__create_relations()`:
- Decision frameworks and evaluation criteria effectiveness
- Alternative approach viability and long-term outcomes
- Risk assessment accuracy and mitigation strategy success
- Cross-domain decision relationships and pattern evolution

## Related Commands

- `/review` - Code-focused analysis with quality and security perspectives
- `/refactor` - Implementation-focused improvement with systematic approaches
- `/agents-audit` - Meta-analysis of decision-making process effectiveness
- Use options-analyzer agent for alternative generation, conflicts for conflict resolution