---
description: Comprehensive documentation synchronization with code changes.
argument-hint: Optional scope or FILES to update documentation for.
allowed-tools: Task, Read, Edit, Write, MultiEdit, Bash
---

# Documentation Update

Comprehensive documentation synchronization with code changes for all project documentation including README, CHANGELOG, API docs, and guides.

## Instructions

1. Parse $ARGUMENTS for documentation update parameters:
   - --scope [api|readme|changelog|all] (documentation scope, default: all)
   - --changes-since [commit|tag|date] (analyze changes since specific point)
   - --validate-examples (test all code examples for accuracy)
   - --dry-run (show what would be updated without making changes)
   - --priority [critical|high|medium|low] (filter updates by priority)

2. Execute enhanced parallel documentation analysis clusters
1. invoke stack-advisor agent: systematic documentation analysis with enhanced universal agent coordination
2. coordinate enhanced parallel documentation analysis clusters:
   - **Gap Analysis Cluster**: patterns + code-cleaner + critic (identify gaps, inconsistencies, micro-improvements, critical assessment)
   - **Historical Intelligence Cluster**: researcher + context + patterns (documentation evolution, historical patterns, system understanding, pattern recognition)
   - **Standards Compliance Cluster**: stack-advisor + constraint-solver + principles (project standards, limitations, design principles, integrity validation)
   - **Accuracy Validation Cluster**: critic + test-strategist + performance-optimizer + code-cleaner (validate accuracy, test examples, performance impact, completeness assessment)
   - **Implementation Coordination Cluster**: conflicts + principles + stack-advisor (conflict resolution, fundamental principles, documentation synthesis)
3. generate comprehensive documentation update plan with priority mapping validated by conflicts + critic + principles agents
4. implement updates with cross-reference validation and consistency checking coordinated by code-cleaner + constraint-solver + test-strategist agents

PARAMETERS:
--scope [api|readme|changelog|all] (documentation scope, default: all)
--changes-since [commit|tag|date] (analyze changes since specific point)
--validate-examples (test all code examples for accuracy)
--dry-run (show what would be updated without making changes)
--priority [critical|high|medium|low] (filter updates by priority)

ENHANCED_AGENT_CLUSTERS:
Primary Documentation: stack-advisor (comprehensive documentation strategy with universal agent coordination)
Gap Analysis: patterns + code-cleaner + critic + researcher
Historical Intelligence: researcher + context + patterns + principles
Standards Compliance: stack-advisor + constraint-solver + principles + code-cleaner
Accuracy Validation: critic + test-strategist + performance-optimizer + code-cleaner + principles
Implementation Coordination: conflicts + principles + stack-advisor + constraint-solver
Synthesis & Quality: critic + principles + code-cleaner + stack-advisor
Coordination: All enhanced clusters support stack-advisor agent leadership with comprehensive universal integration

OUTPUT:
- Comprehensive documentation audit with gap identification
- Prioritized update plan with change impact analysis
- Cross-referenced documentation updates ensuring consistency
- Validation report for all code examples and technical accuracy
- Integration with git workflow for synchronized commits

## Documentation Analysis Framework

**Enhanced Multi-Dimensional Documentation Assessment**:
- **Content Accuracy**: Code example validation and technical correctness verified by testing + critic + principles agents
- **Completeness**: Gap identification and coverage analysis conducted by completer + patterns + researcher agents
- **Consistency**: Cross-document reference validation and style compliance ensured by invariants + guidelines-repo + principles agents
- **Usability**: User journey analysis and accessibility assessment performed by context + explorer + critic agents
- **Maintenance**: Historical update patterns and sustainability analysis conducted by time + researcher + constraints agents
- **Implementation Quality**: Technical implementation validation by performance + testing + invariants agents
- **Strategic Alignment**: Documentation strategy validation by resolver + axioms + principles agents

**Enhanced Memory-Coordinated Documentation**: Leverages historical documentation effectiveness and user feedback patterns through time + researcher + context + patterns agents with validation by critic + principles + resolver agents for comprehensive, evidence-based documentation strategy

## Memory Integration

**Before Documentation Update**: Use `mcp__memory__search_nodes()` to check for:
- Previous documentation update patterns and effectiveness
- Historical user feedback and documentation pain points
- Successful documentation structures and content strategies
- Cross-project documentation best practices and lessons learned

**After Documentation Update**: Store findings with `mcp__memory__create_entities()` and `mcp__memory__create_relations()`:
- Documentation update effectiveness and user engagement metrics
- Content structure evolution and accessibility improvements
- Cross-document relationship patterns and maintenance strategies
- Documentation-code synchronization success rates and automation opportunities

## Focus Areas

- **New features**: README features section + usage examples + API documentation
- **Breaking changes**: CHANGELOG entries + migration guides + compatibility matrices
- **API changes**: Endpoint documentation + parameter updates + response examples
- **Configuration changes**: Setup instructions + environment variables + deployment guides
- **Bug fixes**: CHANGELOG entries + corrected examples + troubleshooting updates
- **Performance improvements**: Documentation of optimizations + benchmark updates
- **Security enhancements**: Security documentation + best practices + compliance updates

## Integration with Development Workflow

**Synchronized with Simple Git Protocol**:
1. Documentation updates committed with related code changes
2. Cross-validation with code examples and technical accuracy
3. Automated consistency checking across all documentation
4. Integration with version management and release documentation

## Related Commands

- `/review` - Include documentation review in comprehensive code analysis
- `/refactor` - Ensure documentation updates accompany code refactoring
- `/version-prepare` - Integrate with release documentation and CHANGELOG generation
- `/agents-audit` - Analyze documentation process effectiveness and agent coordination