---
description: Technology stack analysis and guidance for stack configurations and technology choices.
argument-hint: Optional technology stack to analyze.
allowed-tools: Task, Read, Glob, Grep
---

# Technology Stack Analysis

Comprehensive technology stack configuration analysis and guidance effectiveness for all stack configurations in .support/stacks/ directory and related guidance systems.

## Instructions

1. Automatically determine analysis scope:
   - If $ARGUMENTS contains stack name, focus on that stack
   - If no arguments, analyze all stacks in .support/stacks/
   - Always include usage patterns, effectiveness, and recommendations

2. Execute enhanced parallel stack analysis clusters with universal agent integration
1. coordinate enhanced parallel stack analysis clusters with universal agent integration:
   - **Technology Guidance Cluster**: stack-advisor + constraint-solver + principles (technology guidance analysis, limitations, design principles)
   - **Usage Intelligence Cluster**: patterns + context + researcher (usage patterns, system understanding, researcher validation)
   - **Evolution Research Cluster**: researcher + options-analyzer + principles (ecosystem evolution, technology theories, alternative approaches, fundamental principles)
   - **Validation & Assessment Cluster**: critic + code-cleaner + constraint-solver + performance-optimizer (critical assessment, completeness validation, design integrity, performance implications)
   - **Integration Analysis Cluster**: conflicts + stack-advisor + test-strategist (conflict resolution, documentation, implementation testing)
2. analyze stack configuration completeness and guidance effectiveness through code-cleaner + critic + principles validation
3. provide comprehensive technology guidance overview with usage recommendations validated by conflicts + stack-advisor agents

AUTOMATED ANALYSIS:
- Stack detection and selection based on $ARGUMENTS or comprehensive analysis
- Usage patterns automatically identified and analyzed
- Effectiveness assessment included in all analyses
- Recommendations generated based on findings

ENHANCED_AGENT_CLUSTERS:
Technology Guidance: stack-advisor + constraint-solver + principles + code-cleaner
Usage Intelligence: patterns + context + researcher + principles
Evolution Research: researcher + options-analyzer + principles
Validation & Assessment: critic + code-cleaner + constraint-solver + performance-optimizer + test-strategist
Integration Analysis: conflicts + stack-advisor + test-strategist + principles
Synthesis & Optimization: conflicts + critic + principles + stack-advisor + code-cleaner
Coordination: All enhanced clusters provide comprehensive multi-dimensional stack analysis with universal agent support

OUTPUT:
- Comprehensive stack configuration inventory with capability mapping
- Technology guidance effectiveness analysis and coverage assessment
- Stack usage patterns and selection optimization recommendations
- Technology ecosystem evolution insights and future considerations
- Stack improvement recommendations and gap identification

## Stack Analysis Framework

**Enhanced Multi-Dimensional Stack Assessment**:
- **Coverage Analysis**: Technology support completeness and guidance depth analyzed by completer + patterns + guidelines-repo agents
- **Usage Effectiveness**: Stack selection patterns and guidance utilization validated by patterns + context + researcher agents
- **Evolution Tracking**: Technology ecosystem changes and adaptation requirements researched by researcher + time + hypothesis agents
- **Integration Assessment**: Cross-stack compatibility and workflow integration evaluated by connector + resolver + constraints agents
- **Quality Validation**: Guidance accuracy and best practices alignment verified by critic + principles + invariants agents
- **Performance Impact**: Technology performance implications assessed by performance + constraints + testing agents
- **Strategic Alignment**: Stack strategy validation conducted by axioms + resolver + principles agents

**Enhanced Memory-Coordinated Technology Guidance**: Leverages historical technology adoption patterns and guidance effectiveness through time + researcher + context + patterns agents with strategic validation by resolver + critic + principles agents for comprehensive, evidence-based technology guidance strategy

## Memory Integration

**Before Stack Analysis**: Use `mcp__memory__search_nodes()` to check for:
- Historical technology adoption decisions and outcomes
- Stack guidance effectiveness patterns and user feedback
- Cross-project technology choice patterns and lessons learned
- Technology ecosystem evolution trends and adaptation strategies

**After Stack Analysis**: Store findings with `mcp__memory__create_entities()` and `mcp__memory__create_relations()`:
- Stack guidance effectiveness metrics and improvement opportunities
- Technology adoption pattern evolution and decision frameworks
- Cross-stack relationship patterns and integration strategies
- Technology ecosystem adaptation success rates and optimization approaches

## Stack Configuration Details

For each technology stack, provides comprehensive analysis of:
1. **Stack name and file location** - Complete configuration mapping
2. **Key tools and frameworks covered** - Technology ecosystem coverage assessment
3. **Main guidelines and restrictions** - Guidance effectiveness and limitation analysis
4. **Associated commands and workflows** - Integration pattern effectiveness
5. **Activation and usage optimization** - Selection algorithm effectiveness and usage patterns
6. **Cross-stack relationships** - Technology compatibility and workflow integration
7. **Evolution and maintenance** - Adaptation requirements and sustainability analysis

## Technology Guidance Integration

**Guidelines Agent Coordination**:
- **stack-advisor**: Repository-level technology stack analysis and architecture guidance
- **stack-advisor**: File-level technology-specific guidance and implementation patterns
- **Conditional Activation**: Technology-specific guidance only when patterns are unclear

**Stack Detection Integration**: References @templates/guidelines/stack-mapping.md for centralized technology detection and optimization

## Related Commands

- `/review` - Include technology-specific guidance in comprehensive code analysis
- `/refactor` - Apply stack-specific refactoring patterns and best practices
- `/agents-audit` - Analyze technology guidance agent effectiveness and coordination
- Use stack-advisor agent for technology-specific analysis