#! /usr/bin/env python

##############################################################################
##  pyvolve: Python platform for simulating evolutionary sequences.
##
##  Written by Stephanie J. Spielman (stephanie.spielman@gmail.com) 
##############################################################################

'''
    Test model module.
'''


import unittest
import os
from pyvolve import *
import numpy as np
ZERO    = 1e-8
DECIMAL = 8


class model_custom_tests(unittest.TestCase):
    ''' 
        Tests for a custom Model (user provides rate matrix).
    '''

    def tearDown(self):
        ''' 
            The tearDown here just deletes the custom_matrix_frequencies.txt file generated.
            
        '''
        try:
            os.remove("custom_matrix_frequencies.txt")   
        except:
            pass
            
        
    def test_model_custommatrix_acceptable(self):
        '''
            Test that properly-specified matrix works correctly.
        '''
        custom_codon_matrix = np.array([[-1.349975704555383960e+00, 6.364679535939857247e-02, 1.277097380283088168e-01, 7.919074340016568625e-02, 1.439089117091822689e-01, 0.0, 0.0, 0.0, 3.227081589895426372e-01, 0.0, 0.0, 0.0, 1.471601513268189498e-01, 0.0, 0.0, 0.0, 9.823916713055715066e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.674120386114100301e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [1.190800144017270801e-01, -8.111253192454067618e-01, 7.662584281698529842e-02, 1.319845723336094678e-01, 0.0, 1.199587104099346102e-01, 0.0, 0.0, 0.0, 9.050053333775449904e-02, 0.0, 0.0, 0.0, 2.743545360204182118e-02, 0.0, 0.0, 0.0, 1.168601017315806651e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.363908796195048845e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.504100264982280721e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [1.984666906695451427e-01, 6.364679535939857247e-02, -9.238071720597268444e-01, 7.919074340016568625e-02, 0.0, 0.0, 9.037343479593649975e-02, 0.0, 0.0, 0.0, 1.173579081806063878e-01, 0.0, 0.0, 0.0, 2.466472050901183377e-02, 0.0, 0.0, 0.0, 1.726023602629593867e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.775045188821034459e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [1.190800144017270801e-01, 1.060779922656642782e-01, 7.662584281698529842e-02, -9.879788158155174971e-01, 0.0, 0.0, 0.0, 6.767091186769211286e-02, 0.0, 0.0, 0.0, 2.947906887808233178e-01, 0.0, 0.0, 0.0, 2.876245830508082982e-02, 0.0, 0.0, 0.0, 1.553419280862226581e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.006183285564997698e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.956714643567183720e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [1.190800144017270801e-01, 0.0, 0.0, 0.0, -1.211134648584501372e+00, 7.997247360662307347e-02, 1.506223913265608561e-01, 4.511394124512807524e-02, 1.290832635958170660e-01, 0.0, 0.0, 0.0, 3.679003783170473607e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.221210415561683159e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.106262563608926330e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.652382557508824845e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 6.364679535939857247e-02, 0.0, 0.0, 9.593927447278817466e-02, -9.824150157043188836e-01, 6.024895653062433548e-02, 1.127848531128201881e-01, 0.0, 3.620021333510180239e-02, 0.0, 0.0, 0.0, 6.858863400510455122e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.048405264624480276e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.504331893387535035e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.973257308727992931e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 7.662584281698529842e-02, 0.0, 2.398481861819704297e-01, 7.997247360662307347e-02, -9.810530313793327517e-01, 4.511394124512807524e-02, 0.0, 0.0, 4.694316327224255792e-02, 0.0, 0.0, 0.0, 6.166180127252958443e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.117061183535621061e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.464910238155726963e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.432259873329247979e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 7.919074340016568625e-02, 9.593927447278817466e-02, 1.999311840165576559e-01, 6.024895653062433548e-02, -8.439058287624919830e-01, 0.0, 0.0, 0.0, 1.179162755123293188e-01, 0.0, 0.0, 0.0, 7.190614576270207281e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.370515304155900116e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.103119265075475863e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.069052600098004860e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [2.977000360043177141e-01, 0.0, 0.0, 0.0, 1.439089117091822689e-01, 0.0, 0.0, 0.0, -9.967407148622288160e-01, 3.620021333510180239e-02, 7.823860545373759190e-02, 1.179162755123293188e-01, 1.471601513268189498e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.423620178618960619e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.113803197345517859e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 1.591169883984964173e-01, 0.0, 0.0, 0.0, 1.199587104099346102e-01, 0.0, 0.0, 1.290832635958170660e-01, -1.170400259162157619e+00, 4.694316327224255792e-02, 1.965271258538822119e-01, 0.0, 2.743545360204182118e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.049094320248859930e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.365443026494024326e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.498818193554544986e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 1.915646070424632530e-01, 0.0, 0.0, 0.0, 9.037343479593649975e-02, 0.0, 2.151387726596950822e-01, 3.620021333510180239e-02, -9.855502720423577889e-01, 1.179162755123293188e-01, 0.0, 0.0, 2.466472050901183377e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.662126838542537843e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.220946797366974423e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.097630006569721983e-02, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 1.979768585004142156e-01, 0.0, 0.0, 0.0, 6.767091186769211286e-02, 1.290832635958170660e-01, 6.033368889183633732e-02, 4.694316327224255792e-02, -7.856847210063072628e-01, 0.0, 0.0, 0.0, 2.876245830508082982e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.215271444449976701e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.349724737527979002e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.926441475344454812e-02, 0.0, 0.0, 0.0, 0.0], [1.190800144017270801e-01, 0.0, 0.0, 0.0, 3.597722792729556307e-01, 0.0, 0.0, 0.0, 1.290832635958170660e-01, 0.0, 0.0, 0.0, -1.296960509868487765e+00, 1.829030240136121643e-02, 6.166180127252958443e-02, 1.917497220338722219e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.207358666313057827e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.075158091099481128e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.164620097945595206e-02, 0.0, 0.0, 0.0], [0.0, 6.364679535939857247e-02, 0.0, 0.0, 0.0, 2.998967760248365533e-01, 0.0, 0.0, 0.0, 3.620021333510180239e-02, 0.0, 0.0, 9.810676755121261472e-02, -8.608616761463714351e-01, 2.466472050901183377e-02, 4.793743050846805548e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.671139981280925224e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.221088784918274023e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.186096238422058337e-03, 0.0, 0.0], [0.0, 0.0, 7.662584281698529842e-02, 0.0, 0.0, 0.0, 2.259335869898412563e-01, 0.0, 0.0, 0.0, 4.694316327224255792e-02, 0.0, 3.679003783170473607e-01, 2.743545360204182118e-02, -1.161178816982928019e+00, 2.876245830508082982e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.215878636189055673e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.540769091681253866e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.513422381496730695e-01, 0.0], [0.0, 0.0, 0.0, 7.919074340016568625e-02, 0.0, 0.0, 0.0, 1.691772796692302960e-01, 0.0, 0.0, 0.0, 1.179162755123293188e-01, 9.810676755121261472e-02, 4.572575600340304108e-02, 2.466472050901183377e-02, -9.345291863553736311e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.833975078917709250e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.483425822025813190e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.030653107182625539e-01], [1.190800144017270801e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.199751187587493551e+00, 1.168601017315806651e-01, 2.876706004382656445e-01, 1.553419280862226581e-01, 1.221210415561683159e-02, 0.0, 0.0, 0.0, 2.408857566982110232e-01, 0.0, 0.0, 0.0, 1.207358666313057827e-01, 0.0, 0.0, 0.0, 1.469648154445640231e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 6.364679535939857247e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.823916713055715066e-02, -1.315677782692045383e+00, 1.726023602629593867e-01, 2.589032134770377080e-01, 0.0, 1.048405264624480276e-01, 0.0, 0.0, 0.0, 2.622735800622149616e-01, 0.0, 0.0, 0.0, 1.671139981280925224e-01, 0.0, 0.0, 0.0, 2.545563518478019885e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.626025066245570250e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 7.662584281698529842e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.637319452175952650e-01, 1.168601017315806651e-01, -9.942207800478171098e-01, 1.553419280862226581e-01, 0.0, 0.0, 4.117061183535621061e-02, 0.0, 0.0, 0.0, 2.873297564453451969e-01, 0.0, 0.0, 0.0, 8.215878636189055673e-02, 0.0, 0.0, 0.0, 7.100180755284137002e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 7.919074340016568625e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.823916713055715066e-02, 1.947668362193011315e-01, 1.726023602629593867e-01, -1.183514773560439215e+00, 0.0, 0.0, 0.0, 1.370515304155900116e-01, 0.0, 0.0, 0.0, 2.303817861112494036e-01, 0.0, 0.0, 0.0, 4.833975078917709250e-02, 0.0, 0.0, 0.0, 2.402473314225999149e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.989178660891795791e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 1.439089117091822689e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.823916713055715066e-02, 0.0, 0.0, 0.0, -1.195781172223651545e+00, 6.989368430829868972e-02, 6.861768639226034638e-02, 9.136768694372666977e-02, 9.635430267928440928e-02, 0.0, 0.0, 0.0, 3.018396665782644428e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.425050254435705044e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.413095639377206558e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 1.199587104099346102e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.168601017315806651e-01, 0.0, 0.0, 8.141402770411221637e-03, -1.388025642626965928e+00, 2.744707455690414272e-02, 2.284192173593166952e-01, 0.0, 1.049094320248859930e-01, 0.0, 0.0, 0.0, 4.177849953202313338e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.401732757355013959e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.243314327181998302e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.037343479593649975e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.726023602629593867e-01, 0.0, 2.035350692602804976e-02, 6.989368430829868972e-02, -1.221580919578354685e+00, 9.136768694372666977e-02, 0.0, 0.0, 1.149319025781380676e-01, 0.0, 0.0, 0.0, 2.053969659047263918e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.859640952622908405e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.580649683323119947e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.767091186769211286e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.553419280862226581e-01, 8.141402770411221637e-03, 1.747342107707466896e-01, 2.744707455690414272e-02, -7.434764115321713662e-01, 0.0, 0.0, 0.0, 9.215271444449976701e-02, 0.0, 0.0, 0.0, 1.208493769729427486e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.041247706030190415e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.672631500245011282e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.605550906387803012e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.455979178263928697e-01, 0.0, 0.0, 0.0, 1.221210415561683159e-02, 0.0, 0.0, 0.0, -8.320814608475014529e-01, 6.993962134992399993e-02, 1.915531709635634461e-01, 6.143514296299984467e-02, 1.207358666313057827e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.455212789382071575e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.620021333510180239e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.921502543289516973e-01, 0.0, 0.0, 0.0, 1.048405264624480276e-01, 0.0, 0.0, 6.423620178618960619e-02, -1.364072589282105730e+00, 7.662126838542537843e-02, 1.535878574074996117e-01, 0.0, 1.671139981280925224e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.461772105976097580e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.747045483886362605e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.129544218149503398e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.315059006573984668e-01, 0.0, 0.0, 0.0, 4.117061183535621061e-02, 0.0, 1.605905044654740155e-01, 6.993962134992399993e-02, -9.943746318734599798e-01, 6.143514296299984467e-02, 0.0, 0.0, 8.215878636189055673e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.883787189467898249e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.744075016424304611e-02, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.179162755123293188e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.883548202155566176e-01, 0.0, 0.0, 0.0, 1.370515304155900116e-01, 6.423620178618960619e-02, 1.748490533748099651e-01, 7.662126838542537843e-02, -1.238928836312801263e+00, 0.0, 0.0, 0.0, 4.833975078917709250e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.339889895011191601e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.981610368836113634e-01, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.471601513268189498e-01, 0.0, 0.0, 0.0, 9.823916713055715066e-02, 0.0, 0.0, 0.0, 3.053026038904207984e-02, 0.0, 0.0, 0.0, 9.635430267928440928e-02, 0.0, 0.0, 0.0, -9.186010166834390755e-01, 1.114093320853950381e-01, 1.369313106031509464e-01, 3.222650052611806398e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.630063236439792396e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.027436682990932465e-01, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.743545360204182118e-02, 0.0, 0.0, 0.0, 1.168601017315806651e-01, 0.0, 0.0, 0.0, 2.621013161561200899e-01, 0.0, 0.0, 0.0, 1.049094320248859930e-01, 0.0, 0.0, 8.049057775420385974e-02, -7.789444488181741511e-01, 5.477252424126036884e-02, 8.056625131529515649e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.884355139673095952e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.965240596055145842e-03, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.466472050901183377e-02, 0.0, 0.0, 0.0, 1.726023602629593867e-01, 0.0, 0.0, 0.0, 1.029265295883905196e-01, 0.0, 0.0, 0.0, 1.149319025781380676e-01, 0.0, 2.012264443855096563e-01, 1.114093320853950381e-01, -1.073855617185561329e+00, 3.222650052611806398e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.163076366725015603e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.522370635827885232e-01, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.876245830508082982e-02, 0.0, 0.0, 0.0, 1.553419280862226581e-01, 0.0, 0.0, 0.0, 3.426288260389749873e-01, 0.0, 0.0, 0.0, 9.215271444449976701e-02, 8.049057775420385974e-02, 2.785233302134875744e-01, 5.477252424126036884e-02, -1.389672668760419061e+00, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.933703288103253037e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.576632767956563708e-01], [2.977000360043177141e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.823916713055715066e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -9.223930633062055184e-01, 2.545563518478019885e-02, 1.183363459214022972e-01, 2.402473314225999149e-02, 8.425050254435705044e-02, 0.0, 0.0, 0.0, 1.113803197345517859e-01, 0.0, 0.0, 0.0, 1.630063236439792396e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 1.591169883984964173e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.168601017315806651e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.469648154445640231e-01, -1.024587067462706891e+00, 7.100180755284137002e-02, 4.004122190376665363e-02, 0.0, 1.401732757355013959e-01, 0.0, 0.0, 0.0, 2.365443026494024326e-01, 0.0, 0.0, 0.0, 4.884355139673095952e-02, 0.0, 0.0, 6.504100264982280721e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 1.915646070424632530e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.726023602629593867e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.449413590742733349e-01, 2.545563518478019885e-02, -1.040910547636912931e+00, 2.402473314225999149e-02, 0.0, 0.0, 9.859640952622908405e-02, 0.0, 0.0, 0.0, 2.220946797366974423e-01, 0.0, 0.0, 0.0, 6.163076366725015603e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 1.979768585004142156e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.553419280862226581e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.469648154445640231e-01, 4.242605864130033488e-02, 7.100180755284137002e-02, -8.965253719776286045e-01, 0.0, 0.0, 0.0, 2.041247706030190415e-02, 0.0, 0.0, 0.0, 8.349724737527979002e-02, 0.0, 0.0, 0.0, 9.933703288103253037e-02, 0.0, 7.956714643567183720e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 3.597722792729556307e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.221210415561683159e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.469648154445640231e-01, 0.0, 0.0, 0.0, -1.338925479192911050e+00, 9.344885049033425928e-02, 1.643273492103818068e-01, 1.360831804020126885e-02, 4.455212789382071575e-02, 0.0, 0.0, 0.0, 4.075158091099481128e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 9.652382557508824845e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 2.998967760248365533e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.048405264624480276e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.545563518478019885e-02, 0.0, 0.0, 5.616700169623803363e-02, -8.925708467918269662e-01, 6.573093968415272270e-02, 3.402079510050316780e-02, 0.0, 9.461772105976097580e-02, 0.0, 0.0, 0.0, 1.221088784918274023e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 8.973257308727992931e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.259335869898412563e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.117061183535621061e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.100180755284137002e-02, 0.0, 1.404175042405950979e-01, 9.344885049033425928e-02, -9.717214475448986422e-01, 1.360831804020126885e-02, 0.0, 0.0, 8.883787189467898249e-02, 0.0, 0.0, 0.0, 1.540769091681253866e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 1.432259873329247979e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.691772796692302960e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.370515304155900116e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.402473314225999149e-02, 5.616700169623803363e-02, 2.336221262258356968e-01, 6.573093968415272270e-02, -9.982056179869800427e-01, 0.0, 0.0, 0.0, 3.339889895011191601e-02, 0.0, 0.0, 0.0, 2.483425822025813190e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 3.069052600098004860e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.227081589895426372e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.635430267928440928e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.674120386114100301e-01, 0.0, 0.0, 0.0, 8.425050254435705044e-02, 0.0, 0.0, 0.0, -1.267138859632953807e+00, 6.307848070650731720e-02, 1.480631198244649893e-01, 2.226593263340794285e-02, 1.630063236439792396e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.050053333775449904e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.049094320248859930e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.363908796195048845e-02, 0.0, 0.0, 0.0, 1.401732757355013959e-01, 0.0, 0.0, 2.970141859588047370e-02, -7.425391979214640559e-01, 5.922524792978599295e-02, 5.566483158351986232e-02, 0.0, 4.884355139673095952e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.498818193554544986e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.173579081806063878e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.149319025781380676e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.775045188821034459e-01, 0.0, 0.0, 0.0, 9.859640952622908405e-02, 0.0, 7.425354648970118598e-02, 6.307848070650731720e-02, -7.405957627296407830e-01, 2.226593263340794285e-02, 0.0, 0.0, 6.163076366725015603e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.097630006569721983e-02, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.947906887808233178e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.215271444449976701e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.006183285564997698e-02, 0.0, 0.0, 0.0, 2.041247706030190415e-02, 2.970141859588047370e-02, 1.576962017662683069e-01, 5.922524792978599295e-02, -8.926420290676866376e-01, 0.0, 0.0, 0.0, 9.933703288103253037e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.926441475344454812e-02, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.679003783170473607e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.207358666313057827e-01, 0.0, 0.0, 0.0, 1.469648154445640231e-01, 0.0, 0.0, 0.0, 2.106262563608926330e-01, 0.0, 0.0, 0.0, 4.455212789382071575e-02, 0.0, 0.0, 0.0, -1.153930641257678857e+00, 3.256236759782064200e-02, 1.027179394454169198e-01, 6.622468858735502950e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.164620097945595206e-02, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.858863400510455122e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.671139981280925224e-01, 0.0, 0.0, 0.0, 2.545563518478019885e-02, 0.0, 0.0, 0.0, 3.504331893387535035e-01, 0.0, 0.0, 0.0, 9.461772105976097580e-02, 0.0, 0.0, 1.086708824293194930e-01, -1.022715053630787851e+00, 4.108717577816677069e-02, 1.655617214683875738e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.186096238422058337e-03, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.166180127252958443e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.215878636189055673e-02, 0.0, 0.0, 0.0, 7.100180755284137002e-02, 0.0, 0.0, 0.0, 2.464910238155726963e-01, 0.0, 0.0, 0.0, 8.883787189467898249e-02, 0.0, 2.716772060732987604e-01, 3.256236759782064200e-02, -1.071957791305660601e+00, 6.622468858735502950e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.513422381496730695e-01, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.190614576270207281e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.833975078917709250e-02, 0.0, 0.0, 0.0, 2.402473314225999149e-02, 0.0, 0.0, 0.0, 5.103119265075475863e-02, 0.0, 0.0, 0.0, 3.339889895011191601e-02, 1.086708824293194930e-01, 8.140591899455161540e-02, 4.108717577816677069e-02, -5.629300092153062263e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.030653107182625539e-01], [0.0, 6.364679535939857247e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.921502543289516973e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.545563518478019885e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -9.794878133135884735e-01, 1.326119107261197194e-01, 0.0, 8.973257308727992931e-02, 0.0, 0.0, 3.747045483886362605e-01, 0.0, 0.0, 0.0, 1.186096238422058337e-03, 0.0, 0.0], [0.0, 0.0, 0.0, 7.919074340016568625e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.883548202155566176e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.402473314225999149e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.084016710830380259e-01, -9.318888414438744050e-01, 0.0, 0.0, 0.0, 3.069052600098004860e-02, 0.0, 0.0, 1.981610368836113634e-01, 0.0, 0.0, 0.0, 1.030653107182625539e-01], [0.0, 0.0, 0.0, 0.0, 1.439089117091822689e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.053026038904207984e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.425050254435705044e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -7.317972220382692461e-01, 5.982171539151994594e-02, 2.387099788882079965e-01, 2.046035066732003124e-02, 0.0, 0.0, 0.0, 1.541155024486398628e-01, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 1.199587104099346102e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.621013161561200899e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.401732757355013959e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.504100264982280721e-02, 0.0, 6.434921705005883230e-02, -9.511054501765308089e-01, 9.548399155528319859e-02, 5.115087666830007984e-02, 1.498818193554544986e-01, 0.0, 0.0, 0.0, 2.965240596055145842e-03, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.037343479593649975e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.029265295883905196e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.859640952622908405e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.608730426251470669e-01, 5.982171539151994594e-02, -9.223833780344231625e-01, 2.046035066732003124e-02, 0.0, 1.097630006569721983e-02, 0.0, 0.0, 0.0, 3.783555953741826738e-01, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.767091186769211286e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.426288260389749873e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.041247706030190415e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.956714643567183720e-02, 6.434921705005883230e-02, 1.495542884787998683e-01, 9.548399155528319859e-02, -1.156594550035883628e+00, 0.0, 0.0, 7.926441475344454812e-02, 0.0, 0.0, 0.0, 2.576632767956563708e-01], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.620021333510180239e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.622735800622149616e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.461772105976097580e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.626025066245570250e-01, 0.0, 0.0, 8.973257308727992931e-02, 0.0, 0.0, -7.896963483954415608e-01, 1.097630006569721983e-02, 1.321073579224075756e-01, 0.0, 1.186096238422058337e-03, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.694316327224255792e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.873297564453451969e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.883787189467898249e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.432259873329247979e-01, 0.0, 1.498818193554544986e-01, -9.468252512037638180e-01, 7.926441475344454812e-02, 0.0, 0.0, 1.513422381496730695e-01, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.179162755123293188e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.303817861112494036e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.339889895011191601e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 1.989178660891795791e-01, 0.0, 0.0, 0.0, 3.069052600098004860e-02, 2.498030322590908681e-01, 1.097630006569721983e-02, -9.751499957069009739e-01, 0.0, 0.0, 0.0, 1.030653107182625539e-01], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.471601513268189498e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.012264443855096563e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.630063236439792396e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 2.413095639377206558e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.109190953833501636e+00, 1.186096238422058337e-03, 2.522370635827885232e-01, 1.030653107182625539e-01], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.743545360204182118e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.177849953202313338e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.884355139673095952e-02, 0.0, 0.0, 6.504100264982280721e-02, 0.0, 0.0, 2.243314327181998302e-01, 0.0, 0.0, 1.498818193554544986e-01, 0.0, 0.0, 6.164620097945595206e-02, -1.318082212035381229e+00, 1.513422381496730695e-01, 1.717755178637709323e-01], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.466472050901183377e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.369313106031509464e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.163076366725015603e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 3.580649683323119947e-01, 0.0, 0.0, 1.097630006569721983e-02, 0.0, 1.027436682990932465e-01, 1.186096238422058337e-03, -7.992631384332000710e-01, 1.030653107182625539e-01], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.876245830508082982e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.208493769729427486e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.933703288103253037e-02, 0.0, 7.956714643567183720e-02, 0.0, 0.0, 0.0, 7.672631500245011282e-02, 0.0, 0.0, 7.926441475344454812e-02, 6.164620097945595206e-02, 1.976827064036764184e-03, 1.513422381496730695e-01, -6.994720105437883806e-01]])  
        m = Model("custom", {'matrix': custom_codon_matrix})
        for i in range(61):
            np.testing.assert_array_almost_equal( m.matrix[i], custom_codon_matrix[i], decimal = DECIMAL, err_msg = "acceptable custom matrix not retained.")               



    def test_model_custommatrix_badrowsums(self):
        '''
            Test that custom matrix for which rows don't sum to 0 raises an assertion error.
        '''
        
        bad_codon_matrix =  np.array([[-1.349975704555383960e+00,2, 1.277097380283088168e-01, 7.919074340016568625e-02, 1.439089117091822689e-01, 0.0, 0.0, 0.0, 3.227081589895426372e-01, 0.0, 0.0, 0.0, 1.471601513268189498e-01, 0.0, 0.0, 0.0, 9.823916713055715066e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.674120386114100301e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [1.190800144017270801e-01, -8.111253192454067618e-01, 7.662584281698529842e-02, 1.319845723336094678e-01, 0.0, 1.199587104099346102e-01, 0.0, 0.0, 0.0, 9.050053333775449904e-02, 0.0, 0.0, 0.0, 2.743545360204182118e-02, 0.0, 0.0, 0.0, 1.168601017315806651e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.363908796195048845e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.504100264982280721e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [1.984666906695451427e-01, 6.364679535939857247e-02, -9.238071720597268444e-01, 7.919074340016568625e-02, 0.0, 0.0, 9.037343479593649975e-02, 0.0, 0.0, 0.0, 1.173579081806063878e-01, 0.0, 0.0, 0.0, 2.466472050901183377e-02, 0.0, 0.0, 0.0, 1.726023602629593867e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.775045188821034459e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [1.190800144017270801e-01, 1.060779922656642782e-01, 7.662584281698529842e-02, -9.879788158155174971e-01, 0.0, 0.0, 0.0, 6.767091186769211286e-02, 0.0, 0.0, 0.0, 2.947906887808233178e-01, 0.0, 0.0, 0.0, 2.876245830508082982e-02, 0.0, 0.0, 0.0, 1.553419280862226581e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.006183285564997698e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.956714643567183720e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [1.190800144017270801e-01, 0.0, 0.0, 0.0, -1.211134648584501372e+00, 7.997247360662307347e-02, 1.506223913265608561e-01, 4.511394124512807524e-02, 1.290832635958170660e-01, 0.0, 0.0, 0.0, 3.679003783170473607e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.221210415561683159e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.106262563608926330e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.652382557508824845e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 6.364679535939857247e-02, 0.0, 0.0, 9.593927447278817466e-02, -9.824150157043188836e-01, 6.024895653062433548e-02, 1.127848531128201881e-01, 0.0, 3.620021333510180239e-02, 0.0, 0.0, 0.0, 6.858863400510455122e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.048405264624480276e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.504331893387535035e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.973257308727992931e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 7.662584281698529842e-02, 0.0, 2.398481861819704297e-01, 7.997247360662307347e-02, -9.810530313793327517e-01, 4.511394124512807524e-02, 0.0, 0.0, 4.694316327224255792e-02, 0.0, 0.0, 0.0, 6.166180127252958443e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.117061183535621061e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.464910238155726963e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.432259873329247979e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 7.919074340016568625e-02, 9.593927447278817466e-02, 1.999311840165576559e-01, 6.024895653062433548e-02, -8.439058287624919830e-01, 0.0, 0.0, 0.0, 1.179162755123293188e-01, 0.0, 0.0, 0.0, 7.190614576270207281e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.370515304155900116e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 5.103119265075475863e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.069052600098004860e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [2.977000360043177141e-01, 0.0, 0.0, 0.0, 1.439089117091822689e-01, 0.0, 0.0, 0.0, -9.967407148622288160e-01, 3.620021333510180239e-02, 7.823860545373759190e-02, 1.179162755123293188e-01, 1.471601513268189498e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.423620178618960619e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.113803197345517859e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 1.591169883984964173e-01, 0.0, 0.0, 0.0, 1.199587104099346102e-01, 0.0, 0.0, 1.290832635958170660e-01, -1.170400259162157619e+00, 4.694316327224255792e-02, 1.965271258538822119e-01, 0.0, 2.743545360204182118e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.049094320248859930e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.365443026494024326e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.498818193554544986e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 1.915646070424632530e-01, 0.0, 0.0, 0.0, 9.037343479593649975e-02, 0.0, 2.151387726596950822e-01, 3.620021333510180239e-02, -9.855502720423577889e-01, 1.179162755123293188e-01, 0.0, 0.0, 2.466472050901183377e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.662126838542537843e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.220946797366974423e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.097630006569721983e-02, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 1.979768585004142156e-01, 0.0, 0.0, 0.0, 6.767091186769211286e-02, 1.290832635958170660e-01, 6.033368889183633732e-02, 4.694316327224255792e-02, -7.856847210063072628e-01, 0.0, 0.0, 0.0, 2.876245830508082982e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.215271444449976701e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.349724737527979002e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.926441475344454812e-02, 0.0, 0.0, 0.0, 0.0], [1.190800144017270801e-01, 0.0, 0.0, 0.0, 3.597722792729556307e-01, 0.0, 0.0, 0.0, 1.290832635958170660e-01, 0.0, 0.0, 0.0, -1.296960509868487765e+00, 1.829030240136121643e-02, 6.166180127252958443e-02, 1.917497220338722219e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.207358666313057827e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.075158091099481128e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.164620097945595206e-02, 0.0, 0.0, 0.0], [0.0, 6.364679535939857247e-02, 0.0, 0.0, 0.0, 2.998967760248365533e-01, 0.0, 0.0, 0.0, 3.620021333510180239e-02, 0.0, 0.0, 9.810676755121261472e-02, -8.608616761463714351e-01, 2.466472050901183377e-02, 4.793743050846805548e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.671139981280925224e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.221088784918274023e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.186096238422058337e-03, 0.0, 0.0], [0.0, 0.0, 7.662584281698529842e-02, 0.0, 0.0, 0.0, 2.259335869898412563e-01, 0.0, 0.0, 0.0, 4.694316327224255792e-02, 0.0, 3.679003783170473607e-01, 2.743545360204182118e-02, -1.161178816982928019e+00, 2.876245830508082982e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.215878636189055673e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.540769091681253866e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.513422381496730695e-01, 0.0], [0.0, 0.0, 0.0, 7.919074340016568625e-02, 0.0, 0.0, 0.0, 1.691772796692302960e-01, 0.0, 0.0, 0.0, 1.179162755123293188e-01, 9.810676755121261472e-02, 4.572575600340304108e-02, 2.466472050901183377e-02, -9.345291863553736311e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.833975078917709250e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.483425822025813190e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.030653107182625539e-01], [1.190800144017270801e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.199751187587493551e+00, 1.168601017315806651e-01, 2.876706004382656445e-01, 1.553419280862226581e-01, 1.221210415561683159e-02, 0.0, 0.0, 0.0, 2.408857566982110232e-01, 0.0, 0.0, 0.0, 1.207358666313057827e-01, 0.0, 0.0, 0.0, 1.469648154445640231e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 6.364679535939857247e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.823916713055715066e-02, -1.315677782692045383e+00, 1.726023602629593867e-01, 2.589032134770377080e-01, 0.0, 1.048405264624480276e-01, 0.0, 0.0, 0.0, 2.622735800622149616e-01, 0.0, 0.0, 0.0, 1.671139981280925224e-01, 0.0, 0.0, 0.0, 2.545563518478019885e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.626025066245570250e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 7.662584281698529842e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.637319452175952650e-01, 1.168601017315806651e-01, -9.942207800478171098e-01, 1.553419280862226581e-01, 0.0, 0.0, 4.117061183535621061e-02, 0.0, 0.0, 0.0, 2.873297564453451969e-01, 0.0, 0.0, 0.0, 8.215878636189055673e-02, 0.0, 0.0, 0.0, 7.100180755284137002e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 7.919074340016568625e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.823916713055715066e-02, 1.947668362193011315e-01, 1.726023602629593867e-01, -1.183514773560439215e+00, 0.0, 0.0, 0.0, 1.370515304155900116e-01, 0.0, 0.0, 0.0, 2.303817861112494036e-01, 0.0, 0.0, 0.0, 4.833975078917709250e-02, 0.0, 0.0, 0.0, 2.402473314225999149e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.989178660891795791e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 1.439089117091822689e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.823916713055715066e-02, 0.0, 0.0, 0.0, -1.195781172223651545e+00, 6.989368430829868972e-02, 6.861768639226034638e-02, 9.136768694372666977e-02, 9.635430267928440928e-02, 0.0, 0.0, 0.0, 3.018396665782644428e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.425050254435705044e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.413095639377206558e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 1.199587104099346102e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.168601017315806651e-01, 0.0, 0.0, 8.141402770411221637e-03, -1.388025642626965928e+00, 2.744707455690414272e-02, 2.284192173593166952e-01, 0.0, 1.049094320248859930e-01, 0.0, 0.0, 0.0, 4.177849953202313338e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.401732757355013959e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.243314327181998302e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.037343479593649975e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.726023602629593867e-01, 0.0, 2.035350692602804976e-02, 6.989368430829868972e-02, -1.221580919578354685e+00, 9.136768694372666977e-02, 0.0, 0.0, 1.149319025781380676e-01, 0.0, 0.0, 0.0, 2.053969659047263918e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.859640952622908405e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.580649683323119947e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.767091186769211286e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.553419280862226581e-01, 8.141402770411221637e-03, 1.747342107707466896e-01, 2.744707455690414272e-02, -7.434764115321713662e-01, 0.0, 0.0, 0.0, 9.215271444449976701e-02, 0.0, 0.0, 0.0, 1.208493769729427486e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.041247706030190415e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.672631500245011282e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.605550906387803012e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.455979178263928697e-01, 0.0, 0.0, 0.0, 1.221210415561683159e-02, 0.0, 0.0, 0.0, -8.320814608475014529e-01, 6.993962134992399993e-02, 1.915531709635634461e-01, 6.143514296299984467e-02, 1.207358666313057827e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.455212789382071575e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.620021333510180239e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.921502543289516973e-01, 0.0, 0.0, 0.0, 1.048405264624480276e-01, 0.0, 0.0, 6.423620178618960619e-02, -1.364072589282105730e+00, 7.662126838542537843e-02, 1.535878574074996117e-01, 0.0, 1.671139981280925224e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.461772105976097580e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.747045483886362605e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.129544218149503398e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.315059006573984668e-01, 0.0, 0.0, 0.0, 4.117061183535621061e-02, 0.0, 1.605905044654740155e-01, 6.993962134992399993e-02, -9.943746318734599798e-01, 6.143514296299984467e-02, 0.0, 0.0, 8.215878636189055673e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.883787189467898249e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.744075016424304611e-02, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.179162755123293188e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.883548202155566176e-01, 0.0, 0.0, 0.0, 1.370515304155900116e-01, 6.423620178618960619e-02, 1.748490533748099651e-01, 7.662126838542537843e-02, -1.238928836312801263e+00, 0.0, 0.0, 0.0, 4.833975078917709250e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.339889895011191601e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.981610368836113634e-01, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.471601513268189498e-01, 0.0, 0.0, 0.0, 9.823916713055715066e-02, 0.0, 0.0, 0.0, 3.053026038904207984e-02, 0.0, 0.0, 0.0, 9.635430267928440928e-02, 0.0, 0.0, 0.0, -9.186010166834390755e-01, 1.114093320853950381e-01, 1.369313106031509464e-01, 3.222650052611806398e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.630063236439792396e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.027436682990932465e-01, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.743545360204182118e-02, 0.0, 0.0, 0.0, 1.168601017315806651e-01, 0.0, 0.0, 0.0, 2.621013161561200899e-01, 0.0, 0.0, 0.0, 1.049094320248859930e-01, 0.0, 0.0, 8.049057775420385974e-02, -7.789444488181741511e-01, 5.477252424126036884e-02, 8.056625131529515649e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.884355139673095952e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.965240596055145842e-03, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.466472050901183377e-02, 0.0, 0.0, 0.0, 1.726023602629593867e-01, 0.0, 0.0, 0.0, 1.029265295883905196e-01, 0.0, 0.0, 0.0, 1.149319025781380676e-01, 0.0, 2.012264443855096563e-01, 1.114093320853950381e-01, -1.073855617185561329e+00, 3.222650052611806398e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.163076366725015603e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.522370635827885232e-01, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.876245830508082982e-02, 0.0, 0.0, 0.0, 1.553419280862226581e-01, 0.0, 0.0, 0.0, 3.426288260389749873e-01, 0.0, 0.0, 0.0, 9.215271444449976701e-02, 8.049057775420385974e-02, 2.785233302134875744e-01, 5.477252424126036884e-02, -1.389672668760419061e+00, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.933703288103253037e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.576632767956563708e-01], [2.977000360043177141e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.823916713055715066e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -9.223930633062055184e-01, 2.545563518478019885e-02, 1.183363459214022972e-01, 2.402473314225999149e-02, 8.425050254435705044e-02, 0.0, 0.0, 0.0, 1.113803197345517859e-01, 0.0, 0.0, 0.0, 1.630063236439792396e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 1.591169883984964173e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.168601017315806651e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.469648154445640231e-01, -1.024587067462706891e+00, 7.100180755284137002e-02, 4.004122190376665363e-02, 0.0, 1.401732757355013959e-01, 0.0, 0.0, 0.0, 2.365443026494024326e-01, 0.0, 0.0, 0.0, 4.884355139673095952e-02, 0.0, 0.0, 6.504100264982280721e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 1.915646070424632530e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.726023602629593867e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.449413590742733349e-01, 2.545563518478019885e-02, -1.040910547636912931e+00, 2.402473314225999149e-02, 0.0, 0.0, 9.859640952622908405e-02, 0.0, 0.0, 0.0, 2.220946797366974423e-01, 0.0, 0.0, 0.0, 6.163076366725015603e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 1.979768585004142156e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.553419280862226581e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.469648154445640231e-01, 4.242605864130033488e-02, 7.100180755284137002e-02, -8.965253719776286045e-01, 0.0, 0.0, 0.0, 2.041247706030190415e-02, 0.0, 0.0, 0.0, 8.349724737527979002e-02, 0.0, 0.0, 0.0, 9.933703288103253037e-02, 0.0, 7.956714643567183720e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 3.597722792729556307e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.221210415561683159e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.469648154445640231e-01, 0.0, 0.0, 0.0, -1.338925479192911050e+00, 9.344885049033425928e-02, 1.643273492103818068e-01, 1.360831804020126885e-02, 4.455212789382071575e-02, 0.0, 0.0, 0.0, 4.075158091099481128e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 9.652382557508824845e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 2.998967760248365533e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.048405264624480276e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.545563518478019885e-02, 0.0, 0.0, 5.616700169623803363e-02, -8.925708467918269662e-01, 6.573093968415272270e-02, 3.402079510050316780e-02, 0.0, 9.461772105976097580e-02, 0.0, 0.0, 0.0, 1.221088784918274023e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 8.973257308727992931e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.259335869898412563e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.117061183535621061e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.100180755284137002e-02, 0.0, 1.404175042405950979e-01, 9.344885049033425928e-02, -9.717214475448986422e-01, 1.360831804020126885e-02, 0.0, 0.0, 8.883787189467898249e-02, 0.0, 0.0, 0.0, 1.540769091681253866e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 1.432259873329247979e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.691772796692302960e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.370515304155900116e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.402473314225999149e-02, 5.616700169623803363e-02, 2.336221262258356968e-01, 6.573093968415272270e-02, -9.982056179869800427e-01, 0.0, 0.0, 0.0, 3.339889895011191601e-02, 0.0, 0.0, 0.0, 2.483425822025813190e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 3.069052600098004860e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.227081589895426372e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.635430267928440928e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.674120386114100301e-01, 0.0, 0.0, 0.0, 8.425050254435705044e-02, 0.0, 0.0, 0.0, -1.267138859632953807e+00, 6.307848070650731720e-02, 1.480631198244649893e-01, 2.226593263340794285e-02, 1.630063236439792396e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.050053333775449904e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.049094320248859930e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.363908796195048845e-02, 0.0, 0.0, 0.0, 1.401732757355013959e-01, 0.0, 0.0, 2.970141859588047370e-02, -7.425391979214640559e-01, 5.922524792978599295e-02, 5.566483158351986232e-02, 0.0, 4.884355139673095952e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.498818193554544986e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.173579081806063878e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.149319025781380676e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.775045188821034459e-01, 0.0, 0.0, 0.0, 9.859640952622908405e-02, 0.0, 7.425354648970118598e-02, 6.307848070650731720e-02, -7.405957627296407830e-01, 2.226593263340794285e-02, 0.0, 0.0, 6.163076366725015603e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.097630006569721983e-02, 0.0, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.947906887808233178e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.215271444449976701e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.006183285564997698e-02, 0.0, 0.0, 0.0, 2.041247706030190415e-02, 2.970141859588047370e-02, 1.576962017662683069e-01, 5.922524792978599295e-02, -8.926420290676866376e-01, 0.0, 0.0, 0.0, 9.933703288103253037e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.926441475344454812e-02, 0.0, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.679003783170473607e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.207358666313057827e-01, 0.0, 0.0, 0.0, 1.469648154445640231e-01, 0.0, 0.0, 0.0, 2.106262563608926330e-01, 0.0, 0.0, 0.0, 4.455212789382071575e-02, 0.0, 0.0, 0.0, -1.153930641257678857e+00, 3.256236759782064200e-02, 1.027179394454169198e-01, 6.622468858735502950e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.164620097945595206e-02, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.858863400510455122e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.671139981280925224e-01, 0.0, 0.0, 0.0, 2.545563518478019885e-02, 0.0, 0.0, 0.0, 3.504331893387535035e-01, 0.0, 0.0, 0.0, 9.461772105976097580e-02, 0.0, 0.0, 1.086708824293194930e-01, -1.022715053630787851e+00, 4.108717577816677069e-02, 1.655617214683875738e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.186096238422058337e-03, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.166180127252958443e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.215878636189055673e-02, 0.0, 0.0, 0.0, 7.100180755284137002e-02, 0.0, 0.0, 0.0, 2.464910238155726963e-01, 0.0, 0.0, 0.0, 8.883787189467898249e-02, 0.0, 2.716772060732987604e-01, 3.256236759782064200e-02, -1.071957791305660601e+00, 6.622468858735502950e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.513422381496730695e-01, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.190614576270207281e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.833975078917709250e-02, 0.0, 0.0, 0.0, 2.402473314225999149e-02, 0.0, 0.0, 0.0, 5.103119265075475863e-02, 0.0, 0.0, 0.0, 3.339889895011191601e-02, 1.086708824293194930e-01, 8.140591899455161540e-02, 4.108717577816677069e-02, -5.629300092153062263e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.030653107182625539e-01], [0.0, 6.364679535939857247e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.921502543289516973e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.545563518478019885e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -9.794878133135884735e-01, 1.326119107261197194e-01, 0.0, 8.973257308727992931e-02, 0.0, 0.0, 3.747045483886362605e-01, 0.0, 0.0, 0.0, 1.186096238422058337e-03, 0.0, 0.0], [0.0, 0.0, 0.0, 7.919074340016568625e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.883548202155566176e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.402473314225999149e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.084016710830380259e-01, -9.318888414438744050e-01, 0.0, 0.0, 0.0, 3.069052600098004860e-02, 0.0, 0.0, 1.981610368836113634e-01, 0.0, 0.0, 0.0, 1.030653107182625539e-01], [0.0, 0.0, 0.0, 0.0, 1.439089117091822689e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.053026038904207984e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.425050254435705044e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -7.317972220382692461e-01, 5.982171539151994594e-02, 2.387099788882079965e-01, 2.046035066732003124e-02, 0.0, 0.0, 0.0, 1.541155024486398628e-01, 0.0, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 1.199587104099346102e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.621013161561200899e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.401732757355013959e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.504100264982280721e-02, 0.0, 6.434921705005883230e-02, -9.511054501765308089e-01, 9.548399155528319859e-02, 5.115087666830007984e-02, 1.498818193554544986e-01, 0.0, 0.0, 0.0, 2.965240596055145842e-03, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.037343479593649975e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.029265295883905196e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.859640952622908405e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.608730426251470669e-01, 5.982171539151994594e-02, -9.223833780344231625e-01, 2.046035066732003124e-02, 0.0, 1.097630006569721983e-02, 0.0, 0.0, 0.0, 3.783555953741826738e-01, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.767091186769211286e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.426288260389749873e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.041247706030190415e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 7.956714643567183720e-02, 6.434921705005883230e-02, 1.495542884787998683e-01, 9.548399155528319859e-02, -1.156594550035883628e+00, 0.0, 0.0, 7.926441475344454812e-02, 0.0, 0.0, 0.0, 2.576632767956563708e-01], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.620021333510180239e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.622735800622149616e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.461772105976097580e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.626025066245570250e-01, 0.0, 0.0, 8.973257308727992931e-02, 0.0, 0.0, -7.896963483954415608e-01, 1.097630006569721983e-02, 1.321073579224075756e-01, 0.0, 1.186096238422058337e-03, 0.0, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.694316327224255792e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.873297564453451969e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 8.883787189467898249e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.432259873329247979e-01, 0.0, 1.498818193554544986e-01, -9.468252512037638180e-01, 7.926441475344454812e-02, 0.0, 0.0, 1.513422381496730695e-01, 0.0], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.179162755123293188e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.303817861112494036e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 3.339889895011191601e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 1.989178660891795791e-01, 0.0, 0.0, 0.0, 3.069052600098004860e-02, 2.498030322590908681e-01, 1.097630006569721983e-02, -9.751499957069009739e-01, 0.0, 0.0, 0.0, 1.030653107182625539e-01], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.471601513268189498e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.012264443855096563e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.630063236439792396e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 2.413095639377206558e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, -1.109190953833501636e+00, 1.186096238422058337e-03, 2.522370635827885232e-01, 1.030653107182625539e-01], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.743545360204182118e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.177849953202313338e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 4.884355139673095952e-02, 0.0, 0.0, 6.504100264982280721e-02, 0.0, 0.0, 2.243314327181998302e-01, 0.0, 0.0, 1.498818193554544986e-01, 0.0, 0.0, 6.164620097945595206e-02, -1.318082212035381229e+00, 1.513422381496730695e-01, 1.717755178637709323e-01], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.466472050901183377e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.369313106031509464e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 6.163076366725015603e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 3.580649683323119947e-01, 0.0, 0.0, 1.097630006569721983e-02, 0.0, 1.027436682990932465e-01, 1.186096238422058337e-03, -7.992631384332000710e-01, 1.030653107182625539e-01], [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 2.876245830508082982e-02, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.208493769729427486e-01, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 9.933703288103253037e-02, 0.0, 7.956714643567183720e-02, 0.0, 0.0, 0.0, 7.672631500245011282e-02, 0.0, 0.0, 7.926441475344454812e-02, 6.164620097945595206e-02, 1.976827064036764184e-03, 1.513422381496730695e-01, -6.994720105437883806e-01]])
        self.failUnlessRaises(AssertionError, Model, "custom", {'matrix': bad_codon_matrix}, msg = "Assertion not raised when user-specified matrix rows don't sum to 0.")



    def test_model_custommatrix_baddimensions(self):
        '''
            Test that custom matrix with improper dimensions raises an assertion error.
        '''
        
        bad_dimensions_matrix = np.array([[-1,0.5,0.5], [0.33, -1, 0.66], [0.25, 0.75, -1]])

        self.failUnlessRaises(AssertionError, Model, "custom", {'matrix': bad_dimensions_matrix}, msg = "Assertion not raised when user-specified matrix had improper dimensions.")


    def test_model_custommatrix_calc_state_freqs(self):
        '''
            Test that state frequencies are computed properly from a matrix.
        '''
        custom_matrix = np.array([[-1.0, 0.33, 0.33, 0.34], 
                         [0.25, -1.0, 0.25, 0.50], 
                         [0.10, 0.80, -1.0, 0.10],
                         [0.34, 0.33, 0.33, -1.0]] )
        correct_freqs = np.array( [ 0.19074982,  0.32881262,  0.2283421,   0.25209546] )
        m = Model("custom", {'matrix': custom_matrix})
        np.testing.assert_array_almost_equal( m.params["state_freqs"], correct_freqs, decimal = DECIMAL, err_msg = "frequencies not properly calculated from provided custom matrix.")               


    def test_model_custommatrix_customfreqs(self):
        '''
            Test that custom model construction works with properly provided state freqs.
        '''
        custom_matrix = np.array([[-1.0,  0.6, 0.2, 0.2], 
                                  [ 0.6, -1.0, 0.2, 0.2], 
                                  [ 0.2, 0.2, -1.0, 0.6],
                                  [ 0.2, 0.2, 0.6, -1.0]] )
        final_matrix = np.array([[-0.05,  0.03,  0.01,  0.01],
                                 [ 0.18, -0.3,   0.06,  0.06],
                                 [ 0.03,  0.03, -0.15,  0.09],
                                 [ 0.1,   0.1,   0.3,  -0.5 ]])
        custom_freqs = [0.05, 0.3, 0.15, 0.5]        
        m = Model("custom", {'matrix': custom_matrix, 'state_freqs': custom_freqs})
        for i in range(4):
            np.testing.assert_array_almost_equal( m.matrix[i], final_matrix[i], decimal = DECIMAL, err_msg = "\n\nCustom matrix with custom frequencies not accepted even though correct.")               


    def test_model_custommatrix_customBADfreqs1(self):
        '''
            Test that custom model construction fails with badly provided state freqs (bad sum).
        '''
        custom_matrix = np.array([[-1.0,  0.6, 0.2, 0.2], 
                                  [ 0.6, -1.0, 0.2, 0.2], 
                                  [ 0.2, 0.2, -1.0, 0.6],
                                  [ 0.2, 0.2, 0.6, -1.0]] )
        custom_freqs = [0.05, 0.3, 0.15, 0.6]  
        self.failUnlessRaises(AssertionError, Model, "custom", {'matrix': custom_matrix, 'state_freqs': custom_freqs}, msg = "Assertion not raised when user-specified frequencies do not sum to 1 for custom model.")



    def test_model_custommatrix_customBADfreqs2(self):
        '''
            Test that custom model construction fails with badly provided state freqs (bad dimension).
        '''
        custom_matrix = np.array([[-1.0,  0.6, 0.2, 0.2], 
                                  [ 0.6, -1.0, 0.2, 0.2], 
                                  [ 0.2, 0.2, -1.0, 0.6],
                                  [ 0.2, 0.2, 0.6, -1.0]] )
        custom_freqs = [0.05, 0.3, 0.15, 0.5, 0.1]  
        self.failUnlessRaises(AssertionError, Model, "custom", {'matrix': custom_matrix, 'state_freqs': custom_freqs}, msg = "Assertion not raised when user-specified matrix doesn't match dimensions of user-specified frequencies.")


    def test_model_custommatrix_customfreqs_asymmatrix(self):
        '''
            Test that custom model construction fails with provided state freqs by asymmetric matrix.
        '''
        custom_matrix = np.array([[-1.0,  0.6, 0.2, 0.3], 
                                  [ 0.6, -1.0, 0.2, 0.2], 
                                  [ 0.2, 0.2, -1.0, 0.6],
                                  [ 0.2, 0.2, 0.6, -1.0]] )
        custom_freqs = [0.05, 0.3, 0.15, 0.5]  
        self.failUnlessRaises(AssertionError, Model, "custom", {'matrix': custom_matrix, 'state_freqs': custom_freqs}, msg = "Assertion not raised when user-specified matrix is nonsymmetric, with accompanying state frequencies.")




    def test_model_custommatrix_customcode(self):
        '''
            Test that everything works out when a custom code is provided along with the custom matrix.
        '''
        matrix = np.array([ [-0.5, 0.25, 0.25], [0.25, -0.5, 0.25], [0.25, 0.25, -0.5] ]) 
        code = ["0", "1", "2"]
        correct_freqs = np.array([1./3, 1./3, 1./3])
        m = Model("custom", {"matrix":matrix, "code":code})
        np.testing.assert_array_almost_equal( m.params["state_freqs"], correct_freqs, decimal = DECIMAL, err_msg = "frequencies not properly calculated from provided custom matrix of 3x3 dimension with custom code.")

        
        
    def test_model_custommatrix_customcode_incompatible(self):
        '''
            Test that assertion raised when custom matrix has diff dimension from custom code.
        '''
        matrix = np.array([ [-0.5, 0.25, 0.25], [0.25, -0.5, 0.25], [0.25, 0.25, -0.5] ]) 
        code = ["0", "1", "2", "3"]
        self.failUnlessRaises(AssertionError, Model, "custom", {"matrix":matrix, "code":code}, msg = "Assertion not raised when custom matrix dimensions dont match custom code dimensions.")   
        
        
    def test_model_custommatrix_customcode_badcode(self):
        '''
            Test that assertion raised when custom code incorrectly specified.
        '''
        matrix = np.array([ [-0.5, 0.25, 0.25], [0.25, -0.5, 0.25], [0.25, 0.25, -0.5] ]) 
        code = "0123"
        self.failUnlessRaises(AssertionError, Model, "custom", {"matrix":matrix, "code":code}, msg = "Assertion not raised when custom matrix dimensions dont match custom code dimensions.")   
 
 
    def tearDown(self):
        ''' 
            Remove custom matrix freq file, as needed
        '''
        if os.path.exists("custom_matrix_frequencies.txt"):
            os.remove("custom_matrix_frequencies.txt")        
    





class model_nohet_tests(unittest.TestCase):
    ''' 
        Suite of tests for Model without site heterogeneity.
    '''
    
    def setUp(self):
        
        mu_dict     = {'AC':1, 'AG':1, 'AT':1, 'CG':1, 'CT':1, 'GT':1}
        nuc_freqs   = np.repeat(0.25, 4)
        codon_freqs = np.repeat(1./61., 61)
        amino_freqs = np.repeat(0.05, 20)
        
        self.nuc_model       = Model("nucleotide", {'state_freqs':nuc_freqs, 'mu':mu_dict} )
        self.aa_model        = Model("wag", {'state_freqs':amino_freqs})
        self.gy_model        = Model("gy", {'state_freqs':codon_freqs, 'mu':mu_dict, 'beta':2.5, 'alpha':1.0})
        self.codon_model     = Model("codon", {'state_freqs':codon_freqs, 'mu':mu_dict, 'beta':2.5, 'alpha':1.0})
        self.mg_model        = Model("mg", {'state_freqs':codon_freqs, 'mu':mu_dict, 'beta':2.5, 'alpha':1.0})
        self.mutselcodon_model  = Model("mutsel", {'state_freqs':codon_freqs, 'mu':mu_dict})
        self.mutselnuc_model    = Model("mutsel", {'state_freqs':nuc_freqs, 'mu':mu_dict})
        self.ecmrest_model   = Model("ecmrest", {'state_freqs':codon_freqs, 'mu':mu_dict})
        self.ecmunrest_model = Model("ecmunrest", {'state_freqs':codon_freqs, 'mu':mu_dict})
   

    
    def test_model_nohet_construct_model_matrix_type(self):
        '''
            Are matrices of correct dimension created?"
        '''
        self.assertTrue( self.nuc_model.matrix.shape == (4,4), msg = "nucleotide model built wrong matrix type.")
        self.assertTrue( self.aa_model.matrix.shape == (20,20), msg = "amino acid model built wrong matrix type.")
        self.assertTrue( self.codon_model.matrix.shape == (61,61), msg = "codon model without heterogeneity built wrong matrix type.")
        self.assertTrue( self.gy_model.matrix.shape == (61,61), msg = "gy model without heterogeneity built wrong matrix type.")
        self.assertTrue( self.mg_model.matrix.shape == (61,61), msg = "mg model without heterogeneity built wrong matrix type.")
        self.assertTrue( self.mutselcodon_model.matrix.shape == (61,61), msg = "mutsel codon model without heterogeneity built wrong matrix type.")
        self.assertTrue( self.mutselnuc_model.matrix.shape == (4,4), msg = "mutsel nucleotide model without heterogeneity built wrong matrix type.")
        self.assertTrue( self.ecmrest_model.matrix.shape == (61,61), msg = "ecmrest model without heterogeneity built wrong matrix type.")
        self.assertTrue( self.ecmunrest_model.matrix.shape == (61,61), msg = "ecmunrest model without heterogeneity built wrong matrix type.")


    def test_model_nohet_rates(self):
        '''
            Are matrices of correct dimension created?"
        '''
        np.testing.assert_array_almost_equal(self.nuc_model.rate_factors, np.array([1.]), decimal = DECIMAL, err_msg = "rate_factor doesn't==1. for no heterogeneity.")
        np.testing.assert_array_almost_equal(self.nuc_model.rate_probs, np.array([1.]), decimal = DECIMAL, err_msg = "rate_probs doesn't==1. for no heterogeneity.")
        
        
 
 
 
 
class model_gammahet_tests(unittest.TestCase):
    ''' 
        Suite of tests for Model without gamma heterogeneity.
        Tests conducted with nucleotides.
    ''' 
    
    def setUp(self):
        
        self.mu_dict        = {'AC':1, 'AG':1, 'AT':1, 'CG':1, 'CT':1, 'GT':1}
        self.nuc_freqs      = np.repeat(0.25, 4)
        
    
    
    def test_model_het_gamma_rates_simprobs(self):
        '''
            Are gamma rates and probabilities assigned correctly?"
        '''    
        k = 5
        nuc_model = Model( "nucleotide", {'state_freqs':self.nuc_freqs, 'mu':self.mu_dict}, alpha = 0.5, num_categories = k)
        self.assertTrue( len(nuc_model.rate_probs) == k, msg = "incorrect number of rate probabilities for gamma heterogeneity.")
        self.assertTrue( len(nuc_model.rate_factors) == k, msg = "incorrect number of rate factors for gamma heterogeneity.")
        self.assertTrue( abs(1. - np.sum(nuc_model.rate_probs)) <= ZERO, msg = "rate probabilities don't sum to 1 for gamma hetereogenity.")
        self.assertTrue( abs(1. - np.sum(nuc_model.rate_probs * nuc_model.rate_factors)) <= ZERO, msg = "rate probabilities and factors improperly normalized for gamma hetereogenity.")
         




class model_userhet_tests(unittest.TestCase):
    ''' 
        Suite of tests for Model with user-specified heterogeneity.
        Tests conducted with nucleotides.
    ''' 
    
    def setUp(self):
        
        self.mu_dict        = {'AC':1, 'AG':1, 'AT':1, 'CG':1, 'CT':1, 'GT':1}
        self.nuc_freqs      = np.repeat(0.25, 4)
        self.rate_factors = [2.5, 4.5, 3.5, 0.8]
        self.rate_probs = [0.1, 0.1, 0.1, 0.7]
    
    
    
    def test_model_het_userrates_simprobs(self):
        '''
            Are rates and probabilities assigned correctly when users give rates but not probs?"
        '''    
        nuc_model = Model("nucleotide", {'state_freqs':self.nuc_freqs, 'mu':self.mu_dict}, rate_factors = self.rate_factors)

        self.assertTrue( len(nuc_model.rate_probs) == len(self.rate_factors), msg = "incorrect number of rate probabilities for user-specified factors, default rates.")
        self.assertTrue( len(nuc_model.rate_factors) == len(self.rate_factors), msg = "incorrect number of rate factors for user-specified factors, default rates.")
        self.assertTrue( abs(1. - np.sum(nuc_model.rate_probs)) <= ZERO, msg = "rate probabilities don't sum to 1 for user-specified factors, default rates.")
        self.assertTrue( abs(1. - np.sum(nuc_model.rate_probs * nuc_model.rate_factors)) <= ZERO, msg = "rate probabilities and factors improperly normalized for user-specified factors, default rates.")

    
    
    def test_model_het_userrates_userprobs(self):
        '''
            Are rates and probabilities assigned correctly when users give compatible rates and probs?"
        '''    
        
        nuc_model = Model("nucleotide", {'state_freqs':self.nuc_freqs, 'mu':self.mu_dict}, rate_probs = self.rate_probs, rate_factors = self.rate_factors)
        
        np.testing.assert_array_almost_equal( nuc_model.rate_probs, np.array(self.rate_probs), decimal = DECIMAL, err_msg = "incorrect rate probs from user-specified list.")               
        self.assertTrue( len(nuc_model.rate_probs) == len(self.rate_factors), msg = "incorrect number of rate probabilities for user-specified factors, default rates.")
        self.assertTrue( len(nuc_model.rate_factors) == len(self.rate_factors), msg = "incorrect number of rate factors for user-specified factors, default rates.")
        self.assertTrue( abs(1. - np.sum(nuc_model.rate_probs)) <= ZERO, msg = "rate probabilities don't sum to 1 for user-specified factors, default rates.")
        self.assertTrue( abs(1. - np.sum(nuc_model.rate_probs * nuc_model.rate_factors)) <= ZERO, msg = "rate probabilities and factors improperly normalized for user-specified factors, default rates.")


    def test_model_het_bad_ratesprobs(self):
        '''
            Errors thrown when rates and probabilities specified incorrectly?"
        '''    
        
        self.failUnlessRaises(AssertionError, Model, "nucleotide", {'state_freqs':self.nuc_freqs, 'mu':self.mu_dict}, rate_probs = [0.6, 0.3, 0.2], rate_factors = [1., 2, 3.], msg = "Assertion not raised when user-specified Model rate_probs sum > 1.")
        self.failUnlessRaises(AssertionError, Model, "nucleotide", {'state_freqs':self.nuc_freqs, 'mu':self.mu_dict}, rate_probs = [0.6, 0.3, 0.1], rate_factors = [1., 2.], msg = "Assertion not raised when user-specified Model rate_probs diff size from rate_factors.")
 
 





class model_matrix_tests(unittest.TestCase):
    ''' 
        Suite of tests to verify that matrix is being constructed correctly following a Model call.
    ''' 

    def setUp(self):
        self.mu = {"AT":0.5, "AC":0.6, "AG":1.6, "CG":8.1, "CT":0.022, "GT":0.91}
        self.codon_freqs = [0.0234005005 , 0.01638106, 0.01372575, 0.01330357, 0.01419047, 0.01791854, 0.01069625, 0.00836638, 0.01307488, 0.01315727, 0.01886524, 0.01300595, 0.02704645, 0.01853276, 0.00813181, 0.00553555, 0.01786036, 0.00951009, 0.02221829, 0.01554665, 0.00748666, 0.02355158, 0.02650033, 0.00656869, 0.0099631 , 0.0168717 , 0.01543626, 0.01895149, 0.01619116, 0.01017567, 0.01312612, 0.02636875, 0.02331105, 0.01373902, 0.00844827, 0.02400436, 0.00882751, 0.00671437, 0.02512051, 0.01724287, 0.01741193, 0.0263832 , 0.01933077, 0.01046162, 0.0235815 , 0.0230325 , 0.02209538, 0.02369242, 0.02595669, 0.00601315, 0.01678629, 0.02035909, 0.02514437, 0.0079483 , 0.01355738, 0.01633555, 0.02196548, 0.01925015, 0.02175937, 0.01222366, 0.00764391]


    def test_aminoacid_matrix(self):
        '''
            AA model matrix.
        '''    
        
        f = [0.00463253, 0.00284344, 0.06537318, 0.00449111, 0.05123511, 0.09516231, 0.06253008, 0.03324557, 0.07314561, 0.08433455, 0.09536747, 0.03097788, 0.06219496, 0.06791723, 0.07584411, 0.05024045, 0.08200368, 0.03260186, 0.00484201, 0.02101687]
        wag_model = Model("wag", {'state_freqs': f})
        true_wagmat = np.loadtxt("tests/modelFiles/true_wag_matrix.txt")
        np.testing.assert_array_almost_equal(wag_model.matrix, true_wagmat, decimal=DECIMAL, err_msg = "WAG matrix not properly constructed via Model call.")


    def test_nucleotide_matrix(self):
        '''
            Nucleotide model matrix.
        '''    
        
        f = [0.18, 0.22, 0.36, 0.24]
        mu = {"AT":0.5, "AC":0.6, "AG":1.6, "CG":8.1, "CT":0.022, "GT":0.91}
        nuc_model = Model("nucleotide", {'state_freqs': f, 'mu': self.mu})
        true_nucmat = np.loadtxt("tests/modelFiles/true_nucleotide_matrix.txt")
        np.testing.assert_array_almost_equal(nuc_model.matrix, true_nucmat, decimal=DECIMAL, err_msg = "Nucleotide matrix not properly constructed via Model call.")


    def test_GY_matrix(self):
        '''
            GY model matrix, homogeneous.
        '''    
        gy_model = Model("GY", {'beta':0.25, 'alpha': 0.95, 'state_freqs': self.codon_freqs, 'mu': self.mu})
        true_gymat = np.loadtxt("tests/modelFiles/true_gy_matrix.txt")
        np.testing.assert_array_almost_equal(gy_model.matrix, true_gymat, decimal=DECIMAL, err_msg = "GY matrix not properly constructed via Model call.")


    def test_MG_matrix(self):
        '''
            MG model matrix, homogeneous, codon frequencies provided.
        '''    
        mg_model = Model("MG", {'beta':0.25, 'alpha': 0.95, 'state_freqs': self.codon_freqs, 'mu': self.mu})
        true_mgmat = np.loadtxt("tests/modelFiles/true_mg_matrix.txt")
        np.testing.assert_array_almost_equal(mg_model.matrix, true_mgmat, decimal=DECIMAL, err_msg = "MG matrix not properly constructed via Model call")



    def test_mutsel_codonfreq_matrix(self):
        '''
            MutSel codon matrix, from frequencies.
        '''    
        mutsel_model = Model("mutsel", {'state_freqs': self.codon_freqs, 'mu': self.mu})
        true_mat = np.loadtxt("tests/modelFiles/true_mutsel_codonfreq_matrix.txt")
        np.testing.assert_array_almost_equal(mutsel_model.matrix, true_mat, decimal=DECIMAL, err_msg = "MutSel codon matrix not properly constructed via Model call, with provided frequencies.")


    def test_mutsel_codonfit_matrix(self):
        '''
            MutSel codon matrix, from codon fitness.
        '''     
        f = [1.8970215971, 0.567147292 , 1.1228964009, 0.7122141061, 0.4233940575, 0.6770065416, 0.9043122529, 0.1691421405, 0.5353947351, 1.0842023103, 0.642641667 , 1.4094232924, 0.4138358352, 0.5262269065, 0.0417332379, 0.2843622682, 1.2989471804, 0.1747452575, 0.2433260789, 0.3098592594, 0.0072069924, 0.0967470084, 0.5163979361, 0.4849491678, 0.2110091508, 0.0175081305, 0.4557293531, 0.4807273659, 1.786984962 , 1.8028908667, 0.5931107805, 1.1073056689, 1.1337024622, 0.2590742184, 1.0178695245, 0.3371392926, 0.083770607 , 0.715352595 , 1.1424499115, 0.1944330252, 0.6839959301, 0.6078953532, 1.347408841 , 1.5644741946, 1.0742141332, 1.065201616 , 0.0380435509, 0.6261539168, 1.8788676804, 0.1596766738, 0.4200790836, 0.5653116007, 0.8980891102, 0.4304018897, 0.3424052275, 0.2289472162, 0.0204877731, 1.2621947394, 0.3579786845, 0.3383154339, 0.8203637977]
        mutsel_model = Model("mutsel", {'fitness': f, 'mu': self.mu})
        true_mat = np.loadtxt("tests/modelFiles/true_mutsel_codonfit_matrix.txt")
        np.testing.assert_array_almost_equal(mutsel_model.matrix, true_mat, decimal=DECIMAL, err_msg = "MutSel codon matrix not properly constructed via Model call, with provided fitnesses.")


    def test_mutsel_aafit_matrix(self):
        '''
            MutSel codon matrix, from aa fitness.
        '''   
        f = [1.8970215971, 0.567147292 , 1.1228964009, 0.7122141061, 0.4233940575, 0.6770065416, 0.9043122529, 0.1691421405, 0.5353947351, 1.0842023103, 0.642641667 , 1.4094232924, 0.4138358352, 0.5262269065, 0.0417332379, 0.2843622682, 1.2989471804, 0.1747452575, 0.2433260789, 0.3098592594]
        mutsel_model = Model("mutsel", {'fitness': f, 'mu': self.mu})
        true_mat = np.loadtxt("tests/modelFiles/true_mutsel_aafit_matrix.txt")
        np.testing.assert_array_almost_equal(mutsel_model.matrix, true_mat, decimal=DECIMAL, err_msg = "MutSel codon matrix not properly constructed via Model call, with provided fitnesses.")


    def test_mutsel_nucfreq_matrix(self):
        '''
            MutSel nuc matrix, from frequencies.
        '''    
        f = [0.18, 0.22, 0.36, 0.24]
        mutsel_model = Model("mutsel", {'state_freqs': f, 'mu': self.mu})
        true_mat = np.loadtxt("tests/modelFiles/true_mutsel_nucfreq_matrix.txt")
        np.testing.assert_array_almost_equal(mutsel_model.matrix, true_mat, decimal=DECIMAL, err_msg = "MutSel nucleotide matrix not properly constructed via Model call, with provided frequencies.")



    def test_mutsel_nucfit_matrix(self):
        '''
            MutSel nuc matrix, from fitness.
        '''    
        f = [1.5, 2.6, 0.4, 4.5]
        mutsel_model = Model("mutsel", {'fitness': f, 'mu': self.mu})
        true_mat = np.loadtxt("tests/modelFiles/true_mutsel_nucfit_matrix.txt")
        np.testing.assert_array_almost_equal(mutsel_model.matrix, true_mat, decimal=DECIMAL, err_msg = "MutSel nucleotide matrix not properly constructed via Model call, with provided fitnesses.")


   
    def test_ECM_matrix(self):
        '''
            ECM<rest/unrest> matrices.
        '''    
        ecm_model = Model("ecmrest", {'state_freqs':self.codon_freqs, 'k_ti':2.5, 'k_tv':1.5})
        true_ecmmat = np.loadtxt("tests/modelFiles/true_ecmrest_matrix.txt")
        np.testing.assert_array_almost_equal(ecm_model.matrix, true_ecmmat, decimal=DECIMAL, err_msg = "ECMrest matrix not properly constructed via Model call.")

        ecm_model = Model("ecmunrest", {'state_freqs':self.codon_freqs, 'k_ti':2.5, 'k_tv':1.5})
        true_ecmmat = np.loadtxt("tests/modelFiles/true_ecmunrest_matrix.txt")
        np.testing.assert_array_almost_equal(ecm_model.matrix, true_ecmmat, decimal=DECIMAL, err_msg = "ECMunrest matrix not properly constructed via Model call.")



    def test_GYhet_matrices(self):    
        '''
            Heterogeneous GY model with equiprobable categories.
        '''
        params = {"omega": [0.2, 0.8]} 
        truematrix1 = np.loadtxt("tests/modelFiles/scaled_matrix_hetcodon_w0.2.txt")
        truematrix2 = np.loadtxt("tests/modelFiles/scaled_matrix_hetcodon_w0.8.txt")
        model = Model("GY", params)
        np.testing.assert_array_almost_equal(truematrix1, model.matrix[0], decimal = DECIMAL, err_msg = "Matrix improperly constructed for hetero GY codon model.")
        np.testing.assert_array_almost_equal(truematrix2, model.matrix[1], decimal = DECIMAL, err_msg = "Matrix improperly constructed for hetero GY codon model.")
    


    def test_GYhet_uneven_matrices(self):    
        '''
            Heterogeneous GY model with unevenly weighted categories.
        '''
        params = {"omega": [0.2, 0.8]} 
        truematrix1 = np.loadtxt("tests/modelFiles/scaled_matrix_hetcodon_uneven_w0.2.txt")
        truematrix2 = np.loadtxt("tests/modelFiles/scaled_matrix_hetcodon_uneven_w0.8.txt")
        model = Model("GY", params, rate_probs = [0.3, 0.7])
        np.testing.assert_array_almost_equal(truematrix1, model.matrix[0], decimal = DECIMAL, err_msg = "Matrix improperly constructed for hetero GY codon model, uneven probabilities.")
        np.testing.assert_array_almost_equal(truematrix2, model.matrix[1], decimal = DECIMAL, err_msg = "Matrix improperly constructed for hetero GY codon model, uneven probabilties.")
    










class model_hetcodonmodel_tests(unittest.TestCase):
    ''' 
        Suite of tests for Model with user-specified *codon* heterogeneity.
        Tests conducted with GY.
    ''' 
    
    
    def setUp(self):
        
        self.mu_dict       = {'AC':1, 'AG':1, 'AT':1, 'CG':1, 'CT':1, 'GT':1}
        self.codon_freqs   = np.repeat(1./61., 61)


    def test_hetcodonmodel_nummatrices(self):
        '''
            Heterogenous codon model matrix, GY.
        '''    
        gy_model = Model("GY", {'state_freqs':self.codon_freqs, 'mu':self.mu_dict, 'beta':[2.5, 1.5], 'alpha':[1.0, 0.75]})
        
        np.testing.assert_array_almost_equal(gy_model.rate_probs, np.array([0.5, 0.5]), decimal=DECIMAL, err_msg = "incorrect default rate_probs for codon het model.")
        self.assertTrue( len(gy_model.matrix) == 2, msg = "incorrect number of matrices created for a het codon model.")
        self.assertTrue( gy_model.matrix[0].shape == (61,61) and gy_model.matrix[1].shape == (61,61), msg = "incorrect matrix dimensions for codon het model.")

    def test_hetcodonmodel_user_probs(self):
        '''
            Codon het model created properly when probs specified correctly?"
        '''    
        p = np.array([0.9, 0.1])
        gy_model = Model("gy", {'state_freqs':self.codon_freqs, 'mu':self.mu_dict, 'beta':[2.5, 1.5], 'alpha':[1.0, 0.75]}, rate_probs = p)
        
        np.testing.assert_array_almost_equal(gy_model.rate_probs, p, decimal=DECIMAL, err_msg = "incorrect rate_probs for codon het model.")
        self.assertTrue( len(gy_model.matrix) == 2, msg = "incorrect number of matrices created for a het codon model.")
        self.assertTrue( gy_model.matrix[0].shape == (61,61) and gy_model.matrix[1].shape == (61,61), msg = "incorrect matrix dimensions for codon het model.")
        

    def test_hetcodonmodel_badprobs(self):
        '''
            CodonModel created properly when probs specified incorrectly?"
        '''    

        self.failUnlessRaises(AssertionError, Model, "gy", {'state_freqs':self.codon_freqs, 'mu':self.mu_dict, 'beta':[2.5, 1.5], 'alpha':[1.0, 0.75]}, rate_probs = [0.6, 0.9], msg = "Assertion not raised when user-specified codon het model rate_probs sum > 1.")
        self.failUnlessRaises(AssertionError, Model, "gy", {'state_freqs':self.codon_freqs, 'mu':self.mu_dict, 'beta':[2.5, 1.5], 'alpha':[1.0, 0.75]}, rate_probs = [0.5, 0.25, 0.5], msg = "Assertion not raised when user-specified codon het model rate_probs size diff from number of dN/dS values.")

    def test_is_hetcodon_model_true(self):
        '''
            Ensure that we can correctly call heterogeneous codon models as such.
        '''
        model = Model("gy", {'state_freqs':self.codon_freqs, 'mu':self.mu_dict, 'beta':[2.5, 1.5], 'alpha':[1.0, 0.75]})
        self.assertTrue(model.is_hetcodon_model() == True, msg = "Heterogeneous codon model not properly identified as such.")
    

    def test_is_hetcodon_model(self):
        '''
            Ensure that we can correctly call non-codon models as non-codon models.
        '''
        model = Model("gy", {'state_freqs':self.codon_freqs, 'mu':self.mu_dict, 'beta':1.5})
        self.assertTrue(model.is_hetcodon_model() == False, msg = "Homogeneous codon model incorrectly identified as heterogeneous.")
        
    
        
# def run_models_test():
#        
#     run_tests = unittest.TextTestRunner()
# 
#     print "Testing Model construction without site heterogeneity."
#     test_suite_call = unittest.TestLoader().loadTestsFromTestCase(model_nohet_tests)
#     run_tests.run(test_suite_call)
#     
#     print "Testing Model construction with gamma site heterogeneity."
#     test_suite_call = unittest.TestLoader().loadTestsFromTestCase(model_gammahet_tests)
#     run_tests.run(test_suite_call)
# 
#     print "Testing Model construction with user-specified site heterogeneity."
#     test_suite_call = unittest.TestLoader().loadTestsFromTestCase(model_userhet_tests)
#     run_tests.run(test_suite_call)
#          
#     print "Testing CodonModel construction."
#     test_suite_call = unittest.TestLoader().loadTestsFromTestCase(model_codonmodel_tests)
#     run_tests.run(test_suite_call)

         
        
        
        
        
        
        
        
        
