"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import Any, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypeAliasType, TypedDict


class GetCustomerInclude(str, Enum):
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""

    EVENTS = "events"


class GetCustomerRequestTypedDict(TypedDict):
    customer_id: str
    r"""Provide the ID of the related customer."""
    include: NotRequired[Nullable[GetCustomerInclude]]
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetCustomerRequest(BaseModel):
    customer_id: Annotated[
        str,
        pydantic.Field(alias="customerId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related customer."""

    include: Annotated[
        OptionalNullable[GetCustomerInclude],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""This endpoint allows you to include additional information via the `include` query string parameter."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["include", "testmode"]
        nullable_fields = ["include", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetCustomerNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetCustomerNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetCustomerNotFoundLinksTypedDict(TypedDict):
    documentation: GetCustomerNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetCustomerNotFoundLinks(BaseModel):
    documentation: GetCustomerNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetCustomerHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[GetCustomerNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class GetCustomerHalJSONError(ClientError):
    r"""An error response object."""

    data: GetCustomerHalJSONErrorData

    def __init__(
        self,
        data: GetCustomerHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class GetCustomerMode(str, Enum):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class GetCustomerLocale(str, Enum):
    r"""Preconfigure the language to be used in the hosted payment pages shown to the customer. Should only be provided if
    absolutely necessary. If not provided, the browser language will be used which is typically highly accurate.
    """

    EN_US = "en_US"
    EN_GB = "en_GB"
    NL_NL = "nl_NL"
    NL_BE = "nl_BE"
    DE_DE = "de_DE"
    DE_AT = "de_AT"
    DE_CH = "de_CH"
    FR_FR = "fr_FR"
    FR_BE = "fr_BE"
    ES_ES = "es_ES"
    CA_ES = "ca_ES"
    PT_PT = "pt_PT"
    IT_IT = "it_IT"
    NB_NO = "nb_NO"
    SV_SE = "sv_SE"
    FI_FI = "fi_FI"
    DA_DK = "da_DK"
    IS_IS = "is_IS"
    HU_HU = "hu_HU"
    PL_PL = "pl_PL"
    LV_LV = "lv_LV"
    LT_LT = "lt_LT"


GetCustomerMetadataTypedDict = TypeAliasType(
    "GetCustomerMetadataTypedDict", Union[str, Dict[str, Any], List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


GetCustomerMetadata = TypeAliasType(
    "GetCustomerMetadata", Union[str, Dict[str, Any], List[str]]
)
r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
"""


class GetCustomerSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerDashboardTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerDashboard(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerPaymentsTypedDict(TypedDict):
    r"""The API resource URL of the [payments](list-payments) linked to this customer. Omitted if no such payments
    exist (yet).
    """

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerPayments(BaseModel):
    r"""The API resource URL of the [payments](list-payments) linked to this customer. Omitted if no such payments
    exist (yet).
    """

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerMandatesTypedDict(TypedDict):
    r"""The API resource URL of the [mandates](list-mandates) linked to this customer. Omitted if no such mandates
    exist (yet).
    """

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerMandates(BaseModel):
    r"""The API resource URL of the [mandates](list-mandates) linked to this customer. Omitted if no such mandates
    exist (yet).
    """

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerSubscriptionsTypedDict(TypedDict):
    r"""The API resource URL of the [subscriptions](list-subscriptions) linked to this customer. Omitted if no such
    subscriptions exist (yet).
    """

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerSubscriptions(BaseModel):
    r"""The API resource URL of the [subscriptions](list-subscriptions) linked to this customer. Omitted if no such
    subscriptions exist (yet).
    """

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetCustomerLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: GetCustomerSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    dashboard: GetCustomerDashboardTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: GetCustomerDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payments: NotRequired[Nullable[GetCustomerPaymentsTypedDict]]
    r"""The API resource URL of the [payments](list-payments) linked to this customer. Omitted if no such payments
    exist (yet).
    """
    mandates: NotRequired[Nullable[GetCustomerMandatesTypedDict]]
    r"""The API resource URL of the [mandates](list-mandates) linked to this customer. Omitted if no such mandates
    exist (yet).
    """
    subscriptions: NotRequired[Nullable[GetCustomerSubscriptionsTypedDict]]
    r"""The API resource URL of the [subscriptions](list-subscriptions) linked to this customer. Omitted if no such
    subscriptions exist (yet).
    """


class GetCustomerLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[GetCustomerSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    dashboard: GetCustomerDashboard
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: GetCustomerDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payments: OptionalNullable[GetCustomerPayments] = UNSET
    r"""The API resource URL of the [payments](list-payments) linked to this customer. Omitted if no such payments
    exist (yet).
    """

    mandates: OptionalNullable[GetCustomerMandates] = UNSET
    r"""The API resource URL of the [mandates](list-mandates) linked to this customer. Omitted if no such mandates
    exist (yet).
    """

    subscriptions: OptionalNullable[GetCustomerSubscriptions] = UNSET
    r"""The API resource URL of the [subscriptions](list-subscriptions) linked to this customer. Omitted if no such
    subscriptions exist (yet).
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["payments", "mandates", "subscriptions"]
        nullable_fields = ["payments", "mandates", "subscriptions"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class URLTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class URL(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class EventLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    url: NotRequired[URLTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EventLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    url: Optional[URL] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class EventTypedDict(TypedDict):
    resource: str
    type: int
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    message: str
    links: NotRequired[EventLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class Event(BaseModel):
    resource: str

    type: int

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    message: str

    links: Annotated[Optional[EventLinks], pydantic.Field(alias="_links")] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetCustomerResponseTypedDict(TypedDict):
    r"""The customer object."""

    resource: str
    r"""Indicates the response contains a customer object. Will always contain the string `customer` for this endpoint."""
    id: str
    r"""The identifier uniquely referring to this customer. Example: `cst_vsKJpSsabw`."""
    mode: GetCustomerMode
    r"""Whether this entity was created in live mode or in test mode."""
    name: Nullable[str]
    r"""The full name of the customer."""
    email: Nullable[str]
    r"""The email address of the customer."""
    locale: Nullable[GetCustomerLocale]
    r"""Preconfigure the language to be used in the hosted payment pages shown to the customer. Should only be provided if
    absolutely necessary. If not provided, the browser language will be used which is typically highly accurate.
    """
    metadata: Nullable[GetCustomerMetadataTypedDict]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    links: GetCustomerLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    events: NotRequired[List[EventTypedDict]]


class GetCustomerResponse(BaseModel):
    r"""The customer object."""

    resource: str
    r"""Indicates the response contains a customer object. Will always contain the string `customer` for this endpoint."""

    id: str
    r"""The identifier uniquely referring to this customer. Example: `cst_vsKJpSsabw`."""

    mode: GetCustomerMode
    r"""Whether this entity was created in live mode or in test mode."""

    name: Nullable[str]
    r"""The full name of the customer."""

    email: Nullable[str]
    r"""The email address of the customer."""

    locale: Nullable[GetCustomerLocale]
    r"""Preconfigure the language to be used in the hosted payment pages shown to the customer. Should only be provided if
    absolutely necessary. If not provided, the browser language will be used which is typically highly accurate.
    """

    metadata: Nullable[GetCustomerMetadata]
    r"""Provide any data you like, for example a string or a JSON object. We will save the data alongside the entity. Whenever
    you fetch the entity with our API, we will also include the metadata. You can use up to approximately 1kB.
    """

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    links: Annotated[GetCustomerLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    events: Optional[List[Event]] = None

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["events"]
        nullable_fields = ["name", "email", "locale", "metadata"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
