"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Any, Dict, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GetNextSettlementStatus(str, Enum):
    r"""The status of the settlement."""

    OPEN = "open"
    PENDING = "pending"
    PAIDOUT = "paidout"
    FAILED = "failed"


class GetNextSettlementAmountTypedDict(TypedDict):
    r"""The total amount of the settlement."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetNextSettlementAmount(BaseModel):
    r"""The total amount of the settlement."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class GetNextSettlementSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetNextSettlementSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetNextSettlementPaymentsTypedDict(TypedDict):
    r"""The API resource URL of the [payments](list-payments) included in this settlement."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetNextSettlementPayments(BaseModel):
    r"""The API resource URL of the [payments](list-payments) included in this settlement."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetNextSettlementCapturesTypedDict(TypedDict):
    r"""The API resource URL of the [captures](list-captures) included in this settlement."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetNextSettlementCaptures(BaseModel):
    r"""The API resource URL of the [captures](list-captures) included in this settlement."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetNextSettlementRefundsTypedDict(TypedDict):
    r"""The API resource URL of the [refunds](list-refunds) deducted from this settlement."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetNextSettlementRefunds(BaseModel):
    r"""The API resource URL of the [refunds](list-refunds) deducted from this settlement."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetNextSettlementChargebacksTypedDict(TypedDict):
    r"""The API resource URL of the [chargebacks](list-chargebacks) deducted from this settlement."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetNextSettlementChargebacks(BaseModel):
    r"""The API resource URL of the [chargebacks](list-chargebacks) deducted from this settlement."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetNextSettlementInvoiceTypedDict(TypedDict):
    r"""The API resource URL of the [invoice](list-invoices)."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class GetNextSettlementInvoice(BaseModel):
    r"""The API resource URL of the [invoice](list-invoices)."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class GetNextSettlementDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetNextSettlementDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetNextSettlementLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetNextSettlementSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payments: NotRequired[GetNextSettlementPaymentsTypedDict]
    r"""The API resource URL of the [payments](list-payments) included in this settlement."""
    captures: NotRequired[GetNextSettlementCapturesTypedDict]
    r"""The API resource URL of the [captures](list-captures) included in this settlement."""
    refunds: NotRequired[GetNextSettlementRefundsTypedDict]
    r"""The API resource URL of the [refunds](list-refunds) deducted from this settlement."""
    chargebacks: NotRequired[GetNextSettlementChargebacksTypedDict]
    r"""The API resource URL of the [chargebacks](list-chargebacks) deducted from this settlement."""
    invoice: NotRequired[Nullable[GetNextSettlementInvoiceTypedDict]]
    r"""The API resource URL of the [invoice](list-invoices)."""
    documentation: NotRequired[GetNextSettlementDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetNextSettlementLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetNextSettlementSelf], pydantic.Field(alias="self")] = (
        None
    )
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payments: Optional[GetNextSettlementPayments] = None
    r"""The API resource URL of the [payments](list-payments) included in this settlement."""

    captures: Optional[GetNextSettlementCaptures] = None
    r"""The API resource URL of the [captures](list-captures) included in this settlement."""

    refunds: Optional[GetNextSettlementRefunds] = None
    r"""The API resource URL of the [refunds](list-refunds) deducted from this settlement."""

    chargebacks: Optional[GetNextSettlementChargebacks] = None
    r"""The API resource URL of the [chargebacks](list-chargebacks) deducted from this settlement."""

    invoice: OptionalNullable[GetNextSettlementInvoice] = UNSET
    r"""The API resource URL of the [invoice](list-invoices)."""

    documentation: Optional[GetNextSettlementDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "self",
            "payments",
            "captures",
            "refunds",
            "chargebacks",
            "invoice",
            "documentation",
        ]
        nullable_fields = ["invoice"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetNextSettlementResponseTypedDict(TypedDict):
    r"""The next settlement object. For a complete reference of the settlement object, refer to the
    [Get settlement](get-settlement) endpoint documentation.
    """

    resource: NotRequired[str]
    r"""Indicates the response contains a settlement object. Will always contain the string `settlement` for this
    endpoint.
    """
    id: NotRequired[str]
    r"""The identifier uniquely referring to this settlement."""
    created_at: NotRequired[str]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    reference: NotRequired[Nullable[str]]
    r"""The settlement's bank reference, as found in your Mollie account and on your bank statement."""
    settled_at: NotRequired[Nullable[str]]
    r"""The date on which the settlement was settled, in ISO 8601 format.

    For an [open settlement](get-open-settlement) or for the [next settlement](get-next-settlement), no settlement
    date is available.
    """
    status: NotRequired[GetNextSettlementStatus]
    r"""The status of the settlement."""
    amount: NotRequired[GetNextSettlementAmountTypedDict]
    r"""The total amount of the settlement."""
    balance_id: NotRequired[str]
    r"""The balance token that the settlement was settled to."""
    invoice_id: NotRequired[Nullable[str]]
    r"""The ID of the oldest invoice created for all the periods, if the invoice has been created yet."""
    periods: NotRequired[Dict[str, Any]]
    r"""For bookkeeping purposes, the settlement includes an overview of transactions included in the settlement. These
    transactions are grouped into 'period' objects — one for each calendar month.

    For example, if a settlement includes funds from 15 April until 4 May, it will include two period objects. One for
    all transactions processed between 15 April and 30 April, and one for all transactions between 1 May and 4 May.

    Period objects are grouped by year, and then by month. So in the above example, the full `periods` collection will
    look as follows: `{\"2024\": {\"04\": {...}, \"05\": {...}}}`. The year and month in this documentation are referred as `<year>` and `<month>`.

    The example response should give a good idea of what this looks like in practise.
    """
    links: NotRequired[GetNextSettlementLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetNextSettlementResponse(BaseModel):
    r"""The next settlement object. For a complete reference of the settlement object, refer to the
    [Get settlement](get-settlement) endpoint documentation.
    """

    resource: Optional[str] = None
    r"""Indicates the response contains a settlement object. Will always contain the string `settlement` for this
    endpoint.
    """

    id: Optional[str] = None
    r"""The identifier uniquely referring to this settlement."""

    created_at: Annotated[Optional[str], pydantic.Field(alias="createdAt")] = None
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    reference: OptionalNullable[str] = UNSET
    r"""The settlement's bank reference, as found in your Mollie account and on your bank statement."""

    settled_at: Annotated[OptionalNullable[str], pydantic.Field(alias="settledAt")] = (
        UNSET
    )
    r"""The date on which the settlement was settled, in ISO 8601 format.

    For an [open settlement](get-open-settlement) or for the [next settlement](get-next-settlement), no settlement
    date is available.
    """

    status: Optional[GetNextSettlementStatus] = None
    r"""The status of the settlement."""

    amount: Optional[GetNextSettlementAmount] = None
    r"""The total amount of the settlement."""

    balance_id: Annotated[Optional[str], pydantic.Field(alias="balanceId")] = None
    r"""The balance token that the settlement was settled to."""

    invoice_id: Annotated[OptionalNullable[str], pydantic.Field(alias="invoiceId")] = (
        UNSET
    )
    r"""The ID of the oldest invoice created for all the periods, if the invoice has been created yet."""

    periods: Optional[Dict[str, Any]] = None
    r"""For bookkeeping purposes, the settlement includes an overview of transactions included in the settlement. These
    transactions are grouped into 'period' objects — one for each calendar month.

    For example, if a settlement includes funds from 15 April until 4 May, it will include two period objects. One for
    all transactions processed between 15 April and 30 April, and one for all transactions between 1 May and 4 May.

    Period objects are grouped by year, and then by month. So in the above example, the full `periods` collection will
    look as follows: `{\"2024\": {\"04\": {...}, \"05\": {...}}}`. The year and month in this documentation are referred as `<year>` and `<month>`.

    The example response should give a good idea of what this looks like in practise.
    """

    links: Annotated[
        Optional[GetNextSettlementLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "resource",
            "id",
            "createdAt",
            "reference",
            "settledAt",
            "status",
            "amount",
            "balanceId",
            "invoiceId",
            "periods",
            "_links",
        ]
        nullable_fields = ["reference", "settledAt", "invoiceId"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
