"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class ListPaymentLinksRequestTypedDict(TypedDict):
    from_: NotRequired[str]
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """
    limit: NotRequired[Nullable[int]]
    r"""The maximum number of items to return. Defaults to 50 items."""
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class ListPaymentLinksRequest(BaseModel):
    from_: Annotated[
        Optional[str],
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = None
    r"""Provide an ID to start the result set from the item with the given ID and onwards. This allows you to paginate the
    result set.
    """

    limit: Annotated[
        OptionalNullable[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""The maximum number of items to return. Defaults to 50 items."""

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["from", "limit", "testmode"]
        nullable_fields = ["limit", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListPaymentLinksBadRequestDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class ListPaymentLinksBadRequestDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class ListPaymentLinksBadRequestLinksTypedDict(TypedDict):
    documentation: ListPaymentLinksBadRequestDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class ListPaymentLinksBadRequestLinks(BaseModel):
    documentation: ListPaymentLinksBadRequestDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class ListPaymentLinksHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[ListPaymentLinksBadRequestLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class ListPaymentLinksHalJSONError(ClientError):
    r"""An error response object."""

    data: ListPaymentLinksHalJSONErrorData

    def __init__(
        self,
        data: ListPaymentLinksHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class ListPaymentLinksMode(str, Enum):
    r"""Whether this entity was created in live mode or in test mode."""

    LIVE = "live"
    TEST = "test"


class ListPaymentLinksAmountTypedDict(TypedDict):
    r"""The amount of the payment link. If no amount is provided initially, the customer will be prompted to enter an
    amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListPaymentLinksAmount(BaseModel):
    r"""The amount of the payment link. If no amount is provided initially, the customer will be prompted to enter an
    amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListPaymentLinksMinimumAmountTypedDict(TypedDict):
    r"""The minimum amount of the payment link. This property is only allowed when there is no amount provided. The
    customer will be prompted to enter a value greater than or equal to the minimum amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListPaymentLinksMinimumAmount(BaseModel):
    r"""The minimum amount of the payment link. This property is only allowed when there is no amount provided. The
    customer will be prompted to enter a value greater than or equal to the minimum amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListPaymentLinksType(str, Enum):
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.
    """

    PHYSICAL = "physical"
    DIGITAL = "digital"
    SHIPPING_FEE = "shipping_fee"
    DISCOUNT = "discount"
    STORE_CREDIT = "store_credit"
    GIFT_CARD = "gift_card"
    SURCHARGE = "surcharge"
    TIP = "tip"


class ListPaymentLinksUnitPriceTypedDict(TypedDict):
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListPaymentLinksUnitPrice(BaseModel):
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListPaymentLinksDiscountAmountTypedDict(TypedDict):
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount
    type.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListPaymentLinksDiscountAmount(BaseModel):
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount
    type.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListPaymentLinksTotalAmountTypedDict(TypedDict):
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListPaymentLinksTotalAmount(BaseModel):
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListPaymentLinksVatAmountTypedDict(TypedDict):
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be
    calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of
    `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListPaymentLinksVatAmount(BaseModel):
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be
    calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of
    `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListPaymentLinksCategory(str, Enum):
    MEAL = "meal"
    ECO = "eco"
    GIFT = "gift"
    SPORT_CULTURE = "sport_culture"


class ListPaymentLinksLineTypedDict(TypedDict):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""
    quantity: int
    r"""The number of items."""
    unit_price: ListPaymentLinksUnitPriceTypedDict
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """
    total_amount: ListPaymentLinksTotalAmountTypedDict
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """
    type: NotRequired[ListPaymentLinksType]
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.
    """
    quantity_unit: NotRequired[str]
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""
    discount_amount: NotRequired[ListPaymentLinksDiscountAmountTypedDict]
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount
    type.
    """
    vat_rate: NotRequired[str]
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and
    not as a float, to ensure the correct number of decimals are passed.
    """
    vat_amount: NotRequired[ListPaymentLinksVatAmountTypedDict]
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be
    calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of
    `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """
    sku: NotRequired[str]
    r"""The SKU, EAN, ISBN or UPC of the product sold."""
    categories: NotRequired[List[ListPaymentLinksCategory]]
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the
    [Integrating Vouchers](https://docs.mollie.com/docs/integrating-vouchers/) guide for more information.
    """
    image_url: NotRequired[str]
    r"""A link pointing to an image of the product sold."""
    product_url: NotRequired[str]
    r"""A link pointing to the product page in your web shop of the product sold."""


class ListPaymentLinksLine(BaseModel):
    description: str
    r"""A description of the line item. For example *LEGO 4440 Forest Police Station*."""

    quantity: int
    r"""The number of items."""

    unit_price: Annotated[ListPaymentLinksUnitPrice, pydantic.Field(alias="unitPrice")]
    r"""The price of a single item including VAT.

    For example: `{\"currency\":\"EUR\", \"value\":\"89.00\"}` if the box of LEGO costs €89.00 each.

    For types `discount`, `store_credit`, and `gift_card`, the unit price must be negative.

    The unit price can be zero in case of free items.
    """

    total_amount: Annotated[
        ListPaymentLinksTotalAmount, pydantic.Field(alias="totalAmount")
    ]
    r"""The total amount of the line, including VAT and discounts.

    Should match the following formula: `(unitPrice × quantity) - discountAmount`.

    The sum of all `totalAmount` values of all order lines should be equal to the full payment amount.
    """

    type: Optional[ListPaymentLinksType] = None
    r"""The type of product purchased. For example, a physical or a digital product.

    The `tip` payment line type is not available when creating a payment.
    """

    quantity_unit: Annotated[Optional[str], pydantic.Field(alias="quantityUnit")] = None
    r"""The unit for the quantity. For example *pcs*, *kg*, or *cm*."""

    discount_amount: Annotated[
        Optional[ListPaymentLinksDiscountAmount], pydantic.Field(alias="discountAmount")
    ] = None
    r"""Any line-specific discounts, as a positive amount. Not relevant if the line itself is already a discount
    type.
    """

    vat_rate: Annotated[Optional[str], pydantic.Field(alias="vatRate")] = None
    r"""The VAT rate applied to the line, for example `21.00` for 21%. The vatRate should be passed as a string and
    not as a float, to ensure the correct number of decimals are passed.
    """

    vat_amount: Annotated[
        Optional[ListPaymentLinksVatAmount], pydantic.Field(alias="vatAmount")
    ] = None
    r"""The amount of value-added tax on the line. The `totalAmount` field includes VAT, so the `vatAmount` can be
    calculated with the formula `totalAmount × (vatRate / (100 + vatRate))`.

    Any deviations from this will result in an error.

    For example, for a `totalAmount` of SEK 100.00 with a 25.00% VAT rate, we expect a VAT amount of
    `SEK 100.00 × (25 / 125) = SEK 20.00`.
    """

    sku: Optional[str] = None
    r"""The SKU, EAN, ISBN or UPC of the product sold."""

    categories: Optional[List[ListPaymentLinksCategory]] = None
    r"""An array with the voucher categories, in case of a line eligible for a voucher. See the
    [Integrating Vouchers](https://docs.mollie.com/docs/integrating-vouchers/) guide for more information.
    """

    image_url: Annotated[Optional[str], pydantic.Field(alias="imageUrl")] = None
    r"""A link pointing to an image of the product sold."""

    product_url: Annotated[Optional[str], pydantic.Field(alias="productUrl")] = None
    r"""A link pointing to the product page in your web shop of the product sold."""


class ListPaymentLinksBillingAddressTypedDict(TypedDict):
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """

    title: NotRequired[str]
    r"""The title of the person, for example *Mr.* or *Mrs.*."""
    given_name: NotRequired[str]
    r"""The given name (first name) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    family_name: NotRequired[str]
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    organization_name: NotRequired[str]
    r"""The name of the organization, in case the addressee is an organization."""
    street_and_number: NotRequired[str]
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    street_additional: NotRequired[str]
    r"""Any additional addressing details, for example an apartment number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    email: NotRequired[str]
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions
    email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    phone: NotRequired[str]
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""
    city: NotRequired[str]
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    region: NotRequired[str]
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""
    country: NotRequired[str]
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class ListPaymentLinksBillingAddress(BaseModel):
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """

    title: Optional[str] = None
    r"""The title of the person, for example *Mr.* or *Mrs.*."""

    given_name: Annotated[Optional[str], pydantic.Field(alias="givenName")] = None
    r"""The given name (first name) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    family_name: Annotated[Optional[str], pydantic.Field(alias="familyName")] = None
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    organization_name: Annotated[
        Optional[str], pydantic.Field(alias="organizationName")
    ] = None
    r"""The name of the organization, in case the addressee is an organization."""

    street_and_number: Annotated[
        Optional[str], pydantic.Field(alias="streetAndNumber")
    ] = None
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    street_additional: Annotated[
        Optional[str], pydantic.Field(alias="streetAdditional")
    ] = None
    r"""Any additional addressing details, for example an apartment number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    email: Optional[str] = None
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions
    email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    phone: Optional[str] = None
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""

    city: Optional[str] = None
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    region: Optional[str] = None
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""

    country: Optional[str] = None
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class ListPaymentLinksShippingAddressTypedDict(TypedDict):
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.
    """

    title: NotRequired[str]
    r"""The title of the person, for example *Mr.* or *Mrs.*."""
    given_name: NotRequired[str]
    r"""The given name (first name) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    family_name: NotRequired[str]
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    organization_name: NotRequired[str]
    r"""The name of the organization, in case the addressee is an organization."""
    street_and_number: NotRequired[str]
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    street_additional: NotRequired[str]
    r"""Any additional addressing details, for example an apartment number."""
    postal_code: NotRequired[str]
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    email: NotRequired[str]
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions
    email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    phone: NotRequired[str]
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""
    city: NotRequired[str]
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """
    region: NotRequired[str]
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""
    country: NotRequired[str]
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class ListPaymentLinksShippingAddress(BaseModel):
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.
    """

    title: Optional[str] = None
    r"""The title of the person, for example *Mr.* or *Mrs.*."""

    given_name: Annotated[Optional[str], pydantic.Field(alias="givenName")] = None
    r"""The given name (first name) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    family_name: Annotated[Optional[str], pydantic.Field(alias="familyName")] = None
    r"""The given family name (surname) of the person should be at least two characters and cannot contain only
    numbers.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    organization_name: Annotated[
        Optional[str], pydantic.Field(alias="organizationName")
    ] = None
    r"""The name of the organization, in case the addressee is an organization."""

    street_and_number: Annotated[
        Optional[str], pydantic.Field(alias="streetAndNumber")
    ] = None
    r"""A street and street number.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    street_additional: Annotated[
        Optional[str], pydantic.Field(alias="streetAdditional")
    ] = None
    r"""Any additional addressing details, for example an apartment number."""

    postal_code: Annotated[Optional[str], pydantic.Field(alias="postalCode")] = None
    r"""A postal code. This field may be required if the provided country has a postal code system.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    email: Optional[str] = None
    r"""A valid e-mail address.

    If you provide the email address for a `banktransfer` payment, we will automatically send the instructions
    email upon payment creation. The language of the email will follow the locale parameter of the payment.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    phone: Optional[str] = None
    r"""If provided, it must be in the [E.164](https://en.wikipedia.org/wiki/E.164) format. For example: +31208202070."""

    city: Optional[str] = None
    r"""A city name.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """

    region: Optional[str] = None
    r"""The top-level administrative subdivision of the country. For example: Noord-Holland."""

    country: Optional[str] = None
    r"""A country code in [ISO 3166-1 alpha-2](https://en.wikipedia.org/wiki/ISO_3166-1_alpha-2) format.

    Required for payment methods `billie`, `in3`, `klarna` and `riverty`.
    """


class ListPaymentLinksApplicationFeeAmountTypedDict(TypedDict):
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge
    a €0.99 fee on a €1.00 payment.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListPaymentLinksApplicationFeeAmount(BaseModel):
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge
    a €0.99 fee on a €1.00 payment.
    """

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ListPaymentLinksApplicationFeeTypedDict(TypedDict):
    r"""With Mollie Connect you can charge fees on payment links that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payment links on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If a payment on the payment link succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.
    """

    amount: ListPaymentLinksApplicationFeeAmountTypedDict
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge
    a €0.99 fee on a €1.00 payment.
    """
    description: str
    r"""The description of the application fee. This will appear on settlement reports towards both you and the
    connected merchant.
    """


class ListPaymentLinksApplicationFee(BaseModel):
    r"""With Mollie Connect you can charge fees on payment links that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payment links on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If a payment on the payment link succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.
    """

    amount: ListPaymentLinksApplicationFeeAmount
    r"""The fee that you wish to charge.

    Be careful to leave enough space for Mollie's own fees to be deducted as well. For example, you cannot charge
    a €0.99 fee on a €1.00 payment.
    """

    description: str
    r"""The description of the application fee. This will appear on settlement reports towards both you and the
    connected merchant.
    """


class ListPaymentLinksSequenceType(str, Enum):
    r"""If set to `first`, a payment mandate is established right after a payment is made by the customer.

    Defaults to `oneoff`, which is a regular payment link and will not establish a mandate after payment.

    The mandate ID can be retrieved by making a call to the
    [Payment Link Payments Endpoint](get-payment-link-payments).
    """

    ONEOFF = "oneoff"
    FIRST = "first"


class PaymentLinkSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class PaymentLinkSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListPaymentLinksLinksPaymentLinkTypedDict(TypedDict):
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListPaymentLinksLinksPaymentLink(BaseModel):
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class PaymentLinkLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: PaymentLinkSelfTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    payment_link: ListPaymentLinksLinksPaymentLinkTypedDict
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""


class PaymentLinkLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[PaymentLinkSelf, pydantic.Field(alias="self")]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    payment_link: Annotated[
        ListPaymentLinksLinksPaymentLink, pydantic.Field(alias="paymentLink")
    ]
    r"""The URL your customer should visit to make the payment. This is where you should redirect the customer to."""


class ListPaymentLinksPaymentLinkOutputTypedDict(TypedDict):
    resource: str
    r"""Indicates the response contains a payment link object. Will always contain the string `payment-link` for this
    endpoint.
    """
    id: str
    r"""The identifier uniquely referring to this payment link. Example: `pl_4Y0eZitmBnQ6IDoMqZQKh`."""
    mode: ListPaymentLinksMode
    r"""Whether this entity was created in live mode or in test mode."""
    description: str
    r"""A short description of the payment link. The description is visible in the Dashboard and will be shown on the
    customer's bank or card statement when possible.
    """
    amount: Nullable[ListPaymentLinksAmountTypedDict]
    r"""The amount of the payment link. If no amount is provided initially, the customer will be prompted to enter an
    amount.
    """
    archived: bool
    r"""Whether the payment link is archived. Customers will not be able to complete payments on archived payment links."""
    redirect_url: Nullable[str]
    r"""The URL your customer will be redirected to after completing the payment process. If no redirect URL is provided,
    the customer will be shown a generic message after completing the payment.
    """
    webhook_url: Nullable[str]
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to any payments
    resulting from the payment link.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use
    webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your
    local machine.
    """
    profile_id: Nullable[str]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """
    reusable: Nullable[bool]
    r"""Indicates whether the payment link is reusable. If this field is set to `true`, customers can make multiple
    payments using the same link.

    If no value is specified, the field defaults to `false`, allowing only a single payment per link.
    """
    created_at: str
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""
    paid_at: Nullable[str]
    r"""The date and time the payment link became paid, in ISO 8601 format."""
    expires_at: Nullable[str]
    r"""The date and time the payment link is set to expire, in ISO 8601 format. If no expiry date was provided up front,
    the payment link will not expire automatically.
    """
    allowed_methods: Nullable[List[str]]
    r"""An array of payment methods that are allowed to be used for this payment link. When this parameter is
    not provided or is an empty array, all enabled payment methods will be available.

    Enum: 'applepay', 'bancomatpay', 'bancontact', 'banktransfer', 'belfius', 'blik', 'creditcard', 'eps', 'giftcard',
    'ideal', 'kbc', 'mybank', 'paybybank', 'paypal', 'paysafecard', 'pointofsale', 'przelewy24', 'satispay', 'trustly', 'twint',
    'in3', 'riverty', 'klarna', 'billie'.
    """
    links: PaymentLinkLinksTypedDict
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
    minimum_amount: NotRequired[Nullable[ListPaymentLinksMinimumAmountTypedDict]]
    r"""The minimum amount of the payment link. This property is only allowed when there is no amount provided. The
    customer will be prompted to enter a value greater than or equal to the minimum amount.
    """
    lines: NotRequired[Nullable[List[ListPaymentLinksLineTypedDict]]]
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """
    billing_address: NotRequired[ListPaymentLinksBillingAddressTypedDict]
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """
    shipping_address: NotRequired[ListPaymentLinksShippingAddressTypedDict]
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.
    """
    application_fee: NotRequired[ListPaymentLinksApplicationFeeTypedDict]
    r"""With Mollie Connect you can charge fees on payment links that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payment links on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If a payment on the payment link succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.
    """
    sequence_type: NotRequired[Nullable[ListPaymentLinksSequenceType]]
    r"""If set to `first`, a payment mandate is established right after a payment is made by the customer.

    Defaults to `oneoff`, which is a regular payment link and will not establish a mandate after payment.

    The mandate ID can be retrieved by making a call to the
    [Payment Link Payments Endpoint](get-payment-link-payments).
    """
    customer_id: NotRequired[Nullable[str]]
    r"""**Only relevant when `sequenceType` is set to `first`**

    The ID of the [customer](get-customer) the payment link is being created for. If a value is not provided,
    the customer will be required to input relevant information which will be used to establish a mandate after
    the payment is made.
    """


class ListPaymentLinksPaymentLinkOutput(BaseModel):
    resource: str
    r"""Indicates the response contains a payment link object. Will always contain the string `payment-link` for this
    endpoint.
    """

    id: str
    r"""The identifier uniquely referring to this payment link. Example: `pl_4Y0eZitmBnQ6IDoMqZQKh`."""

    mode: ListPaymentLinksMode
    r"""Whether this entity was created in live mode or in test mode."""

    description: str
    r"""A short description of the payment link. The description is visible in the Dashboard and will be shown on the
    customer's bank or card statement when possible.
    """

    amount: Nullable[ListPaymentLinksAmount]
    r"""The amount of the payment link. If no amount is provided initially, the customer will be prompted to enter an
    amount.
    """

    archived: bool
    r"""Whether the payment link is archived. Customers will not be able to complete payments on archived payment links."""

    redirect_url: Annotated[Nullable[str], pydantic.Field(alias="redirectUrl")]
    r"""The URL your customer will be redirected to after completing the payment process. If no redirect URL is provided,
    the customer will be shown a generic message after completing the payment.
    """

    webhook_url: Annotated[Nullable[str], pydantic.Field(alias="webhookUrl")]
    r"""The webhook URL where we will send payment status updates to.

    The webhookUrl is optional, but without a webhook you will miss out on important status changes to any payments
    resulting from the payment link.

    The webhookUrl must be reachable from Mollie's point of view, so you cannot use `localhost`. If you want to use
    webhook during development on `localhost`, you must use a tool like ngrok to have the webhooks delivered to your
    local machine.
    """

    profile_id: Annotated[Nullable[str], pydantic.Field(alias="profileId")]
    r"""The identifier referring to the [profile](get-profile) this entity belongs to.

    Most API credentials are linked to a single profile. In these cases the `profileId` can be omitted in the creation
    request. For organization-level credentials such as OAuth access tokens however, the `profileId` parameter is
    required.
    """

    reusable: Nullable[bool]
    r"""Indicates whether the payment link is reusable. If this field is set to `true`, customers can make multiple
    payments using the same link.

    If no value is specified, the field defaults to `false`, allowing only a single payment per link.
    """

    created_at: Annotated[str, pydantic.Field(alias="createdAt")]
    r"""The entity's date and time of creation, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601) format."""

    paid_at: Annotated[Nullable[str], pydantic.Field(alias="paidAt")]
    r"""The date and time the payment link became paid, in ISO 8601 format."""

    expires_at: Annotated[Nullable[str], pydantic.Field(alias="expiresAt")]
    r"""The date and time the payment link is set to expire, in ISO 8601 format. If no expiry date was provided up front,
    the payment link will not expire automatically.
    """

    allowed_methods: Annotated[
        Nullable[List[str]], pydantic.Field(alias="allowedMethods")
    ]
    r"""An array of payment methods that are allowed to be used for this payment link. When this parameter is
    not provided or is an empty array, all enabled payment methods will be available.

    Enum: 'applepay', 'bancomatpay', 'bancontact', 'banktransfer', 'belfius', 'blik', 'creditcard', 'eps', 'giftcard',
    'ideal', 'kbc', 'mybank', 'paybybank', 'paypal', 'paysafecard', 'pointofsale', 'przelewy24', 'satispay', 'trustly', 'twint',
    'in3', 'riverty', 'klarna', 'billie'.
    """

    links: Annotated[PaymentLinkLinks, pydantic.Field(alias="_links")]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    minimum_amount: Annotated[
        OptionalNullable[ListPaymentLinksMinimumAmount],
        pydantic.Field(alias="minimumAmount"),
    ] = UNSET
    r"""The minimum amount of the payment link. This property is only allowed when there is no amount provided. The
    customer will be prompted to enter a value greater than or equal to the minimum amount.
    """

    lines: OptionalNullable[List[ListPaymentLinksLine]] = UNSET
    r"""Optionally provide the order lines for the payment. Each line contains details such as a description of the item
    ordered and its price.

    All lines must have the same currency as the payment.

    Required for payment methods `billie`, `in3`, `klarna`, `riverty` and `voucher`.
    """

    billing_address: Annotated[
        Optional[ListPaymentLinksBillingAddress], pydantic.Field(alias="billingAddress")
    ] = None
    r"""The customer's billing address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.

    Required for payment method `in3`, `klarna`, `billie` and `riverty`.
    """

    shipping_address: Annotated[
        Optional[ListPaymentLinksShippingAddress],
        pydantic.Field(alias="shippingAddress"),
    ] = None
    r"""The customer's shipping address details. We advise to provide these details to improve fraud protection and
    conversion.

    Should include `email` or a valid postal address consisting of `streetAndNumber`, `postalCode`, `city` and
    `country`.
    """

    application_fee: Annotated[
        Optional[ListPaymentLinksApplicationFee], pydantic.Field(alias="applicationFee")
    ] = None
    r"""With Mollie Connect you can charge fees on payment links that your app is processing on behalf of other Mollie
    merchants.

    If you use OAuth to create payment links on a connected merchant's account, you can charge a fee using this
    `applicationFee` parameter. If a payment on the payment link succeeds, the fee will be deducted from the merchant's balance and sent
    to your own account balance.
    """

    sequence_type: Annotated[
        OptionalNullable[ListPaymentLinksSequenceType],
        pydantic.Field(alias="sequenceType"),
    ] = UNSET
    r"""If set to `first`, a payment mandate is established right after a payment is made by the customer.

    Defaults to `oneoff`, which is a regular payment link and will not establish a mandate after payment.

    The mandate ID can be retrieved by making a call to the
    [Payment Link Payments Endpoint](get-payment-link-payments).
    """

    customer_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="customerId")
    ] = UNSET
    r"""**Only relevant when `sequenceType` is set to `first`**

    The ID of the [customer](get-customer) the payment link is being created for. If a value is not provided,
    the customer will be required to input relevant information which will be used to establish a mandate after
    the payment is made.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "minimumAmount",
            "lines",
            "billingAddress",
            "shippingAddress",
            "applicationFee",
            "sequenceType",
            "customerId",
        ]
        nullable_fields = [
            "amount",
            "minimumAmount",
            "redirectUrl",
            "webhookUrl",
            "lines",
            "profileId",
            "reusable",
            "paidAt",
            "expiresAt",
            "allowedMethods",
            "sequenceType",
            "customerId",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListPaymentLinksEmbeddedTypedDict(TypedDict):
    payment_links: NotRequired[List[ListPaymentLinksPaymentLinkOutputTypedDict]]
    r"""An array of payment link objects."""


class ListPaymentLinksEmbedded(BaseModel):
    payment_links: Optional[List[ListPaymentLinksPaymentLinkOutput]] = None
    r"""An array of payment link objects."""


class ListPaymentLinksSelfTypedDict(TypedDict):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListPaymentLinksSelf(BaseModel):
    r"""The URL to the current set of items."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListPaymentLinksPreviousTypedDict(TypedDict):
    r"""The previous set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListPaymentLinksPrevious(BaseModel):
    r"""The previous set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListPaymentLinksNextTypedDict(TypedDict):
    r"""The next set of items, if available."""

    href: NotRequired[str]
    r"""The actual URL string."""
    type: NotRequired[str]
    r"""The content type of the page or endpoint the URL points to."""


class ListPaymentLinksNext(BaseModel):
    r"""The next set of items, if available."""

    href: Optional[str] = None
    r"""The actual URL string."""

    type: Optional[str] = None
    r"""The content type of the page or endpoint the URL points to."""


class ListPaymentLinksDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListPaymentLinksDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class ListPaymentLinksLinksTypedDict(TypedDict):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: ListPaymentLinksSelfTypedDict
    r"""The URL to the current set of items."""
    previous: Nullable[ListPaymentLinksPreviousTypedDict]
    r"""The previous set of items, if available."""
    next: Nullable[ListPaymentLinksNextTypedDict]
    r"""The next set of items, if available."""
    documentation: ListPaymentLinksDocumentationTypedDict
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class ListPaymentLinksLinks(BaseModel):
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[ListPaymentLinksSelf, pydantic.Field(alias="self")]
    r"""The URL to the current set of items."""

    previous: Nullable[ListPaymentLinksPrevious]
    r"""The previous set of items, if available."""

    next: Nullable[ListPaymentLinksNext]
    r"""The next set of items, if available."""

    documentation: ListPaymentLinksDocumentation
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = []
        nullable_fields = ["previous", "next"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ListPaymentLinksResponseTypedDict(TypedDict):
    r"""A list of payment link objects."""

    count: int
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """
    embedded: ListPaymentLinksEmbeddedTypedDict
    links: ListPaymentLinksLinksTypedDict
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""


class ListPaymentLinksResponse(BaseModel):
    r"""A list of payment link objects."""

    count: int
    r"""The number of items in this result set. If more items are available, a `_links.next` URL will be present in the result
    as well.

    The maximum number of items per result set is controlled by the `limit` property provided in the request. The default
    limit is 50 items.
    """

    embedded: Annotated[ListPaymentLinksEmbedded, pydantic.Field(alias="_embedded")]

    links: Annotated[ListPaymentLinksLinks, pydantic.Field(alias="_links")]
    r"""Links to help navigate through the lists of items. Every URL object will contain an `href` and a `type` field."""
