/*
 * Decompiled with CFR 0.152.
 */
package org.testng.reporters;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.testng.IReporter;
import org.testng.ISuite;
import org.testng.ISuiteResult;
import org.testng.ITestContext;
import org.testng.ITestNGMethod;
import org.testng.ITestResult;
import org.testng.Reporter;
import org.testng.collections.ListMultiMap;
import org.testng.collections.Lists;
import org.testng.collections.Maps;
import org.testng.collections.SetMultiMap;
import org.testng.collections.Sets;
import org.testng.internal.Utils;
import org.testng.reporters.JUnitXMLReporter;
import org.testng.reporters.XMLStringBuffer;
import org.testng.xml.XmlSuite;

public class JUnitReportReporter
implements IReporter {
    @Override
    public void generateReport(List<XmlSuite> xmlSuites, List<ISuite> suites, String defaultOutputDirectory) {
        Map<Class<?>, Set<ITestResult>> results = Maps.newHashMap();
        ListMultiMap<Object, ITestResult> befores = Maps.newListMultiMap();
        ListMultiMap<Object, ITestResult> afters = Maps.newListMultiMap();
        SetMultiMap mapping = new SetMultiMap(false);
        for (ISuite iSuite : suites) {
            Map<String, ISuiteResult> suiteResults = iSuite.getResults();
            this.addMapping(mapping, iSuite.getExcludedMethods());
            for (ISuiteResult sr : suiteResults.values()) {
                ITestContext tc = sr.getTestContext();
                this.addResults(tc.getPassedTests().getAllResults(), results);
                this.addResults(tc.getFailedTests().getAllResults(), results);
                this.addResults(tc.getSkippedTests().getAllResults(), results);
                this.addResults(tc.getFailedConfigurations().getAllResults(), results);
                for (ITestResult tr : tc.getPassedConfigurations().getAllResults()) {
                    if (tr.getMethod().isBeforeMethodConfiguration()) {
                        befores.put(tr.getInstance(), tr);
                    }
                    if (!tr.getMethod().isAfterMethodConfiguration()) continue;
                    afters.put(tr.getInstance(), tr);
                }
            }
        }
        for (Map.Entry entry : results.entrySet()) {
            Class cls = (Class)entry.getKey();
            Properties p1 = new Properties();
            p1.setProperty("name", cls.getName());
            p1.setProperty("timestamp", JUnitXMLReporter.formattedTime());
            List<TestTag> testCases = Lists.newArrayList();
            int failures = 0;
            int errors = 0;
            int skipped = 0;
            int testCount = 0;
            float totalTime = 0.0f;
            Collection<ITestResult> iTestResults = JUnitReportReporter.sort((Set)entry.getValue());
            for (ITestResult iTestResult : iTestResults) {
                long time = iTestResult.getEndMillis() - iTestResult.getStartMillis();
                time += this.getNextConfiguration(befores, iTestResult);
                time += this.getNextConfiguration(afters, iTestResult);
                Throwable t2 = iTestResult.getThrowable();
                switch (iTestResult.getStatus()) {
                    case 3: 
                    case 4: {
                        ++skipped;
                        break;
                    }
                    case 2: {
                        if (t2 instanceof AssertionError) {
                            ++failures;
                            break;
                        }
                        ++errors;
                    }
                }
                totalTime += (float)time;
                ++testCount;
                TestTag testTag = this.createTestTagFor(iTestResult, cls);
                testTag.properties.setProperty("time", "" + this.formatTime(time));
                testCases.add(testTag);
            }
            int ignored = JUnitReportReporter.getDisabledTestCount((Set)mapping.get((Class)entry.getKey()));
            for (ITestNGMethod eachMethod : (Set)mapping.get((Class)entry.getKey())) {
                testCases.add(this.createIgnoredTestTagFor(eachMethod));
            }
            p1.setProperty("failures", Integer.toString(failures));
            p1.setProperty("errors", Integer.toString(errors));
            p1.setProperty("skipped", Integer.toString(skipped + ignored));
            p1.setProperty("name", cls.getName());
            p1.setProperty("tests", Integer.toString(testCount + ignored));
            p1.setProperty("time", "" + this.formatTime(totalTime));
            try {
                p1.setProperty("hostname", InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            XMLStringBuffer xMLStringBuffer = new XMLStringBuffer();
            xMLStringBuffer.addComment("Generated by " + this.getClass().getName());
            xMLStringBuffer.push("testsuite", p1);
            for (TestTag testTag : testCases) {
                if (this.putElement(xMLStringBuffer, "testcase", testTag.properties, testTag.childTag != null)) {
                    Properties p = new Properties();
                    this.safeSetProperty(p, "message", testTag.message);
                    this.safeSetProperty(p, "type", testTag.type);
                    if (this.putElement(xMLStringBuffer, testTag.childTag, p, testTag.stackTrace != null)) {
                        xMLStringBuffer.addCDATA(testTag.stackTrace);
                        xMLStringBuffer.pop(testTag.childTag);
                    }
                    xMLStringBuffer.pop("testcase");
                }
                if (!this.putElement(xMLStringBuffer, "system-out", new Properties(), testTag.sysOut != null)) continue;
                xMLStringBuffer.addCDATA(testTag.sysOut);
                xMLStringBuffer.pop("system-out");
            }
            xMLStringBuffer.pop("testsuite");
            String outputDirectory = defaultOutputDirectory + File.separator + "junitreports";
            Utils.writeUtf8File(outputDirectory, this.getFileName(cls), xMLStringBuffer.toXML());
        }
    }

    private static Collection<ITestResult> sort(Set<ITestResult> results) {
        ArrayList<ITestResult> sortedResults = new ArrayList<ITestResult>(results);
        sortedResults.sort(Comparator.comparingInt(o -> o.getMethod().getPriority()));
        return Collections.unmodifiableList(sortedResults);
    }

    private static int getDisabledTestCount(Set<ITestNGMethod> methods) {
        int count = 0;
        for (ITestNGMethod method : methods) {
            if (method.getEnabled()) continue;
            ++count;
        }
        return count;
    }

    private TestTag createIgnoredTestTagFor(ITestNGMethod method) {
        TestTag testTag = new TestTag();
        Properties p2 = new Properties();
        p2.setProperty("classname", method.getRealClass().getName());
        p2.setProperty("name", method.getMethodName());
        testTag.childTag = "skipped";
        testTag.properties = p2;
        return testTag;
    }

    private TestTag createTestTagFor(ITestResult tr, Class<?> cls) {
        TestTag testTag = new TestTag();
        Properties p2 = new Properties();
        p2.setProperty("classname", cls.getName());
        p2.setProperty("name", this.getTestName(tr));
        int status = tr.getStatus();
        if (status == 3 || status == 4) {
            testTag.childTag = "skipped";
        } else if (status == 2) {
            JUnitReportReporter.handleFailure(testTag, tr.getThrowable());
        }
        List<String> output = Reporter.getOutput(tr);
        if (!output.isEmpty()) {
            testTag.sysOut = String.join((CharSequence)"\n", output);
        }
        testTag.properties = p2;
        return testTag;
    }

    private static void handleFailure(TestTag testTag, Throwable t2) {
        String string = testTag.childTag = t2 instanceof AssertionError ? "failure" : "error";
        if (t2 != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            t2.printStackTrace(pw);
            testTag.message = t2.getMessage();
            testTag.type = t2.getClass().getName();
            testTag.stackTrace = sw.toString();
        }
    }

    private boolean putElement(XMLStringBuffer xsb, String tagName, Properties attributes, boolean hasChildElements) {
        if (hasChildElements) {
            xsb.push(tagName, attributes);
        } else {
            xsb.addEmptyElement(tagName, attributes);
        }
        return hasChildElements;
    }

    private void safeSetProperty(Properties p, String key, String value) {
        if (value != null) {
            p.setProperty(key, value);
        }
    }

    private long getNextConfiguration(ListMultiMap<Object, ITestResult> configurations, ITestResult tr) {
        long result = 0L;
        List confResults = (List)configurations.get(tr.getInstance());
        Map<ITestNGMethod, ITestResult> seen = Maps.newHashMap();
        for (ITestResult r : confResults) {
            if (seen.containsKey(r.getMethod())) continue;
            result += r.getEndMillis() - r.getStartMillis();
            seen.put(r.getMethod(), r);
        }
        confResults.removeAll(seen.values());
        return result;
    }

    protected String getFileName(Class cls) {
        return "TEST-" + cls.getName() + ".xml";
    }

    protected String getTestName(ITestResult tr) {
        return tr.getMethod().getMethodName();
    }

    private String formatTime(float time) {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        DecimalFormat format = new DecimalFormat("#.###", symbols);
        format.setMinimumFractionDigits(3);
        return format.format(time / 1000.0f);
    }

    private void addResults(Set<ITestResult> allResults, Map<Class<?>, Set<ITestResult>> out) {
        for (ITestResult tr : allResults) {
            Class<?> cls = tr.getMethod().getTestClass().getRealClass();
            Set l = out.computeIfAbsent(cls, k -> Sets.newHashSet());
            l.add(tr);
        }
    }

    private void addMapping(SetMultiMap<Class<?>, ITestNGMethod> mapping, Collection<ITestNGMethod> methods) {
        for (ITestNGMethod method : methods) {
            if (method.getEnabled()) continue;
            mapping.put(method.getRealClass(), method);
        }
    }

    private static class TestTag {
        Properties properties;
        String message;
        String type;
        String stackTrace;
        String childTag;
        String sysOut;

        private TestTag() {
        }
    }
}

