from enum import Enum


class Channel(str, Enum):
    PHONE = 'phone'
    SIP = 'sip'
    WEBSOCKET = 'websocket'
    VBC = 'vbc'


class NccoActionType(str, Enum):
    RECORD = 'record'
    CONVERSATION = 'conversation'
    CONNECT = 'connect'
    TALK = 'talk'
    STREAM = 'stream'
    INPUT = 'input'
    NOTIFY = 'notify'


class ConnectEndpointType(str, Enum):
    PHONE = 'phone'
    APP = 'app'
    WEBSOCKET = 'websocket'
    SIP = 'sip'
    VBC = 'vbc'


class CallState(str, Enum):
    STARTED = 'started'
    RINGING = 'ringing'
    ANSWERED = 'answered'
    MACHINE = 'machine'
    COMPLETED = 'completed'
    BUSY = 'busy'
    CANCELLED = 'cancelled'
    FAILED = 'failed'
    REJECTED = 'rejected'
    TIMEOUT = 'timeout'
    UNANSWERED = 'unanswered'


class TtsLanguageCode(str, Enum):
    AR = 'ar'
    CA_ES = 'ca-ES'
    CMN_CN = 'cmn-CN'
    CMN_TW = 'cmn-TW'
    CS_CZ = 'cs-CZ'
    CY_GB = 'cy-GB'
    DA_DK = 'da-DK'
    DE_DE = 'de-DE'
    EL_GR = 'el-GR'
    EN_AU = 'en-AU'
    EN_GB = 'en-GB'
    EN_GB_WLS = 'en-GB-WLS'
    EN_IN = 'en-IN'
    EN_US = 'en-US'
    EN_ZA = 'en-ZA'
    ES_ES = 'es-ES'
    ES_MX = 'es-MX'
    ES_US = 'es-US'
    EU_ES = 'eu-ES'
    FI_FI = 'fi-FI'
    FIL_PH = 'fil-PH'
    FR_CA = 'fr-CA'
    FR_FR = 'fr-FR'
    HE_IL = 'he-IL'
    HI_IN = 'hi-IN'
    HU_HU = 'hu-HU'
    ID_ID = 'id-ID'
    IS_IS = 'is-IS'
    IT_IT = 'it-IT'
    JA_JP = 'ja-JP'
    KO_KR = 'ko-KR'
    NB_NO = 'nb-NO'
    NL_NL = 'nl-NL'
    NO_NO = 'no-NO'
    PL_PL = 'pl-PL'
    PT_BR = 'pt-BR'
    PT_PT = 'pt-PT'
    RO_RO = 'ro-RO'
    RU_RU = 'ru-RU'
    SK_SK = 'sk-SK'
    SV_SE = 'sv-SE'
    TH_TH = 'th-TH'
    TR_TR = 'tr-TR'
    UK_UA = 'uk-UA'
    VI_VN = 'vi-VN'
    YUE_CN = 'yue-CN'
