/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.matrices;

import JSci.maths.DimensionException;
import JSci.maths.ExtraMath;
import JSci.maths.Mapping;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.matrices.AbstractComplexMatrix;
import JSci.maths.matrices.AbstractDoubleMatrix;
import JSci.maths.matrices.AbstractIntegerMatrix;
import JSci.maths.matrices.ComplexMatrix;
import JSci.maths.matrices.DoubleSquareMatrix;
import JSci.maths.matrices.IntegerMatrix;
import JSci.maths.matrices.Matrix;
import JSci.maths.matrices.MatrixDimensionException;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.DoubleVector;

public class DoubleMatrix
extends AbstractDoubleMatrix {
    protected final double[][] matrix;

    public DoubleMatrix(double[][] dArray) {
        super(dArray.length, dArray[0].length);
        this.matrix = dArray;
    }

    public DoubleMatrix(int n, int n2) {
        this(new double[n][n2]);
    }

    public DoubleMatrix(AbstractDoubleVector[] abstractDoubleVectorArray) {
        this(abstractDoubleVectorArray[0].dimension(), abstractDoubleVectorArray.length);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                this.matrix[i][j] = abstractDoubleVectorArray[j].getComponent(i);
            }
        }
    }

    public boolean equals(AbstractDoubleMatrix abstractDoubleMatrix, double d) {
        if (abstractDoubleMatrix != null && this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            double d2 = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < this.numCols; ++j) {
                    double d3 = this.matrix[i][j] - abstractDoubleMatrix.getElement(i, j);
                    d2 += d3 * d3;
                }
            }
            return d2 <= d * d;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(5 * this.numRows * this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                stringBuffer.append(this.matrix[i][j]);
                stringBuffer.append(' ');
            }
            stringBuffer.append('\n');
        }
        return stringBuffer.toString();
    }

    public AbstractIntegerMatrix toIntegerMatrix() {
        int[][] nArray = new int[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                nArray[i][j] = Math.round((float)this.matrix[i][j]);
            }
        }
        return new IntegerMatrix(nArray);
    }

    public AbstractComplexMatrix toComplexMatrix() {
        ComplexMatrix complexMatrix = new ComplexMatrix(this.numRows, this.numCols);
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                complexMatrix.setElement(i, j, this.matrix[i][j], 0.0);
            }
        }
        return complexMatrix;
    }

    public double getElement(int n, int n2) {
        if (n >= 0 && n < this.numRows && n2 >= 0 && n2 < this.numCols) {
            return this.matrix[n][n2];
        }
        throw new MatrixDimensionException(DoubleMatrix.getInvalidElementMsg(n, n2));
    }

    public void setElement(int n, int n2, double d) {
        if (n < 0 || n >= this.numRows || n2 < 0 || n2 >= this.numCols) {
            throw new MatrixDimensionException(DoubleMatrix.getInvalidElementMsg(n, n2));
        }
        this.matrix[n][n2] = d;
    }

    public double infNorm() {
        double d = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            double d2 = 0.0;
            for (int j = 0; j < this.numCols; ++j) {
                d2 += Math.abs(this.matrix[i][j]);
            }
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double frobeniusNorm() {
        double d = 0.0;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                d = ExtraMath.hypot(d, this.matrix[i][j]);
            }
        }
        return d;
    }

    public AbelianGroup.Member negate() {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = -this.matrix[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = -this.matrix[i][j];
            }
        }
        return new DoubleMatrix(dArray);
    }

    public AbstractDoubleMatrix add(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = this.matrix[i][0] + abstractDoubleMatrix.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    dArray[i][j] = this.matrix[i][j] + abstractDoubleMatrix.getElement(i, j);
                }
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleMatrix subtract(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            double[][] dArray = new double[this.numRows][this.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i][0] = this.matrix[i][0] - abstractDoubleMatrix.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    dArray[i][j] = this.matrix[i][j] - abstractDoubleMatrix.getElement(i, j);
                }
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleMatrix scalarMultiply(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = d * this.matrix[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = d * this.matrix[i][j];
            }
        }
        return new DoubleMatrix(dArray);
    }

    public AbstractDoubleMatrix scalarDivide(double d) {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = this.matrix[i][0] / d;
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = this.matrix[i][j] / d;
            }
        }
        return new DoubleMatrix(dArray);
    }

    public double scalarProduct(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (abstractDoubleMatrix instanceof DoubleMatrix) {
            return this.scalarProduct((DoubleMatrix)abstractDoubleMatrix);
        }
        if (this.numRows == abstractDoubleMatrix.rows() && this.numCols == abstractDoubleMatrix.columns()) {
            double d = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                d += this.matrix[i][0] * abstractDoubleMatrix.getElement(i, 0);
                for (int j = 1; j < this.numCols; ++j) {
                    d += this.matrix[i][j] * abstractDoubleMatrix.getElement(i, j);
                }
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public double scalarProduct(DoubleMatrix doubleMatrix) {
        if (this.numRows == doubleMatrix.numRows && this.numCols == doubleMatrix.numCols) {
            double d = 0.0;
            for (int i = 0; i < this.numRows; ++i) {
                d += this.matrix[i][0] * doubleMatrix.matrix[i][0];
                for (int j = 1; j < this.numCols; ++j) {
                    d += this.matrix[i][j] * doubleMatrix.matrix[i][j];
                }
            }
            return d;
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public AbstractDoubleVector multiply(AbstractDoubleVector abstractDoubleVector) {
        if (this.numCols == abstractDoubleVector.dimension()) {
            double[] dArray = new double[this.numRows];
            for (int i = 0; i < this.numRows; ++i) {
                dArray[i] = this.matrix[i][0] * abstractDoubleVector.getComponent(0);
                for (int j = 1; j < this.numCols; ++j) {
                    int n = i;
                    dArray[n] = dArray[n] + this.matrix[i][j] * abstractDoubleVector.getComponent(j);
                }
            }
            return new DoubleVector(dArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public AbstractDoubleMatrix multiply(AbstractDoubleMatrix abstractDoubleMatrix) {
        if (abstractDoubleMatrix instanceof DoubleMatrix) {
            return this.multiply((DoubleMatrix)abstractDoubleMatrix);
        }
        if (this.numCols == abstractDoubleMatrix.rows()) {
            int n = abstractDoubleMatrix.columns();
            double[][] dArray = new double[this.numRows][n];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < n; ++j) {
                    dArray[i][j] = this.matrix[i][0] * abstractDoubleMatrix.getElement(0, j);
                    for (int k = 1; k < this.numCols; ++k) {
                        double[] dArray2 = dArray[i];
                        int n2 = j;
                        dArray2[n2] = dArray2[n2] + this.matrix[i][k] * abstractDoubleMatrix.getElement(k, j);
                    }
                }
            }
            if (this.numRows == n) {
                return new DoubleSquareMatrix(dArray);
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractDoubleMatrix multiply(DoubleMatrix doubleMatrix) {
        if (this.numCols == doubleMatrix.numRows) {
            double[][] dArray = new double[this.numRows][doubleMatrix.numCols];
            for (int i = 0; i < this.numRows; ++i) {
                for (int j = 0; j < doubleMatrix.numCols; ++j) {
                    dArray[i][j] = this.matrix[i][0] * doubleMatrix.matrix[0][j];
                    for (int k = 1; k < this.numCols; ++k) {
                        double[] dArray2 = dArray[i];
                        int n = j;
                        dArray2[n] = dArray2[n] + this.matrix[i][k] * doubleMatrix.matrix[k][j];
                    }
                }
            }
            if (this.numRows == doubleMatrix.numCols) {
                return new DoubleSquareMatrix(dArray);
            }
            return new DoubleMatrix(dArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public AbstractDoubleMatrix directSum(AbstractDoubleMatrix abstractDoubleMatrix) {
        int n;
        int n2;
        double[][] dArray = new double[this.numRows + abstractDoubleMatrix.numRows][this.numCols + abstractDoubleMatrix.numCols];
        for (n2 = 0; n2 < this.numRows; ++n2) {
            for (n = 0; n < this.numCols; ++n) {
                dArray[n2][n] = this.matrix[n2][n];
            }
        }
        for (n2 = 0; n2 < abstractDoubleMatrix.numRows; ++n2) {
            for (n = 0; n < abstractDoubleMatrix.numCols; ++n) {
                dArray[n2 + this.numRows][n + this.numCols] = abstractDoubleMatrix.getElement(n2, n);
            }
        }
        return new DoubleMatrix(dArray);
    }

    public AbstractDoubleMatrix tensor(AbstractDoubleMatrix abstractDoubleMatrix) {
        double[][] dArray = new double[this.numRows * abstractDoubleMatrix.numRows][this.numCols * abstractDoubleMatrix.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numCols; ++j) {
                int n = 0;
                while (n < abstractDoubleMatrix.numRows) {
                    for (int k = 0; k < abstractDoubleMatrix.numCols; ++k) {
                        dArray[i * abstractDoubleMatrix.numRows + n][j * abstractDoubleMatrix.numCols + k] = this.matrix[i][j] * abstractDoubleMatrix.getElement(n, k);
                    }
                    ++j;
                }
            }
        }
        return new DoubleMatrix(dArray);
    }

    public Matrix transpose() {
        double[][] dArray = new double[this.numCols][this.numRows];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[0][i] = this.matrix[i][0];
            for (int j = 1; j < this.numCols; ++j) {
                dArray[j][i] = this.matrix[i][j];
            }
        }
        return new DoubleMatrix(dArray);
    }

    public AbstractDoubleMatrix mapElements(Mapping mapping) {
        double[][] dArray = new double[this.numRows][this.numCols];
        for (int i = 0; i < this.numRows; ++i) {
            dArray[i][0] = mapping.map(this.matrix[i][0]);
            for (int j = 1; j < this.numCols; ++j) {
                dArray[i][j] = mapping.map(this.matrix[i][j]);
            }
        }
        return new DoubleMatrix(dArray);
    }
}

