/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.vectors;

import JSci.GlobalSettings;
import JSci.maths.ExtraMath;
import JSci.maths.Mapping;
import JSci.maths.algebras.BanachSpace;
import JSci.maths.vectors.MathVector;

public abstract class AbstractDoubleVector
extends MathVector
implements BanachSpace.Member {
    protected AbstractDoubleVector(int n) {
        super(n);
    }

    public final boolean equals(Object object) {
        return this.equals(object, GlobalSettings.ZERO_TOL);
    }

    public boolean equals(Object object, double d) {
        if (object != null && object instanceof AbstractDoubleVector) {
            AbstractDoubleVector abstractDoubleVector = (AbstractDoubleVector)object;
            return this.dimension() == abstractDoubleVector.dimension() && this.subtract(abstractDoubleVector).norm() <= d;
        }
        return false;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(8 * this.N);
        for (n = 0; n < this.N - 1; ++n) {
            stringBuffer.append(this.getComponent(n));
            stringBuffer.append(',');
        }
        stringBuffer.append(this.getComponent(n));
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public abstract double getComponent(int var1);

    public abstract void setComponent(int var1, double var2);

    public Object getSet() {
        throw new RuntimeException("Not implemented: file bug");
    }

    public double norm(int n) {
        double d = Math.pow(Math.abs(this.getComponent(0)), n);
        for (int i = 1; i < this.N; ++i) {
            d += Math.pow(Math.abs(this.getComponent(i)), n);
        }
        return Math.pow(d, 1.0 / (double)n);
    }

    public double norm() {
        double d = this.getComponent(0);
        for (int i = 1; i < this.N; ++i) {
            d = ExtraMath.hypot(d, this.getComponent(i));
        }
        return d;
    }

    public double infNorm() {
        double d = Math.abs(this.getComponent(0));
        for (int i = 1; i < this.N; ++i) {
            double d2 = Math.abs(this.getComponent(i));
            if (!(d2 > d)) continue;
            d = d2;
        }
        return d;
    }

    public double mass() {
        double d = 0.0;
        for (int i = 1; i < this.N; ++i) {
            d += this.getComponent(i);
        }
        return d;
    }

    public abstract AbstractDoubleVector add(AbstractDoubleVector var1);

    public abstract AbstractDoubleVector subtract(AbstractDoubleVector var1);

    public abstract AbstractDoubleVector scalarMultiply(double var1);

    public abstract AbstractDoubleVector scalarDivide(double var1);

    public AbstractDoubleVector normalize() {
        return this.scalarDivide(this.norm());
    }

    public abstract double scalarProduct(AbstractDoubleVector var1);

    public abstract AbstractDoubleVector mapComponents(Mapping var1);
}

