/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.vectors;

import JSci.maths.ExtraMath;
import JSci.maths.MathInteger;
import JSci.maths.algebras.Module;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;
import JSci.maths.vectors.AbstractComplexVector;
import JSci.maths.vectors.AbstractDoubleVector;
import JSci.maths.vectors.AbstractIntegerVector;
import JSci.maths.vectors.ComplexVector;
import JSci.maths.vectors.DoubleVector;
import JSci.maths.vectors.VectorDimensionException;

public class IntegerVector
extends AbstractIntegerVector {
    protected int[] vector;

    public IntegerVector(int n) {
        super(n);
        this.vector = new int[n];
    }

    public IntegerVector(int[] nArray) {
        super(nArray.length);
        this.vector = nArray;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof AbstractIntegerVector && this.N == ((AbstractIntegerVector)object).N) {
            AbstractIntegerVector abstractIntegerVector = (AbstractIntegerVector)object;
            int n = 0;
            for (int i = 0; i < this.N; ++i) {
                int n2 = this.vector[i] - abstractIntegerVector.getComponent(i);
                n += n2 * n2;
            }
            return n == 0;
        }
        return false;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer(this.N);
        for (n = 0; n < this.N - 1; ++n) {
            stringBuffer.append(this.vector[n]);
            stringBuffer.append(',');
        }
        stringBuffer.append(this.vector[n]);
        return stringBuffer.toString();
    }

    public AbstractDoubleVector toDoubleVector() {
        double[] dArray = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            dArray[i] = this.vector[i];
        }
        return new DoubleVector(dArray);
    }

    public AbstractComplexVector toComplexVector() {
        double[] dArray = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            dArray[i] = this.vector[i];
        }
        return new ComplexVector(dArray, new double[this.N]);
    }

    public int getComponent(int n) {
        if (n >= 0 && n < this.N) {
            return this.vector[n];
        }
        throw new VectorDimensionException(IntegerVector.getInvalidComponentMsg(n));
    }

    public void setComponent(int n, int n2) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(IntegerVector.getInvalidComponentMsg(n));
        }
        this.vector[n] = n2;
    }

    public double norm(int n) {
        double d = Math.pow(Math.abs(this.vector[0]), n);
        for (int i = 1; i < this.N; ++i) {
            d += Math.pow(Math.abs(this.vector[i]), n);
        }
        return Math.pow(d, 1.0 / (double)n);
    }

    public double norm() {
        double d = this.vector[0];
        for (int i = 1; i < this.N; ++i) {
            d = ExtraMath.hypot(d, this.vector[i]);
        }
        return d;
    }

    public double infNorm() {
        int n = Math.abs(this.vector[0]);
        for (int i = 1; i < this.N; ++i) {
            int n2 = Math.abs(this.vector[i]);
            if (n2 <= n) continue;
            n = n2;
        }
        return n;
    }

    public AbelianGroup.Member negate() {
        int[] nArray = new int[this.N];
        nArray[0] = -this.vector[0];
        for (int i = 1; i < this.N; ++i) {
            nArray[i] = -this.vector[i];
        }
        return new IntegerVector(nArray);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof IntegerVector) {
            return this.add((IntegerVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerVector add(AbstractIntegerVector abstractIntegerVector) {
        if (abstractIntegerVector instanceof IntegerVector) {
            return this.add((IntegerVector)abstractIntegerVector);
        }
        if (this.N == abstractIntegerVector.N) {
            int[] nArray = new int[this.N];
            nArray[0] = this.vector[0] + abstractIntegerVector.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                nArray[i] = this.vector[i] + abstractIntegerVector.getComponent(i);
            }
            return new IntegerVector(nArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public IntegerVector add(IntegerVector integerVector) {
        if (this.N == integerVector.N) {
            int[] nArray = new int[this.N];
            nArray[0] = this.vector[0] + integerVector.vector[0];
            for (int i = 1; i < this.N; ++i) {
                nArray[i] = this.vector[i] + integerVector.vector[i];
            }
            return new IntegerVector(nArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof IntegerVector) {
            return this.subtract((IntegerVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerVector subtract(AbstractIntegerVector abstractIntegerVector) {
        if (abstractIntegerVector instanceof IntegerVector) {
            return this.subtract((IntegerVector)abstractIntegerVector);
        }
        if (this.N == abstractIntegerVector.N) {
            int[] nArray = new int[this.N];
            nArray[0] = this.vector[0] - abstractIntegerVector.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                nArray[i] = this.vector[i] - abstractIntegerVector.getComponent(i);
            }
            return new IntegerVector(nArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public IntegerVector subtract(IntegerVector integerVector) {
        if (this.N == integerVector.N) {
            int[] nArray = new int[this.N];
            nArray[0] = this.vector[0] - integerVector.vector[0];
            for (int i = 1; i < this.N; ++i) {
                nArray[i] = this.vector[i] - integerVector.vector[i];
            }
            return new IntegerVector(nArray);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public AbstractIntegerVector scalarMultiply(int n) {
        int[] nArray = new int[this.N];
        nArray[0] = n * this.vector[0];
        for (int i = 1; i < this.N; ++i) {
            nArray[i] = n * this.vector[i];
        }
        return new IntegerVector(nArray);
    }

    public int scalarProduct(AbstractIntegerVector abstractIntegerVector) {
        if (abstractIntegerVector instanceof IntegerVector) {
            return this.scalarProduct((IntegerVector)abstractIntegerVector);
        }
        if (this.N == abstractIntegerVector.N) {
            int n = this.vector[0] * abstractIntegerVector.getComponent(0);
            for (int i = 1; i < this.N; ++i) {
                n += this.vector[i] * abstractIntegerVector.getComponent(i);
            }
            return n;
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public int scalarProduct(IntegerVector integerVector) {
        if (this.N == integerVector.N) {
            int n = this.vector[0] * integerVector.vector[0];
            for (int i = 1; i < this.N; ++i) {
                n += this.vector[i] * integerVector.vector[i];
            }
            return n;
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }
}

