/*
 * Decompiled with CFR 0.152.
 */
package edu.iris.Fissures.seed.container;

import edu.iris.Fissures.seed.container.SeedObject;
import edu.iris.Fissures.seed.exception.SeedInputException;
import edu.iris.Fissures.seed.util.Utility;
import java.text.DecimalFormat;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class Btime
extends SeedObject {
    private int year = 2500;
    private int jday = 1;
    private int hour = 0;
    private int min = 0;
    private int sec = 0;
    private int tenthMilli = 0;
    private boolean swapFlag = false;
    private StringBuffer formatErrors;

    public Btime() throws SeedInputException {
        this.formatErrors = new StringBuffer();
        TimeZone timeZone = TimeZone.getTimeZone("GMT+00");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        String string = "" + gregorianCalendar.get(1) + "," + gregorianCalendar.get(6) + "," + gregorianCalendar.get(11) + ":" + gregorianCalendar.get(12) + ":" + gregorianCalendar.get(13);
        this.setString(string);
        this.formatCheck();
    }

    public Btime(byte[] byArray, boolean bl) throws SeedInputException {
        if (byArray.length < 10) {
            throw new SeedInputException("input array is too small (" + byArray.length + " bytes)");
        }
        this.formatErrors = new StringBuffer();
        this.swapFlag = bl;
        this.year = Utility.uBytesToInt(byArray[0], byArray[1], this.swapFlag);
        this.jday = Utility.uBytesToInt(byArray[2], byArray[3], this.swapFlag);
        this.hour = byArray[4] & 0xFF;
        this.min = byArray[5] & 0xFF;
        this.sec = byArray[6] & 0xFF;
        this.tenthMilli = Utility.uBytesToInt(byArray[8], byArray[9], this.swapFlag);
        this.formatCheck();
    }

    public Btime(byte[] byArray) throws SeedInputException {
        if (byArray.length < 10) {
            throw new SeedInputException("input array is too small (" + byArray.length + " bytes)");
        }
        this.formatErrors = new StringBuffer();
        this.year = Utility.uBytesToInt(byArray[0], byArray[1], false);
        this.swapFlag = this.year < 1900 || this.year > 2050;
        this.year = Utility.uBytesToInt(byArray[0], byArray[1], this.swapFlag);
        this.jday = Utility.uBytesToInt(byArray[2], byArray[3], this.swapFlag);
        this.hour = byArray[4] & 0xFF;
        this.min = byArray[5] & 0xFF;
        this.sec = byArray[6] & 0xFF;
        this.tenthMilli = Utility.uBytesToInt(byArray[8], byArray[9], this.swapFlag);
        this.formatCheck();
    }

    public Btime(String string) throws SeedInputException {
        this.formatErrors = new StringBuffer();
        this.setString(string);
        this.formatCheck();
    }

    public int getType() {
        return 10000;
    }

    public int getLookupId() {
        return (int)(this.getEpochTime() / 10000L);
    }

    public byte[] getByteTime() {
        byte[] byArray = new byte[10];
        System.arraycopy(Utility.intToShortBytes(this.year), 0, byArray, 0, 2);
        System.arraycopy(Utility.intToShortBytes(this.jday), 0, byArray, 2, 2);
        byArray[4] = (byte)this.hour;
        byArray[5] = (byte)this.min;
        byArray[6] = (byte)this.sec;
        byArray[7] = 0;
        System.arraycopy(Utility.intToShortBytes(this.tenthMilli), 0, byArray, 8, 2);
        return byArray;
    }

    public String getStringTime() {
        DecimalFormat decimalFormat = new DecimalFormat("00");
        DecimalFormat decimalFormat2 = new DecimalFormat("000");
        DecimalFormat decimalFormat3 = new DecimalFormat("0000");
        return new String(decimalFormat3.format(this.year) + "," + decimalFormat2.format(this.jday) + "," + decimalFormat.format(this.hour) + ":" + decimalFormat.format(this.min) + ":" + decimalFormat.format(this.sec) + "." + decimalFormat3.format(this.tenthMilli));
    }

    public String toString() {
        return this.getStringTime();
    }

    public long getEpochTime() {
        boolean bl;
        int n;
        long l = 0L;
        for (n = this.year; n < 1970; ++n) {
            l -= 31536000L;
            boolean bl2 = bl = n % 4 == 0 && n % 100 != 0 || n % 400 == 0;
            if (!bl) continue;
            l -= 86400L;
        }
        for (n = 1970; n < this.year; ++n) {
            l += 31536000L;
            boolean bl3 = bl = n % 4 == 0 && n % 100 != 0 || n % 400 == 0;
            if (!bl) continue;
            l += 86400L;
        }
        l *= 10000L;
        return l += (long)this.ttConvert();
    }

    public boolean equals(Btime btime) {
        return this.toString().equals(btime.toString());
    }

    public long diffSeconds(Btime btime) {
        return this.getEpochTime() - btime.getEpochTime();
    }

    public boolean getSwapFlag() {
        return this.swapFlag;
    }

    public String getError() {
        return this.formatErrors.toString();
    }

    public int compareTo(Object object) throws ClassCastException {
        double d;
        if (object == null) {
            throw new ClassCastException("null parameter value");
        }
        Btime btime = (Btime)object;
        long l = this.diffSeconds(btime);
        if (l < 0L) {
            return -1;
        }
        if (l > 0L) {
            return 1;
        }
        double d2 = this.ttConvert();
        if (d2 < (d = btime.ttConvert())) {
            return -1;
        }
        if (d2 > d) {
            return 1;
        }
        return 0;
    }

    public Btime projectTime(double d) throws SeedInputException {
        boolean bl;
        Btime btime = new Btime(this.getStringTime());
        int n = 0;
        boolean bl2 = bl = this.year % 4 == 0 && this.year % 100 != 0 || this.year % 400 == 0;
        if (bl) {
            n = 1;
        }
        if ((d += this.ttConvert()) >= (double)(366 + n) * 8.64E8) {
            ++btime.year;
            d -= (double)(365 + n) * 8.64E8;
        }
        btime.jday = (int)(d / 8.64E8);
        ++btime.jday;
        btime.hour = (int)((d -= (double)btime.jday * 8.64E8) / 3.6E7);
        btime.min = (int)((d -= (double)btime.hour * 3.6E7) / 600000.0);
        btime.sec = (int)((d -= (double)btime.min * 600000.0) / 10000.0);
        btime.tenthMilli = (int)(d -= (double)btime.sec * 10000.0);
        return btime;
    }

    public static String getMonthDay(int n, int n2) {
        TimeZone timeZone = TimeZone.getTimeZone("GMT+00");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setLenient(true);
        gregorianCalendar.set(1, n);
        gregorianCalendar.set(6, n2);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        DecimalFormat decimalFormat = new DecimalFormat("00");
        DecimalFormat decimalFormat2 = new DecimalFormat("0000");
        int n3 = gregorianCalendar.get(2) + 1;
        String string = "" + decimalFormat2.format(gregorianCalendar.get(1)) + "/" + decimalFormat.format(n3) + "/" + decimalFormat.format(gregorianCalendar.get(5));
        return string;
    }

    public static String getJulianDay(int n, int n2, int n3) {
        TimeZone timeZone = TimeZone.getTimeZone("GMT+00");
        GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
        gregorianCalendar.setLenient(true);
        gregorianCalendar.set(1, n);
        gregorianCalendar.set(2, n2 - 1);
        gregorianCalendar.set(5, n3);
        gregorianCalendar.set(11, 0);
        gregorianCalendar.set(12, 0);
        gregorianCalendar.set(13, 0);
        DecimalFormat decimalFormat = new DecimalFormat("000");
        DecimalFormat decimalFormat2 = new DecimalFormat("0000");
        String string = "" + decimalFormat2.format(gregorianCalendar.get(1)) + "/" + decimalFormat.format(gregorianCalendar.get(6));
        return string;
    }

    public int getYear() {
        return this.year;
    }

    public int getDayOfYear() {
        return this.jday;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.min;
    }

    public int getSecond() {
        return this.sec;
    }

    public int getTenthMill() {
        return this.tenthMilli;
    }

    public void setYear(int n) {
        this.year = n;
    }

    public void setDayOfYear(int n) {
        this.jday = n;
    }

    public void setHour(int n) {
        this.hour = n;
    }

    public void setMinute(int n) {
        this.min = n;
    }

    public void setSecond(int n) {
        this.sec = n;
    }

    public void setTenthMill(int n) {
        this.tenthMilli = n;
    }

    protected double ttConvert() {
        double d = (double)(this.jday - 1) * 8.64E8;
        d += (double)this.hour * 3.6E7;
        d += (double)this.min * 600000.0;
        d += (double)this.sec * 10000.0;
        return d += (double)this.tenthMilli;
    }

    private void setString(String string) {
        String string2 = "2500";
        String string3 = "001";
        String string4 = "00";
        String string5 = "00";
        String string6 = "00";
        String string7 = "0000";
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",:.");
        if (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
        }
        this.year = Integer.parseInt(string2);
        if (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
        }
        this.jday = Integer.parseInt(string3);
        if (stringTokenizer.hasMoreTokens()) {
            string4 = stringTokenizer.nextToken();
        }
        this.hour = Integer.parseInt(string4);
        if (stringTokenizer.hasMoreTokens()) {
            string5 = stringTokenizer.nextToken();
        }
        this.min = Integer.parseInt(string5);
        if (stringTokenizer.hasMoreTokens()) {
            string6 = stringTokenizer.nextToken();
        }
        this.sec = Integer.parseInt(string6);
        if (stringTokenizer.hasMoreTokens()) {
            string7 = stringTokenizer.nextToken();
        }
        this.tenthMilli = Integer.parseInt(string7);
    }

    private void formatCheck() {
        if (this.year < 1900 || this.year > 9999) {
            this.formatErrors.append("Invalid year " + this.year);
        }
        if (this.jday < 1 || this.jday > 366) {
            this.formatErrors.append("Invalid day of year " + this.jday);
        }
        if (this.hour < 0 || this.hour > 23) {
            this.formatErrors.append("Invalid hour " + this.hour);
        }
        if (this.min < 0 || this.min > 59) {
            this.formatErrors.append("Invalid minute " + this.min);
        }
        if (this.sec < 0 || this.sec > 59) {
            this.formatErrors.append("Invalid second " + this.sec);
        }
        if (this.tenthMilli < 0 || this.tenthMilli > 9999) {
            this.formatErrors.append("Invalid fraction second " + this.tenthMilli);
        }
    }
}

