/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.geog;

import java.io.Serializable;
import net.alomax.geog.Constants;
import net.alomax.util.NumberFormat;

public class Position
extends Constants
implements Serializable {
    public double latitude = Double.MAX_VALUE;
    public double longitude = Double.MAX_VALUE;
    public double elevation = Double.MAX_VALUE;
    public double depth = Double.MAX_VALUE;

    public Position() {
    }

    public Position(double d, double d2) {
        this(d, d2, 0.0, 0.0);
    }

    public Position(double d, double d2, double d3) {
        this(d, d2, 0.0, d3);
    }

    public Position(double d, double d2, double d3, double d4) {
        this.latitude = d;
        this.longitude = d2;
        this.elevation = d3;
        this.depth = d4;
    }

    public Position(Position position) {
        this.latitude = position.latitude;
        this.longitude = position.longitude;
        this.elevation = position.elevation;
        this.depth = position.depth;
    }

    public String toString() {
        String string = System.getProperty("line.separator");
        return new String("latitude = " + this.latitude + string + "longitude = " + this.longitude + string + "elevation = " + this.elevation + string + "depth = " + this.depth + string);
    }

    public String toStringGeog(int n) {
        return new String("lat:" + NumberFormat.floatString((float)this.latitude, n + 3, n) + " " + "lon:" + NumberFormat.floatString((float)this.longitude, n + 3, n) + " " + "depth:" + NumberFormat.floatString((float)(this.depth - this.elevation), n + 3, n) + "km");
    }
}

