/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.message;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.Vector;
import net.alomax.io.GeneralInputStream;
import net.alomax.message.FileMessagePullerListener;
import net.alomax.net.GeneralURLConnection;

public class FileMessagePuller
extends Thread {
    protected boolean stopRunning = false;
    protected FileMessagePullerListener listener;
    protected URL documentBase;
    protected String messageFileName;
    protected long waitMilliSec;
    protected long maxWaitMilliSec;
    protected String[] currentMessage = null;
    private static final int FAIL_COUNT_LIMIT = 20;
    private int failCount = 20;
    private static final int EXCEPTION_COUNT_LIMIT = 20;
    private int exceptCount = 20;

    public FileMessagePuller(FileMessagePullerListener fileMessagePullerListener, URL uRL, String string, long l, long l2) {
        this.listener = fileMessagePullerListener;
        this.documentBase = uRL;
        this.messageFileName = string;
        this.waitMilliSec = l;
        this.maxWaitMilliSec = l2;
    }

    public void stopRunning() {
        this.stopRunning = true;
    }

    private boolean checkForStop() {
        return this.stopRunning || this.listener == null;
    }

    public String[] getCurrentMessage() {
        return this.currentMessage;
    }

    protected synchronized URLConnection openMessageFileURL(URL uRL, String string) throws Exception {
        URLConnection uRLConnection = null;
        for (int i = 5; i > 0; --i) {
            try {
                uRLConnection = GeneralURLConnection.openURLConnection(uRL, string);
                if (uRLConnection != null) continue;
                throw new Exception(this.getClass().getName() + ": " + "Cannot open message pull file URL connection: " + string);
            }
            catch (Exception exception) {
                if (i <= 0) {
                    throw exception;
                }
                FileMessagePuller.sleep(100L);
                continue;
            }
        }
        uRLConnection.setUseCaches(false);
        return uRLConnection;
    }

    protected synchronized void closeMessageFileURL(URLConnection uRLConnection) {
        try {
            InputStream inputStream = GeneralInputStream.getInputStream(uRLConnection);
            inputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        uRLConnection = null;
    }

    protected synchronized String[] readMessageFileURL(URLConnection uRLConnection) throws Exception {
        Object[] objectArray;
        Object object;
        BufferedReader bufferedReader = null;
        try {
            object = GeneralInputStream.getInputStream(uRLConnection);
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)object));
        }
        catch (Exception exception) {
            try {
                bufferedReader.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if (uRLConnection == null || bufferedReader == null) {
            throw new Exception(this.getClass().getName() + ": " + "ERROR: Opening message pull file: " + this.messageFileName);
        }
        object = new Vector();
        ((Vector)object).addElement(new Date().toString());
        try {
            objectArray = bufferedReader.readLine();
            while (objectArray != null) {
                ((Vector)object).addElement(objectArray);
                objectArray = bufferedReader.readLine();
            }
        }
        catch (Exception exception) {
            throw new Exception(this.getClass().getName() + ": " + "ERROR: Reading message pull file: " + this.messageFileName + ": " + exception);
        }
        finally {
            try {
                bufferedReader.close();
            }
            catch (Exception exception) {}
        }
        objectArray = new String[((Vector)object).size()];
        ((Vector)object).copyInto(objectArray);
        return objectArray;
    }

    public long getLastModified(URLConnection uRLConnection) {
        Object object;
        long l = uRLConnection.getLastModified();
        if (l <= 0L) {
            object = new File(uRLConnection.getURL().getFile());
            l = ((File)object).lastModified();
        }
        if (l <= 0L) {
            if (this.failCount++ > 20) {
                object = this.getClass().getName() + ": " + "WARNING: Failed to get file last modified time " + "(connection may have been lost): " + uRLConnection;
                System.out.println((String)object);
                this.failCount = 0;
            }
        } else {
            this.failCount = 20;
        }
        return l;
    }

    public void run() {
        long l = this.waitMilliSec;
        long l2 = this.maxWaitMilliSec;
        long l3 = Long.MAX_VALUE;
        long l4 = System.currentTimeMillis();
        do {
            block19: {
                if (this.checkForStop()) {
                    return;
                }
                try {
                    long l5;
                    URLConnection uRLConnection;
                    block17: {
                        uRLConnection = null;
                        int n = 0;
                        do {
                            FileMessagePuller.sleep(l);
                            n = (int)((long)n + l);
                            if (this.checkForStop()) {
                                return;
                            }
                            l4 = System.currentTimeMillis();
                            uRLConnection = this.openMessageFileURL(this.documentBase, this.messageFileName);
                            l5 = this.getLastModified(uRLConnection);
                            if (l5 > l3) break block17;
                            this.closeMessageFileURL(uRLConnection);
                            l3 = l5;
                            if (this.checkForStop()) {
                                return;
                            }
                            if (l2 <= 0L || (long)n <= l2) continue;
                            String string = this.getClass().getName() + ": " + "WARNING: Too much time before message file update.";
                            System.out.println(string);
                            n = 0;
                        } while (!this.checkForStop());
                        return;
                    }
                    l3 = l5;
                    l4 = System.currentTimeMillis();
                    try {
                        this.currentMessage = this.readMessageFileURL(uRLConnection);
                    }
                    catch (Exception exception) {
                        throw exception;
                    }
                    finally {
                        this.closeMessageFileURL(uRLConnection);
                    }
                    this.listener.newPullMessageAvailable(this, this.currentMessage);
                    if (this.checkForStop()) {
                        return;
                    }
                    this.exceptCount = 20;
                }
                catch (Exception exception) {
                    if (this.exceptCount++ > 20) {
                        System.out.println("FileMessagePuller: (" + new Date().toString() + ") caught and ignoring an exception:");
                        System.out.println(exception.getMessage());
                        this.exceptCount = 0;
                    }
                }
                catch (Throwable throwable) {
                    if (this.exceptCount++ <= 20) break block19;
                    System.out.println("FileMessagePuller: (" + new Date().toString() + ") caught and ignoring a throwable:");
                    System.out.println(throwable.getMessage());
                    this.exceptCount = 0;
                }
            }
            long l6 = l - (System.currentTimeMillis() - l4);
            if (l6 <= 0L) continue;
            try {
                FileMessagePuller.sleep(l6);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!this.checkForStop());
    }
}

