/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.liveseis;

import java.io.FilterInputStream;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import net.alomax.io.GeneralInputStream;
import net.alomax.io.ZipStream;
import net.alomax.net.GeneralURLConnection;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.IndicatorJPanel;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.Seismogram;
import net.alomax.seisgram2k.liveseis.LiveSeisDescriptor;
import net.alomax.seisgram2k.liveseis.LiveSeisManagerBase;
import net.alomax.seisgram2k.liveseis.LiveSeisSegmentURL;
import sdsu.io.ASCIIInputStream;

public class LiveSeisManager
extends LiveSeisManagerBase {
    protected int firstSegRead;
    protected int lastSegRead;
    protected long lastModified;
    protected final String LAST_SEG_FILE = "liveseis.last";
    protected String lastWrittenSegFileName;

    public LiveSeisManager(GatherPanel gatherPanel, URL uRL, LiveSeisDescriptor liveSeisDescriptor) {
        super(gatherPanel, uRL, liveSeisDescriptor);
    }

    public void stopRunning() {
        this.stopRunning = true;
    }

    protected boolean checkForStop() {
        return this.stopRunning || this.client == null || !this.client.isAlive();
    }

    public int init() throws Exception {
        this.initialized = false;
        this.lastWrittenSegFileName = this.generateLastWrittenSegFileName();
        Object object = this.openLastWrittenSegFile(this.lastWrittenSegFileName);
        if (this.checkForStop()) {
            return -1;
        }
        try {
            this.lastSegRead = this.readLastWrittenSegFile((URLConnection)object);
        }
        catch (Exception exception) {
            this.closeLastWrittenSegFile((URLConnection)object);
            throw exception;
        }
        if (this.checkForStop()) {
            return -1;
        }
        this.lastModified = ((URLConnection)object).getLastModified();
        if (this.checkForStop()) {
            return -1;
        }
        this.closeLastWrittenSegFile((URLConnection)object);
        this.firstSegRead = this.lastSegRead - (this.liveSeisDescriptor.numSegmentsDisplay - 1);
        while (this.firstSegRead < 0) {
            this.firstSegRead += this.liveSeisDescriptor.numSegments;
        }
        object = this.formatMessage("first seg: " + this.firstSegRead + "  last seg: " + this.lastSegRead);
        this.client.writeMessage((String)object);
        System.out.println((String)object);
        if (this.checkForStop()) {
            return -1;
        }
        this.initialized = true;
        return this.liveSeisDescriptor.numSegments;
    }

    protected String generateLastWrittenSegFileName() {
        String string = this.liveSeisDescriptor.segmentURLTemplate[0].URLname;
        int n = string.lastIndexOf(47);
        if (n < 0) {
            n = string.lastIndexOf(92);
        }
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(0, n + 1) + "liveseis.last";
        return string2;
    }

    protected synchronized URLConnection openLastWrittenSegFile(String string) throws Exception {
        URLConnection uRLConnection = null;
        for (int i = 5; i > 0; --i) {
            try {
                uRLConnection = GeneralURLConnection.openURLConnection(this.documentBase, string);
                if (uRLConnection != null) continue;
                throw new Exception(this.formatMessage("Cannot open last segment index file URL connection: " + string));
            }
            catch (Exception exception) {
                if (i <= 0) {
                    throw exception;
                }
                LiveSeisManager.sleep(100L);
                continue;
            }
        }
        uRLConnection.setUseCaches(false);
        return uRLConnection;
    }

    protected synchronized int readLastWrittenSegFile(URLConnection uRLConnection) throws Exception {
        FilterInputStream filterInputStream = null;
        try {
            InputStream inputStream = GeneralInputStream.getInputStream(uRLConnection);
            filterInputStream = new ASCIIInputStream(inputStream);
        }
        catch (Exception exception) {
            try {
                filterInputStream.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
        if (uRLConnection == null || filterInputStream == null) {
            throw new Exception(this.formatMessage("ERROR: Opening last segment index file: liveseis.last"));
        }
        int n = -1;
        try {
            n = ((ASCIIInputStream)filterInputStream).readInt();
        }
        catch (Exception exception) {
            throw new Exception(this.formatMessage("ERROR: Reading last segment index file: liveseis.last"));
        }
        finally {
            try {
                filterInputStream.close();
            }
            catch (Exception exception) {}
        }
        if (n < 0 || n >= this.liveSeisDescriptor.numSegments) {
            throw new Exception(this.formatMessage("ERROR: In last segment index file: liveseis.last: index value: " + n + ": out of range: (0," + (this.liveSeisDescriptor.numSegments - 1) + ")"));
        }
        return n;
    }

    protected synchronized void closeLastWrittenSegFile(URLConnection uRLConnection) {
        uRLConnection = null;
    }

    protected int loadSegments() throws Exception {
        if (!this.initialized) {
            return -1;
        }
        int n = LiveSeisManager.readSegment(0, this.firstSegRead, this.numChannels, this.documentBase, this.liveSeisDescriptor, this.client);
        if (this.checkForStop()) {
            return -1;
        }
        int n2 = this.firstSegRead;
        while (n2 != this.lastSegRead) {
            if (++n2 >= this.liveSeisDescriptor.numSegments) {
                n2 -= this.liveSeisDescriptor.numSegments;
            }
            if (this.checkForStop()) {
                return -1;
            }
            LiveSeisManager.readSegment(1, n2, this.numChannels, this.documentBase, this.liveSeisDescriptor, this.client);
            if (!this.checkForStop()) continue;
            return -1;
        }
        this.doPreDisplay();
        this.client.monitorSeismogramAppended();
        return n;
    }

    protected static synchronized int readSegment(int n, int n2, int n3, URL uRL, LiveSeisDescriptor liveSeisDescriptor, GatherPanel gatherPanel) throws Exception {
        int n4;
        Seismogram[] seismogramArray = new Seismogram[n3];
        for (n4 = 0; n4 < n3; ++n4) {
            InputStream inputStream = null;
            int n5 = 0;
            while (true) {
                String string;
                try {
                    LiveSeisSegmentURL liveSeisSegmentURL = new LiveSeisSegmentURL(n2, uRL, liveSeisDescriptor.segmentURLTemplate[n4].URLname);
                    inputStream = liveSeisSegmentURL.getInputStream();
                    string = "";
                    string = n == 0 ? "Reading: " + liveSeisSegmentURL.URLname : "Appending: " + liveSeisSegmentURL.URLname;
                    gatherPanel.writeMessage(string);
                    inputStream = ZipStream.getInputStream(inputStream, liveSeisSegmentURL.URLname);
                    seismogramArray[n4] = gatherPanel.readSeismogramInputStream(inputStream, liveSeisDescriptor.segmentURLTemplate[n4], false);
                }
                catch (Exception exception) {
                    if (n5++ < 4) {
                        string = "WARNING: Trying again(" + n5 + "): ERROR: " + exception;
                        gatherPanel.writeMessage(string);
                        System.out.println(string);
                        if (!SeisGram2KFrame.PRINT_STACK_TRACES) continue;
                        exception.printStackTrace();
                        continue;
                    }
                    try {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                        Runtime.getRuntime().gc();
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    throw exception;
                }
                break;
            }
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                Runtime.getRuntime().gc();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (seismogramArray[n4] != null) continue;
            return -1;
        }
        if (n == 0) {
            gatherPanel.addSeismograms(seismogramArray);
        } else {
            n4 = liveSeisDescriptor.numSegmentsDisplay;
            gatherPanel.appendSeismograms(seismogramArray, n3, n4, liveSeisDescriptor.contiguous);
        }
        return n3;
    }

    protected synchronized int appendSegments(int n) throws Exception {
        if (!this.initialized) {
            return -1;
        }
        int n2 = -1;
        int n3 = 0;
        int n4 = this.lastSegRead;
        while (n4 != n) {
            if (++n4 >= this.liveSeisDescriptor.numSegments) {
                n4 -= this.liveSeisDescriptor.numSegments;
            }
            n2 = LiveSeisManager.readSegment(1, n4, this.numChannels, this.documentBase, this.liveSeisDescriptor, this.client);
            ++n3;
            if (n2 <= 0) {
                --n3;
                continue;
            }
            if (n2 == this.numChannels) continue;
            String string = this.formatMessage("ERROR: Not all channels appended.");
            this.writeMessageWithDateStamp(string);
        }
        return n3;
    }

    public void run() {
        double d = this.liveSeisDescriptor.waitTime;
        long l = (long)(950.0 * d);
        long l2 = (long)(50.0 * d);
        long l3 = 2L * l;
        long l4 = -1L;
        try {
            if (this.init() < 0) {
                return;
            }
            if (this.checkForStop()) {
                return;
            }
            if (this.loadSegments() < 0) {
                return;
            }
            if (this.checkForStop()) {
                return;
            }
            this.client.liveSeisInitFinished();
        }
        catch (Exception exception) {
            String string = this.formatMessage("ERROR: " + exception);
            this.writeMessageWithDateStamp(string);
            System.out.println(string);
            if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                exception.printStackTrace();
            }
            return;
        }
        while (!this.checkForStop()) {
            try {
                int n;
                URLConnection uRLConnection;
                block24: {
                    uRLConnection = null;
                    int n2 = 0;
                    do {
                        if ((l4 = (uRLConnection = this.openLastWrittenSegFile(this.lastWrittenSegFileName)).getLastModified()) > this.lastModified) break block24;
                        this.closeLastWrittenSegFile(uRLConnection);
                        if (this.checkForStop()) {
                            return;
                        }
                        if ((long)n2 > l3) {
                            String string = this.formatMessage("WARNING: Too much time before segment update.");
                            this.writeMessageWithDateStamp(string);
                            this.client.setIndicator(IndicatorJPanel.INDICATOR_ERROR);
                            n2 = 0;
                        } else {
                            this.client.setIndicator(IndicatorJPanel.INDICATOR_OFF);
                        }
                        if (this.checkForStop()) {
                            return;
                        }
                        LiveSeisManager.sleep(l2);
                        n2 = (int)((long)n2 + l2);
                    } while (!this.checkForStop());
                    return;
                }
                this.lastModified = l4;
                long l5 = System.currentTimeMillis();
                try {
                    n = this.readLastWrittenSegFile(uRLConnection);
                }
                catch (Exception exception) {
                    throw exception;
                }
                finally {
                    this.closeLastWrittenSegFile(uRLConnection);
                }
                this.client.unDoRemoveMean();
                if (this.appendSegments(n) != n - this.lastSegRead) {
                    String string = this.formatMessage("ERROR: Not all segments appended.");
                    this.writeMessageWithDateStamp(string);
                }
                this.lastSegRead = n;
                this.doPreDisplay();
                this.client.monitorSeismogramAppended();
                this.writeMessageWithDateStamp(this.formatMessage("Last successful segment update:"));
                if (this.checkForStop()) {
                    return;
                }
                long l6 = l - (System.currentTimeMillis() - l5);
                if (l6 > 0L) {
                    LiveSeisManager.sleep(l6);
                }
                if (!this.checkForStop()) continue;
                return;
            }
            catch (Exception exception) {
                System.out.println("Manager: (" + new Date().toString() + ") caught and ignoring an exception:");
                System.out.println(exception);
                if (!SeisGram2KFrame.PRINT_STACK_TRACES) continue;
                exception.printStackTrace();
                continue;
            }
            break;
        }
        return;
    }

    protected String formatMessage(String string) {
        return "LiveSeisManager(" + this.managerIndex + "): " + string;
    }

    public double getNominalWindowLength() {
        return this.liveSeisDescriptor.waitTime * (double)this.liveSeisDescriptor.numSegmentsDisplay;
    }
}

