/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.seisgram2k.monitor.waveserver;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import net.alomax.earthworm.WSPacket;
import net.alomax.earthworm.WSSiteChanNet;
import net.alomax.seisgram2k.GatherPanel;
import net.alomax.seisgram2k.SeisGram2KException;
import net.alomax.seisgram2k.SeisGram2KFrame;
import net.alomax.seisgram2k.Seismogram;
import net.alomax.seisgram2k.SeismogramURL;
import net.alomax.seisgram2k.monitor.MonitorManager;
import net.alomax.seisgram2k.monitor.MonitorStatusPanel;
import net.alomax.seisgram2k.monitor.waveserver.ProcessTraceDataActionEvent;
import net.alomax.seisgram2k.monitor.waveserver.WaveserverClient;
import net.alomax.util.StringExt;

public class WaveserverManager
extends MonitorManager
implements ActionListener {
    protected WaveserverClient waveserverClient = null;
    protected int initSegmentLength = 5;

    public WaveserverManager(SeisGram2KFrame seisGram2KFrame, String string, boolean bl, double[] dArray) throws Exception {
        super(seisGram2KFrame, bl, dArray);
        className = CLASS_NAME + "[" + (numberManagers + 1) + "]";
        String[] stringArray = StringExt.parse(string, "#");
        if (stringArray == null) {
            String string2 = "ERROR: " + className + ": cannot parse waveserver parameters: " + string;
            throw new SeisGram2KException(string2);
        }
        if (stringArray.length < 3) {
            String string3 = "ERROR: " + className + ": not at least 2 waveserver parameters: " + string;
            throw new SeisGram2KException(string3);
        }
        if (stringArray.length > 2) {
            this.windowLength = Integer.parseInt(stringArray[2]);
        }
        String[] stringArray2 = new String[]{stringArray[0], stringArray[1]};
        boolean bl2 = seisGram2KFrame.getTrueFalseParameter(false, "waveserver.asciidata");
        int n = 0;
        if (bl2) {
            n = 1;
        }
        this.waveserverClient = new WaveserverClient(this, stringArray2, this.windowLength, this.initSegmentLength, n);
        this.waveserverClient.init();
        this.runnableClient = this.waveserverClient;
        this.monitorClient = this.waveserverClient;
        if (stringArray.length > 3) {
            this.minPeakToPeakAmplitude = Double.parseDouble(stringArray[3]);
        }
        if (stringArray.length > 4) {
            this.maxPeakToPeakAmplitude = Double.parseDouble(stringArray[4]);
        }
        if (stringArray.length > 5) {
            this.title = stringArray[5];
        }
        if (stringArray.length > 6) {
            this.multiplier = Double.parseDouble(stringArray[6]);
        }
        className = CLASS_NAME + "[" + numberManagers + ":" + this.waveserverClient.wsconn.getWSAddress() + "]";
        ++numberManagers;
    }

    public boolean packetHandler(WSPacket wSPacket) throws Exception {
        ProcessTraceDataActionEvent processTraceDataActionEvent = new ProcessTraceDataActionEvent(this, "processTraceData", wSPacket);
        this.seisFrame.getJFrame().getToolkit().getSystemEventQueue().postEvent(processTraceDataActionEvent);
        return true;
    }

    public void processTraceData(WSPacket wSPacket) {
        WSSiteChanNet wSSiteChanNet = wSPacket.scnList[0];
        String string = null;
        String string2 = null;
        String string3 = wSSiteChanNet.network;
        String string4 = wSSiteChanNet.site;
        String string5 = wSSiteChanNet.channel;
        String string6 = wSSiteChanNet.toStringPretty();
        string = string3 + "_" + string4 + ":" + string5;
        string2 = this.waveserverClient.wsconn.getWSAddress() + ":" + string + ":" + string6;
        string2 = string2.trim().replace(' ', '_');
        boolean bl = true;
        GatherPanel gatherPanel = null;
        boolean bl2 = false;
        gatherPanel = (GatherPanel)this.gatherTable.get(string);
        if (gatherPanel == null) {
            if (!this.groupMode || (gatherPanel = this.findRelatedGather(string)) == null) {
                gatherPanel = this.seisFrame.createWaveserverGather();
                gatherPanel.setMonitorManager(this);
                bl2 = true;
            }
            this.gatherTable.put(string, gatherPanel);
            bl = false;
        }
        if (gatherPanel == CLOSED_GATHER) {
            return;
        }
        Seismogram seismogram = null;
        try {
            seismogram = this.readChannel(wSPacket, string2, gatherPanel);
            if (seismogram == null) {
                return;
            }
        }
        catch (Exception exception) {
            String string7 = "ERROR: " + className + ": " + exception;
            if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                exception.printStackTrace();
            }
            System.out.println(string7);
            this.seisFrame.writeMessage(string7);
            return;
        }
        this.doPreProcessing(seismogram);
        if (!bl) {
            gatherPanel.addSeismogram(seismogram, this.getChannelIndex(string));
            this.doPreDisplay(gatherPanel);
            if (bl2) {
                MonitorStatusPanel monitorStatusPanel = new MonitorStatusPanel(this.latencyLimits, this.nStatusDec);
                gatherPanel.setAuxilliaryPanel(monitorStatusPanel);
                gatherPanel.monitorSeismogramAppended(true);
            }
        } else {
            gatherPanel.appendSeismogram(seismogram, this.windowLength, true, false);
            this.doPreDisplay(gatherPanel);
        }
    }

    protected Seismogram readChannel(WSPacket wSPacket, String string, GatherPanel gatherPanel) throws Exception {
        Seismogram seismogram = null;
        SeismogramURL seismogramURL = new SeismogramURL();
        seismogramURL.URLname = string;
        seismogramURL.binaryTypeName = this.seisFrame.getBinaryTypeName();
        if (this.waveserverClient.dataRequestType == 0) {
            seismogramURL.formatName = "EW_TRACEBUF";
        } else if (this.waveserverClient.dataRequestType == 1) {
            seismogramURL.formatName = "EW_ASCII";
        }
        byte[] byArray = new byte[wSPacket.reply.length + wSPacket.reply_data.length];
        System.arraycopy(wSPacket.reply, 0, byArray, 0, wSPacket.reply.length);
        System.arraycopy(wSPacket.reply_data, 0, byArray, wSPacket.reply.length, wSPacket.reply_data.length);
        try {
            seismogram = gatherPanel.readSeismogramInputStream(new ByteArrayInputStream(byArray), seismogramURL, false);
        }
        catch (Exception exception) {
            if (SeisGram2KFrame.PRINT_STACK_TRACES) {
                exception.printStackTrace();
            }
            throw exception;
        }
        return seismogram;
    }

    protected void updateStatusPanel(GatherPanel gatherPanel) {
        super.updateStatusPanel(gatherPanel);
    }

    public void writeMessage(String string) {
        this.seisFrame.writeMessage(className + ": " + string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent instanceof ProcessTraceDataActionEvent) {
            ProcessTraceDataActionEvent processTraceDataActionEvent = (ProcessTraceDataActionEvent)actionEvent;
            if (processTraceDataActionEvent.waveserverManager == this) {
                this.processTraceData(processTraceDataActionEvent.wspack);
            }
        } else if (actionEvent.getSource() == this.seisFrame.getRealtimeTimer()) {
            super.actionPerformed(actionEvent);
        }
    }
}

