/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.swing;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import net.alomax.swing.AJLFileFilter;
import net.alomax.swing.SwingExt;

public class URLChooser
extends JPanel {
    public static final int OPEN_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    protected static FileFilter lastFileFilter = null;
    protected static FileFilter acceptAllFileFilter = null;
    protected static Vector recentFileFilters = new Vector();
    protected int currentOption = 1;
    protected String urlName = null;
    protected String initialURLName = null;
    protected String title = null;
    protected String prompt = null;
    protected String chooseFileText = null;
    protected String openText = null;
    protected String cancelText = null;
    protected boolean allowFile = true;
    protected boolean directoriesOnly = true;
    protected FileFilter[] fileFilters = null;
    protected FileView fileView = null;
    protected JFrame ownerFrame = null;
    protected JDialog dialog = null;
    protected JComboBox urlComboBox = null;

    public URLChooser(JComboBox jComboBox, String string, boolean bl, boolean bl2) {
        this(jComboBox, string, "Open URL", "Enter the web location (URL) or choose a file", "Choose File...", "Open", "Cancel", bl, bl2);
    }

    public URLChooser(JComboBox jComboBox, String string, String string2, String string3, String string4, String string5, String string6, boolean bl, boolean bl2) {
        this.urlComboBox = jComboBox;
        this.initialURLName = string;
        this.title = string2;
        this.prompt = string3;
        this.chooseFileText = string4;
        this.openText = string5;
        this.cancelText = string6;
        this.allowFile = bl;
        this.directoriesOnly = bl2;
    }

    public static void addRecentFileFilter(FileFilter fileFilter) {
        recentFileFilters.add(fileFilter);
    }

    public int showURLDialog(JFrame jFrame) {
        block8: {
            this.ownerFrame = jFrame;
            this.setLayout(new GridLayout(0, 1));
            this.urlComboBox.setEditable(true);
            this.urlComboBox.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                }
            });
            if (this.initialURLName != null) {
                try {
                    int n = URLChooser.getIndexInComboBox(this.urlComboBox, this.initialURLName);
                    if (n >= 0) {
                        this.urlComboBox.setSelectedIndex(n);
                        break block8;
                    }
                    this.urlComboBox.insertItemAt(this.initialURLName, 0);
                    this.urlComboBox.setSelectedIndex(0);
                }
                catch (Exception exception) {
                    this.urlComboBox.insertItemAt(this.initialURLName, 0);
                    this.urlComboBox.setSelectedIndex(0);
                }
            } else {
                this.urlComboBox.insertItemAt("<enter a URL>                                   ", 0);
                this.urlComboBox.setSelectedIndex(0);
            }
        }
        JButton jButton = new JButton(this.chooseFileText);
        if (this.allowFile) {
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    String[] stringArray = URLChooser.doFileChooser(URLChooser.this.ownerFrame, "Choose directory", URLChooser.this.fileFilters, URLChooser.this.fileView, URLChooser.this.initialURLName, URLChooser.this.directoriesOnly, false, true);
                    if (stringArray[0] != null) {
                        int n = URLChooser.getIndexInComboBox(URLChooser.this.urlComboBox, stringArray[0]);
                        if (n >= 0) {
                            URLChooser.this.urlComboBox.setSelectedIndex(n);
                        } else {
                            URLChooser.this.urlComboBox.insertItemAt(stringArray[0], 0);
                            URLChooser.this.urlComboBox.setSelectedIndex(0);
                        }
                    }
                }
            });
        }
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout());
        jPanel.add(this.urlComboBox);
        if (this.allowFile) {
            jPanel.add(jButton);
        }
        JButton jButton2 = new JButton(this.openText);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                URLChooser.this.urlName = (String)URLChooser.this.urlComboBox.getSelectedItem();
                int n = URLChooser.getIndexInComboBox(URLChooser.this.urlComboBox, URLChooser.this.urlName);
                if (n < 0) {
                    URLChooser.this.urlComboBox.insertItemAt(URLChooser.this.urlName, 0);
                }
                URLChooser.this.currentOption = 0;
                URLChooser.this.dialog.setVisible(false);
            }
        });
        JButton jButton3 = new JButton(this.cancelText);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                URLChooser.this.currentOption = 1;
                URLChooser.this.dialog.setVisible(false);
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(2));
        jPanel2.add(jButton2);
        jPanel2.add(jButton3);
        String string = "  " + this.prompt + ":";
        if (string.length() < 60) {
            string = string + new String("                                                              ").substring(0, 60 - string.length());
        }
        JLabel jLabel = new JLabel(string);
        this.add(jLabel);
        this.add(jPanel);
        this.add(new JLabel(""));
        this.add(jPanel2);
        this.dialog = new JDialog(this.ownerFrame, this.title, true);
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        SwingExt.setLocationOnScreen(this.dialog, 0.1, 0.2);
        this.dialog.setVisible(true);
        return this.currentOption;
    }

    public String getSelectedURL() {
        return this.urlName;
    }

    public void setFileFilters(FileFilter[] fileFilterArray) {
        this.fileFilters = fileFilterArray;
    }

    public void setFileView(FileView fileView) {
        this.fileView = fileView;
    }

    public static String[] doFileChooser(JFrame jFrame, String string, FileFilter[] fileFilterArray, FileView fileView, String string2, boolean bl, boolean bl2, boolean bl3) {
        return URLChooser.doFileChooser(jFrame, string, fileFilterArray, fileView, string2, bl, bl2, bl3, false, null);
    }

    public static String[] doFileChooser(JFrame jFrame, String string, FileFilter[] fileFilterArray, FileView fileView, String string2, boolean bl, boolean bl2, boolean bl3, boolean bl4, FileFilter fileFilter) {
        String[] stringArray;
        int n;
        File file;
        try {
            file = new File(string2);
            if (!file.getParentFile().exists()) {
                throw new Exception();
            }
        }
        catch (Exception exception) {
            string2 = System.getProperty("user.dir");
        }
        file = new File(string2);
        String string3 = string2;
        try {
            string3 = file.getCanonicalPath();
        }
        catch (Exception exception) {
            string3 = file.getAbsolutePath();
        }
        JFileChooser jFileChooser = new JFileChooser(string3);
        if (bl3) {
            jFileChooser.setDialogType(0);
        } else {
            jFileChooser.setDialogType(1);
            bl2 = false;
        }
        jFileChooser.setAcceptAllFileFilterUsed(true);
        acceptAllFileFilter = jFileChooser.getAcceptAllFileFilter();
        int n2 = -1;
        int n3 = 0;
        if (fileFilterArray != null && fileFilterArray.length > 0) {
            for (n = 0; n < fileFilterArray.length; ++n) {
                jFileChooser.addChoosableFileFilter(fileFilterArray[n]);
                if (file != null && !file.isDirectory() && fileFilterArray[n].accept(file)) {
                    n2 = n;
                    n3 = Integer.MAX_VALUE;
                }
                for (int i = recentFileFilters.size() - 1; i >= n3; --i) {
                    stringArray = (String[])recentFileFilters.get(i);
                    if (stringArray == null || stringArray.getDescription() != fileFilterArray[n].getDescription()) continue;
                    n2 = n;
                    n3 = i;
                }
            }
        }
        if (n2 >= 0) {
            jFileChooser.setFileFilter(fileFilterArray[n2]);
        } else if (fileFilter != null) {
            jFileChooser.setFileFilter(fileFilter);
        } else {
            jFileChooser.setFileFilter(jFileChooser.getAcceptAllFileFilter());
        }
        jFileChooser.setFileView(fileView);
        if (bl) {
            jFileChooser.setFileSelectionMode(1);
        }
        jFileChooser.setMultiSelectionEnabled(bl2);
        file = new File(string3);
        if (file.isDirectory()) {
            jFileChooser.setCurrentDirectory(file);
        } else {
            jFileChooser.setSelectedFile(file);
        }
        jFileChooser.setDialogTitle(string);
        SwingExt.setLocationOnScreen(jFileChooser, 0.1, 0.2);
        jFileChooser.requestFocus();
        n = -1;
        n = bl3 ? jFileChooser.showOpenDialog(jFrame) : jFileChooser.showSaveDialog(jFrame);
        if (n < 0) {
            return null;
        }
        if (n == 1) {
            return null;
        }
        File[] fileArray = null;
        if (n == 0) {
            fileArray = jFileChooser.isMultiSelectionEnabled() ? jFileChooser.getSelectedFiles() : new File[]{jFileChooser.getSelectedFile()};
            lastFileFilter = jFileChooser.getFileFilter();
            recentFileFilters.add(lastFileFilter);
        }
        stringArray = new String[fileArray.length];
        for (int i = 0; i < fileArray.length; ++i) {
            if (bl4) {
                try {
                    fileArray[i] = ((AJLFileFilter)lastFileFilter).addExtensionAuto(fileArray[i]);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
            try {
                stringArray[i] = fileArray[i].getCanonicalPath();
                continue;
            }
            catch (Exception exception) {
                stringArray[i] = fileArray[i].getAbsolutePath();
            }
        }
        return stringArray;
    }

    public static int getIndexInComboBox(JComboBox jComboBox, String string) {
        for (int i = 0; i < jComboBox.getItemCount(); ++i) {
            String string2 = (String)jComboBox.getItemAt(i);
            if (!string.equals(string2)) continue;
            return i;
        }
        return -1;
    }

    public static FileFilter getLastFileFilter() {
        return lastFileFilter;
    }

    public static FileFilter getAcceptAllFileFilter() {
        return acceptAllFileFilter;
    }
}

