/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.timedom;

import java.util.Vector;
import net.alomax.math.TimeSeries;
import net.alomax.timedom.PickData;
import net.alomax.timedom.TimeDomainException;
import net.alomax.timedom.TimeDomainMemory;
import net.alomax.timedom.TimeDomainProcess;
import net.alomax.timedom.TimeDomainText;

public class PeakSlidingWindow
extends TimeDomainProcess {
    public int windowWidth = 50;
    public int measurementStep = 0;
    public double threshold = Double.MAX_VALUE;
    public String errorMessage = " ";
    protected Vector peakPicks = new Vector();
    public static final int WINDOW_MIN = 1;
    public static final int WINDOW_MAX = Integer.MAX_VALUE;
    public static final int MEASURE_STEP_MIN = 0;
    public static final int MEASURE_STEP_MAX = Integer.MAX_VALUE;
    public static final double THRESHOLD_MIN = -1.7976931348623157E308;
    public static final double THRESHOLD_MAX = Double.MAX_VALUE;

    public PeakSlidingWindow(String string, int n, double d) {
        this.windowWidth = n;
        this.threshold = d;
        TimeDomainText.setLocale(string);
    }

    public PeakSlidingWindow(PeakSlidingWindow peakSlidingWindow) {
        this.windowWidth = peakSlidingWindow.windowWidth;
        this.threshold = peakSlidingWindow.threshold;
        this.useMemory = peakSlidingWindow.useMemory;
        if (peakSlidingWindow.memory != null) {
            this.memory = new TimeDomainMemory(peakSlidingWindow.memory);
        }
    }

    public void setWindowWidth(int n) throws TimeDomainException {
        if (n < 1 || n > Integer.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_peakwin_width_value + ": " + n);
        }
        this.windowWidth = n;
    }

    public void setMeasurementStep(int n) throws TimeDomainException {
        if (n < 1 || n > Integer.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_peakwin_measurement_step_value + ": " + n);
        }
        this.measurementStep = n;
    }

    public void setWindowWidth(String string) throws TimeDomainException {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_peakwin_width_value + ": " + string);
        }
        this.setWindowWidth(n);
    }

    public void setThreshold(double d) throws TimeDomainException {
        if (d < -1.7976931348623157E308 || d > Double.MAX_VALUE) {
            throw new TimeDomainException(TimeDomainText.invalid_peakwin_threshold_value + ": " + d);
        }
        this.threshold = d;
    }

    public void setThreshold(String string) throws TimeDomainException {
        double d;
        try {
            d = Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            throw new TimeDomainException(TimeDomainText.invalid_peakwin_threshold_value + ": " + string);
        }
        this.setThreshold(d);
    }

    public boolean supportsMemory() {
        return true;
    }

    public void checkSettings() throws TimeDomainException {
        String string = "";
        int n = 0;
        this.setWindowWidth(this.windowWidth);
        if (n > 0) {
            throw new TimeDomainException(string + ".");
        }
    }

    public final float[] apply(double d, float[] fArray) {
        float[] fArray2 = fArray;
        if (this.useMemory && this.memory == null) {
            this.memory = new TimeDomainMemory(0, 0.0f, this.windowWidth, 0.0f);
        }
        fArray2 = this.applyImpl(d, fArray);
        if (this.useMemory) {
            for (int i = 0; i < this.windowWidth; ++i) {
                this.memory.output[i] = fArray[fArray.length - (this.windowWidth - i)];
            }
        }
        return fArray2;
    }

    public final float[] applyImpl(double d, float[] fArray) {
        this.peakPicks = new Vector();
        float[] fArray2 = new float[fArray.length];
        double d2 = -1.7976931348623157E308;
        int n = 0;
        int n2 = this.measurementStep;
        if (n2 < 1) {
            n2 = 1;
        }
        for (int i = 0; i < fArray.length; ++i) {
            if (i % n2 != 0 && i > 0) {
                fArray2[i] = fArray2[i - 1];
                continue;
            }
            int n3 = i - this.windowWidth;
            if (!this.useMemory && n3 < 0) {
                n3 = 0;
            }
            int n4 = i;
            double d3 = -1.7976931348623157E308;
            int n5 = 0;
            float f = 0.0f;
            for (int j = n3; j < n4; ++j) {
                f = this.useMemory && j < 0 ? this.memory.output[this.windowWidth + j] : fArray[j];
                d3 = (double)f > d3 ? (double)f : d3;
                ++n5;
            }
            if (n5 > 0) {
                fArray2[i] = (float)d3;
                if (d3 >= this.threshold) {
                    PickData pickData = new PickData(n3, n4, 0, d3, "_DATA");
                    this.peakPicks.add(pickData);
                    n = i;
                }
                d2 = d3;
                continue;
            }
            fArray2[i] = 0.0f;
        }
        return fArray2;
    }

    public Vector getPickData() {
        return this.peakPicks;
    }

    public String getPickPrefix() {
        return "PkWin";
    }

    public void updateFields(TimeSeries timeSeries) {
    }

    public boolean amplititudeModified() {
        return true;
    }
}

