/*
 * Decompiled with CFR 0.152.
 */
package net.alomax.volume3d;

import net.alomax.geog.GeogCoords;
import net.alomax.graphics3d.Vect3D;
import net.alomax.volume3d.SlownessModel;

public class ConstantSlownessModel
extends SlownessModel {
    double pSlowness = -1.0;
    String pWavetype = null;
    double sSlowness = -1.0;
    String sWavetype = null;

    public ConstantSlownessModel(double d, String string, Vect3D vect3D, Vect3D vect3D2, GeogCoords geogCoords) {
        this(d, string, -1.0, null, vect3D, vect3D2, geogCoords);
    }

    public ConstantSlownessModel(double d, String string, double d2, String string2, Vect3D vect3D, Vect3D vect3D2, GeogCoords geogCoords) {
        super(vect3D, vect3D2, geogCoords);
        this.pSlowness = d;
        this.pWavetype = string;
        this.sSlowness = d2;
        this.sWavetype = string2;
    }

    public String toString() {
        String string = this.getClass().getName();
        try {
            string = string.substring(string.lastIndexOf(".") + 1);
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append(": ");
        if (this.pWavetype != null) {
            stringBuffer.append("wavetype: " + this.pWavetype + ", ");
            stringBuffer.append(this.pSlowness);
            stringBuffer.append(ENDLINE);
        }
        if (this.sWavetype != null) {
            stringBuffer.append("wavetype: " + this.sWavetype + ", ");
            stringBuffer.append(this.sSlowness);
            stringBuffer.append(ENDLINE);
        }
        return stringBuffer.toString();
    }

    public double getSlowness(Vect3D vect3D, String string) {
        if (this.pWavetype != null && string.equals(this.pWavetype)) {
            return this.pSlowness;
        }
        if (this.sWavetype != null && string.equals(this.sWavetype)) {
            return this.sSlowness;
        }
        return -1.0;
    }

    public double[] getPartialDerivatives(Vect3D vect3D, Vect3D vect3D2, String string) {
        double d = this.getSlowness(vect3D, string);
        double d2 = vect3D.x - vect3D2.x;
        double d3 = vect3D.y - vect3D2.y;
        double d4 = vect3D.z - vect3D2.z;
        double d5 = Math.sqrt(d2 * d2 + d3 * d3 + d4 * d4);
        if (Math.abs(d5) < Double.MIN_VALUE) {
            return null;
        }
        double[] dArray = new double[]{d * d2 / d5, d * d3 / d5, d * d4 / d5, 1.0};
        return dArray;
    }

    public double getTravelTime(Vect3D vect3D, Vect3D vect3D2, String string) {
        double d = vect3D.x - vect3D2.x;
        double d2 = vect3D.y - vect3D2.y;
        double d3 = vect3D.z - vect3D2.z;
        double d4 = Math.sqrt(d * d + d2 * d2 + d3 * d3);
        return this.getSlowness(vect3D, string) * d4;
    }

    public static void main(String[] stringArray) {
        int n;
        ConstantSlownessModel constantSlownessModel = new ConstantSlownessModel(0.2, "P", new Vect3D(0.0, 0.0, 0.0), new Vect3D(100.0, 100.0, 30.0), null);
        System.out.println("Model: " + constantSlownessModel);
        System.out.println("The pSlowness at the origin = " + constantSlownessModel.getSlowness(constantSlownessModel.getOrigin(), "P"));
        System.out.print("pd (10.0, 100.0, 10.0) = ");
        double[] dArray = constantSlownessModel.getPartialDerivatives(new Vect3D(10.0, 100.0, 10.0), constantSlownessModel.getOrigin(), "P");
        for (n = 0; n < dArray.length; ++n) {
            System.out.print(" " + dArray[n]);
        }
        System.out.println("");
        double d = constantSlownessModel.getTravelTime(new Vect3D(10.0, 100.0, 10.0), constantSlownessModel.getOrigin(), "P");
        System.out.println("tt (10.0, 100.0, 10.0) = " + d);
        System.out.print("pd (0.0, 100.0, 0.0) = ");
        dArray = constantSlownessModel.getPartialDerivatives(new Vect3D(0.0, 100.0, 0.0), constantSlownessModel.getOrigin(), "P");
        for (n = 0; n < dArray.length; ++n) {
            System.out.print(" " + dArray[n]);
        }
        System.out.println("");
        d = constantSlownessModel.getTravelTime(new Vect3D(0.0, 100.0, 0.0), constantSlownessModel.getOrigin(), "P");
        System.out.println("tt (0.0, 100.0, 0.0) = " + d);
        d = constantSlownessModel.getTravelTime(new Vect3D(10.0, 0.0, 0.0), constantSlownessModel.getOrigin(), "P");
        System.out.println("tt (10.0, 0.0, 0.0) = " + d);
        System.out.print("pd (10.0, 0.0, 0.0) = ");
        dArray = constantSlownessModel.getPartialDerivatives(new Vect3D(10.0, 0.0, 0.0), constantSlownessModel.getOrigin(), "P");
        for (n = 0; n < dArray.length; ++n) {
            System.out.print(" " + dArray[n]);
        }
        System.out.println("");
        d = constantSlownessModel.getTravelTime(new Vect3D(0.0, 0.0, 10.0), constantSlownessModel.getOrigin(), "P");
        System.out.println("tt (0.0, 0.0, 10.0) = " + d);
        System.out.print("pd (0.0, 0.0, 10.0) = ");
        dArray = constantSlownessModel.getPartialDerivatives(new Vect3D(0.0, 0.0, 10.0), constantSlownessModel.getOrigin(), "P");
        for (n = 0; n < dArray.length; ++n) {
            System.out.print(" " + dArray[n]);
        }
        System.out.println("");
    }
}

