from typing import overload, Any, Callable, TypeVar, Union
from typing import Tuple, List, Sequence, MutableSequence

Callback = Union[Callable[..., None], None]
Buffer = TypeVar('Buffer')
Pointer = TypeVar('Pointer')
Template = TypeVar('Template')

import vtkmodules.vtkCommonCore
import vtkmodules.vtkInteractionWidgets
import vtkmodules.vtkRenderingCore
import vtkmodules.vtkRenderingOpenGL2

class vtkOpenGLAvatar(vtkmodules.vtkRenderingCore.vtkAvatar):
    def GetBounds(self) -> (float, float, float, float, float, float): ...
    def GetLabelTextProperty(self) -> vtkTextProperty: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkOpenGLAvatar: ...
    def RenderOpaqueGeometry(self, vp:vtkViewport) -> int: ...
    def RenderTranslucentPolygonalGeometry(self, vp:vtkViewport) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkOpenGLAvatar: ...
    def SetLabel(self, label:str) -> None: ...
    def SetLeftShowRay(self, v:bool) -> None: ...
    def SetRayLength(self, length:float) -> None: ...
    def SetRightShowRay(self, v:bool) -> None: ...
    def SetShowHandsOnly(self, val:bool) -> None: ...
    def SetUseLeftHand(self, val:bool) -> None: ...
    def SetUseRightHand(self, val:bool) -> None: ...

class vtkVRCamera(vtkmodules.vtkRenderingOpenGL2.vtkOpenGLCamera):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkVRCamera: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkVRCamera: ...
    def SetCameraFromDeviceToWorldMatrix(self, mat:vtkMatrix4x4, distance:float) -> None: ...
    def SetCameraFromWorldToDeviceMatrix(self, mat:vtkMatrix4x4, distance:float) -> None: ...

class vtkVRControlsHelper(vtkmodules.vtkRenderingCore.vtkProp):
    class ButtonSides(int): ...
    class DrawSides(int): ...
    Back:'ButtonSides'
    Front:'ButtonSides'
    Left:'DrawSides'
    Right:'DrawSides'
    def BuildRepresentation(self) -> None: ...
    def EnabledOff(self) -> None: ...
    def EnabledOn(self) -> None: ...
    def GetEnabled(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRenderer(self) -> vtkRenderer: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkVRControlsHelper: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RenderOpaqueGeometry(self, __a:vtkViewport) -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:vtkViewport) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkVRControlsHelper: ...
    def SetDevice(self, val:vtkEventDataDevice) -> None: ...
    def SetEnabled(self, enabled:bool) -> None: ...
    def SetRenderer(self, ren:vtkRenderer) -> None: ...
    def SetText(self, str:str) -> None: ...
    def SetTooltipInfo(self, s:str, buttonSide:int, drawSide:int, txt:str) -> None: ...
    def UpdateRepresentation(self) -> None: ...

class vtkVRFollower(vtkmodules.vtkRenderingCore.vtkFollower):
    def ComputeMatrix(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkVRFollower: ...
    def Render(self, ren:vtkRenderer) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkVRFollower: ...

class vtkVRHMDCamera(vtkVRCamera):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkVRHMDCamera: ...
    def Render(self, ren:vtkRenderer) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkVRHMDCamera: ...

class vtkVRHardwarePicker(vtkmodules.vtkRenderingCore.vtkPropPicker):
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetSelection(self) -> vtkSelection: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkVRHardwarePicker: ...
    def PickProp(self, selectionPt:[float, float, float], eventWorldOrientation:[float, float, float, float], renderer:vtkRenderer, pickfrom:vtkPropCollection, actorPassOnly:bool) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkVRHardwarePicker: ...

class vtkVRInteractorStyle(vtkmodules.vtkRenderingCore.vtkInteractorStyle3D):
    class MovementStyle(int): ...
    FLY_STYLE:'MovementStyle'
    GROUNDED_STYLE:'MovementStyle'
    def AddTooltipForInput(self, device:vtkEventDataDevice, input:vtkEventDataDeviceInput, text:str=...) -> None: ...
    def Clip(self, __a:vtkEventDataDevice3D) -> None: ...
    def Elevation3D(self, __a:vtkEventDataDevice3D) -> None: ...
    def EndClip(self, __a:vtkEventDataDevice3D) -> None: ...
    def EndLoadCamPose(self, __a:vtkEventDataDevice3D) -> None: ...
    def EndMovement3D(self, __a:vtkEventDataDevice3D) -> None: ...
    def EndPick(self, __a:vtkEventDataDevice3D) -> None: ...
    def EndPositionProp(self, __a:vtkEventDataDevice3D) -> None: ...
    def GetGrabWithRay(self) -> bool: ...
    def GetHoverPick(self) -> bool: ...
    def GetInteractionState(self, device:vtkEventDataDevice) -> int: ...
    def GetMenu(self) -> vtkVRMenuWidget: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetStyle(self) -> MovementStyle: ...
    def GrabWithRayOff(self) -> None: ...
    def GrabWithRayOn(self) -> None: ...
    def GroundMovement3D(self, __a:vtkEventDataDevice3D) -> None: ...
    def HideBillboard(self) -> None: ...
    def HidePickActor(self) -> None: ...
    def HideRay(self, controller:vtkEventDataDevice) -> None: ...
    def HoverPickOff(self) -> None: ...
    def HoverPickOn(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def LoadNextCameraPose(self) -> None: ...
    def MakeControlsHelper(self) -> vtkVRControlsHelper: ...
    @overload
    def MapInputToAction(self, eid:vtkCommand.EventIds, state:int) -> None: ...
    @overload
    def MapInputToAction(self, eid:vtkCommand.EventIds, action:vtkEventDataAction, state:int) -> None: ...
    def NewInstance(self) -> vtkVRInteractorStyle: ...
    def OnElevation3D(self, edata:vtkEventData) -> None: ...
    def OnMenu3D(self, edata:vtkEventData) -> None: ...
    def OnMove3D(self, edata:vtkEventData) -> None: ...
    def OnNextPose3D(self, edata:vtkEventData) -> None: ...
    def OnPan(self) -> None: ...
    def OnPinch(self) -> None: ...
    def OnRotate(self) -> None: ...
    def OnSelect3D(self, edata:vtkEventData) -> None: ...
    def OnViewerMovement3D(self, edata:vtkEventData) -> None: ...
    def PositionProp(self, __a:vtkEventData, lwpos:[float, ...]=..., lwori:[float, ...]=...) -> None: ...
    def ProbeData(self, controller:vtkEventDataDevice) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkVRInteractorStyle: ...
    def SetDrawControls(self, __a:bool) -> None: ...
    def SetGrabWithRay(self, _arg:bool) -> None: ...
    def SetHoverPick(self, _arg:bool) -> None: ...
    def SetInteractor(self, iren:vtkRenderWindowInteractor) -> None: ...
    def SetStyle(self, _arg:MovementStyle) -> None: ...
    def SetupActions(self, iren:vtkRenderWindowInteractor) -> None: ...
    def ShowBillboard(self, text:str) -> None: ...
    def ShowPickCell(self, cell:vtkCell, __b:vtkProp3D) -> None: ...
    def ShowPickSphere(self, pos:[float, ...], radius:float, __c:vtkProp3D) -> None: ...
    def ShowRay(self, controller:vtkEventDataDevice) -> None: ...
    def StartClip(self, __a:vtkEventDataDevice3D) -> None: ...
    def StartLoadCamPose(self, __a:vtkEventDataDevice3D) -> None: ...
    def StartMovement3D(self, interactionState:int, __b:vtkEventDataDevice3D) -> None: ...
    def StartPick(self, __a:vtkEventDataDevice3D) -> None: ...
    def StartPositionProp(self, __a:vtkEventDataDevice3D) -> None: ...
    def ToggleDrawControls(self) -> None: ...

class vtkVRMenuRepresentation(vtkmodules.vtkInteractionWidgets.vtkWidgetRepresentation):
    def BuildRepresentation(self) -> None: ...
    def ComplexInteraction(self, iren:vtkRenderWindowInteractor, widget:vtkAbstractWidget, event:int, calldata:Pointer) -> None: ...
    def EndComplexInteraction(self, iren:vtkRenderWindowInteractor, widget:vtkAbstractWidget, event:int, calldata:Pointer) -> None: ...
    def GetCurrentOption(self) -> float: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkVRMenuRepresentation: ...
    def PushFrontMenuItem(self, name:str, text:str, cmd:vtkCommand) -> None: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RemoveAllMenuItems(self) -> None: ...
    def RemoveMenuItem(self, name:str) -> None: ...
    def RenameMenuItem(self, name:str, text:str) -> None: ...
    def RenderOverlay(self, __a:vtkViewport) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkVRMenuRepresentation: ...
    def StartComplexInteraction(self, iren:vtkRenderWindowInteractor, widget:vtkAbstractWidget, event:int, calldata:Pointer) -> None: ...

class vtkVRMenuWidget(vtkmodules.vtkInteractionWidgets.vtkAbstractWidget):
    class WidgetStateType(int): ...
    Active:'WidgetStateType'
    Start:'WidgetStateType'
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetWidgetState(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkVRMenuWidget: ...
    def PushFrontMenuItem(self, name:str, text:str, cmd:vtkCommand) -> None: ...
    def RemoveAllMenuItems(self) -> None: ...
    def RemoveMenuItem(self, name:str) -> None: ...
    def RenameMenuItem(self, name:str, text:str) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkVRMenuWidget: ...
    def SetRepresentation(self, rep:vtkVRMenuRepresentation) -> None: ...
    def Show(self, ed:vtkEventData) -> None: ...
    def ShowSubMenu(self, __a:vtkVRMenuWidget) -> None: ...

class vtkVRModel(vtkmodules.vtkCommonCore.vtkObject):
    def Build(self, win:vtkOpenGLRenderWindow) -> bool: ...
    def GetName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetRay(self) -> vtkVRRay: ...
    def GetVisibility(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkVRModel: ...
    def ReleaseGraphicsResources(self, win:vtkWindow) -> None: ...
    def Render(self, win:vtkOpenGLRenderWindow, poseInTrackingCoordinates:vtkMatrix4x4) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkVRModel: ...
    def SetName(self, modelName:str) -> None: ...
    def SetRayColor(self, r:float, g:float, b:float) -> None: ...
    def SetRayLength(self, length:float) -> None: ...
    def SetShowRay(self, v:bool) -> None: ...
    def SetVisibility(self, v:bool) -> None: ...

class vtkVRPanelRepresentation(vtkmodules.vtkInteractionWidgets.vtkWidgetRepresentation):
    class InteractionStateType(int): ...
    Moving:'InteractionStateType'
    Outside:'InteractionStateType'
    def AllowAdjustmentOff(self) -> None: ...
    def AllowAdjustmentOn(self) -> None: ...
    def BuildRepresentation(self) -> None: ...
    def ComplexInteraction(self, iren:vtkRenderWindowInteractor, widget:vtkAbstractWidget, event:int, calldata:Pointer) -> None: ...
    def ComputeComplexInteractionState(self, iren:vtkRenderWindowInteractor, widget:vtkAbstractWidget, event:int, calldata:Pointer, modify:int=0) -> int: ...
    def EndComplexInteraction(self, iren:vtkRenderWindowInteractor, widget:vtkAbstractWidget, event:int, calldata:Pointer) -> None: ...
    def GetAllowAdjustment(self) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetTextActor(self) -> vtkTextActor3D: ...
    def HasTranslucentPolygonalGeometry(self) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkVRPanelRepresentation: ...
    def PlaceWidget(self, bounds:[float, float, float, float, float, float]) -> None: ...
    def PlaceWidgetExtended(self, bounds:(float, ...), normal:(float, ...) , upvec:(float, ...), scale:float) -> None: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def RenderOpaqueGeometry(self, __a:vtkViewport) -> int: ...
    def RenderTranslucentPolygonalGeometry(self, __a:vtkViewport) -> int: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkVRPanelRepresentation: ...
    def SetAllowAdjustment(self, _arg:bool) -> None: ...
    def SetCoordinateSystemToHMD(self) -> None: ...
    def SetCoordinateSystemToLeftController(self) -> None: ...
    def SetCoordinateSystemToRightController(self) -> None: ...
    def SetCoordinateSystemToWorld(self) -> None: ...
    def SetText(self, str:str) -> None: ...
    def StartComplexInteraction(self, iren:vtkRenderWindowInteractor, widget:vtkAbstractWidget, event:int, calldata:Pointer) -> None: ...

class vtkVRPanelWidget(vtkmodules.vtkInteractionWidgets.vtkAbstractWidget):
    def CreateDefaultRepresentation(self) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkVRPanelWidget: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkVRPanelWidget: ...
    def SetRepresentation(self, rep:vtkVRPanelRepresentation) -> None: ...

class vtkVRRay(vtkmodules.vtkCommonCore.vtkObject):
    def Build(self, win:vtkOpenGLRenderWindow) -> bool: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShow(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkVRRay: ...
    def ReleaseGraphicsResources(self, win:vtkRenderWindow) -> None: ...
    def Render(self, win:vtkOpenGLRenderWindow, poseMatrix:vtkMatrix4x4) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkVRRay: ...
    @overload
    def SetColor(self, _arg1:float, _arg2:float, _arg3:float) -> None: ...
    @overload
    def SetColor(self, _arg:(float, float, float)) -> None: ...
    def SetLength(self, _arg:float) -> None: ...
    def SetShow(self, _arg:bool) -> None: ...

class vtkVRRenderWindow(vtkmodules.vtkRenderingOpenGL2.vtkOpenGLRenderWindow):
    LeftEye:int
    PhysicalToWorldMatrixModified:int
    RightEye:int
    def AddRenderer(self, __a:vtkRenderer) -> None: ...
    def BaseStationVisibilityOff(self) -> None: ...
    def BaseStationVisibilityOn(self) -> None: ...
    def Finalize(self) -> None: ...
    def GetBaseStationVisibility(self) -> bool: ...
    def GetDeviceToPhysicalMatrixForDevice(self, idx:vtkEventDataDevice) -> vtkMatrix4x4: ...
    def GetDeviceToWorldMatrixForDevice(self, device:vtkEventDataDevice, deviceToWorldMatrix:vtkMatrix4x4) -> bool: ...
    def GetEventPending(self) -> int: ...
    def GetGenericContext(self) -> Pointer: ...
    def GetGenericDisplayId(self) -> Pointer: ...
    def GetGenericDrawable(self) -> Pointer: ...
    def GetGenericParentId(self) -> Pointer: ...
    def GetGenericWindowId(self) -> Pointer: ...
    def GetHelperWindow(self) -> vtkOpenGLRenderWindow: ...
    def GetInitialized(self) -> bool: ...
    def GetModelForDevice(self, idx:vtkEventDataDevice) -> vtkVRModel: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPhysicalScale(self) -> float: ...
    def GetPhysicalToWorldMatrix(self, matrix:vtkMatrix4x4) -> None: ...
    def GetPhysicalTranslation(self) -> (float, float, float): ...
    def GetPhysicalViewDirection(self) -> (float, float, float): ...
    def GetPhysicalViewUp(self) -> (float, float, float): ...
    def GetRenderBufferSize(self, width:int, height:int) -> None: ...
    def GetScreenSize(self) -> (int, int): ...
    def GetState(self) -> vtkOpenGLState: ...
    def GetTrackHMD(self) -> bool: ...
    def Initialize(self) -> None: ...
    def InitializeViewFromCamera(self, cam:vtkCamera) -> None: ...
    def IsA(self, type:str) -> int: ...
    def IsCurrent(self) -> bool: ...
    def IsDirect(self) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeCurrent(self) -> None: ...
    def MakeRenderWindowInteractor(self) -> vtkRenderWindowInteractor: ...
    def NewInstance(self) -> vtkVRRenderWindow: ...
    def ReleaseCurrent(self) -> None: ...
    def ReleaseGraphicsResources(self, __a:vtkWindow) -> None: ...
    def Render(self) -> None: ...
    def RenderModels(self) -> None: ...
    def ReportCapabilities(self) -> str: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkVRRenderWindow: ...
    def SetBaseStationVisibility(self, _arg:bool) -> None: ...
    def SetHelperWindow(self, val:vtkOpenGLRenderWindow) -> None: ...
    def SetPhysicalScale(self, __a:float) -> None: ...
    def SetPhysicalToWorldMatrix(self, matrix:vtkMatrix4x4) -> None: ...
    @overload
    def SetPhysicalTranslation(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetPhysicalTranslation(self, __a:[float, float, float]) -> None: ...
    @overload
    def SetPhysicalViewDirection(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetPhysicalViewDirection(self, __a:[float, float, float]) -> None: ...
    @overload
    def SetPhysicalViewUp(self, __a:float, __b:float, __c:float) -> None: ...
    @overload
    def SetPhysicalViewUp(self, __a:[float, float, float]) -> None: ...
    @overload
    def SetSize(self, width:int, height:int) -> None: ...
    @overload
    def SetSize(self, a:[int, int]) -> None: ...
    def SetTrackHMD(self, _arg:bool) -> None: ...
    def Start(self) -> None: ...
    def SupportsOpenGL(self) -> int: ...
    def UpdateHMDMatrixPose(self) -> None: ...

class vtkVRRenderWindowInteractor(vtkmodules.vtkRenderingCore.vtkRenderWindowInteractor3D):
    def ConvertPoseToWorldCoordinates(self, poseInTrackingCoordinates:vtkMatrix4x4, pos:[float, float, float], wxyz:[float, float, float, float], ppos:[float, float, float], wdir:[float, float, float]) -> None: ...
    def DoOneEvent(self, renWin:vtkVRRenderWindow, ren:vtkRenderer) -> None: ...
    def ExitCallback(self) -> None: ...
    def GetActionManifestFileName(self) -> str: ...
    def GetActionSetName(self) -> str: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetPhysicalScale(self) -> float: ...
    def GetPhysicalTranslation(self, __a:vtkCamera) -> Pointer: ...
    def GetPhysicalViewDirection(self) -> Pointer: ...
    def GetPhysicalViewUp(self) -> Pointer: ...
    def GetPointerDevice(self) -> vtkEventDataDevice: ...
    def GetStartingPhysicalToWorldMatrix(self, startingPhysicalToWorldMatrix:vtkMatrix4x4) -> None: ...
    def Initialize(self) -> None: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def NewInstance(self) -> vtkVRRenderWindowInteractor: ...
    def ProcessEvents(self) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkVRRenderWindowInteractor: ...
    def SetActionManifestFileName(self, _arg:str) -> None: ...
    def SetActionSetName(self, _arg:str) -> None: ...
    @staticmethod
    def SetClassExitMethod(f:Callback) -> None: ...
    def SetPhysicalScale(self, __a:float) -> None: ...
    def SetPhysicalTranslation(self, __a:vtkCamera, __b:float, __c:float, __d:float) -> None: ...
    def SetPhysicalViewDirection(self, __a:float, __b:float, __c:float) -> None: ...
    def SetPhysicalViewUp(self, __a:float, __b:float, __c:float) -> None: ...

class vtkVRRenderer(vtkmodules.vtkRenderingOpenGL2.vtkOpenGLRenderer):
    def DeviceRender(self) -> None: ...
    def GetFloorTransform(self, transform:vtkTransform) -> None: ...
    def GetNumberOfGenerationsFromBase(self, type:str) -> int: ...
    @staticmethod
    def GetNumberOfGenerationsFromBaseType(type:str) -> int: ...
    def GetShowFloor(self) -> bool: ...
    def IsA(self, type:str) -> int: ...
    @staticmethod
    def IsTypeOf(type:str) -> int: ...
    def MakeCamera(self) -> vtkCamera: ...
    def NewInstance(self) -> vtkVRRenderer: ...
    @overload
    def ResetCamera(self, bounds:(float, float, float, float, float, float)) -> None: ...
    @overload
    def ResetCamera(self) -> None: ...
    @overload
    def ResetCamera(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @overload
    def ResetCameraClippingRange(self) -> None: ...
    @overload
    def ResetCameraClippingRange(self, bounds:(float, float, float, float, float, float)) -> None: ...
    @overload
    def ResetCameraClippingRange(self, xmin:float, xmax:float, ymin:float, ymax:float, zmin:float, zmax:float) -> None: ...
    @staticmethod
    def SafeDownCast(o:vtkObjectBase) -> vtkVRRenderer: ...
    def SetShowFloor(self, __a:bool) -> None: ...

