/*  util.cpp -- 

    Copyright (C) 2023 Kuan-Hao Chao

    Author: Kuan-Hao Chao <kuanhao.chao@gmail.com> */

#include "util.h"

#include "junc.h"
#include "common.h"
#include <string>
#include <iostream>
#include <htslib/htslib/hts.h>
#include <unordered_map>
#include <fstream>
#include <sstream>

std::string get_full_path(std::string fname){
    const char *cur_path = fname.c_str();
    char *actualpath;


    actualpath = realpath(cur_path, NULL);
    if (actualpath != NULL){
        return std::string(actualpath);
        free(actualpath);
    }
    else{
        std::cerr<<"could not resolve path: "<<fname<<std::endl;
        exit(-1);
    }
}

void keepAlignment(GSamWriter* outfile_target, GSamRecord* brec, int& counter) {
    outfile_target->write(brec);
    counter += 1;
    // if (count) ALN_COUNT_GOOD++;
}

static unsigned char comp_base[256] = {
  0,   1,   2,   3,   4,   5,   6,   7,   8,   9,  10,  11,  12,  13,  14,  15,
 16,  17,  18,  19,  20,  21,  22,  23,  24,  25,  26,  27,  28,  29,  30,  31,
 32, '!', '"', '#', '$', '%', '&', '\'','(', ')', '*', '+', ',', '-', '.', '/',
'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?',
'@', 'T', 'V', 'G', 'H', 'E', 'F', 'C', 'D', 'I', 'J', 'M', 'L', 'K', 'N', 'O',
'P', 'Q', 'Y', 'S', 'A', 'A', 'B', 'W', 'X', 'R', 'Z', '[', '\\',']', '^', '_',
'`', 't', 'v', 'g', 'h', 'e', 'f', 'c', 'd', 'i', 'j', 'm', 'l', 'k', 'n', 'o',
'p', 'q', 'y', 's', 'a', 'a', 'b', 'w', 'x', 'r', 'z', '{', '|', '}', '~', 127,
128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143,
144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159,
160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175,
176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191,
192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207,
208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223,
224, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 239,
240, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255,
};

void reverse_complement(char *str, const hts_pos_t len) {
    char c;
    hts_pos_t i = 0, j = len - 1;

    while (i <= j) {
        c = str[i];
        str[i] = comp_base[(unsigned char)str[j]];
        str[j] = comp_base[(unsigned char)c];
        i++;
        j--;
    }
}


wchar_t *GetWC(const char *c)
{
    const size_t cSize = strlen(c)+1;
    wchar_t* wc = new wchar_t[cSize];
    mbstowcs (wc, c, cSize);

    return wc;
}
int usage_extract(){ 
    GMessage(
    "usage:   splam-extract [arguments] BAM-file(s) \n\n\n");
    GMessage(
    "\033[1m\033[91mRequired argument:\033[0m\n"
    "\t-o / --output\t\tPath to the output directory\n\n"
    "\033[1m\033[94mOptional argument:\033[0m\n"
    "\t-M / --max-splice <INT>:\tThe maximum intron length for the splice site.\n"
    "\t-g / --bundle-gap <INT>:\tMinimum locus gap separation value. Reads that are mapped closer than this distance are merged together in the same processing bundle. Default: 100 (bp).\n\n"        
    );
  return 0;
}


int usage_clean(){ 
    GMessage(
    "usage:   splam-clean [arguments] \n\n\n");
    GMessage(
    "\033[1m\033[91mRequired argument:\033[0m\n"
    // "\t-b / --bam\t\tPath to the alignment file (BAM)\n"
    "\t-o / --output\t\tPath to the output directory\n\n");
    return 0;
}



std::unordered_map<std::string, int> get_hg38_chrom_size(std::string target) {
    std::unordered_map<std::string, int> chrs;
    std::string ref_file;
    if (target == "STAR") {
        ref_file = "./hg38_chrom_size_refseq.tsv";
    } else {
        ref_file = "./hg38_chrom_size.tsv";
    }
    std::ifstream ref_f(ref_file);
    std::string line;
    while(getline(ref_f, line)){
        std::string chromosome;
        int len;
        std::replace(line.begin(), line.end(), '\t', ' ');
        std::stringstream ss(line);
        ss >> chromosome;
        ss >> len;
        chrs[chromosome] = len;
    }   
    // for (auto i : chrs) {
    //   std::cout << i.first << " ---- " << i.second << std::endl;
    // }
    return chrs;
}



void flushBrec(GVec<GSamRecord*> &pbrecs, std::unordered_map<std::string, int> &hits, GSamWriter* outfile_cleaned) {
    if (pbrecs.Count()==0) return;
    for (int i=0; i < pbrecs.Count(); i++) {
        std::string kv = pbrecs[i]->name();

        std::cout << "kv: " << kv << std::endl;
        std::string tmp = std::to_string(pbrecs[i]->pairOrder());
        kv += ";";
        kv += tmp;
        if (hits.find(kv) != hits.end()) {
            std::cout << "Update NH tage!!" << std::endl;
            int new_nh = pbrecs[i]->tag_int("NH", 0) - hits[kv];
            pbrecs[i]->add_int_tag("NH", new_nh);
        }
// using GArray
//        CRead tmp(pbrecs[i]->pairOrder(), pbrecs[i]->name());
//        int idx;
//        if (spur_reads.Found(tmp, idx)) {
//            int new_nh = pbrecs[i]->tag_int("NH", 0) - spur_reads[idx].spurCnt;
//            pbrecs[i]->add_int_tag("NH", new_nh);
//        }
// for testing
       if (!strcmp(pbrecs[i]->name(), "ERR188044.24337229")) {
           std::cout << pbrecs[i]->tag_int("NH", 0) << std::endl;
       }
    }
}

void create_CHRS() {
    std::string tmp = "NC_000001.11";
    CHRS[tmp] = 248956422;
    tmp = "NT_187361.1";
    CHRS[tmp] = 175055;
    tmp = "NT_187362.1";
    CHRS[tmp] = 32032;
    tmp = "NT_187363.1";
    CHRS[tmp] = 127682;
    tmp = "NT_187364.1";
    CHRS[tmp] = 66860;
    tmp = "NT_187365.1";
    CHRS[tmp] = 40176;
    tmp = "NT_187366.1";
    CHRS[tmp] = 42210;
    tmp = "NT_187367.1";
    CHRS[tmp] = 176043;
    tmp = "NT_187368.1";
    CHRS[tmp] = 40745;
    tmp = "NT_187369.1";
    CHRS[tmp] = 41717;
    tmp = "NC_000002.12";
    CHRS[tmp] = 242193529;
    tmp = "NT_187370.1";
    CHRS[tmp] = 161471;
    tmp = "NT_187371.1";
    CHRS[tmp] = 153799;
    tmp = "NC_000003.12";
    CHRS[tmp] = 198295559;
    tmp = "NT_167215.1";
    CHRS[tmp] = 155397;
    tmp = "NC_000004.12";
    CHRS[tmp] = 190214555;
    tmp = "NT_113793.3";
    CHRS[tmp] = 209709;
    tmp = "NC_000005.10";
    CHRS[tmp] = 181538259;
    tmp = "NT_113948.1";
    CHRS[tmp] = 92689;
    tmp = "NC_000006.12";
    CHRS[tmp] = 170805979;
    tmp = "NC_000007.14";
    CHRS[tmp] = 159345973;
    tmp = "NC_000008.11";
    CHRS[tmp] = 145138636;
    tmp = "NC_000009.12";
    CHRS[tmp] = 138394717;
    tmp = "NT_187372.1";
    CHRS[tmp] = 40062;
    tmp = "NT_187373.1";
    CHRS[tmp] = 38054;
    tmp = "NT_187374.1";
    CHRS[tmp] = 176845;
    tmp = "NT_187375.1";
    CHRS[tmp] = 39050;
    tmp = "NC_000010.11";
    CHRS[tmp] = 133797422;
    tmp = "NC_000011.10";
    CHRS[tmp] = 135086622;
    tmp = "NC_000012.12";
    CHRS[tmp] = 133275309;
    tmp = "NC_000013.11";
    CHRS[tmp] = 114364328;
    tmp = "NC_000014.9";
    CHRS[tmp] = 107043718;
    tmp = "NT_113796.3";
    CHRS[tmp] = 201709;
    tmp = "NT_167219.1";
    CHRS[tmp] = 211173;
    tmp = "NT_187377.1";
    CHRS[tmp] = 194050;
    tmp = "NT_113888.1";
    CHRS[tmp] = 191469;
    tmp = "NT_187378.1";
    CHRS[tmp] = 38115;
    tmp = "NT_187379.1";
    CHRS[tmp] = 39555;
    tmp = "NT_187380.1";
    CHRS[tmp] = 172810;
    tmp = "NT_187381.1";
    CHRS[tmp] = 43739;
    tmp = "NC_000015.10";
    CHRS[tmp] = 101991189;
    tmp = "NT_187382.1";
    CHRS[tmp] = 448248;
    tmp = "NC_000016.10";
    CHRS[tmp] = 90338345;
    tmp = "NT_187383.1";
    CHRS[tmp] = 1872759;
    tmp = "NC_000017.11";
    CHRS[tmp] = 83257441;
    tmp = "NT_113930.2";
    CHRS[tmp] = 185591;
    tmp = "NT_187384.1";
    CHRS[tmp] = 280839;
    tmp = "NT_187385.1";
    CHRS[tmp] = 112551;
    tmp = "NC_000018.10";
    CHRS[tmp] = 80373285;
    tmp = "NC_000019.10";
    CHRS[tmp] = 58617616;
    tmp = "NC_000020.11";
    CHRS[tmp] = 64444167;
    tmp = "NC_000021.9";
    CHRS[tmp] = 46709983;
    tmp = "NC_000022.11";
    CHRS[tmp] = 50818468;
    tmp = "NT_187386.1";
    CHRS[tmp] = 150754;
    tmp = "NT_187387.1";
    CHRS[tmp] = 41543;
    tmp = "NT_187388.1";
    CHRS[tmp] = 179772;
    tmp = "NT_187390.1";
    CHRS[tmp] = 42811;
    tmp = "NT_187391.1";
    CHRS[tmp] = 181920;
    tmp = "NT_187392.1";
    CHRS[tmp] = 103838;
    tmp = "NT_187393.1";
    CHRS[tmp] = 99375;
    tmp = "NT_187394.1";
    CHRS[tmp] = 73985;
    tmp = "NC_000023.11";
    CHRS[tmp] = 156040895;
    tmp = "NC_000024.10";
    CHRS[tmp] = 57227415;
    tmp = "NT_187395.1";
    CHRS[tmp] = 37240;
    tmp = "NT_187396.1";
    CHRS[tmp] = 2274;
    tmp = "NT_187397.1";
    CHRS[tmp] = 2165;
    tmp = "NT_187398.1";
    CHRS[tmp] = 1942;
    tmp = "NT_187399.1";
    CHRS[tmp] = 1472;
    tmp = "NT_187400.1";
    CHRS[tmp] = 21476;
    tmp = "NT_187401.1";
    CHRS[tmp] = 4416;
    tmp = "NT_187402.1";
    CHRS[tmp] = 1201;
    tmp = "NT_187403.1";
    CHRS[tmp] = 1444;
    tmp = "NT_187404.1";
    CHRS[tmp] = 2276;
    tmp = "NT_187405.1";
    CHRS[tmp] = 998;
    tmp = "NT_187406.1";
    CHRS[tmp] = 12399;
    tmp = "NT_187407.1";
    CHRS[tmp] = 37690;
    tmp = "NT_187408.1";
    CHRS[tmp] = 1179;
    tmp = "NT_187409.1";
    CHRS[tmp] = 2646;
    tmp = "NT_187410.1";
    CHRS[tmp] = 2489;
    tmp = "NT_187411.1";
    CHRS[tmp] = 1029;
    tmp = "NT_187412.1";
    CHRS[tmp] = 2145;
    tmp = "NT_187413.1";
    CHRS[tmp] = 2321;
    tmp = "NT_187414.1";
    CHRS[tmp] = 2140;
    tmp = "NT_187415.1";
    CHRS[tmp] = 2043;
    tmp = "NT_187416.1";
    CHRS[tmp] = 1445;
    tmp = "NT_187417.1";
    CHRS[tmp] = 981;
    tmp = "NT_187418.1";
    CHRS[tmp] = 1884;
    tmp = "NT_187419.1";
    CHRS[tmp] = 1361;
    tmp = "NT_187420.1";
    CHRS[tmp] = 392061;
    tmp = "NT_187421.1";
    CHRS[tmp] = 1233;
    tmp = "NT_187422.1";
    CHRS[tmp] = 1774;
    tmp = "NT_187423.1";
    CHRS[tmp] = 3920;
    tmp = "NT_187424.1";
    CHRS[tmp] = 92983;
    tmp = "NT_187425.1";
    CHRS[tmp] = 112505;
    tmp = "NT_187426.1";
    CHRS[tmp] = 4055;
    tmp = "NT_187427.1";
    CHRS[tmp] = 2415;
    tmp = "NT_187428.1";
    CHRS[tmp] = 2318;
    tmp = "NT_187429.1";
    CHRS[tmp] = 2186;
    tmp = "NT_187430.1";
    CHRS[tmp] = 1951;
    tmp = "NT_187431.1";
    CHRS[tmp] = 1300;
    tmp = "NT_187432.1";
    CHRS[tmp] = 22689;
    tmp = "NT_187433.1";
    CHRS[tmp] = 138126;
    tmp = "NT_187434.1";
    CHRS[tmp] = 5674;
    tmp = "NT_187435.1";
    CHRS[tmp] = 8127;
    tmp = "NT_187436.1";
    CHRS[tmp] = 6361;
    tmp = "NT_187437.1";
    CHRS[tmp] = 5353;
    tmp = "NT_187438.1";
    CHRS[tmp] = 3253;
    tmp = "NT_187439.1";
    CHRS[tmp] = 1899;
    tmp = "NT_187440.1";
    CHRS[tmp] = 2983;
    tmp = "NT_187441.1";
    CHRS[tmp] = 2168;
    tmp = "NT_187442.1";
    CHRS[tmp] = 993;
    tmp = "NT_187443.1";
    CHRS[tmp] = 91309;
    tmp = "NT_187444.1";
    CHRS[tmp] = 1202;
    tmp = "NT_187445.1";
    CHRS[tmp] = 1599;
    tmp = "NT_187446.1";
    CHRS[tmp] = 1400;
    tmp = "NT_187447.1";
    CHRS[tmp] = 2969;
    tmp = "NT_187448.1";
    CHRS[tmp] = 1553;
    tmp = "NT_187449.1";
    CHRS[tmp] = 7046;
    tmp = "NT_187450.1";
    CHRS[tmp] = 31033;
    tmp = "NT_187451.1";
    CHRS[tmp] = 44474;
    tmp = "NT_187452.1";
    CHRS[tmp] = 4685;
    tmp = "NT_187453.1";
    CHRS[tmp] = 4513;
    tmp = "NT_187454.1";
    CHRS[tmp] = 6504;
    tmp = "NT_187455.1";
    CHRS[tmp] = 6158;
    tmp = "NT_187456.1";
    CHRS[tmp] = 3041;
    tmp = "NT_187457.1";
    CHRS[tmp] = 5796;
    tmp = "NT_187458.1";
    CHRS[tmp] = 1652;
    tmp = "NT_187459.1";
    CHRS[tmp] = 1040;
    tmp = "NT_187460.1";
    CHRS[tmp] = 1368;
    tmp = "NT_187461.1";
    CHRS[tmp] = 2699;
    tmp = "NT_187462.1";
    CHRS[tmp] = 1048;
    tmp = "NT_187463.1";
    CHRS[tmp] = 1428;
    tmp = "NT_187464.1";
    CHRS[tmp] = 1428;
    tmp = "NT_187465.1";
    CHRS[tmp] = 1026;
    tmp = "NT_187466.1";
    CHRS[tmp] = 1121;
    tmp = "NT_187467.1";
    CHRS[tmp] = 1803;
    tmp = "NT_187468.1";
    CHRS[tmp] = 2855;
    tmp = "NT_187469.1";
    CHRS[tmp] = 3530;
    tmp = "NT_187470.1";
    CHRS[tmp] = 8320;
    tmp = "NT_187471.1";
    CHRS[tmp] = 1048;
    tmp = "NT_187472.1";
    CHRS[tmp] = 1045;
    tmp = "NT_187473.1";
    CHRS[tmp] = 1298;
    tmp = "NT_187474.1";
    CHRS[tmp] = 2387;
    tmp = "NT_187475.1";
    CHRS[tmp] = 1537;
    tmp = "NT_187476.1";
    CHRS[tmp] = 1143;
    tmp = "NT_187477.1";
    CHRS[tmp] = 1880;
    tmp = "NT_187478.1";
    CHRS[tmp] = 1216;
    tmp = "NT_187479.1";
    CHRS[tmp] = 970;
    tmp = "NT_187480.1";
    CHRS[tmp] = 1788;
    tmp = "NT_187481.1";
    CHRS[tmp] = 1484;
    tmp = "NT_187482.1";
    CHRS[tmp] = 1750;
    tmp = "NT_187483.1";
    CHRS[tmp] = 1308;
    tmp = "NT_187484.1";
    CHRS[tmp] = 1658;
    tmp = "NT_187485.1";
    CHRS[tmp] = 971;
    tmp = "NT_187486.1";
    CHRS[tmp] = 1930;
    tmp = "NT_187487.1";
    CHRS[tmp] = 990;
    tmp = "NT_187488.1";
    CHRS[tmp] = 4215;
    tmp = "NT_187489.1";
    CHRS[tmp] = 1136;
    tmp = "NT_187490.1";
    CHRS[tmp] = 2656;
    tmp = "NT_187491.1";
    CHRS[tmp] = 1650;
    tmp = "NT_187492.1";
    CHRS[tmp] = 1451;
    tmp = "NT_187493.1";
    CHRS[tmp] = 2378;
    tmp = "NT_187494.1";
    CHRS[tmp] = 2805;
    tmp = "NT_187495.1";
    CHRS[tmp] = 7992;
    tmp = "NT_187496.1";
    CHRS[tmp] = 7642;
    tmp = "NT_113901.1";
    CHRS[tmp] = 182896;
    tmp = "NT_167213.1";
    CHRS[tmp] = 179198;
    tmp = "NT_167214.1";
    CHRS[tmp] = 161802;
    tmp = "NT_167218.1";
    CHRS[tmp] = 179693;
    tmp = "NT_187497.1";
    CHRS[tmp] = 157432;
    tmp = "NT_167220.1";
    CHRS[tmp] = 15008;
    tmp = "NT_167208.1";
    CHRS[tmp] = 164239;
    tmp = "NT_187498.1";
    CHRS[tmp] = 210658;
    tmp = "NT_187499.1";
    CHRS[tmp] = 168472;
    tmp = "NT_187500.1";
    CHRS[tmp] = 41891;
    tmp = "NT_187501.1";
    CHRS[tmp] = 66486;
    tmp = "NT_187502.1";
    CHRS[tmp] = 198735;
    tmp = "NT_187503.1";
    CHRS[tmp] = 93321;
    tmp = "NT_187504.1";
    CHRS[tmp] = 158759;
    tmp = "NT_187505.1";
    CHRS[tmp] = 148850;
    tmp = "NT_187506.1";
    CHRS[tmp] = 150742;
    tmp = "NT_187508.1";
    CHRS[tmp] = 62944;
    tmp = "NT_187509.1";
    CHRS[tmp] = 40191;
    tmp = "NT_187510.1";
    CHRS[tmp] = 36723;
    tmp = "NT_187511.1";
    CHRS[tmp] = 79590;
    tmp = "NT_187512.1";
    CHRS[tmp] = 71251;
    tmp = "NT_167209.1";
    CHRS[tmp] = 137718;
    tmp = "NT_187513.1";
    CHRS[tmp] = 186739;
    tmp = "NT_167211.2";
    CHRS[tmp] = 176608;
    tmp = "NT_113889.1";
    CHRS[tmp] = 161147;
    tmp = "NW_012132914.1";
    CHRS[tmp] = 467143;
    tmp = "NW_015495298.1";
    CHRS[tmp] = 278659;
    tmp = "NW_025791756.1";
    CHRS[tmp] = 1572686;
    tmp = "NW_011332688.1";
    CHRS[tmp] = 305542;
    tmp = "NW_014040926.1";
    CHRS[tmp] = 349938;
    tmp = "NW_009646195.1";
    CHRS[tmp] = 166200;
    tmp = "NW_018654706.1";
    CHRS[tmp] = 166136;
    tmp = "NW_019805487.1";
    CHRS[tmp] = 44955;
    tmp = "NW_009646194.1";
    CHRS[tmp] = 186494;
    tmp = "NW_018654707.1";
    CHRS[tmp] = 140355;
    tmp = "NW_014040925.1";
    CHRS[tmp] = 141019;
    tmp = "NW_017852928.1";
    CHRS[tmp] = 551020;
    tmp = "NW_009646196.1";
    CHRS[tmp] = 122022;
    tmp = "NW_025791753.1";
    CHRS[tmp] = 516764;
    tmp = "NW_025791758.1";
    CHRS[tmp] = 211934;
    tmp = "NW_025791759.1";
    CHRS[tmp] = 250447;
    tmp = "NW_025791754.1";
    CHRS[tmp] = 847441;
    tmp = "NW_011332687.1";
    CHRS[tmp] = 460100;
    tmp = "NW_018654708.1";
    CHRS[tmp] = 330031;
    tmp = "NW_014040927.1";
    CHRS[tmp] = 212205;
    tmp = "NW_025791757.1";
    CHRS[tmp] = 210426;
    tmp = "NW_025791755.1";
    CHRS[tmp] = 335159;
    tmp = "NW_021159988.1";
    CHRS[tmp] = 84043;
    tmp = "NW_025791767.1";
    CHRS[tmp] = 244725;
    tmp = "NW_025791768.1";
    CHRS[tmp] = 174385;
    tmp = "NW_025791766.1";
    CHRS[tmp] = 489404;
    tmp = "NW_025791763.1";
    CHRS[tmp] = 284971;
    tmp = "NW_012132915.1";
    CHRS[tmp] = 481245;
    tmp = "NW_025791760.1";
    CHRS[tmp] = 431782;
    tmp = "NW_025791765.1";
    CHRS[tmp] = 955087;
    tmp = "NW_018654709.1";
    CHRS[tmp] = 181658;
    tmp = "NW_025791762.1";
    CHRS[tmp] = 500581;
    tmp = "NW_025791761.1";
    CHRS[tmp] = 535251;
    tmp = "NW_025791764.1";
    CHRS[tmp] = 120381;
    tmp = "NW_015495299.1";
    CHRS[tmp] = 535088;
    tmp = "NW_018654710.1";
    CHRS[tmp] = 140361;
    tmp = "NW_011332690.1";
    CHRS[tmp] = 365499;
    tmp = "NW_021159987.1";
    CHRS[tmp] = 145975;
    tmp = "NW_011332689.1";
    CHRS[tmp] = 208149;
    tmp = "NW_017363813.1";
    CHRS[tmp] = 411654;
    tmp = "NW_025791770.1";
    CHRS[tmp] = 301310;
    tmp = "NW_025791771.1";
    CHRS[tmp] = 475876;
    tmp = "NW_009646197.1";
    CHRS[tmp] = 451168;
    tmp = "NW_012132916.1";
    CHRS[tmp] = 373699;
    tmp = "NW_011332691.1";
    CHRS[tmp] = 415308;
    tmp = "NW_021159989.1";
    CHRS[tmp] = 215443;
    tmp = "NW_018654711.1";
    CHRS[tmp] = 175849;
    tmp = "NW_012132917.1";
    CHRS[tmp] = 165718;
    tmp = "NW_009646198.1";
    CHRS[tmp] = 305979;
    tmp = "NW_019805491.1";
    CHRS[tmp] = 105527;
    tmp = "NW_019805492.1";
    CHRS[tmp] = 195063;
    tmp = "NW_019805490.1";
    CHRS[tmp] = 302885;
    tmp = "NW_019805489.1";
    CHRS[tmp] = 197752;
    tmp = "NW_019805488.1";
    CHRS[tmp] = 164041;
    tmp = "NW_025791769.1";
    CHRS[tmp] = 469342;
    tmp = "NW_021159990.1";
    CHRS[tmp] = 235734;
    tmp = "NW_021159993.1";
    CHRS[tmp] = 176674;
    tmp = "NW_013171799.1";
    CHRS[tmp] = 90922;
    tmp = "NW_025791774.1";
    CHRS[tmp] = 205691;
    tmp = "NW_021159992.1";
    CHRS[tmp] = 53476;
    tmp = "NW_021159994.1";
    CHRS[tmp] = 125549;
    tmp = "NW_021159991.1";
    CHRS[tmp] = 341066;
    tmp = "NW_021159995.1";
    CHRS[tmp] = 276109;
    tmp = "NW_013171800.1";
    CHRS[tmp] = 163749;
    tmp = "NW_013171801.1";
    CHRS[tmp] = 236512;
    tmp = "NW_025791772.1";
    CHRS[tmp] = 308682;
    tmp = "NW_017363814.1";
    CHRS[tmp] = 420675;
    tmp = "NW_025791773.1";
    CHRS[tmp] = 113364;
    tmp = "NW_015495301.1";
    CHRS[tmp] = 205407;
    tmp = "NW_015495300.1";
    CHRS[tmp] = 230434;
    tmp = "NW_025791777.1";
    CHRS[tmp] = 2101585;
    tmp = "NW_018654712.1";
    CHRS[tmp] = 135987;
    tmp = "NW_025791776.1";
    CHRS[tmp] = 208405;
    tmp = "NW_009646199.1";
    CHRS[tmp] = 139087;
    tmp = "NW_016107297.1";
    CHRS[tmp] = 362221;
    tmp = "NW_025791779.1";
    CHRS[tmp] = 302485;
    tmp = "NW_021159996.1";
    CHRS[tmp] = 89956;
    tmp = "NW_025791778.1";
    CHRS[tmp] = 508332;
    tmp = "NW_016107298.1";
    CHRS[tmp] = 673059;
    tmp = "NW_025791775.1";
    CHRS[tmp] = 34400;
    tmp = "NW_018654713.1";
    CHRS[tmp] = 242796;
    tmp = "NW_013171803.1";
    CHRS[tmp] = 82315;
    tmp = "NW_025791780.1";
    CHRS[tmp] = 383128;
    tmp = "NW_012132918.1";
    CHRS[tmp] = 320750;
    tmp = "NW_009646200.1";
    CHRS[tmp] = 268330;
    tmp = "NW_013171802.1";
    CHRS[tmp] = 245716;
    tmp = "NW_017363815.1";
    CHRS[tmp] = 139427;
    tmp = "NW_021159997.1";
    CHRS[tmp] = 73265;
    tmp = "NW_021159998.1";
    CHRS[tmp] = 254759;
    tmp = "NW_019805493.1";
    CHRS[tmp] = 172555;
    tmp = "NW_025791781.1";
    CHRS[tmp] = 464417;
    tmp = "NW_017852929.1";
    CHRS[tmp] = 142129;
    tmp = "NW_017852930.1";
    CHRS[tmp] = 468267;
    tmp = "NW_018654714.1";
    CHRS[tmp] = 589656;
    tmp = "NW_018654715.1";
    CHRS[tmp] = 680662;
    tmp = "NW_012132919.1";
    CHRS[tmp] = 179932;
    tmp = "NW_025791785.1";
    CHRS[tmp] = 429744;
    tmp = "NW_018654717.1";
    CHRS[tmp] = 6367528;
    tmp = "NW_017852932.1";
    CHRS[tmp] = 265876;
    tmp = "NW_025791782.1";
    CHRS[tmp] = 150302;
    tmp = "NW_017852931.1";
    CHRS[tmp] = 156998;
    tmp = "NW_025791784.1";
    CHRS[tmp] = 106905;
    tmp = "NW_019805494.1";
    CHRS[tmp] = 103072;
    tmp = "NW_025791786.1";
    CHRS[tmp] = 207371;
    tmp = "NW_018654716.1";
    CHRS[tmp] = 165120;
    tmp = "NW_025791783.1";
    CHRS[tmp] = 39290;
    tmp = "NW_013171804.1";
    CHRS[tmp] = 163882;
    tmp = "NW_013171805.1";
    CHRS[tmp] = 134099;
    tmp = "NW_025791789.1";
    CHRS[tmp] = 569668;
    tmp = "NW_025791787.1";
    CHRS[tmp] = 340717;
    tmp = "NW_025791788.1";
    CHRS[tmp] = 482250;
    tmp = "NW_009646201.1";
    CHRS[tmp] = 330164;
    tmp = "NW_021159999.1";
    CHRS[tmp] = 25408;
    tmp = "NW_021160000.1";
    CHRS[tmp] = 454963;
    tmp = "NW_011332694.1";
    CHRS[tmp] = 420164;
    tmp = "NW_021160001.1";
    CHRS[tmp] = 292944;
    tmp = "NW_013171806.1";
    CHRS[tmp] = 185507;
    tmp = "NW_009646202.1";
    CHRS[tmp] = 277797;
    tmp = "NW_013171807.1";
    CHRS[tmp] = 264545;
    tmp = "NW_025791790.1";
    CHRS[tmp] = 196262;
    tmp = "NW_011332693.1";
    CHRS[tmp] = 85284;
    tmp = "NW_011332692.1";
    CHRS[tmp] = 14347;
    tmp = "NW_015148966.2";
    CHRS[tmp] = 204999;
    tmp = "NW_025791792.1";
    CHRS[tmp] = 434831;
    tmp = "NW_021160004.1";
    CHRS[tmp] = 270122;
    tmp = "NW_025791794.1";
    CHRS[tmp] = 122722;
    tmp = "NW_011332695.1";
    CHRS[tmp] = 203552;
    tmp = "NW_021160006.1";
    CHRS[tmp] = 170928;
    tmp = "NW_019805496.1";
    CHRS[tmp] = 279644;
    tmp = "NW_019805495.1";
    CHRS[tmp] = 305244;
    tmp = "NW_017363816.1";
    CHRS[tmp] = 140877;
    tmp = "NW_025791793.1";
    CHRS[tmp] = 344606;
    tmp = "NW_019805498.1";
    CHRS[tmp] = 181167;
    tmp = "NW_021160005.1";
    CHRS[tmp] = 217075;
    tmp = "NW_021160003.1";
    CHRS[tmp] = 165419;
    tmp = "NW_019805497.1";
    CHRS[tmp] = 301637;
    tmp = "NW_013171808.1";
    CHRS[tmp] = 181958;
    tmp = "NW_021160002.1";
    CHRS[tmp] = 45257;
    tmp = "NW_025791791.1";
    CHRS[tmp] = 261194;
    tmp = "NW_009646203.1";
    CHRS[tmp] = 108875;
    tmp = "NW_013171809.1";
    CHRS[tmp] = 109323;
    tmp = "NW_018654718.1";
    CHRS[tmp] = 1046838;
    tmp = "NW_021160008.1";
    CHRS[tmp] = 192531;
    tmp = "NW_011332696.1";
    CHRS[tmp] = 541038;
    tmp = "NW_009646204.1";
    CHRS[tmp] = 211377;
    tmp = "NW_025791795.1";
    CHRS[tmp] = 104537;
    tmp = "NW_018654720.1";
    CHRS[tmp] = 174808;
    tmp = "NW_015148967.1";
    CHRS[tmp] = 315610;
    tmp = "NW_018654719.1";
    CHRS[tmp] = 64689;
    tmp = "NW_011332697.1";
    CHRS[tmp] = 86533;
    tmp = "NW_019805499.1";
    CHRS[tmp] = 154139;
    tmp = "NW_021160007.1";
    CHRS[tmp] = 297568;
    tmp = "NW_021160012.1";
    CHRS[tmp] = 409912;
    tmp = "NW_011332699.1";
    CHRS[tmp] = 356766;
    tmp = "NW_013171810.1";
    CHRS[tmp] = 168146;
    tmp = "NW_021160009.1";
    CHRS[tmp] = 7309;
    tmp = "NW_009646205.1";
    CHRS[tmp] = 35455;
    tmp = "NW_011332700.1";
    CHRS[tmp] = 148762;
    tmp = "NW_013171811.1";
    CHRS[tmp] = 123480;
    tmp = "NW_021160010.1";
    CHRS[tmp] = 158944;
    tmp = "NW_021160011.1";
    CHRS[tmp] = 65394;
    tmp = "NW_011332698.1";
    CHRS[tmp] = 206320;
    tmp = "NW_021160013.1";
    CHRS[tmp] = 399183;
    tmp = "NW_025791796.1";
    CHRS[tmp] = 722645;
    tmp = "NW_018654722.1";
    CHRS[tmp] = 690932;
    tmp = "NW_021160014.1";
    CHRS[tmp] = 264228;
    tmp = "NW_018654721.1";
    CHRS[tmp] = 171798;
    tmp = "NW_011332701.1";
    CHRS[tmp] = 4998962;
    tmp = "NW_021160018.1";
    CHRS[tmp] = 396515;
    tmp = "NW_021160017.1";
    CHRS[tmp] = 5500449;
    tmp = "NW_012132920.1";
    CHRS[tmp] = 2365364;
    tmp = "NW_025791798.1";
    CHRS[tmp] = 204007;
    tmp = "NW_021160016.1";
    CHRS[tmp] = 369264;
    tmp = "NW_025791797.1";
    CHRS[tmp] = 1154574;
    tmp = "NW_021160015.1";
    CHRS[tmp] = 97763;
    tmp = "NW_025791799.1";
    CHRS[tmp] = 87715;
    tmp = "NW_013171812.1";
    CHRS[tmp] = 59016;
    tmp = "NW_019805500.1";
    CHRS[tmp] = 480415;
    tmp = "NW_017852933.1";
    CHRS[tmp] = 1927115;
    tmp = "NW_021160019.1";
    CHRS[tmp] = 270967;
    tmp = "NW_013171813.1";
    CHRS[tmp] = 267463;
    tmp = "NW_018654723.1";
    CHRS[tmp] = 78609;
    tmp = "NW_012132921.1";
    CHRS[tmp] = 169136;
    tmp = "NW_025791800.1";
    CHRS[tmp] = 334997;
    tmp = "NW_017363817.1";
    CHRS[tmp] = 281919;
    tmp = "NW_021160020.1";
    CHRS[tmp] = 137908;
    tmp = "NW_016107299.1";
    CHRS[tmp] = 154723;
    tmp = "NW_017363819.1";
    CHRS[tmp] = 276292;
    tmp = "NW_025791803.1";
    CHRS[tmp] = 538541;
    tmp = "NW_025791801.1";
    CHRS[tmp] = 372839;
    tmp = "NW_017363818.1";
    CHRS[tmp] = 246895;
    tmp = "NW_019805501.1";
    CHRS[tmp] = 116753;
    tmp = "NW_025791806.1";
    CHRS[tmp] = 172609;
    tmp = "NW_025791802.1";
    CHRS[tmp] = 234878;
    tmp = "NW_025791805.1";
    CHRS[tmp] = 187626;
    tmp = "NW_021160021.1";
    CHRS[tmp] = 56695;
    tmp = "NW_025791804.1";
    CHRS[tmp] = 144689;
    tmp = "NW_019805503.1";
    CHRS[tmp] = 163186;
    tmp = "NW_014040928.1";
    CHRS[tmp] = 205101;
    tmp = "NW_019805502.1";
    CHRS[tmp] = 230843;
    tmp = "NW_013171814.1";
    CHRS[tmp] = 407387;
    tmp = "NW_018654724.1";
    CHRS[tmp] = 93070;
    tmp = "NW_025791809.1";
    CHRS[tmp] = 226166;
    tmp = "NW_025791810.1";
    CHRS[tmp] = 89211;
    tmp = "NW_025791807.1";
    CHRS[tmp] = 333754;
    tmp = "NW_021160022.1";
    CHRS[tmp] = 493165;
    tmp = "NW_014040929.1";
    CHRS[tmp] = 405389;
    tmp = "NW_025791808.1";
    CHRS[tmp] = 137818;
    tmp = "NW_009646206.1";
    CHRS[tmp] = 370917;
    tmp = "NW_016107300.1";
    CHRS[tmp] = 163926;
    tmp = "NW_016107301.1";
    CHRS[tmp] = 170206;
    tmp = "NW_016107302.1";
    CHRS[tmp] = 168131;
    tmp = "NW_016107303.1";
    CHRS[tmp] = 293522;
    tmp = "NW_016107304.1";
    CHRS[tmp] = 241058;
    tmp = "NW_016107305.1";
    CHRS[tmp] = 159285;
    tmp = "NW_016107306.1";
    CHRS[tmp] = 178197;
    tmp = "NW_016107307.1";
    CHRS[tmp] = 166713;
    tmp = "NW_016107308.1";
    CHRS[tmp] = 99845;
    tmp = "NW_016107309.1";
    CHRS[tmp] = 161095;
    tmp = "NW_016107310.1";
    CHRS[tmp] = 223118;
    tmp = "NW_016107311.1";
    CHRS[tmp] = 100553;
    tmp = "NW_016107313.1";
    CHRS[tmp] = 171263;
    tmp = "NW_016107314.1";
    CHRS[tmp] = 145691;
    tmp = "NW_016107312.1";
    CHRS[tmp] = 156965;
    tmp = "NW_025791811.1";
    CHRS[tmp] = 273725;
    tmp = "NW_025791812.1";
    CHRS[tmp] = 355731;
    tmp = "NW_021160023.1";
    CHRS[tmp] = 519485;
    tmp = "NW_025791813.1";
    CHRS[tmp] = 336752;
    tmp = "NW_025791814.1";
    CHRS[tmp] = 1020778;
    tmp = "NW_025791815.1";
    CHRS[tmp] = 189707;
    tmp = "NW_021160026.1";
    CHRS[tmp] = 412368;
    tmp = "NW_021160024.1";
    CHRS[tmp] = 461303;
    tmp = "NW_009646207.1";
    CHRS[tmp] = 156562;
    tmp = "NW_014040930.1";
    CHRS[tmp] = 155930;
    tmp = "NW_014040931.1";
    CHRS[tmp] = 174749;
    tmp = "NW_009646208.1";
    CHRS[tmp] = 153027;
    tmp = "NW_015148968.1";
    CHRS[tmp] = 145162;
    tmp = "NW_021160025.1";
    CHRS[tmp] = 12295;
    tmp = "NW_015148969.2";
    CHRS[tmp] = 101040;
    tmp = "NW_017363820.1";
    CHRS[tmp] = 188004;
    tmp = "NW_021160031.1";
    CHRS[tmp] = 17435;
    tmp = "NW_025791820.1";
    CHRS[tmp] = 330493;
    tmp = "NW_021160028.1";
    CHRS[tmp] = 28824;
    tmp = "NW_025791816.1";
    CHRS[tmp] = 68810;
    tmp = "NW_021160029.1";
    CHRS[tmp] = 68192;
    tmp = "NW_025791817.1";
    CHRS[tmp] = 140567;
    tmp = "NW_021160027.1";
    CHRS[tmp] = 403128;
    tmp = "NW_025791819.1";
    CHRS[tmp] = 294119;
    tmp = "NW_021160030.1";
    CHRS[tmp] = 14678;
    tmp = "NW_025791818.1";
    CHRS[tmp] = 619716;
    tmp = "NW_018654725.1";
    CHRS[tmp] = 48370;
    tmp = "NW_025791821.1";
    CHRS[tmp] = 865743;
    tmp = "NW_018654726.1";
    CHRS[tmp] = 209722;
    tmp = "NW_009646209.1";
    CHRS[tmp] = 101150;
    tmp = "NT_187515.1";
    CHRS[tmp] = 354444;
    tmp = "NT_187517.1";
    CHRS[tmp] = 256271;
    tmp = "NT_187514.1";
    CHRS[tmp] = 109528;
    tmp = "NT_187520.1";
    CHRS[tmp] = 185285;
    tmp = "NW_003315905.1";
    CHRS[tmp] = 182439;
    tmp = "NW_003315906.1";
    CHRS[tmp] = 110268;
    tmp = "NW_003315907.2";
    CHRS[tmp] = 366580;
    tmp = "NT_187521.1";
    CHRS[tmp] = 50258;
    tmp = "NT_187519.1";
    CHRS[tmp] = 911658;
    tmp = "NT_187516.1";
    CHRS[tmp] = 425601;
    tmp = "NT_187518.1";
    CHRS[tmp] = 165834;
    tmp = "NT_187525.1";
    CHRS[tmp] = 136240;
    tmp = "NT_187526.1";
    CHRS[tmp] = 70887;
    tmp = "NT_187529.1";
    CHRS[tmp] = 223625;
    tmp = "NT_187522.1";
    CHRS[tmp] = 120616;
    tmp = "NW_003315908.1";
    CHRS[tmp] = 143390;
    tmp = "NT_187524.1";
    CHRS[tmp] = 133041;
    tmp = "NT_187531.1";
    CHRS[tmp] = 138019;
    tmp = "NT_187530.1";
    CHRS[tmp] = 110395;
    tmp = "NT_187528.1";
    CHRS[tmp] = 110099;
    tmp = "NW_003571033.2";
    CHRS[tmp] = 96131;
    tmp = "NW_003315909.1";
    CHRS[tmp] = 123821;
    tmp = "NT_187527.1";
    CHRS[tmp] = 174166;
    tmp = "NT_187523.1";
    CHRS[tmp] = 161578;
    tmp = "NW_003871060.2";
    CHRS[tmp] = 173151;
    tmp = "NT_187535.1";
    CHRS[tmp] = 109187;
    tmp = "NT_187537.1";
    CHRS[tmp] = 224108;
    tmp = "NW_003315913.1";
    CHRS[tmp] = 180671;
    tmp = "NT_187533.1";
    CHRS[tmp] = 173649;
    tmp = "NT_187536.1";
    CHRS[tmp] = 248252;
    tmp = "NT_187538.1";
    CHRS[tmp] = 113034;
    tmp = "NT_187532.1";
    CHRS[tmp] = 205312;
    tmp = "NT_187534.1";
    CHRS[tmp] = 162429;
    tmp = "NT_187539.1";
    CHRS[tmp] = 184404;
    tmp = "NT_187540.1";
    CHRS[tmp] = 220246;
    tmp = "NW_003315915.1";
    CHRS[tmp] = 376187;
    tmp = "NT_187541.1";
    CHRS[tmp] = 111943;
    tmp = "NT_167250.2";
    CHRS[tmp] = 586476;
    tmp = "NT_187544.1";
    CHRS[tmp] = 158965;
    tmp = "NW_003315914.1";
    CHRS[tmp] = 164536;
    tmp = "NT_187542.1";
    CHRS[tmp] = 119912;
    tmp = "NT_187545.1";
    CHRS[tmp] = 205944;
    tmp = "NT_187543.1";
    CHRS[tmp] = 244096;
    tmp = "NT_187550.1";
    CHRS[tmp] = 126136;
    tmp = "NT_187548.1";
    CHRS[tmp] = 179043;
    tmp = "NT_187547.1";
    CHRS[tmp] = 195710;
    tmp = "NW_003315920.1";
    CHRS[tmp] = 82728;
    tmp = "NW_003571036.1";
    CHRS[tmp] = 226852;
    tmp = "NT_187551.1";
    CHRS[tmp] = 164558;
    tmp = "NW_003315917.2";
    CHRS[tmp] = 1612928;
    tmp = "NW_003315918.1";
    CHRS[tmp] = 101241;
    tmp = "NT_187549.1";
    CHRS[tmp] = 172708;
    tmp = "NW_003315919.1";
    CHRS[tmp] = 173459;
    tmp = "NT_187546.1";
    CHRS[tmp] = 131892;
    tmp = "NT_167244.2";
    CHRS[tmp] = 4672374;
    tmp = "NT_187555.1";
    CHRS[tmp] = 175808;
    tmp = "NT_187554.1";
    CHRS[tmp] = 152148;
    tmp = "NW_003315921.1";
    CHRS[tmp] = 124736;
    tmp = "NT_187556.1";
    CHRS[tmp] = 870480;
    tmp = "NT_187557.1";
    CHRS[tmp] = 75005;
    tmp = "NW_004166862.2";
    CHRS[tmp] = 185823;
    tmp = "NT_187552.1";
    CHRS[tmp] = 197536;
    tmp = "NT_187553.1";
    CHRS[tmp] = 271782;
    tmp = "NT_187558.1";
    CHRS[tmp] = 157952;
    tmp = "NT_187561.1";
    CHRS[tmp] = 209586;
    tmp = "NT_187559.1";
    CHRS[tmp] = 158166;
    tmp = "NW_003315922.2";
    CHRS[tmp] = 119183;
    tmp = "NT_187562.1";
    CHRS[tmp] = 1111570;
    tmp = "NT_187564.1";
    CHRS[tmp] = 271455;
    tmp = "NT_187563.1";
    CHRS[tmp] = 126434;
    tmp = "NT_187560.1";
    CHRS[tmp] = 209988;
    tmp = "NT_187572.1";
    CHRS[tmp] = 145606;
    tmp = "NT_187568.1";
    CHRS[tmp] = 282736;
    tmp = "NT_187565.1";
    CHRS[tmp] = 292436;
    tmp = "NT_187576.1";
    CHRS[tmp] = 985506;
    tmp = "NT_187570.1";
    CHRS[tmp] = 300230;
    tmp = "NT_187577.1";
    CHRS[tmp] = 624492;
    tmp = "NT_187566.1";
    CHRS[tmp] = 141812;
    tmp = "NT_187567.1";
    CHRS[tmp] = 374415;
    tmp = "NT_187574.1";
    CHRS[tmp] = 133535;
    tmp = "NT_187575.1";
    CHRS[tmp] = 36640;
    tmp = "NT_187573.1";
    CHRS[tmp] = 158983;
    tmp = "NT_187571.1";
    CHRS[tmp] = 305841;
    tmp = "NT_187569.1";
    CHRS[tmp] = 132244;
    tmp = "NW_003315928.1";
    CHRS[tmp] = 162988;
    tmp = "NW_003315929.1";
    CHRS[tmp] = 71551;
    tmp = "NW_003315930.1";
    CHRS[tmp] = 171286;
    tmp = "NW_003315931.1";
    CHRS[tmp] = 60032;
    tmp = "NT_187578.1";
    CHRS[tmp] = 439082;
    tmp = "NW_003315934.1";
    CHRS[tmp] = 179254;
    tmp = "NT_187579.1";
    CHRS[tmp] = 181496;
    tmp = "NW_003315935.1";
    CHRS[tmp] = 309802;
    tmp = "NT_187586.1";
    CHRS[tmp] = 210133;
    tmp = "NT_187584.1";
    CHRS[tmp] = 177092;
    tmp = "NT_187585.1";
    CHRS[tmp] = 296895;
    tmp = "NT_187583.1";
    CHRS[tmp] = 204059;
    tmp = "NW_003315936.1";
    CHRS[tmp] = 154407;
    tmp = "NW_003871073.1";
    CHRS[tmp] = 200998;
    tmp = "NW_003871074.1";
    CHRS[tmp] = 191409;
    tmp = "NT_187582.1";
    CHRS[tmp] = 67707;
    tmp = "NT_187581.1";
    CHRS[tmp] = 186169;
    tmp = "NW_003571049.1";
    CHRS[tmp] = 167313;
    tmp = "NW_003571050.1";
    CHRS[tmp] = 408271;
    tmp = "NT_187588.1";
    CHRS[tmp] = 40090;
    tmp = "NW_003315938.1";
    CHRS[tmp] = 120804;
    tmp = "NT_187587.1";
    CHRS[tmp] = 238139;
    tmp = "NW_003315939.2";
    CHRS[tmp] = 169178;
    tmp = "NW_003315941.1";
    CHRS[tmp] = 138655;
    tmp = "NW_003315942.2";
    CHRS[tmp] = 152874;
    tmp = "NT_187590.1";
    CHRS[tmp] = 119498;
    tmp = "NW_003315940.1";
    CHRS[tmp] = 184319;
    tmp = "NT_187589.1";
    CHRS[tmp] = 76061;
    tmp = "NT_187591.1";
    CHRS[tmp] = 56134;
    tmp = "NT_187594.1";
    CHRS[tmp] = 191684;
    tmp = "NT_187593.1";
    CHRS[tmp] = 180306;
    tmp = "NT_187597.1";
    CHRS[tmp] = 103832;
    tmp = "NT_187595.1";
    CHRS[tmp] = 169134;
    tmp = "NT_187592.1";
    CHRS[tmp] = 306913;
    tmp = "NT_187596.1";
    CHRS[tmp] = 37287;
    tmp = "NT_187598.1";
    CHRS[tmp] = 322166;
    tmp = "NT_187601.1";
    CHRS[tmp] = 1511111;
    tmp = "NT_187599.1";
    CHRS[tmp] = 180703;
    tmp = "NT_187600.1";
    CHRS[tmp] = 1351393;
    tmp = "NT_187602.1";
    CHRS[tmp] = 478999;
    tmp = "NT_187604.1";
    CHRS[tmp] = 263054;
    tmp = "NT_187603.1";
    CHRS[tmp] = 327382;
    tmp = "NW_003315943.1";
    CHRS[tmp] = 296527;
    tmp = "NT_187605.1";
    CHRS[tmp] = 244917;
    tmp = "NW_003315944.2";
    CHRS[tmp] = 388773;
    tmp = "NT_187606.1";
    CHRS[tmp] = 430880;
    tmp = "NT_187610.1";
    CHRS[tmp] = 134193;
    tmp = "NT_187609.1";
    CHRS[tmp] = 63982;
    tmp = "NT_187608.1";
    CHRS[tmp] = 232857;
    tmp = "NT_187607.1";
    CHRS[tmp] = 2659700;
    tmp = "NW_003315945.1";
    CHRS[tmp] = 192462;
    tmp = "NW_003315946.1";
    CHRS[tmp] = 89672;
    tmp = "NW_003315952.3";
    CHRS[tmp] = 375691;
    tmp = "NT_187613.1";
    CHRS[tmp] = 391357;
    tmp = "NT_187611.1";
    CHRS[tmp] = 196688;
    tmp = "NT_187614.1";
    CHRS[tmp] = 2877074;
    tmp = "NW_003871091.1";
    CHRS[tmp] = 278131;
    tmp = "NW_003871092.1";
    CHRS[tmp] = 70345;
    tmp = "NW_003315953.2";
    CHRS[tmp] = 133151;
    tmp = "NT_167251.2";
    CHRS[tmp] = 1821992;
    tmp = "NW_003315954.1";
    CHRS[tmp] = 223995;
    tmp = "NT_187615.1";
    CHRS[tmp] = 235827;
    tmp = "NT_187616.1";
    CHRS[tmp] = 108763;
    tmp = "NW_003315955.1";
    CHRS[tmp] = 90219;
    tmp = "NT_187612.1";
    CHRS[tmp] = 178921;
    tmp = "NT_187618.1";
    CHRS[tmp] = 111737;
    tmp = "NW_003315956.1";
    CHRS[tmp] = 289831;
    tmp = "NW_003315959.1";
    CHRS[tmp] = 164789;
    tmp = "NW_003315960.1";
    CHRS[tmp] = 198278;
    tmp = "NW_003315957.1";
    CHRS[tmp] = 104552;
    tmp = "NW_003315958.1";
    CHRS[tmp] = 167950;
    tmp = "NW_003315961.1";
    CHRS[tmp] = 159547;
    tmp = "NT_187617.1";
    CHRS[tmp] = 167999;
    tmp = "NT_187622.1";
    CHRS[tmp] = 61734;
    tmp = "NT_187621.1";
    CHRS[tmp] = 52969;
    tmp = "NW_003315962.1";
    CHRS[tmp] = 385657;
    tmp = "NW_003315964.2";
    CHRS[tmp] = 170222;
    tmp = "NW_003315965.1";
    CHRS[tmp] = 188024;
    tmp = "NW_003315963.1";
    CHRS[tmp] = 155864;
    tmp = "NT_187619.1";
    CHRS[tmp] = 43156;
    tmp = "NT_187620.1";
    CHRS[tmp] = 233762;
    tmp = "NW_003571054.1";
    CHRS[tmp] = 987716;
    tmp = "NW_003315966.2";
    CHRS[tmp] = 128386;
    tmp = "NT_187623.1";
    CHRS[tmp] = 118774;
    tmp = "NT_187625.1";
    CHRS[tmp] = 58661;
    tmp = "NT_187624.1";
    CHRS[tmp] = 183433;
    tmp = "NW_003315967.2";
    CHRS[tmp] = 63917;
    tmp = "NT_187628.1";
    CHRS[tmp] = 166743;
    tmp = "NT_187627.1";
    CHRS[tmp] = 143900;
    tmp = "NW_003315968.2";
    CHRS[tmp] = 201197;
    tmp = "NW_003315969.2";
    CHRS[tmp] = 74653;
    tmp = "NW_003315970.2";
    CHRS[tmp] = 116689;
    tmp = "NT_187626.1";
    CHRS[tmp] = 82692;
    tmp = "NT_187629.1";
    CHRS[tmp] = 259914;
    tmp = "NT_187632.1";
    CHRS[tmp] = 186262;
    tmp = "NT_187633.1";
    CHRS[tmp] = 304135;
    tmp = "NT_187630.1";
    CHRS[tmp] = 263666;
    tmp = "NT_187631.1";
    CHRS[tmp] = 101331;
    tmp = "NW_003315972.2";
    CHRS[tmp] = 96924;
    tmp = "NW_003315971.2";
    CHRS[tmp] = 162811;
    tmp = "NT_187634.1";
    CHRS[tmp] = 284869;
    tmp = "NT_187635.1";
    CHRS[tmp] = 144206;
    tmp = "NT_187646.1";
    CHRS[tmp] = 162212;
    tmp = "NT_187648.1";
    CHRS[tmp] = 214158;
    tmp = "NT_187647.1";
    CHRS[tmp] = 161218;
    tmp = "NT_187649.1";
    CHRS[tmp] = 162896;
    tmp = "NT_187650.1";
    CHRS[tmp] = 378547;
    tmp = "NT_187651.1";
    CHRS[tmp] = 1144418;
    tmp = "NT_187652.1";
    CHRS[tmp] = 130957;
    tmp = "NT_113891.3";
    CHRS[tmp] = 4795265;
    tmp = "NT_187653.1";
    CHRS[tmp] = 190869;
    tmp = "NT_187655.1";
    CHRS[tmp] = 136959;
    tmp = "NT_187654.1";
    CHRS[tmp] = 318687;
    tmp = "NT_187656.1";
    CHRS[tmp] = 106711;
    tmp = "NT_187657.1";
    CHRS[tmp] = 214625;
    tmp = "NT_187658.1";
    CHRS[tmp] = 572349;
    tmp = "NT_187659.1";
    CHRS[tmp] = 196384;
    tmp = "NT_187660.1";
    CHRS[tmp] = 5161414;
    tmp = "NT_187662.1";
    CHRS[tmp] = 137721;
    tmp = "NT_187664.1";
    CHRS[tmp] = 157099;
    tmp = "NT_187661.1";
    CHRS[tmp] = 325800;
    tmp = "NW_003871093.1";
    CHRS[tmp] = 88070;
    tmp = "NT_187663.1";
    CHRS[tmp] = 1423190;
    tmp = "NT_187665.1";
    CHRS[tmp] = 174061;
    tmp = "NT_187666.1";
    CHRS[tmp] = 157710;
    tmp = "NW_003571055.2";
    CHRS[tmp] = 729520;
    tmp = "NW_004504305.1";
    CHRS[tmp] = 74013;
    tmp = "NT_187667.1";
    CHRS[tmp] = 274009;
    tmp = "NT_187678.1";
    CHRS[tmp] = 166540;
    tmp = "NT_187679.1";
    CHRS[tmp] = 555799;
    tmp = "NT_167245.2";
    CHRS[tmp] = 4604811;
    tmp = "NT_187680.1";
    CHRS[tmp] = 229282;
    tmp = "NT_187681.1";
    CHRS[tmp] = 218612;
    tmp = "NW_003571056.2";
    CHRS[tmp] = 1064304;
    tmp = "NT_187682.1";
    CHRS[tmp] = 176103;
    tmp = "NT_187688.1";
    CHRS[tmp] = 163458;
    tmp = "NT_167246.2";
    CHRS[tmp] = 4677643;
    tmp = "NW_003571057.2";
    CHRS[tmp] = 1091841;
    tmp = "NT_187689.1";
    CHRS[tmp] = 197351;
    tmp = "NT_167247.2";
    CHRS[tmp] = 4827813;
    tmp = "NW_003571058.2";
    CHRS[tmp] = 1066390;
    tmp = "NT_187690.1";
    CHRS[tmp] = 164170;
    tmp = "NT_167248.2";
    CHRS[tmp] = 4606388;
    tmp = "NW_003571059.2";
    CHRS[tmp] = 1002683;
    tmp = "NT_187691.1";
    CHRS[tmp] = 165607;
    tmp = "NT_167249.2";
    CHRS[tmp] = 4929269;
    tmp = "NW_003571060.1";
    CHRS[tmp] = 987100;
    tmp = "NT_187692.1";
    CHRS[tmp] = 76752;
    tmp = "NW_003571061.2";
    CHRS[tmp] = 796479;
    tmp = "NT_187693.1";
    CHRS[tmp] = 1066800;
    tmp = "NT_187636.1";
    CHRS[tmp] = 248807;
    tmp = "NT_187637.1";
    CHRS[tmp] = 170399;
    tmp = "NT_187638.1";
    CHRS[tmp] = 157053;
    tmp = "NT_187639.1";
    CHRS[tmp] = 171027;
    tmp = "NT_187640.1";
    CHRS[tmp] = 204239;
    tmp = "NT_187641.1";
    CHRS[tmp] = 209512;
    tmp = "NT_187642.1";
    CHRS[tmp] = 155532;
    tmp = "NT_187643.1";
    CHRS[tmp] = 170698;
    tmp = "NT_187644.1";
    CHRS[tmp] = 184499;
    tmp = "NT_187645.1";
    CHRS[tmp] = 170680;
    tmp = "NT_187668.1";
    CHRS[tmp] = 205194;
    tmp = "NT_187669.1";
    CHRS[tmp] = 170665;
    tmp = "NT_187670.1";
    CHRS[tmp] = 184516;
    tmp = "NT_187671.1";
    CHRS[tmp] = 190932;
    tmp = "NT_187672.1";
    CHRS[tmp] = 123111;
    tmp = "NT_187673.1";
    CHRS[tmp] = 170701;
    tmp = "NT_187674.1";
    CHRS[tmp] = 198005;
    tmp = "NT_187675.1";
    CHRS[tmp] = 282224;
    tmp = "NT_187676.1";
    CHRS[tmp] = 187935;
    tmp = "NT_187677.1";
    CHRS[tmp] = 189352;
    tmp = "NT_187683.1";
    CHRS[tmp] = 186203;
    tmp = "NT_187684.1";
    CHRS[tmp] = 200773;
    tmp = "NT_187685.1";
    CHRS[tmp] = 170148;
    tmp = "NT_187686.1";
    CHRS[tmp] = 215732;
    tmp = "NT_187687.1";
    CHRS[tmp] = 170537;
    tmp = "NT_113949.2";
    CHRS[tmp] = 177381;
    tmp = "NC_012920.1";
    CHRS[tmp] = 16569;
    tmp = "chr1";
    CHRS[tmp] = 248956422;
    tmp = "chr2";
    CHRS[tmp] = 242193529;
    tmp = "chr3";
    CHRS[tmp] = 198295559;
    tmp = "chr4";
    CHRS[tmp] = 190214555;
    tmp = "chr5";
    CHRS[tmp] = 181538259;
    tmp = "chr6";
    CHRS[tmp] = 170805979;
    tmp = "chr7";
    CHRS[tmp] = 159345973;
    tmp = "chr8";
    CHRS[tmp] = 145138636;
    tmp = "chr9";
    CHRS[tmp] = 138394717;
    tmp = "chr10";
    CHRS[tmp] = 133797422;
    tmp = "chr11";
    CHRS[tmp] = 135086622;
    tmp = "chr12";
    CHRS[tmp] = 133275309;
    tmp = "chr13";
    CHRS[tmp] = 114364328;
    tmp = "chr14";
    CHRS[tmp] = 107043718;
    tmp = "chr15";
    CHRS[tmp] = 101991189;
    tmp = "chr16";
    CHRS[tmp] = 90338345;
    tmp = "chr17";
    CHRS[tmp] = 83257441;
    tmp = "chr18";
    CHRS[tmp] = 80373285;
    tmp = "chr19";
    CHRS[tmp] = 58617616;
    tmp = "chr20";
    CHRS[tmp] = 64444167;
    tmp = "chr21";
    CHRS[tmp] = 46709983;
    tmp = "chr22";
    CHRS[tmp] = 50818468;
    tmp = "chrX";
    CHRS[tmp] = 156040895;
    tmp = "chrY";
    CHRS[tmp] = 57227415;
    tmp = "chrM";
    CHRS[tmp] = 16569;
    tmp = "chr11_KI270721v1_random";
    CHRS[tmp] = 100316;
    tmp = "chr14_GL000009v2_random";
    CHRS[tmp] = 201709;
    tmp = "chr14_GL000225v1_random";
    CHRS[tmp] = 211173;
    tmp = "chr14_KI270722v1_random";
    CHRS[tmp] = 194050;
    tmp = "chr14_GL000194v1_random";
    CHRS[tmp] = 191469;
    tmp = "chr14_KI270723v1_random";
    CHRS[tmp] = 38115;
    tmp = "chr14_KI270724v1_random";
    CHRS[tmp] = 39555;
    tmp = "chr14_KI270725v1_random";
    CHRS[tmp] = 172810;
    tmp = "chr14_KI270726v1_random";
    CHRS[tmp] = 43739;
    tmp = "chr15_KI270727v1_random";
    CHRS[tmp] = 448248;
    tmp = "chr16_KI270728v1_random";
    CHRS[tmp] = 1872759;
    tmp = "chr17_GL000205v2_random";
    CHRS[tmp] = 185591;
    tmp = "chr17_KI270729v1_random";
    CHRS[tmp] = 280839;
    tmp = "chr17_KI270730v1_random";
    CHRS[tmp] = 112551;
    tmp = "chr1_KI270706v1_random";
    CHRS[tmp] = 175055;
    tmp = "chr1_KI270707v1_random";
    CHRS[tmp] = 32032;
    tmp = "chr1_KI270708v1_random";
    CHRS[tmp] = 127682;
    tmp = "chr1_KI270709v1_random";
    CHRS[tmp] = 66860;
    tmp = "chr1_KI270710v1_random";
    CHRS[tmp] = 40176;
    tmp = "chr1_KI270711v1_random";
    CHRS[tmp] = 42210;
    tmp = "chr1_KI270712v1_random";
    CHRS[tmp] = 176043;
    tmp = "chr1_KI270713v1_random";
    CHRS[tmp] = 40745;
    tmp = "chr1_KI270714v1_random";
    CHRS[tmp] = 41717;
    tmp = "chr22_KI270731v1_random";
    CHRS[tmp] = 150754;
    tmp = "chr22_KI270732v1_random";
    CHRS[tmp] = 41543;
    tmp = "chr22_KI270733v1_random";
    CHRS[tmp] = 179772;
    tmp = "chr22_KI270734v1_random";
    CHRS[tmp] = 165050;
    tmp = "chr22_KI270735v1_random";
    CHRS[tmp] = 42811;
    tmp = "chr22_KI270736v1_random";
    CHRS[tmp] = 181920;
    tmp = "chr22_KI270737v1_random";
    CHRS[tmp] = 103838;
    tmp = "chr22_KI270738v1_random";
    CHRS[tmp] = 99375;
    tmp = "chr22_KI270739v1_random";
    CHRS[tmp] = 73985;
    tmp = "chr2_KI270715v1_random";
    CHRS[tmp] = 161471;
    tmp = "chr2_KI270716v1_random";
    CHRS[tmp] = 153799;
    tmp = "chr3_GL000221v1_random";
    CHRS[tmp] = 155397;
    tmp = "chr4_GL000008v2_random";
    CHRS[tmp] = 209709;
    tmp = "chr5_GL000208v1_random";
    CHRS[tmp] = 92689;
    tmp = "chr9_KI270717v1_random";
    CHRS[tmp] = 40062;
    tmp = "chr9_KI270718v1_random";
    CHRS[tmp] = 38054;
    tmp = "chr9_KI270719v1_random";
    CHRS[tmp] = 176845;
    tmp = "chr9_KI270720v1_random";
    CHRS[tmp] = 39050;
    tmp = "chr1_KI270762v1_alt";
    CHRS[tmp] = 354444;
    tmp = "chr1_KI270766v1_alt";
    CHRS[tmp] = 256271;
    tmp = "chr1_KI270760v1_alt";
    CHRS[tmp] = 109528;
    tmp = "chr1_KI270765v1_alt";
    CHRS[tmp] = 185285;
    tmp = "chr1_GL383518v1_alt";
    CHRS[tmp] = 182439;
    tmp = "chr1_GL383519v1_alt";
    CHRS[tmp] = 110268;
    tmp = "chr1_GL383520v2_alt";
    CHRS[tmp] = 366580;
    tmp = "chr1_KI270764v1_alt";
    CHRS[tmp] = 50258;
    tmp = "chr1_KI270763v1_alt";
    CHRS[tmp] = 911658;
    tmp = "chr1_KI270759v1_alt";
    CHRS[tmp] = 425601;
    tmp = "chr1_KI270761v1_alt";
    CHRS[tmp] = 165834;
    tmp = "chr2_KI270770v1_alt";
    CHRS[tmp] = 136240;
    tmp = "chr2_KI270773v1_alt";
    CHRS[tmp] = 70887;
    tmp = "chr2_KI270774v1_alt";
    CHRS[tmp] = 223625;
    tmp = "chr2_KI270769v1_alt";
    CHRS[tmp] = 120616;
    tmp = "chr2_GL383521v1_alt";
    CHRS[tmp] = 143390;
    tmp = "chr2_KI270772v1_alt";
    CHRS[tmp] = 133041;
    tmp = "chr2_KI270775v1_alt";
    CHRS[tmp] = 138019;
    tmp = "chr2_KI270771v1_alt";
    CHRS[tmp] = 110395;
    tmp = "chr2_KI270768v1_alt";
    CHRS[tmp] = 110099;
    tmp = "chr2_GL582966v2_alt";
    CHRS[tmp] = 96131;
    tmp = "chr2_GL383522v1_alt";
    CHRS[tmp] = 123821;
    tmp = "chr2_KI270776v1_alt";
    CHRS[tmp] = 174166;
    tmp = "chr2_KI270767v1_alt";
    CHRS[tmp] = 161578;
    tmp = "chr3_JH636055v2_alt";
    CHRS[tmp] = 173151;
    tmp = "chr3_KI270783v1_alt";
    CHRS[tmp] = 109187;
    tmp = "chr3_KI270780v1_alt";
    CHRS[tmp] = 224108;
    tmp = "chr3_GL383526v1_alt";
    CHRS[tmp] = 180671;
    tmp = "chr3_KI270777v1_alt";
    CHRS[tmp] = 173649;
    tmp = "chr3_KI270778v1_alt";
    CHRS[tmp] = 248252;
    tmp = "chr3_KI270781v1_alt";
    CHRS[tmp] = 113034;
    tmp = "chr3_KI270779v1_alt";
    CHRS[tmp] = 205312;
    tmp = "chr3_KI270782v1_alt";
    CHRS[tmp] = 162429;
    tmp = "chr3_KI270784v1_alt";
    CHRS[tmp] = 184404;
    tmp = "chr4_KI270790v1_alt";
    CHRS[tmp] = 220246;
    tmp = "chr4_GL383528v1_alt";
    CHRS[tmp] = 376187;
    tmp = "chr4_KI270787v1_alt";
    CHRS[tmp] = 111943;
    tmp = "chr4_GL000257v2_alt";
    CHRS[tmp] = 586476;
    tmp = "chr4_KI270788v1_alt";
    CHRS[tmp] = 158965;
    tmp = "chr4_GL383527v1_alt";
    CHRS[tmp] = 164536;
    tmp = "chr4_KI270785v1_alt";
    CHRS[tmp] = 119912;
    tmp = "chr4_KI270789v1_alt";
    CHRS[tmp] = 205944;
    tmp = "chr4_KI270786v1_alt";
    CHRS[tmp] = 244096;
    tmp = "chr5_KI270793v1_alt";
    CHRS[tmp] = 126136;
    tmp = "chr5_KI270792v1_alt";
    CHRS[tmp] = 179043;
    tmp = "chr5_KI270791v1_alt";
    CHRS[tmp] = 195710;
    tmp = "chr5_GL383532v1_alt";
    CHRS[tmp] = 82728;
    tmp = "chr5_GL949742v1_alt";
    CHRS[tmp] = 226852;
    tmp = "chr5_KI270794v1_alt";
    CHRS[tmp] = 164558;
    tmp = "chr5_GL339449v2_alt";
    CHRS[tmp] = 1612928;
    tmp = "chr5_GL383530v1_alt";
    CHRS[tmp] = 101241;
    tmp = "chr5_KI270796v1_alt";
    CHRS[tmp] = 172708;
    tmp = "chr5_GL383531v1_alt";
    CHRS[tmp] = 173459;
    tmp = "chr5_KI270795v1_alt";
    CHRS[tmp] = 131892;
    tmp = "chr6_GL000250v2_alt";
    CHRS[tmp] = 4672374;
    tmp = "chr6_KI270800v1_alt";
    CHRS[tmp] = 175808;
    tmp = "chr6_KI270799v1_alt";
    CHRS[tmp] = 152148;
    tmp = "chr6_GL383533v1_alt";
    CHRS[tmp] = 124736;
    tmp = "chr6_KI270801v1_alt";
    CHRS[tmp] = 870480;
    tmp = "chr6_KI270802v1_alt";
    CHRS[tmp] = 75005;
    tmp = "chr6_KB021644v2_alt";
    CHRS[tmp] = 185823;
    tmp = "chr6_KI270797v1_alt";
    CHRS[tmp] = 197536;
    tmp = "chr6_KI270798v1_alt";
    CHRS[tmp] = 271782;
    tmp = "chr7_KI270804v1_alt";
    CHRS[tmp] = 157952;
    tmp = "chr7_KI270809v1_alt";
    CHRS[tmp] = 209586;
    tmp = "chr7_KI270806v1_alt";
    CHRS[tmp] = 158166;
    tmp = "chr7_GL383534v2_alt";
    CHRS[tmp] = 119183;
    tmp = "chr7_KI270803v1_alt";
    CHRS[tmp] = 1111570;
    tmp = "chr7_KI270808v1_alt";
    CHRS[tmp] = 271455;
    tmp = "chr7_KI270807v1_alt";
    CHRS[tmp] = 126434;
    tmp = "chr7_KI270805v1_alt";
    CHRS[tmp] = 209988;
    tmp = "chr8_KI270818v1_alt";
    CHRS[tmp] = 145606;
    tmp = "chr8_KI270812v1_alt";
    CHRS[tmp] = 282736;
    tmp = "chr8_KI270811v1_alt";
    CHRS[tmp] = 292436;
    tmp = "chr8_KI270821v1_alt";
    CHRS[tmp] = 985506;
    tmp = "chr8_KI270813v1_alt";
    CHRS[tmp] = 300230;
    tmp = "chr8_KI270822v1_alt";
    CHRS[tmp] = 624492;
    tmp = "chr8_KI270814v1_alt";
    CHRS[tmp] = 141812;
    tmp = "chr8_KI270810v1_alt";
    CHRS[tmp] = 374415;
    tmp = "chr8_KI270819v1_alt";
    CHRS[tmp] = 133535;
    tmp = "chr8_KI270820v1_alt";
    CHRS[tmp] = 36640;
    tmp = "chr8_KI270817v1_alt";
    CHRS[tmp] = 158983;
    tmp = "chr8_KI270816v1_alt";
    CHRS[tmp] = 305841;
    tmp = "chr8_KI270815v1_alt";
    CHRS[tmp] = 132244;
    tmp = "chr9_GL383539v1_alt";
    CHRS[tmp] = 162988;
    tmp = "chr9_GL383540v1_alt";
    CHRS[tmp] = 71551;
    tmp = "chr9_GL383541v1_alt";
    CHRS[tmp] = 171286;
    tmp = "chr9_GL383542v1_alt";
    CHRS[tmp] = 60032;
    tmp = "chr9_KI270823v1_alt";
    CHRS[tmp] = 439082;
    tmp = "chr10_GL383545v1_alt";
    CHRS[tmp] = 179254;
    tmp = "chr10_KI270824v1_alt";
    CHRS[tmp] = 181496;
    tmp = "chr10_GL383546v1_alt";
    CHRS[tmp] = 309802;
    tmp = "chr10_KI270825v1_alt";
    CHRS[tmp] = 188315;
    tmp = "chr11_KI270832v1_alt";
    CHRS[tmp] = 210133;
    tmp = "chr11_KI270830v1_alt";
    CHRS[tmp] = 177092;
    tmp = "chr11_KI270831v1_alt";
    CHRS[tmp] = 296895;
    tmp = "chr11_KI270829v1_alt";
    CHRS[tmp] = 204059;
    tmp = "chr11_GL383547v1_alt";
    CHRS[tmp] = 154407;
    tmp = "chr11_JH159136v1_alt";
    CHRS[tmp] = 200998;
    tmp = "chr11_JH159137v1_alt";
    CHRS[tmp] = 191409;
    tmp = "chr11_KI270827v1_alt";
    CHRS[tmp] = 67707;
    tmp = "chr11_KI270826v1_alt";
    CHRS[tmp] = 186169;
    tmp = "chr12_GL877875v1_alt";
    CHRS[tmp] = 167313;
    tmp = "chr12_GL877876v1_alt";
    CHRS[tmp] = 408271;
    tmp = "chr12_KI270837v1_alt";
    CHRS[tmp] = 40090;
    tmp = "chr12_GL383549v1_alt";
    CHRS[tmp] = 120804;
    tmp = "chr12_KI270835v1_alt";
    CHRS[tmp] = 238139;
    tmp = "chr12_GL383550v2_alt";
    CHRS[tmp] = 169178;
    tmp = "chr12_GL383552v1_alt";
    CHRS[tmp] = 138655;
    tmp = "chr12_GL383553v2_alt";
    CHRS[tmp] = 152874;
    tmp = "chr12_KI270834v1_alt";
    CHRS[tmp] = 119498;
    tmp = "chr12_GL383551v1_alt";
    CHRS[tmp] = 184319;
    tmp = "chr12_KI270833v1_alt";
    CHRS[tmp] = 76061;
    tmp = "chr12_KI270836v1_alt";
    CHRS[tmp] = 56134;
    tmp = "chr13_KI270840v1_alt";
    CHRS[tmp] = 191684;
    tmp = "chr13_KI270839v1_alt";
    CHRS[tmp] = 180306;
    tmp = "chr13_KI270843v1_alt";
    CHRS[tmp] = 103832;
    tmp = "chr13_KI270841v1_alt";
    CHRS[tmp] = 169134;
    tmp = "chr13_KI270838v1_alt";
    CHRS[tmp] = 306913;
    tmp = "chr13_KI270842v1_alt";
    CHRS[tmp] = 37287;
    tmp = "chr14_KI270844v1_alt";
    CHRS[tmp] = 322166;
    tmp = "chr14_KI270847v1_alt";
    CHRS[tmp] = 1511111;
    tmp = "chr14_KI270845v1_alt";
    CHRS[tmp] = 180703;
    tmp = "chr14_KI270846v1_alt";
    CHRS[tmp] = 1351393;
    tmp = "chr15_KI270852v1_alt";
    CHRS[tmp] = 478999;
    tmp = "chr15_KI270851v1_alt";
    CHRS[tmp] = 263054;
    tmp = "chr15_KI270848v1_alt";
    CHRS[tmp] = 327382;
    tmp = "chr15_GL383554v1_alt";
    CHRS[tmp] = 296527;
    tmp = "chr15_KI270849v1_alt";
    CHRS[tmp] = 244917;
    tmp = "chr15_GL383555v2_alt";
    CHRS[tmp] = 388773;
    tmp = "chr15_KI270850v1_alt";
    CHRS[tmp] = 430880;
    tmp = "chr16_KI270854v1_alt";
    CHRS[tmp] = 134193;
    tmp = "chr16_KI270856v1_alt";
    CHRS[tmp] = 63982;
    tmp = "chr16_KI270855v1_alt";
    CHRS[tmp] = 232857;
    tmp = "chr16_KI270853v1_alt";
    CHRS[tmp] = 2659700;
    tmp = "chr16_GL383556v1_alt";
    CHRS[tmp] = 192462;
    tmp = "chr16_GL383557v1_alt";
    CHRS[tmp] = 89672;
    tmp = "chr17_GL383563v3_alt";
    CHRS[tmp] = 375691;
    tmp = "chr17_KI270862v1_alt";
    CHRS[tmp] = 391357;
    tmp = "chr17_KI270861v1_alt";
    CHRS[tmp] = 196688;
    tmp = "chr17_KI270857v1_alt";
    CHRS[tmp] = 2877074;
    tmp = "chr17_JH159146v1_alt";
    CHRS[tmp] = 278131;
    tmp = "chr17_JH159147v1_alt";
    CHRS[tmp] = 70345;
    tmp = "chr17_GL383564v2_alt";
    CHRS[tmp] = 133151;
    tmp = "chr17_GL000258v2_alt";
    CHRS[tmp] = 1821992;
    tmp = "chr17_GL383565v1_alt";
    CHRS[tmp] = 223995;
    tmp = "chr17_KI270858v1_alt";
    CHRS[tmp] = 235827;
    tmp = "chr17_KI270859v1_alt";
    CHRS[tmp] = 108763;
    tmp = "chr17_GL383566v1_alt";
    CHRS[tmp] = 90219;
    tmp = "chr17_KI270860v1_alt";
    CHRS[tmp] = 178921;
    tmp = "chr18_KI270864v1_alt";
    CHRS[tmp] = 111737;
    tmp = "chr18_GL383567v1_alt";
    CHRS[tmp] = 289831;
    tmp = "chr18_GL383570v1_alt";
    CHRS[tmp] = 164789;
    tmp = "chr18_GL383571v1_alt";
    CHRS[tmp] = 198278;
    tmp = "chr18_GL383568v1_alt";
    CHRS[tmp] = 104552;
    tmp = "chr18_GL383569v1_alt";
    CHRS[tmp] = 167950;
    tmp = "chr18_GL383572v1_alt";
    CHRS[tmp] = 159547;
    tmp = "chr18_KI270863v1_alt";
    CHRS[tmp] = 167999;
    tmp = "chr19_KI270868v1_alt";
    CHRS[tmp] = 61734;
    tmp = "chr19_KI270865v1_alt";
    CHRS[tmp] = 52969;
    tmp = "chr19_GL383573v1_alt";
    CHRS[tmp] = 385657;
    tmp = "chr19_GL383575v2_alt";
    CHRS[tmp] = 170222;
    tmp = "chr19_GL383576v1_alt";
    CHRS[tmp] = 188024;
    tmp = "chr19_GL383574v1_alt";
    CHRS[tmp] = 155864;
    tmp = "chr19_KI270866v1_alt";
    CHRS[tmp] = 43156;
    tmp = "chr19_KI270867v1_alt";
    CHRS[tmp] = 233762;
    tmp = "chr19_GL949746v1_alt";
    CHRS[tmp] = 987716;
    tmp = "chr20_GL383577v2_alt";
    CHRS[tmp] = 128386;
    tmp = "chr20_KI270869v1_alt";
    CHRS[tmp] = 118774;
    tmp = "chr20_KI270871v1_alt";
    CHRS[tmp] = 58661;
    tmp = "chr20_KI270870v1_alt";
    CHRS[tmp] = 183433;
    tmp = "chr21_GL383578v2_alt";
    CHRS[tmp] = 63917;
    tmp = "chr21_KI270874v1_alt";
    CHRS[tmp] = 166743;
    tmp = "chr21_KI270873v1_alt";
    CHRS[tmp] = 143900;
    tmp = "chr21_GL383579v2_alt";
    CHRS[tmp] = 201197;
    tmp = "chr21_GL383580v2_alt";
    CHRS[tmp] = 74653;
    tmp = "chr21_GL383581v2_alt";
    CHRS[tmp] = 116689;
    tmp = "chr21_KI270872v1_alt";
    CHRS[tmp] = 82692;
    tmp = "chr22_KI270875v1_alt";
    CHRS[tmp] = 259914;
    tmp = "chr22_KI270878v1_alt";
    CHRS[tmp] = 186262;
    tmp = "chr22_KI270879v1_alt";
    CHRS[tmp] = 304135;
    tmp = "chr22_KI270876v1_alt";
    CHRS[tmp] = 263666;
    tmp = "chr22_KI270877v1_alt";
    CHRS[tmp] = 101331;
    tmp = "chr22_GL383583v2_alt";
    CHRS[tmp] = 96924;
    tmp = "chr22_GL383582v2_alt";
    CHRS[tmp] = 162811;
    tmp = "chrX_KI270880v1_alt";
    CHRS[tmp] = 284869;
    tmp = "chrX_KI270881v1_alt";
    CHRS[tmp] = 144206;
    tmp = "chr19_KI270882v1_alt";
    CHRS[tmp] = 248807;
    tmp = "chr19_KI270883v1_alt";
    CHRS[tmp] = 170399;
    tmp = "chr19_KI270884v1_alt";
    CHRS[tmp] = 157053;
    tmp = "chr19_KI270885v1_alt";
    CHRS[tmp] = 171027;
    tmp = "chr19_KI270886v1_alt";
    CHRS[tmp] = 204239;
    tmp = "chr19_KI270887v1_alt";
    CHRS[tmp] = 209512;
    tmp = "chr19_KI270888v1_alt";
    CHRS[tmp] = 155532;
    tmp = "chr19_KI270889v1_alt";
    CHRS[tmp] = 170698;
    tmp = "chr19_KI270890v1_alt";
    CHRS[tmp] = 184499;
    tmp = "chr19_KI270891v1_alt";
    CHRS[tmp] = 170680;
    tmp = "chr1_KI270892v1_alt";
    CHRS[tmp] = 162212;
    tmp = "chr2_KI270894v1_alt";
    CHRS[tmp] = 214158;
    tmp = "chr2_KI270893v1_alt";
    CHRS[tmp] = 161218;
    tmp = "chr3_KI270895v1_alt";
    CHRS[tmp] = 162896;
    tmp = "chr4_KI270896v1_alt";
    CHRS[tmp] = 378547;
    tmp = "chr5_KI270897v1_alt";
    CHRS[tmp] = 1144418;
    tmp = "chr5_KI270898v1_alt";
    CHRS[tmp] = 130957;
    tmp = "chr6_GL000251v2_alt";
    CHRS[tmp] = 4795265;
    tmp = "chr7_KI270899v1_alt";
    CHRS[tmp] = 190869;
    tmp = "chr8_KI270901v1_alt";
    CHRS[tmp] = 136959;
    tmp = "chr8_KI270900v1_alt";
    CHRS[tmp] = 318687;
    tmp = "chr11_KI270902v1_alt";
    CHRS[tmp] = 106711;
    tmp = "chr11_KI270903v1_alt";
    CHRS[tmp] = 214625;
    tmp = "chr12_KI270904v1_alt";
    CHRS[tmp] = 572349;
    tmp = "chr15_KI270906v1_alt";
    CHRS[tmp] = 196384;
    tmp = "chr15_KI270905v1_alt";
    CHRS[tmp] = 5161414;
    tmp = "chr17_KI270907v1_alt";
    CHRS[tmp] = 137721;
    tmp = "chr17_KI270910v1_alt";
    CHRS[tmp] = 157099;
    tmp = "chr17_KI270909v1_alt";
    CHRS[tmp] = 325800;
    tmp = "chr17_JH159148v1_alt";
    CHRS[tmp] = 88070;
    tmp = "chr17_KI270908v1_alt";
    CHRS[tmp] = 1423190;
    tmp = "chr18_KI270912v1_alt";
    CHRS[tmp] = 174061;
    tmp = "chr18_KI270911v1_alt";
    CHRS[tmp] = 157710;
    tmp = "chr19_GL949747v2_alt";
    CHRS[tmp] = 729520;
    tmp = "chr22_KB663609v1_alt";
    CHRS[tmp] = 74013;
    tmp = "chrX_KI270913v1_alt";
    CHRS[tmp] = 274009;
    tmp = "chr19_KI270914v1_alt";
    CHRS[tmp] = 205194;
    tmp = "chr19_KI270915v1_alt";
    CHRS[tmp] = 170665;
    tmp = "chr19_KI270916v1_alt";
    CHRS[tmp] = 184516;
    tmp = "chr19_KI270917v1_alt";
    CHRS[tmp] = 190932;
    tmp = "chr19_KI270918v1_alt";
    CHRS[tmp] = 123111;
    tmp = "chr19_KI270919v1_alt";
    CHRS[tmp] = 170701;
    tmp = "chr19_KI270920v1_alt";
    CHRS[tmp] = 198005;
    tmp = "chr19_KI270921v1_alt";
    CHRS[tmp] = 282224;
    tmp = "chr19_KI270922v1_alt";
    CHRS[tmp] = 187935;
    tmp = "chr19_KI270923v1_alt";
    CHRS[tmp] = 189352;
    tmp = "chr3_KI270924v1_alt";
    CHRS[tmp] = 166540;
    tmp = "chr4_KI270925v1_alt";
    CHRS[tmp] = 555799;
    tmp = "chr6_GL000252v2_alt";
    CHRS[tmp] = 4604811;
    tmp = "chr8_KI270926v1_alt";
    CHRS[tmp] = 229282;
    tmp = "chr11_KI270927v1_alt";
    CHRS[tmp] = 218612;
    tmp = "chr19_GL949748v2_alt";
    CHRS[tmp] = 1064304;
    tmp = "chr22_KI270928v1_alt";
    CHRS[tmp] = 176103;
    tmp = "chr19_KI270929v1_alt";
    CHRS[tmp] = 186203;
    tmp = "chr19_KI270930v1_alt";
    CHRS[tmp] = 200773;
    tmp = "chr19_KI270931v1_alt";
    CHRS[tmp] = 170148;
    tmp = "chr19_KI270932v1_alt";
    CHRS[tmp] = 215732;
    tmp = "chr19_KI270933v1_alt";
    CHRS[tmp] = 170537;
    tmp = "chr19_GL000209v2_alt";
    CHRS[tmp] = 177381;
    tmp = "chr3_KI270934v1_alt";
    CHRS[tmp] = 163458;
    tmp = "chr6_GL000253v2_alt";
    CHRS[tmp] = 4677643;
    tmp = "chr19_GL949749v2_alt";
    CHRS[tmp] = 1091841;
    tmp = "chr3_KI270935v1_alt";
    CHRS[tmp] = 197351;
    tmp = "chr6_GL000254v2_alt";
    CHRS[tmp] = 4827813;
    tmp = "chr19_GL949750v2_alt";
    CHRS[tmp] = 1066390;
    tmp = "chr3_KI270936v1_alt";
    CHRS[tmp] = 164170;
    tmp = "chr6_GL000255v2_alt";
    CHRS[tmp] = 4606388;
    tmp = "chr19_GL949751v2_alt";
    CHRS[tmp] = 1002683;
    tmp = "chr3_KI270937v1_alt";
    CHRS[tmp] = 165607;
    tmp = "chr6_GL000256v2_alt";
    CHRS[tmp] = 4929269;
    tmp = "chr19_GL949752v1_alt";
    CHRS[tmp] = 987100;
    tmp = "chr6_KI270758v1_alt";
    CHRS[tmp] = 76752;
    tmp = "chr19_GL949753v2_alt";
    CHRS[tmp] = 796479;
    tmp = "chr19_KI270938v1_alt";
    CHRS[tmp] = 1066800;
    tmp = "chrUn_KI270302v1";
    CHRS[tmp] = 2274;
    tmp = "chrUn_KI270304v1";
    CHRS[tmp] = 2165;
    tmp = "chrUn_KI270303v1";
    CHRS[tmp] = 1942;
    tmp = "chrUn_KI270305v1";
    CHRS[tmp] = 1472;
    tmp = "chrUn_KI270322v1";
    CHRS[tmp] = 21476;
    tmp = "chrUn_KI270320v1";
    CHRS[tmp] = 4416;
    tmp = "chrUn_KI270310v1";
    CHRS[tmp] = 1201;
    tmp = "chrUn_KI270316v1";
    CHRS[tmp] = 1444;
    tmp = "chrUn_KI270315v1";
    CHRS[tmp] = 2276;
    tmp = "chrUn_KI270312v1";
    CHRS[tmp] = 998;
    tmp = "chrUn_KI270311v1";
    CHRS[tmp] = 12399;
    tmp = "chrUn_KI270317v1";
    CHRS[tmp] = 37690;
    tmp = "chrUn_KI270412v1";
    CHRS[tmp] = 1179;
    tmp = "chrUn_KI270411v1";
    CHRS[tmp] = 2646;
    tmp = "chrUn_KI270414v1";
    CHRS[tmp] = 2489;
    tmp = "chrUn_KI270419v1";
    CHRS[tmp] = 1029;
    tmp = "chrUn_KI270418v1";
    CHRS[tmp] = 2145;
    tmp = "chrUn_KI270420v1";
    CHRS[tmp] = 2321;
    tmp = "chrUn_KI270424v1";
    CHRS[tmp] = 2140;
    tmp = "chrUn_KI270417v1";
    CHRS[tmp] = 2043;
    tmp = "chrUn_KI270422v1";
    CHRS[tmp] = 1445;
    tmp = "chrUn_KI270423v1";
    CHRS[tmp] = 981;
    tmp = "chrUn_KI270425v1";
    CHRS[tmp] = 1884;
    tmp = "chrUn_KI270429v1";
    CHRS[tmp] = 1361;
    tmp = "chrUn_KI270442v1";
    CHRS[tmp] = 392061;
    tmp = "chrUn_KI270466v1";
    CHRS[tmp] = 1233;
    tmp = "chrUn_KI270465v1";
    CHRS[tmp] = 1774;
    tmp = "chrUn_KI270467v1";
    CHRS[tmp] = 3920;
    tmp = "chrUn_KI270435v1";
    CHRS[tmp] = 92983;
    tmp = "chrUn_KI270438v1";
    CHRS[tmp] = 112505;
    tmp = "chrUn_KI270468v1";
    CHRS[tmp] = 4055;
    tmp = "chrUn_KI270510v1";
    CHRS[tmp] = 2415;
    tmp = "chrUn_KI270509v1";
    CHRS[tmp] = 2318;
    tmp = "chrUn_KI270518v1";
    CHRS[tmp] = 2186;
    tmp = "chrUn_KI270508v1";
    CHRS[tmp] = 1951;
    tmp = "chrUn_KI270516v1";
    CHRS[tmp] = 1300;
    tmp = "chrUn_KI270512v1";
    CHRS[tmp] = 22689;
    tmp = "chrUn_KI270519v1";
    CHRS[tmp] = 138126;
    tmp = "chrUn_KI270522v1";
    CHRS[tmp] = 5674;
    tmp = "chrUn_KI270511v1";
    CHRS[tmp] = 8127;
    tmp = "chrUn_KI270515v1";
    CHRS[tmp] = 6361;
    tmp = "chrUn_KI270507v1";
    CHRS[tmp] = 5353;
    tmp = "chrUn_KI270517v1";
    CHRS[tmp] = 3253;
    tmp = "chrUn_KI270529v1";
    CHRS[tmp] = 1899;
    tmp = "chrUn_KI270528v1";
    CHRS[tmp] = 2983;
    tmp = "chrUn_KI270530v1";
    CHRS[tmp] = 2168;
    tmp = "chrUn_KI270539v1";
    CHRS[tmp] = 993;
    tmp = "chrUn_KI270538v1";
    CHRS[tmp] = 91309;
    tmp = "chrUn_KI270544v1";
    CHRS[tmp] = 1202;
    tmp = "chrUn_KI270548v1";
    CHRS[tmp] = 1599;
    tmp = "chrUn_KI270583v1";
    CHRS[tmp] = 1400;
    tmp = "chrUn_KI270587v1";
    CHRS[tmp] = 2969;
    tmp = "chrUn_KI270580v1";
    CHRS[tmp] = 1553;
    tmp = "chrUn_KI270581v1";
    CHRS[tmp] = 7046;
    tmp = "chrUn_KI270579v1";
    CHRS[tmp] = 31033;
    tmp = "chrUn_KI270589v1";
    CHRS[tmp] = 44474;
    tmp = "chrUn_KI270590v1";
    CHRS[tmp] = 4685;
    tmp = "chrUn_KI270584v1";
    CHRS[tmp] = 4513;
    tmp = "chrUn_KI270582v1";
    CHRS[tmp] = 6504;
    tmp = "chrUn_KI270588v1";
    CHRS[tmp] = 6158;
    tmp = "chrUn_KI270593v1";
    CHRS[tmp] = 3041;
    tmp = "chrUn_KI270591v1";
    CHRS[tmp] = 5796;
    tmp = "chrUn_KI270330v1";
    CHRS[tmp] = 1652;
    tmp = "chrUn_KI270329v1";
    CHRS[tmp] = 1040;
    tmp = "chrUn_KI270334v1";
    CHRS[tmp] = 1368;
    tmp = "chrUn_KI270333v1";
    CHRS[tmp] = 2699;
    tmp = "chrUn_KI270335v1";
    CHRS[tmp] = 1048;
    tmp = "chrUn_KI270338v1";
    CHRS[tmp] = 1428;
    tmp = "chrUn_KI270340v1";
    CHRS[tmp] = 1428;
    tmp = "chrUn_KI270336v1";
    CHRS[tmp] = 1026;
    tmp = "chrUn_KI270337v1";
    CHRS[tmp] = 1121;
    tmp = "chrUn_KI270363v1";
    CHRS[tmp] = 1803;
    tmp = "chrUn_KI270364v1";
    CHRS[tmp] = 2855;
    tmp = "chrUn_KI270362v1";
    CHRS[tmp] = 3530;
    tmp = "chrUn_KI270366v1";
    CHRS[tmp] = 8320;
    tmp = "chrUn_KI270378v1";
    CHRS[tmp] = 1048;
    tmp = "chrUn_KI270379v1";
    CHRS[tmp] = 1045;
    tmp = "chrUn_KI270389v1";
    CHRS[tmp] = 1298;
    tmp = "chrUn_KI270390v1";
    CHRS[tmp] = 2387;
    tmp = "chrUn_KI270387v1";
    CHRS[tmp] = 1537;
    tmp = "chrUn_KI270395v1";
    CHRS[tmp] = 1143;
    tmp = "chrUn_KI270396v1";
    CHRS[tmp] = 1880;
    tmp = "chrUn_KI270388v1";
    CHRS[tmp] = 1216;
    tmp = "chrUn_KI270394v1";
    CHRS[tmp] = 970;
    tmp = "chrUn_KI270386v1";
    CHRS[tmp] = 1788;
    tmp = "chrUn_KI270391v1";
    CHRS[tmp] = 1484;
    tmp = "chrUn_KI270383v1";
    CHRS[tmp] = 1750;
    tmp = "chrUn_KI270393v1";
    CHRS[tmp] = 1308;
    tmp = "chrUn_KI270384v1";
    CHRS[tmp] = 1658;
    tmp = "chrUn_KI270392v1";
    CHRS[tmp] = 971;
    tmp = "chrUn_KI270381v1";
    CHRS[tmp] = 1930;
    tmp = "chrUn_KI270385v1";
    CHRS[tmp] = 990;
    tmp = "chrUn_KI270382v1";
    CHRS[tmp] = 4215;
    tmp = "chrUn_KI270376v1";
    CHRS[tmp] = 1136;
    tmp = "chrUn_KI270374v1";
    CHRS[tmp] = 2656;
    tmp = "chrUn_KI270372v1";
    CHRS[tmp] = 1650;
    tmp = "chrUn_KI270373v1";
    CHRS[tmp] = 1451;
    tmp = "chrUn_KI270375v1";
    CHRS[tmp] = 2378;
    tmp = "chrUn_KI270371v1";
    CHRS[tmp] = 2805;
    tmp = "chrUn_KI270448v1";
    CHRS[tmp] = 7992;
    tmp = "chrUn_KI270521v1";
    CHRS[tmp] = 7642;
    tmp = "chrUn_GL000195v1";
    CHRS[tmp] = 182896;
    tmp = "chrUn_GL000219v1";
    CHRS[tmp] = 179198;
    tmp = "chrUn_GL000220v1";
    CHRS[tmp] = 161802;
    tmp = "chrUn_GL000224v1";
    CHRS[tmp] = 179693;
    tmp = "chrUn_KI270741v1";
    CHRS[tmp] = 157432;
    tmp = "chrUn_GL000226v1";
    CHRS[tmp] = 15008;
    tmp = "chrUn_GL000213v1";
    CHRS[tmp] = 164239;
    tmp = "chrUn_KI270743v1";
    CHRS[tmp] = 210658;
    tmp = "chrUn_KI270744v1";
    CHRS[tmp] = 168472;
    tmp = "chrUn_KI270745v1";
    CHRS[tmp] = 41891;
    tmp = "chrUn_KI270746v1";
    CHRS[tmp] = 66486;
    tmp = "chrUn_KI270747v1";
    CHRS[tmp] = 198735;
    tmp = "chrUn_KI270748v1";
    CHRS[tmp] = 93321;
    tmp = "chrUn_KI270749v1";
    CHRS[tmp] = 158759;
    tmp = "chrUn_KI270750v1";
    CHRS[tmp] = 148850;
    tmp = "chrUn_KI270751v1";
    CHRS[tmp] = 150742;
    tmp = "chrUn_KI270752v1";
    CHRS[tmp] = 27745;
    tmp = "chrUn_KI270753v1";
    CHRS[tmp] = 62944;
    tmp = "chrUn_KI270754v1";
    CHRS[tmp] = 40191;
    tmp = "chrUn_KI270755v1";
    CHRS[tmp] = 36723;
    tmp = "chrUn_KI270756v1";
    CHRS[tmp] = 79590;
    tmp = "chrUn_KI270757v1";
    CHRS[tmp] = 71251;
    tmp = "chrUn_GL000214v1";
    CHRS[tmp] = 137718;
    tmp = "chrUn_KI270742v1";
    CHRS[tmp] = 186739;
    tmp = "chrUn_GL000216v2";
    CHRS[tmp] = 176608;
    tmp = "chrUn_GL000218v1";
    CHRS[tmp] = 161147;
    tmp = "chrY_KI270740v1_random";
    CHRS[tmp] = 37240;
}
