from pypetka_script import * #импорт всех функций

'''Это пример использования PyPetka Script. 
Все функции вы можете посмотреть в readme.md или https://github.com/IlyaChaek/PyPetka-Script или на https://pypi.org/project/PyPetka-Script
Тут описана лишь часть функций, и создано для понимания синтаксиса
'''
# 1. Математические функции
вывод("Сумма:", сумма(1, 2, 3, 4))  # 10
вывод("Вычитание:", вычесть(10, 2, 3))  # -5
вывод("Деление:", деление(10, 2))  # 5.0
вывод("Умножение:", умножение(3, 4))  # 12
вывод("Факториал:", факториал(5))  # 120
вывод("Квадратный корень:", квадратный_корень(16))  # 4.0
вывод("Возведение в степень:", возвести_в_степень(2, 3))  # 8

# 2. Функции ввода/вывода
вывод("Привет, мир!")  # Выводит "Привет, мир!"
вывод_на_экран("Это вывод на экран.")  # Выводит "Это вывод на экран."
вывод_в_файл("Это будет записано в файл.", file=open("output.txt", "w"))  # Записывает в файл
вывод_без_переноса("Вывод без переноса строки. ")
вывод_с_переносом_строки("Вывод с переносом строки.")

# 3. Ввод
имя = ввод("Введите ваше имя: ")
вывод("Привет,", имя)

# 4. Проверка на четность
проверка_на_четность(4)  # Число четное
проверка_на_четность(5)  # Число нечетное

# 5. Игра "Угадай число"
угадай_число()  # Запускает игру

# 6. Преобразования
число = 10.5
вывод("Обычное число:", обычное_число(число))  # 10
вывод("Строка:", строка(число))  # '10.5'
вывод("Список:", список([1, 2, 3]))  # [1, 2, 3]

# 7. Циклы
условие = True
пока(условие, lambda: вывод("Это выполняется, пока условие истинно."))  # Пример использования, но нужно изменить условие для выхода

# 8. Строковые функции
строка = "Привет, мир!"
вывод("Перевернутая строка:", перевернуть_строку(строка))  # !рим ,тевирП
вывод("Проверка палиндрома:", проверить_палиндром("А роза упала на лапу Азора"))  # True
вывод("Удалить символ:", удалить_символ(строка, 'и'))  # Првет, мир!
вывод("Получить подстроку:", получить_подстроку(строка, 0, 5))  # Привет

# 9. Списковые функции
список1 = [1, 2, 3, 4, 5]
список2 = [4, 5, 6, 7, 8]
вывод("Сортировка:", сортировка(список1))  # [1, 2, 3, 4, 5]
вывод("Уникальные значения:", уникальные_значения([1, 2, 2, 3, 4, 4]))  # [1, 2, 3, 4]
вывод("Объединить списки:", объединить_списки(список1, список2))  # [1, 2, 3, 4, 5, 4, 5, 6, 7, 8]
вывод("Найти максимум:", найти_максимум(список1))  # 5
вывод("Найти минимум:", найти_минимум(список1))  # 1
вывод("Среднее значение:", среднее_значение(список1))  # 3.0
вывод("Фильтрация:", фильтрация(список1, lambda x: x > 2))  # [3, 4, 5]

# 10. Генерация и случайные функции
вывод("Генератор чисел:", генератор_чисел(1, 10))  # [1, 2, ..., 10]
вывод("Случайный элемент:", случайный_элемент(список1))  # Случайный элемент из списка
вывод("Генератор паролей:", генератор_паролей(8))  # Генерирует случайный пароль длиной 8

# 11. Группировка и агрегация
группировка = сгруппировать_по_ключу(список1, lambda x: x % 2)
вывод("Группировка по ключу (четность):", группировка)  # Группирует по четности
вывод("Среднее значение по ключу:", получить_среднее_значение_по_ключу(список1, lambda x: x))  # 3.0