from pypetka_script import pypetka_script as пипетка #импорт всех функций

'''Это пример использования PyPetka Script. 
Все функции вы можете посмотреть в README.MD на https://github.com/IlyaChaek/PyPetka-Script или на https://pypi.org/project/PyPetka-Script
Тут описана лишь часть функций, и создано для понимания синтаксиса
'''
# 1. Математические функции
пипетка.вывод("Сумма:", пипетка.сумма(1, 2, 3, 4))  # 10
пипетка.вывод("Вычитание:", пипетка.вычесть(10, 2, 3))  # -5
пипетка.вывод("Деление:", пипетка.деление(10, 2))  # 5.0
пипетка.вывод("Умножение:", пипетка.умножение(3, 4))  # 12
пипетка.вывод("Факториал:", пипетка.факториал(5))  # 120
пипетка.вывод("Квадратный корень:", пипетка.квадратный_корень(16))  # 4.0
пипетка.вывод("Возведение в степень:", пипетка.возвести_в_степень(2, 3))  # 8

# 2. Функции ввода/вывода
пипетка.вывод("Привет, мир!")  # Выводит "Привет, мир!"
пипетка.вывод_на_экран("Это вывод на экран.")  # Выводит "Это вывод на экран."
пипетка.вывод_в_файл("Это будет записано в файл.", file=open("output.txt", "w"))  # Записывает в файл
пипетка.вывод_без_переноса("Вывод без переноса строки. ")
пипетка.вывод_с_переносом_строки("Вывод с переносом строки.")

# 3. Ввод
пипетка.имя = пипетка.ввод("Введите ваше имя: ")
пипетка.вывод("Привет,", пипетка.имя)

# 4. Проверка на четность
пипетка.проверка_на_четность(4)  # Число четное
пипетка.проверка_на_четность(5)  # Число нечетное

# 5. Игра "Угадай число"
пипетка.угадай_число()  # Запускает игру

# 6. Преобразования
число = 10.5
пипетка.вывод("Обычное число:", пипетка.обычное_число(число))  # 10
пипетка.вывод("Строка:", пипетка.строка(число))  # '10.5'
пипетка.вывод("Список:", пипетка.список([1, 2, 3]))  # [1, 2, 3]

# 7. Циклы
условие = True
пипетка.пока(условие, lambda: пипетка.вывод("Это выполняется, пока условие истинно."))  # Пример использования, но нужно изменить условие для выхода

# 8. Строковые функции
строка = "Привет, мир!"
пипетка.вывод("Перевернутая строка:", пипетка.перевернуть_строку(строка))  # !рим ,тевирП
пипетка.вывод("Проверка палиндрома:", пипетка.проверить_палиндром("А роза упала на лапу Азора"))  # True
пипетка.вывод("Удалить символ:", пипетка.удалить_символ(строка, 'и'))  # Првет, мир!
пипетка.вывод("Получить подстроку:", пипетка.получить_подстроку(строка, 0, 5))  # Привет

# 9. Списковые функции
список1 = [1, 2, 3, 4, 5]
список2 = [4, 5, 6, 7, 8]
пипетка.вывод("Сортировка:", пипетка.сортировка(список1))  # [1, 2, 3, 4, 5]
пипетка.вывод("Уникальные значения:", пипетка.уникальные_значения([1, 2, 2, 3, 4, 4]))  # [1, 2, 3, 4]
пипетка.вывод("Объединить списки:", пипетка.объединить_списки(список1, список2))  # [1, 2, 3, 4, 5, 4, 5, 6, 7, 8]
пипетка.вывод("Найти максимум:", пипетка.найти_максимум(список1))  # 5
пипетка.вывод("Найти минимум:", пипетка.найти_минимум(список1))  # 1
пипетка.вывод("Среднее значение:", пипетка.среднее_значение(список1))  # 3.0
пипетка.вывод("Фильтрация:", пипетка.фильтрация(список1, lambda x: x > 2))  # [3, 4, 5]

# 10. Генерация и случайные функции
пипетка.вывод("Генератор чисел:", пипетка.генератор_чисел(1, 10))  # [1, 2, ..., 10]
пипетка.вывод("Случайный элемент:", пипетка.случайный_элемент(список1))  # Случайный элемент из списка
пипетка.вывод("Генератор паролей:", пипетка.генератор_паролей(8))  # Генерирует случайный пароль длиной 8

# 11. Группировка и агрегация
пипетка.группировка = пипетка.сгруппировать_по_ключу(список1, lambda x: x % 2)
пипетка.вывод("Группировка по ключу (четность):", пипетка.группировка)  # Группирует по четности
пипетка.вывод("Среднее значение по ключу:", пипетка.получить_среднее_значение_по_ключу(список1, lambda x: x))  # 3.0