import math
import sys
import random
import time
import tkinter as tk
from tkinter import ttk
import re
import ast

# 1.3.2
def сумма(*числа):
    """Возвращает сумму переданных чисел."""
    return sum(числа)

def вычесть(*числа):
    """Возвращает разность, вычитая все переданные числа из нуля."""
    return -sum(числа)

def вывод(*аргументы, sep=' ', end='\n', file=sys.stdout, flush=False):
    """Выводит аргументы на экран или в файл."""
    print(*аргументы, sep=sep, end=end, file=file, flush=flush)

def вывод_без_переноса(*аргументы, sep=' '):
    """Выводит аргументы без переноса строки."""
    print(*аргументы, sep=sep, end='')

def вывод_на_экран(*аргументы, sep=' ', end='\n'):
    """Выводит аргументы на экран."""
    print(*аргументы, sep=sep, end=end)

def вывод_в_файл(*аргументы, sep=' ', end='\n', file=sys.stdout):
    """Выводит аргументы в файл."""
    print(*аргументы, sep=sep, end=end, file=file)

def вывод_с_переносом_строки(*аргументы, sep=' '):
    """Выводит аргументы с переносом строки."""
    print(*аргументы, sep=sep)

def ввод(комментарий=None):
    """Запрашивает ввод от пользователя с опциональным комментарием."""
    return input(комментарий) if комментарий else input()
# 2.4.1  
def проверка_на_четность(число):
    """Проверяет, является ли число четным или нечетным."""
    if число % 2 == 0:
        вывод('Число четное')
    else:
        вывод('Число нечетное')

def деление(число1, число2):
    """Возвращает результат деления двух чисел."""
    if число2 == 0:
        вывод('Ошибка: деление на ноль!')
        return None
    return число1 / число2

def умножение(число1, число2):
    """Возвращает произведение двух чисел."""
    return число1 * число2

def привет_мир():
    """Выводит приветственное сообщение."""
    вывод('Привет, мир!')

def вернуть_значение(значение):
    """Возвращает переданное значение."""
    return значение

def обычное_число(число):
    """Преобразует число в целое."""
    return int(число)

def строка(число):
    """Преобразует число в строку."""
    return str(число)

def если(условие, действие_если_да, действие_если_нет=None):
    """Возвращает результат в зависимости от условия."""
    return действие_если_да if условие else действие_если_нет

def список(пользовательский_список):
    """Преобразует переданный объект в список."""
    return list(пользовательский_список)

def угадай_число():
    """Игра 'Угадай число'."""
    random_number = random.randint(1, 100)
    попытки = 0
    while True:
        попытки += 1
        try:
            user_number = int(input('Введите число: '))
        except ValueError:
            вывод('Пожалуйста, введите действительное число.')
            continue
        if user_number < random_number:
            вывод('Число меньше, чем загаданное')
        elif user_number > random_number:
            вывод('Число больше, чем загаданное')
        else:
            вывод(f'Вы угадали! Количество попыток: {попытки}')
            break

def пока(условие, действие):
    """Выполняет действие, пока условие истинно."""
    while условие:
        действие()

# Дополнительные функции
def факториал(число):
    """Возвращает факториал числа."""
    if число < 0:
        вывод('Ошибка: факториал отрицательного числа не определен!')
        return None
    return math.factorial(число)

def квадратный_корень(число):
    """Возвращает квадратный корень числа."""
    if число < 0:
        вывод('Ошибка: нельзя извлечь квадратный корень из отрицательного числа!')
        return None
    return math.sqrt(число)

def возвести_в_степень(основание, степень):
    """Возвращает основание, возведенное в заданную степень."""
    return основание ** степень

Истина = True
Ложь = False
число_пи = math.pi
def сортировка(список):
   """Сортирует переданный список."""
   return sorted(список)

def уникальные_значения(список):
   """Возвращает уникальные значения из списка."""
   return list(set(список))

def объединить_списки(список1, список2):
   """Объединяет два списка."""
   return список1 + список2

def найти_максимум(список):
   """Возвращает максимальное значение из списка."""
   return max(список)

def найти_минимум(список):
   """Возвращает минимальное значение из списка."""
   return min(список)

def среднее_значение(список):
   """Возвращает среднее значение чисел в списке."""
   return sum(список) / len(список) if список else 0

def перевернуть_строку(строка):
   """Возвращает перевернутую строку."""
   return строка[::-1]

def заменить_символы(строка, старый_символ, новый_символ):
   """Заменяет старый символ на новый в строке."""
   return строка.replace(старый_символ, новый_символ)

def проверить_палиндром(строка):
   """Проверяет, является ли строка палиндромом."""
   очищенная_строка = ''.join(строка.split()).lower()
   return очищенная_строка == очищенная_строка[::-1]

def генератор_чисел(начало, конец):
   """Генерирует список чисел от начала до конца."""
   return list(range(начало, конец + 1))

def случайный_элемент(список):
   """Возвращает случайный элемент из списка."""
   return random.choice(список) if список else None

def фильтрация(список, условие):
   """Возвращает элементы списка, которые соответствуют условию."""
   return [элемент for элемент in список if условие(элемент)]


def замена_в_списке(список, старый_элемент, новый_элемент):
   """Заменяет старый элемент на новый в списке."""
   return [новый_элемент if элемент == старый_элемент else элемент for элемент in список]


def пересечение_списков(список1, список2):
   """Возвращает пересечение двух списков."""
   return list(set(список1) & set(список2))

def разность_списков(список1, список2):
   """Возвращает элементы, которые есть в первом списке, но отсутствуют во втором."""
   return list(set(список1) - set(список2))

def объединение_списков(список1, список2):
   """Объединяет два списка, удаляя дубликаты."""
   return list(set(список1) | set(список2))

def найти_индекс(список, элемент):
   """Возвращает индекс элемента в списке, если он существует."""
   try:
       return список.index(элемент)
   except ValueError:
       return -1

def заменить_в_строке(строка, старый_символ, новый_символ):
   """Заменяет старый символ на новый в строке."""
   return строка.replace(старый_символ, новый_символ)

def подсчет_символов(строка):
   """Возвращает количество символов в строке."""
   return len(строка)

def удалить_символ(строка, символ):
   """Удаляет все вхождения символа из строки."""
   return строка.replace(символ, '')

def получить_подстроку(строка, начало, конец):
   """Возвращает подстроку из строки."""
   return строка[начало:конец]

def найти_дубликаты(список):
   """Возвращает список дубликатов из переданного списка."""
   seen = set()
   duplicates = set()
   for элемент in список:
       if элемент in seen:
           duplicates.add(элемент)
       else:
           seen.add(элемент)
   return list(duplicates)

def объединить_и_отсортировать(список1, список2):
   """Объединяет два списка и сортирует результат."""
   return sorted(set(список1) | set(список2))

def проверить_пустоту(список):
   """Проверяет, является ли список пустым."""
   return len(список) == 0

def получить_первый_элемент(список):
   """Возвращает первый элемент списка, если он существует."""
   return список[0] if список else None

def получить_последний_элемент(список):
   """Возвращает последний элемент списка, если он существует."""
   return список[-1] if список else None

def заменить_все(строка, старый_символ, новый_символ):
   """Заменяет все вхождения старого символа на новый в строке."""
   return строка.replace(старый_символ, новый_символ)

def проверить_анаграмму(строка1, строка2):
   """Проверяет, являются ли две строки анаграммами."""
   return sorted(строка1) == sorted(строка2)

def получить_часть_строки(строка, начало, длина):
   """Возвращает часть строки заданной длины, начиная с указанного индекса."""
   return строка[начало:начало + длина]

def удалить_пробелы(строка):
   """Удаляет все пробелы из строки."""
   return строка.replace(' ', '')

def заменить_первое_вхождение(строка, старый_символ, новый_символ):
   """Заменяет первое вхождение старого символа на новый в строке."""
   return строка.replace(старый_символ, новый_символ, 1)

def получить_индексы(список, элемент):
   """Возвращает список индексов всех вхождений элемента в списке."""
   return [i for i, x in enumerate(список) if x == элемент]

def разделить_по_символу(строка, символ):
   """Разделяет строку по заданному символу и возвращает список."""
   return строка.split(символ)

def объединить_с_разделителем(список, разделитель):
   """Объединяет элементы списка в строку с заданным разделителем."""
   return разделитель.join(список)

def получить_различия(список1, список2):
   """Возвращает элементы, которые есть в первом списке, но отсутствуют во втором."""
   return list(set(список1) - set(список2))



def получить_разность(список1, список2):
   """Возвращает элементы, которые есть в первом списке, но отсутствуют во втором."""
   return list(set(список1) - set(список2))


def найти_максимум_по_ключу(список, ключ):
   """Возвращает элемент с максимальным значением по заданному ключу."""
   return max(список, key=ключ) if список else None

def найти_минимум_по_ключу(список, ключ):
   """Возвращает элемент с минимальным значением по заданному ключу."""
   return min(список, key=ключ) if список else None

def сгруппировать_по_ключу(список, ключ):
   """Группирует элементы списка по заданному ключу."""
   from collections import defaultdict
   grouped = defaultdict(list)
   for элемент in список:
       grouped[ключ(элемент)].append(элемент)
   return dict(grouped)

def получить_среднее_значение_по_ключу(список, ключ):
   """Возвращает среднее значение по заданному ключу."""
   значения = [ключ(элемент) for элемент in список]
   return sum(значения) / len(значения) if значения else 0

def проверить_пустоту_словаря(словарь):
   """Проверяет, является ли словарь пустым."""
   return len(словарь) == 0

def получить_первый_ключ(словарь):
   """Возвращает первый ключ из словаря, если он существует."""
   return next(iter(словарь), None)

def получить_первое_значение(словарь):
   """Возвращает первое значение из словаря, если он существует."""
   return next(iter(словарь.values()), None)

def получить_последний_ключ(словарь):
   """Возвращает последний ключ из словаря, если он существует."""
   return list(словарь.keys())[-1] if словарь else None

def получить_последнее_значение(словарь):
   """Возвращает последнее значение из словаря, если он существует."""
   return list(словарь.values())[-1] if словарь else None

def объединить_и_отсортировать_по_ключу(список1, список2, ключ):
   """Объединяет два списка и сортирует результат по заданному ключу."""
   return sorted(set(список1) | set(список2), key=ключ)

def получить_различия_по_ключу(список1, список2, ключ):
   """Возвращает элементы, которые есть в первом списке, но отсутствуют во втором, по заданному ключу."""
   ключи2 = {ключ(элемент) for элемент in список2}
   return [элемент for элемент in список1 if ключ(элемент) not in ключи2]

def получить_пересечение_по_ключу(список1, список2, ключ):
   """Возвращает элементы, которые есть в обоих списках, по заданному ключу."""
   ключи1 = {ключ(элемент) for элемент in список1}
   return [элемент for элемент in список2 if ключ(элемент) in ключи1]

def получить_объединение_по_ключу(список1, список2, ключ):
   """Возвращает объединение двух списков без дубликатов по заданному ключу."""
   ключи = {ключ(элемент) for элемент in список1 + список2}
   return [элемент for элемент in список1 + список2 if ключ(элемент) in ключи]

def найти_дубликаты_по_ключу(список, ключ):
   """Возвращает список дубликатов из переданного списка по заданному ключу."""
   seen = set()
   duplicates = set()
   for элемент in список:
       ключ_элемента = ключ(элемент)
       if ключ_элемента in seen:
           duplicates.add(ключ_элемента)
       else:
           seen.add(ключ_элемента)
   return [элемент for элемент in список if ключ(элемент) in duplicates]

def получить_первый_дубликат(список, ключ):
   """Возвращает первый дубликат из списка по заданному ключу."""
   seen = set()
   for элемент in список:
       ключ_элемента = ключ(элемент)
       if ключ_элемента in seen:
           return элемент
       seen.add(ключ_элемента)
   return None

def получить_последний_дубликат(список, ключ):
   """Возвращает последний дубликат из списка по заданному ключу."""
   seen = set()
   последний_дубликат = None
   for элемент in список:
       ключ_элемента = ключ(элемент)
       if ключ_элемента in seen:
           последний_дубликат = элемент
       else:
           seen.add(ключ_элемента)
   return последний_дубликат

def получить_различия_по_значению(список1, список2, ключ):
   """Возвращает элементы, которые есть в первом списке, но отсутствуют во втором, по заданному ключу."""
   ключи2 = {ключ(элемент) for элемент in список2}
   return [элемент for элемент in список1 if ключ(элемент) not in ключи2]

def получить_пересечение_по_значению(список1, список2, ключ):
   """Возвращает элементы, которые есть в обоих списках, по заданному ключу."""
   ключи1 = {ключ(элемент) for элемент in список1}
   return [элемент for элемент in список2 if ключ(элемент) in ключи1]


def сгруппировать_по_значению(список, ключ):
   """Группирует элементы списка по значению, возвращаемому заданным ключом."""
   from collections import defaultdict
   grouped = defaultdict(list)
   for элемент in список:
       grouped[ключ(элемент)].append(элемент)
   return dict(grouped)


def генератор_паролей(Длина=12,маленькие_буквы=True,большие_буквы=True,цифры=True,спец_символы=True):
    """Генерирует случайный пароль заданной длины из возможных символов."""
    symbols = ''
    if маленькие_буквы:
        symbols += 'abcdefghijklmnopqrstuvwxyz'
    if большие_буквы:
        symbols += 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
    if цифры:
        symbols += '0123456789'
    if спец_символы:
        symbols += '!@#$%^&*()_+-=[]{}|;:,.<>/?'
    return ''.join(random.choice(symbols) for _ in range(Длина))

def генератор_рандомных_чисел(диапозон_начало, диапозон_конец):
    """Генерирует случайное число в заданном диапазоне."""
    import random
    return random.randint(диапозон_начало, диапозон_конец)

# 2.4.7


def начало_кода():
   """Запускает таймер выполнения кода, аргументы не требуются."""
   return time.perf_counter()

def конец_кода(начало):
   """Останавливает таймер выполнения кода. Вывод времени автоматически. В аргументе требуется указать начало кода (лучше всего переменную)"""
   end_time = time.perf_counter()
   execution_time = end_time - начало
   print(f"Время выполнения: {execution_time} секунд")

def калькулятор_консольный():
   """Запускает консольный калькулятор."""
   import math
   print("Калькулятор")
   print("Введите выражение:")
   expression = input()
   try:
       result = eval(expression)
       print("Результат:", result)
   except Exception as e:
       print("Ошибка:", e)
def калькулятор_с_интерфейсом():
    """Запускает интерфейсный калькулятор."""
    def calculate():
        expression = entry.get()
        try:
            result = eval(expression)
            result_label.config(text=f"Результат: {result}")
        except Exception as e:
            result_label.config(text=f"Ошибка: {e}")

    root = tk.Tk()
    root.title("Калькулятор")

    entry = ttk.Entry(root, width=30)
    entry.pack(pady=10)

    calculate_button = ttk.Button(root, text="=", command=calculate)
    calculate_button.pack()

    result_label = ttk.Label(root, text="")
    result_label.pack()

    root.mainloop()


def проверка_пароля_на_надежность(пароль):
    """Проверяет надежность пароля."""
    if len(пароль) < 8:
        return "Пароль ненадежен, длина должна быть не менее 8 знаков"
    if not re.search(r"\d", пароль):
        return "Пароль ненадежен, должен содержать цифры"
    if not re.search(r"[A-Za-z]", пароль):
        return "Пароль ненадежен, должен содержать буквы"
    if not re.search(r"[!@#$%^&*()_+=-{};:'<>,./?]", пароль):
        return "Пароль ненадежен, должен содержать спецсимволы"
    return "Пароль надежен"


def добавить_задачу_в_файл(task):
    """Добавляет задачу в файл."""
    file = open('Tasks_manager_file.txt', 'a', encoding='utf-8')
    file.write(f'\n{task}\n')
    file.close
def удалить_все_задачи():
    """Удаляет все задачи из файла."""
    i = input('Вы действительно хотите очистить спиок задач? y (Yes/Да) или n (No/Нет)\nВвод: ')
    if i == 'y':
        file = open('Tasks_manager_file.txt', 'w', encoding='utf-8')
        file.write(' ')
        file.close()
        print('Задачи успешно удалены!')
    elif i == 'n':
        print('Отмена удаления списка задач')
    else:
        print('Некорректный ввод. Выберите y(Yes/Да) или n(No/Нет)')

def проверка_простых_чисел(число):
    """Проверяет, является ли число простым."""
    if число <= 1:
        return "Число не является простым"
    for i in range(2, int(math.sqrt(число)) + 1):
        if число % i == 0:
            return "Число не является простым"
    return "Число является простым"

def проверка_трехзначных_чисел_на_убывающую_последовательность(число):
    """Проверяет, являются ли цифры трехзначного числа убывающей последовательностью."""
    if len(str(число)) != 3:
        return "Число не трехзначное"
    digits = sorted(str(число), reverse=True)
    return "Цифры образуют убывающую последовательность" if digits == list(str(число)) else "Цифры не образуют убывающую последовательность"



def очистка_кода_от_дубликатов(путь):
    """Очищает код от дубликатов."""
    with open(путь, 'r', encoding='utf-8') as file:
        lines = file.readlines()

    unique_lines = []
    seen_lines = set()

    for line in lines:
        if line not in seen_lines:
            unique_lines.append(line)
            seen_lines.add(line)

    cleaned_file_path = путь.replace('.py', '_cleaned.py')
    with open(cleaned_file_path, 'w', encoding='utf-8') as file:
        file.writelines(unique_lines)

