# Generated by Django 3.2.16 on 2022-12-11 06:51

from __future__ import annotations

from django.db import migrations, models


class Migration(migrations.Migration):
    """
    Track DeepL API usage
    """

    dependencies = [
        ("cms", "0054_user_totp_key"),
    ]

    operations = [
        migrations.AddField(
            model_name="region",
            name="deepl_addon_booked",
            field=models.BooleanField(
                default=False,
                help_text="This makes 1000000 translation credits available to the region instead of the 50000 free ones.",
                verbose_name="DeepL add-on package booked",
            ),
        ),
        migrations.AddField(
            model_name="region",
            name="deepl_budget_used",
            field=models.PositiveIntegerField(
                default=0, verbose_name="used DeepL budget"
            ),
        ),
        migrations.AddField(
            model_name="region",
            name="deepl_midyear_start_month",
            field=models.PositiveIntegerField(
                blank=True,
                choices=[
                    (0, "January"),
                    (1, "February"),
                    (2, "March"),
                    (3, "April"),
                    (4, "May"),
                    (5, "June"),
                    (6, "July"),
                    (7, "August"),
                    (8, "September"),
                    (9, "October"),
                    (10, "November"),
                    (11, "December"),
                ],
                default=None,
                help_text="Month from which the add-on package was booked",
                null=True,
                verbose_name="DeepL budget year start date",
            ),
        ),
        migrations.AddField(
            model_name="region",
            name="deepl_renewal_month",
            field=models.PositiveIntegerField(
                choices=[
                    (0, "January"),
                    (1, "February"),
                    (2, "March"),
                    (3, "April"),
                    (4, "May"),
                    (5, "June"),
                    (6, "July"),
                    (7, "August"),
                    (8, "September"),
                    (9, "October"),
                    (10, "November"),
                    (11, "December"),
                ],
                default=0,
                help_text="Budget usage will be reset on the 1st of the month",
                verbose_name="DeepL credits renewal date",
            ),
        ),
    ]
