# Generated by Django 3.2.20 on 2023-07-31 11:30

from __future__ import annotations

from django.db import migrations, models


class Migration(migrations.Migration):
    """
    Add fields for News / push notification templates
    """

    dependencies = [
        ("cms", "0075_add_pushnotification_multiple_regions"),
    ]

    operations = [
        migrations.AlterField(
            model_name="pushnotification",
            name="draft",
            field=models.BooleanField(
                default=True,
                help_text="Whether or not the News is a draft (drafts cannot be sent)",
                verbose_name="draft",
            ),
        ),
        migrations.AddField(
            model_name="pushnotification",
            name="is_template",
            field=models.BooleanField(default=False, verbose_name="News template"),
        ),
        migrations.AlterField(
            model_name="pushnotification",
            name="mode",
            field=models.CharField(
                choices=[
                    ("ONLY_AVAILABLE", "Only send available translations"),
                    (
                        "USE_MAIN_LANGUAGE",
                        "Use main language if no translation is available",
                    ),
                ],
                help_text="Sets behavior for dealing with not existing News translations",
                max_length=128,
                verbose_name="mode",
            ),
        ),
        migrations.AlterField(
            model_name="pushnotification",
            name="scheduled_send_date",
            field=models.DateTimeField(
                blank=True,
                help_text="The scheduled date for this News to be sent",
                null=True,
                verbose_name="scheduled send date",
            ),
        ),
        migrations.AlterField(
            model_name="pushnotification",
            name="sent_date",
            field=models.DateTimeField(
                blank=True,
                help_text="The date and time when the News was sent.",
                null=True,
                verbose_name="sent date",
            ),
        ),
        migrations.AddField(
            model_name="pushnotification",
            name="template_name",
            field=models.CharField(
                blank=True,
                help_text="Provide a distinct name for the template",
                max_length=128,
                null=True,
                verbose_name="News template name",
            ),
        ),
    ]
