# Generated by Django 4.2.9 on 2024-02-20 13:39

from django.db import migrations, models


class Migration(migrations.Migration):
    """
    Migration file to rename deeplXXX to names general to all MT providers
    """

    dependencies = [
        ("cms", "0087_add_preferred_mt_provider_to_languagetreenode"),
    ]

    operations = [
        migrations.RenameField(
            model_name="region",
            old_name="deepl_renewal_month",
            new_name="mt_renewal_month",
        ),
        migrations.RenameField(
            model_name="region",
            old_name="deepl_addon_booked",
            new_name="mt_addon_booked",
        ),
        migrations.RenameField(
            model_name="region",
            old_name="deepl_midyear_start_month",
            new_name="mt_midyear_start_month",
        ),
        migrations.RenameField(
            model_name="region",
            old_name="deepl_budget_used",
            new_name="mt_budget_used",
        ),
        migrations.AlterField(
            model_name="region",
            name="mt_renewal_month",
            field=models.PositiveIntegerField(
                choices=[
                    (0, "January"),
                    (1, "February"),
                    (2, "March"),
                    (3, "April"),
                    (4, "May"),
                    (5, "June"),
                    (6, "July"),
                    (7, "August"),
                    (8, "September"),
                    (9, "October"),
                    (10, "November"),
                    (11, "December"),
                ],
                default=0,
                verbose_name="Credits renewal date for foreign language translation",
                help_text="Budget usage will be reset on the 1st of the month",
            ),
        ),
        migrations.AlterField(
            model_name="region",
            name="mt_addon_booked",
            field=models.BooleanField(
                default=False,
                verbose_name="Add-on package for foreign languages booked",
                help_text="This makes 1000000 translation credits available to the region in addition to the 50000 free ones.",
            ),
        ),
        migrations.AlterField(
            model_name="region",
            name="mt_midyear_start_month",
            field=models.PositiveIntegerField(
                default=None,
                blank=True,
                null=True,
                choices=[
                    (0, "January"),
                    (1, "February"),
                    (2, "March"),
                    (3, "April"),
                    (4, "May"),
                    (5, "June"),
                    (6, "July"),
                    (7, "August"),
                    (8, "September"),
                    (9, "October"),
                    (10, "November"),
                    (11, "December"),
                ],
                verbose_name="Budget year start date for foreign language translation",
                help_text="Month from which the add-on package was booked",
            ),
        ),
        migrations.AlterField(
            model_name="region",
            name="mt_budget_used",
            field=models.PositiveIntegerField(
                default=0,
                verbose_name="used budget",
            ),
        ),
        migrations.AlterField(
            model_name="languagetreenode",
            name="preferred_mt_provider",
            field=models.CharField(
                choices=[
                    ("DeepL", "DeepL"),
                    ("Google Translate", "Google Translate"),
                    ("SUMM.AI", "SUMM.AI"),
                ],
                default="DeepL",
                help_text="Preferred provider for translations into this language",
                max_length=255,
                verbose_name="machine translation provider",
            ),
        ),
    ]
