# Generated by Django 4.2.13 on 2024-06-17 08:30

import django.core.validators
import django.db.models.deletion
from django.db import migrations, models


class Migration(migrations.Migration):
    """
    Add fields for chat beta testing functionality
    """

    dependencies = [
        ("cms", "0095_region_integreat_chat_enabled"),
    ]

    operations = [
        migrations.AddField(
            model_name="region",
            name="chat_beta_tester_percentage",
            field=models.IntegerField(
                blank=True,
                default=0,
                help_text="Percentage of users selected as beta testers for the Integreat Chat feature",
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(100),
                ],
                verbose_name="Chat beta tester percentage",
            ),
        ),
        migrations.CreateModel(
            name="ABTester",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("device_id", models.CharField(max_length=200)),
                ("is_tester", models.BooleanField(default=False)),
                (
                    "region",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE, to="cms.region"
                    ),
                ),
            ],
            options={
                "verbose_name": "ab tester",
                "verbose_name_plural": "ab testers",
                "ordering": ["-pk"],
                "default_permissions": ("delete", "change"),
            },
        ),
    ]
