# Generated by Django 4.2.13 on 2024-09-25 15:01

from __future__ import annotations

from typing import TYPE_CHECKING

import django.db.models.constraints
from django.db import migrations, models

from ..utils.repair_tree import repair_tree

if TYPE_CHECKING:
    from django.apps.registry import Apps
    from django.db.backends.base.schema import BaseDatabaseSchemaEditor


def forwards_func(
    apps: Apps,
    schema_editor: BaseDatabaseSchemaEditor,  # pylint: disable=unused-argument
) -> None:
    """
    Data migration step attempting to fix all trees
    to remove any lingering inconsistencies before adding constraints
    """
    repair_tree(commit=True, dj_apps=apps)


def reverse_func(
    apps: Apps,  # pylint: disable=unused-argument
    schema_editor: BaseDatabaseSchemaEditor,  # pylint: disable=unused-argument
) -> None:
    """
    Data migration when reverting this migration
    (nothing to do since the data is already consistent)
    """


class Migration(migrations.Migration):
    """
    Add (deferrable) constraints for the page tree and language nodes
    """

    dependencies = [
        ("cms", "0104_userchat_language_userchat_region_and_more"),
    ]

    operations = [
        migrations.RunPython(forwards_func, reverse_func),
        migrations.AddConstraint(
            model_name="languagetreenode",
            constraint=models.UniqueConstraint(
                deferrable=django.db.models.constraints.Deferrable["DEFERRED"],
                fields=("tree_id", "lft"),
                name="languagetreenode_unique_lft_tree",
            ),
        ),
        migrations.AddConstraint(
            model_name="languagetreenode",
            constraint=models.UniqueConstraint(
                deferrable=django.db.models.constraints.Deferrable["DEFERRED"],
                fields=("tree_id", "rgt"),
                name="languagetreenode_unique_rgt_tree",
            ),
        ),
        migrations.AddConstraint(
            model_name="languagetreenode",
            constraint=models.CheckConstraint(
                check=models.Q(("lft__lt", models.F("rgt"))),
                name="languagetreenode_check_rgt_greater_lft",
            ),
        ),
        migrations.AddConstraint(
            model_name="page",
            constraint=models.UniqueConstraint(
                deferrable=django.db.models.constraints.Deferrable["DEFERRED"],
                fields=("tree_id", "lft"),
                name="page_unique_lft_tree",
            ),
        ),
        migrations.AddConstraint(
            model_name="page",
            constraint=models.UniqueConstraint(
                deferrable=django.db.models.constraints.Deferrable["DEFERRED"],
                fields=("tree_id", "rgt"),
                name="page_unique_rgt_tree",
            ),
        ),
        migrations.AddConstraint(
            model_name="page",
            constraint=models.CheckConstraint(
                check=models.Q(("lft__lt", models.F("rgt"))),
                name="page_check_rgt_greater_lft",
            ),
        ),
    ]
