# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins
import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities
from . import outputs

__all__ = [
    'GetVclSnippetsResult',
    'AwaitableGetVclSnippetsResult',
    'get_vcl_snippets',
    'get_vcl_snippets_output',
]

@pulumi.output_type
class GetVclSnippetsResult:
    """
    A collection of values returned by getVclSnippets.
    """
    def __init__(__self__, id=None, service_id=None, service_version=None, vcl_snippets=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if service_id and not isinstance(service_id, str):
            raise TypeError("Expected argument 'service_id' to be a str")
        pulumi.set(__self__, "service_id", service_id)
        if service_version and not isinstance(service_version, int):
            raise TypeError("Expected argument 'service_version' to be a int")
        pulumi.set(__self__, "service_version", service_version)
        if vcl_snippets and not isinstance(vcl_snippets, list):
            raise TypeError("Expected argument 'vcl_snippets' to be a list")
        pulumi.set(__self__, "vcl_snippets", vcl_snippets)

    @property
    @pulumi.getter
    def id(self) -> builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="serviceId")
    def service_id(self) -> builtins.str:
        """
        Alphanumeric string identifying the service.
        """
        return pulumi.get(self, "service_id")

    @property
    @pulumi.getter(name="serviceVersion")
    def service_version(self) -> builtins.int:
        """
        Integer identifying a service version.
        """
        return pulumi.get(self, "service_version")

    @property
    @pulumi.getter(name="vclSnippets")
    def vcl_snippets(self) -> Sequence['outputs.GetVclSnippetsVclSnippetResult']:
        """
        List of all VCL snippets for the version of the service.
        """
        return pulumi.get(self, "vcl_snippets")


class AwaitableGetVclSnippetsResult(GetVclSnippetsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVclSnippetsResult(
            id=self.id,
            service_id=self.service_id,
            service_version=self.service_version,
            vcl_snippets=self.vcl_snippets)


def get_vcl_snippets(service_id: Optional[builtins.str] = None,
                     service_version: Optional[builtins.int] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVclSnippetsResult:
    """
    VCL Snippets are blocks of VCL logic inserted into your service's configuration that don't require custom VCL.

    Use this data source to get a list of [Fastly VCL Snippets](https://www.fastly.com/documentation/reference/api/vcl-services/snippet/) for the specified service/version.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fastly as fastly

    example_service_vcl = fastly.ServiceVcl("example",
        name="Example Service",
        domains=[{
            "name": "example.com",
        }],
        force_destroy=True)
    example = fastly.get_vcl_snippets_output(service_id=example_service_vcl.id,
        service_version=example_service_vcl.active_version)
    pulumi.export("serviceVclSnippets", example)
    ```

    [1]: https://www.fastly.com/documentation/reference/api/vcl-services/snippet/


    :param builtins.str service_id: Alphanumeric string identifying the service.
    :param builtins.int service_version: Integer identifying a service version.
    """
    __args__ = dict()
    __args__['serviceId'] = service_id
    __args__['serviceVersion'] = service_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('fastly:index/getVclSnippets:getVclSnippets', __args__, opts=opts, typ=GetVclSnippetsResult).value

    return AwaitableGetVclSnippetsResult(
        id=pulumi.get(__ret__, 'id'),
        service_id=pulumi.get(__ret__, 'service_id'),
        service_version=pulumi.get(__ret__, 'service_version'),
        vcl_snippets=pulumi.get(__ret__, 'vcl_snippets'))
def get_vcl_snippets_output(service_id: Optional[pulumi.Input[builtins.str]] = None,
                            service_version: Optional[pulumi.Input[builtins.int]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetVclSnippetsResult]:
    """
    VCL Snippets are blocks of VCL logic inserted into your service's configuration that don't require custom VCL.

    Use this data source to get a list of [Fastly VCL Snippets](https://www.fastly.com/documentation/reference/api/vcl-services/snippet/) for the specified service/version.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_fastly as fastly

    example_service_vcl = fastly.ServiceVcl("example",
        name="Example Service",
        domains=[{
            "name": "example.com",
        }],
        force_destroy=True)
    example = fastly.get_vcl_snippets_output(service_id=example_service_vcl.id,
        service_version=example_service_vcl.active_version)
    pulumi.export("serviceVclSnippets", example)
    ```

    [1]: https://www.fastly.com/documentation/reference/api/vcl-services/snippet/


    :param builtins.str service_id: Alphanumeric string identifying the service.
    :param builtins.int service_version: Integer identifying a service version.
    """
    __args__ = dict()
    __args__['serviceId'] = service_id
    __args__['serviceVersion'] = service_version
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('fastly:index/getVclSnippets:getVclSnippets', __args__, opts=opts, typ=GetVclSnippetsResult)
    return __ret__.apply(lambda __response__: GetVclSnippetsResult(
        id=pulumi.get(__response__, 'id'),
        service_id=pulumi.get(__response__, 'service_id'),
        service_version=pulumi.get(__response__, 'service_version'),
        vcl_snippets=pulumi.get(__response__, 'vcl_snippets')))
