# Generated by Django 6.0.dev20250312034749 on 2025-03-12 04:23

import django.core.validators
import django.db.models.deletion
from django.conf import settings
from django.db import migrations, models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='ApiService',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, unique=True, verbose_name='Name')),
                ('url', models.URLField(verbose_name='URL')),
                ('kong_id', models.CharField(blank=True, max_length=100, null=True, verbose_name='Kong ID')),
                ('active', models.BooleanField(default=True, verbose_name='Active')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created At')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated At')),
            ],
            options={
                'verbose_name': 'API Service',
                'verbose_name_plural': 'API Services',
                'indexes': [models.Index(fields=['active'], name='stripe_kong_active_356634_idx')],
            },
        ),
        migrations.CreateModel(
            name='Plan',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=100, verbose_name='Name')),
                ('stripe_price_id', models.CharField(max_length=100, unique=True, verbose_name='Stripe Price ID')),
                ('amount', models.DecimalField(decimal_places=2, max_digits=10, validators=[django.core.validators.MinValueValidator(0.01)], verbose_name='Amount')),
                ('currency', models.CharField(default='USD', max_length=3, verbose_name='Currency')),
                ('interval', models.CharField(choices=[('month', 'Monthly'), ('year', 'Yearly'), ('once', 'One-time')], max_length=20, verbose_name='Interval')),
                ('active', models.BooleanField(default=True, verbose_name='Active')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created At')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated At')),
            ],
            options={
                'verbose_name': 'Plan',
                'verbose_name_plural': 'Plans',
                'indexes': [models.Index(fields=['active'], name='stripe_kong_active_457b16_idx'), models.Index(fields=['interval'], name='stripe_kong_interva_428239_idx')],
            },
        ),
        migrations.CreateModel(
            name='PuckPage',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('title', models.CharField(max_length=200, verbose_name='Title')),
                ('slug', models.SlugField(unique=True, verbose_name='Slug')),
                ('content', models.JSONField(verbose_name='Content')),
                ('published', models.BooleanField(default=False, verbose_name='Published')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created At')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated At')),
            ],
            options={
                'verbose_name': 'Page',
                'verbose_name_plural': 'Pages',
                'indexes': [models.Index(fields=['published'], name='stripe_kong_publish_24c9cc_idx')],
            },
        ),
        migrations.CreateModel(
            name='ApiRoute',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('path', models.CharField(max_length=200, verbose_name='Path')),
                ('name', models.CharField(max_length=100, verbose_name='Name')),
                ('kong_id', models.CharField(blank=True, max_length=100, null=True, verbose_name='Kong ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created At')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated At')),
                ('service', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='routes', to='stripe_kong.apiservice', verbose_name='Service')),
            ],
            options={
                'verbose_name': 'API Route',
                'verbose_name_plural': 'API Routes',
                'constraints': [models.UniqueConstraint(fields=('service', 'path'), name='unique_service_path')],
            },
        ),
        migrations.CreateModel(
            name='ApiPlan',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('rate_limit', models.IntegerField(help_text='Requests per minute', validators=[django.core.validators.MinValueValidator(1)], verbose_name='Rate Limit')),
                ('kong_plugin_id', models.CharField(blank=True, max_length=100, null=True, verbose_name='Kong Plugin ID')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created At')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated At')),
                ('service', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='stripe_kong.apiservice', verbose_name='Service')),
                ('plan', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='stripe_kong.plan', verbose_name='Plan')),
            ],
            options={
                'verbose_name': 'API Plan',
                'verbose_name_plural': 'API Plans',
                'constraints': [models.UniqueConstraint(fields=('plan', 'service'), name='unique_plan_service')],
            },
        ),
        migrations.CreateModel(
            name='Subscription',
            fields=[
                ('id', models.BigAutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('stripe_subscription_id', models.CharField(blank=True, max_length=100, null=True, verbose_name='Stripe Subscription ID')),
                ('status', models.CharField(max_length=20, verbose_name='Status')),
                ('current_period_end', models.DateTimeField(blank=True, null=True, verbose_name='Current Period End')),
                ('created_at', models.DateTimeField(auto_now_add=True, verbose_name='Created At')),
                ('updated_at', models.DateTimeField(auto_now=True, verbose_name='Updated At')),
                ('plan', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='stripe_kong.plan', verbose_name='Plan')),
                ('user', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='subscriptions', to=settings.AUTH_USER_MODEL, verbose_name='User')),
            ],
            options={
                'verbose_name': 'Subscription',
                'verbose_name_plural': 'Subscriptions',
                'indexes': [models.Index(fields=['status'], name='stripe_kong_status_474022_idx'), models.Index(fields=['current_period_end'], name='stripe_kong_current_3293b2_idx')],
            },
        ),
    ]
