/*
 * Decompiled with CFR 0.152.
 */
package com.datapps.linkoopdb.jdbc.impl.pool;

import com.datapps.linkoopdb.jdbc.impl.JDBCConnection;
import com.datapps.linkoopdb.jdbc.impl.pool.JDBCXAConnection;
import com.datapps.linkoopdb.jdbc.impl.pool.JDBCXAResource;
import java.sql.SQLException;
import java.sql.Savepoint;

public class JDBCXAConnectionWrapper
extends JDBCConnection {
    private JDBCXAResource xaResource;

    public JDBCXAConnectionWrapper(JDBCXAResource xaResource, JDBCXAConnection xaConnection, JDBCConnection databaseConnection) throws SQLException {
        super(databaseConnection, xaConnection);
        xaResource.setConnection(this);
        this.xaResource = xaResource;
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        this.validateNotWithinTransaction();
        super.setAutoCommit(autoCommit);
    }

    @Override
    public void commit() throws SQLException {
        this.validateNotWithinTransaction();
        super.commit();
    }

    @Override
    public void rollback() throws SQLException {
        this.validateNotWithinTransaction();
        super.rollback();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        this.validateNotWithinTransaction();
        super.rollback(savepoint);
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        this.validateNotWithinTransaction();
        return super.setSavepoint();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        this.validateNotWithinTransaction();
        return super.setSavepoint(name);
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        this.validateNotWithinTransaction();
        super.setTransactionIsolation(level);
    }

    private void validateNotWithinTransaction() throws SQLException {
        if (this.xaResource.withinGlobalTransaction()) {
            throw new SQLException("Method prohibited within a global transaction");
        }
    }
}

