"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const lazy_1 = require("./lazy");
/**
 * Includes special markers for automatic generation of physical names.
 */
class PhysicalName {
    constructor() { }
}
/**
 * Use this to automatically generate a physical name for an AWS resource only
 * if the resource is referenced across environments (account/region).
 * Otherwise, the name will be allocated during deployment by CloudFormation.
 *
 * If you are certain that a resource will be referenced across environments,
 * you may also specify an explicit physical name for it. This option is
 * mostly designed for reusable constructs which may or may not be referenced
 * acrossed environments.
 */
PhysicalName.GENERATE_IF_NEEDED = lazy_1.Lazy.stringValue({
    produce: () => {
        throw new Error(`Invalid physical name passed to CloudFormation. Use "this.physicalName" instead`);
    }
});
exports.PhysicalName = PhysicalName;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGh5c2ljYWwtbmFtZS5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInBoeXNpY2FsLW5hbWUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7QUFBQSxpQ0FBOEI7QUFFOUI7O0dBRUc7QUFDSCxNQUFhLFlBQVk7SUFpQnZCLGdCQUF3QixDQUFDOztBQWhCekI7Ozs7Ozs7OztHQVNHO0FBQ29CLCtCQUFrQixHQUFHLFdBQUksQ0FBQyxXQUFXLENBQUM7SUFDM0QsT0FBTyxFQUFFLEdBQUcsRUFBRTtRQUNaLE1BQU0sSUFBSSxLQUFLLENBQUMsaUZBQWlGLENBQUMsQ0FBQztJQUNyRyxDQUFDO0NBQ0YsQ0FBQyxDQUFDO0FBZkwsb0NBa0JDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0IHsgTGF6eSB9IGZyb20gXCIuL2xhenlcIjtcblxuLyoqXG4gKiBJbmNsdWRlcyBzcGVjaWFsIG1hcmtlcnMgZm9yIGF1dG9tYXRpYyBnZW5lcmF0aW9uIG9mIHBoeXNpY2FsIG5hbWVzLlxuICovXG5leHBvcnQgY2xhc3MgUGh5c2ljYWxOYW1lIHtcbiAgLyoqXG4gICAqIFVzZSB0aGlzIHRvIGF1dG9tYXRpY2FsbHkgZ2VuZXJhdGUgYSBwaHlzaWNhbCBuYW1lIGZvciBhbiBBV1MgcmVzb3VyY2Ugb25seVxuICAgKiBpZiB0aGUgcmVzb3VyY2UgaXMgcmVmZXJlbmNlZCBhY3Jvc3MgZW52aXJvbm1lbnRzIChhY2NvdW50L3JlZ2lvbikuXG4gICAqIE90aGVyd2lzZSwgdGhlIG5hbWUgd2lsbCBiZSBhbGxvY2F0ZWQgZHVyaW5nIGRlcGxveW1lbnQgYnkgQ2xvdWRGb3JtYXRpb24uXG4gICAqXG4gICAqIElmIHlvdSBhcmUgY2VydGFpbiB0aGF0IGEgcmVzb3VyY2Ugd2lsbCBiZSByZWZlcmVuY2VkIGFjcm9zcyBlbnZpcm9ubWVudHMsXG4gICAqIHlvdSBtYXkgYWxzbyBzcGVjaWZ5IGFuIGV4cGxpY2l0IHBoeXNpY2FsIG5hbWUgZm9yIGl0LiBUaGlzIG9wdGlvbiBpc1xuICAgKiBtb3N0bHkgZGVzaWduZWQgZm9yIHJldXNhYmxlIGNvbnN0cnVjdHMgd2hpY2ggbWF5IG9yIG1heSBub3QgYmUgcmVmZXJlbmNlZFxuICAgKiBhY3Jvc3NlZCBlbnZpcm9ubWVudHMuXG4gICAqL1xuICBwdWJsaWMgc3RhdGljIHJlYWRvbmx5IEdFTkVSQVRFX0lGX05FRURFRCA9IExhenkuc3RyaW5nVmFsdWUoe1xuICAgIHByb2R1Y2U6ICgpID0+IHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgSW52YWxpZCBwaHlzaWNhbCBuYW1lIHBhc3NlZCB0byBDbG91ZEZvcm1hdGlvbi4gVXNlIFwidGhpcy5waHlzaWNhbE5hbWVcIiBpbnN0ZWFkYCk7XG4gICAgfVxuICB9KTtcblxuICBwcml2YXRlIGNvbnN0cnVjdG9yKCkgeyB9XG59XG4iXX0=