# -*- coding: utf-8 -*-
"""
Created on Fri Aug 26 09:32:50 2022

@author: RobWen
Version: 0.4.0
"""

# Packages
import requests
from bs4 import BeautifulSoup

# Header
from .TickerRequest import *

class GuruFocusRequest(TickerRequest):
    def __init__(self, ticker, headers_standard):
        super().__init__(ticker, headers_standard)
        self.__headers_standard = headers_standard

    ##############################
    ###                        ###
    ###  Gurufocus Requests    ###
    ###                        ###
    ##############################

    @property
    def pe_ratio_av(self):
        return self.__gurufocus_pe_ratio_av_v()

    @property
    def debt_to_ebitda(self):
        return self.__gurufocus_debt_to_ebitda()
       
    ##########################
    ###                    ###
    ###  Gurufocus Data    ###
    ###                    ###
    ##########################
    
    def __stock_exchange(self):
        r = requests.get(f'https://www.gurufocus.com/stock/{self.ticker}/summary')
        stock_exchange = BeautifulSoup(r.content, 'html.parser')
        
        try:
            stock_exchange = stock_exchange.find('span', {'class':'t-label'}).text.split()[0]
        except:
            return None
        
        return stock_exchange
    
    def __gurufocus_pe_ratio_av_v(self):
        if self.__stock_exchange() != None:
            r = requests.get(f'https://www.gurufocus.com/term/pettm/{self.__stock_exchange()}/PE-Ratio-TTM/')
            page = BeautifulSoup(r.content, 'html.parser')
        
            table = page.find('div', {'class':'history_bar value'})
            try:
                table = table.find('strong').text.split()
                self.__PE_Ratio_Average = float(table[3])
                return self.__PE_Ratio_Average
            except:
                return None
        else:
            return None
        
    def __gurufocus_debt_to_ebitda(self):
        
        if self.__stock_exchange() != None:
          
            url = f'https://www.gurufocus.com/term/debt2ebitda/{self.__stock_exchange()}/Debt-to-EBITDA'
            page = requests.get(url)
            page = BeautifulSoup(page.content, 'html.parser')

            table = page.find('div', {'class':'history_bar value'})

            try:
                table = table.find('strong')
                table = table.text.split()
                debt_to_EBITDA = table[7]
                try:
                    self.__debt_to_EBITDA = float(debt_to_EBITDA)
                except:
                    return '#'
                return self.__debt_to_EBITDA
            except (AttributeError):
                return '#'