"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

This program source code file is part of KiCad, a free EDA CAD application.

Copyright (C) 2024 Jon Evans <jon@craftyjon.com>
Copyright (C) 2024 KiCad Developers, see AUTHORS.txt for contributors.

This program is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, either version 3 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see <http://www.gnu.org/licenses/>.
"""
from .. import board
import builtins
import collections.abc
from .. import common
import google.protobuf.descriptor
import google.protobuf.internal.containers
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions
DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _BoardStackupLayerType:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _BoardStackupLayerTypeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_BoardStackupLayerType.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    BSLT_UNKNOWN: _BoardStackupLayerType.ValueType
    BSLT_COPPER: _BoardStackupLayerType.ValueType
    BSLT_DIELECTRIC: _BoardStackupLayerType.ValueType
    BSLT_SILKSCREEN: _BoardStackupLayerType.ValueType
    BSLT_SOLDERMASK: _BoardStackupLayerType.ValueType
    BSLT_SOLDERPASTE: _BoardStackupLayerType.ValueType
    BSLT_UNDEFINED: _BoardStackupLayerType.ValueType

class BoardStackupLayerType(_BoardStackupLayerType, metaclass=_BoardStackupLayerTypeEnumTypeWrapper):
    ...
BSLT_UNKNOWN: BoardStackupLayerType.ValueType
BSLT_COPPER: BoardStackupLayerType.ValueType
BSLT_DIELECTRIC: BoardStackupLayerType.ValueType
BSLT_SILKSCREEN: BoardStackupLayerType.ValueType
BSLT_SOLDERMASK: BoardStackupLayerType.ValueType
BSLT_SOLDERPASTE: BoardStackupLayerType.ValueType
BSLT_UNDEFINED: BoardStackupLayerType.ValueType
global___BoardStackupLayerType = BoardStackupLayerType

class _BoardLayerClass:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _BoardLayerClassEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_BoardLayerClass.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    BLC_UNKNOWN: _BoardLayerClass.ValueType
    BLC_SILKSCREEN: _BoardLayerClass.ValueType
    BLC_COPPER: _BoardLayerClass.ValueType
    BLC_EDGES: _BoardLayerClass.ValueType
    BLC_COURTYARD: _BoardLayerClass.ValueType
    BLC_FABRICATION: _BoardLayerClass.ValueType
    BLC_OTHER: _BoardLayerClass.ValueType

class BoardLayerClass(_BoardLayerClass, metaclass=_BoardLayerClassEnumTypeWrapper):
    """LAYER_CLASS_* in BOARD_DESIGN_SETTINGS -- needs to become an enum class"""
BLC_UNKNOWN: BoardLayerClass.ValueType
BLC_SILKSCREEN: BoardLayerClass.ValueType
BLC_COPPER: BoardLayerClass.ValueType
BLC_EDGES: BoardLayerClass.ValueType
BLC_COURTYARD: BoardLayerClass.ValueType
BLC_FABRICATION: BoardLayerClass.ValueType
BLC_OTHER: BoardLayerClass.ValueType
global___BoardLayerClass = BoardLayerClass

@typing.final
class BoardFinish(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    TYPE_NAME_FIELD_NUMBER: builtins.int
    type_name: builtins.str

    def __init__(self, *, type_name: builtins.str=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['type_name', b'type_name']) -> None:
        ...
global___BoardFinish = BoardFinish

@typing.final
class BoardImpedanceControl(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    IS_CONTROLLED_FIELD_NUMBER: builtins.int
    is_controlled: builtins.bool

    def __init__(self, *, is_controlled: builtins.bool=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['is_controlled', b'is_controlled']) -> None:
        ...
global___BoardImpedanceControl = BoardImpedanceControl

@typing.final
class BoardEdgeConnector(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(self) -> None:
        ...
global___BoardEdgeConnector = BoardEdgeConnector

@typing.final
class Castellation(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    HAS_CASTELLATED_PADS_FIELD_NUMBER: builtins.int
    has_castellated_pads: builtins.bool

    def __init__(self, *, has_castellated_pads: builtins.bool=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['has_castellated_pads', b'has_castellated_pads']) -> None:
        ...
global___Castellation = Castellation

@typing.final
class EdgePlating(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    HAS_EDGE_PLATING_FIELD_NUMBER: builtins.int
    has_edge_plating: builtins.bool

    def __init__(self, *, has_edge_plating: builtins.bool=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['has_edge_plating', b'has_edge_plating']) -> None:
        ...
global___EdgePlating = EdgePlating

@typing.final
class BoardEdgeSettings(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    CONNECTOR_FIELD_NUMBER: builtins.int
    CASTELLATION_FIELD_NUMBER: builtins.int
    PLATING_FIELD_NUMBER: builtins.int

    @property
    def connector(self) -> global___BoardEdgeConnector:
        ...

    @property
    def castellation(self) -> global___Castellation:
        ...

    @property
    def plating(self) -> global___EdgePlating:
        ...

    def __init__(self, *, connector: global___BoardEdgeConnector | None=..., castellation: global___Castellation | None=..., plating: global___EdgePlating | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['castellation', b'castellation', 'connector', b'connector', 'plating', b'plating']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['castellation', b'castellation', 'connector', b'connector', 'plating', b'plating']) -> None:
        ...
global___BoardEdgeSettings = BoardEdgeSettings

@typing.final
class BoardStackupCopperLayer(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(self) -> None:
        ...
global___BoardStackupCopperLayer = BoardStackupCopperLayer

@typing.final
class BoardStackupDielectricProperties(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    EPSILON_R_FIELD_NUMBER: builtins.int
    LOSS_TANGENT_FIELD_NUMBER: builtins.int
    MATERIAL_NAME_FIELD_NUMBER: builtins.int
    THICKNESS_FIELD_NUMBER: builtins.int
    epsilon_r: builtins.float
    loss_tangent: builtins.float
    material_name: builtins.str

    @property
    def thickness(self) -> common.types.base_types_pb2.Distance:
        ...

    def __init__(self, *, epsilon_r: builtins.float=..., loss_tangent: builtins.float=..., material_name: builtins.str=..., thickness: common.types.base_types_pb2.Distance | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['thickness', b'thickness']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['epsilon_r', b'epsilon_r', 'loss_tangent', b'loss_tangent', 'material_name', b'material_name', 'thickness', b'thickness']) -> None:
        ...
global___BoardStackupDielectricProperties = BoardStackupDielectricProperties

@typing.final
class BoardStackupDielectricLayer(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    LAYER_FIELD_NUMBER: builtins.int

    @property
    def layer(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BoardStackupDielectricProperties]:
        """A single dielectric slot (between copper layers) can be made up of multiple physical layers"""

    def __init__(self, *, layer: collections.abc.Iterable[global___BoardStackupDielectricProperties] | None=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['layer', b'layer']) -> None:
        ...
global___BoardStackupDielectricLayer = BoardStackupDielectricLayer

@typing.final
class BoardStackupLayer(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    THICKNESS_FIELD_NUMBER: builtins.int
    LAYER_FIELD_NUMBER: builtins.int
    ENABLED_FIELD_NUMBER: builtins.int
    TYPE_FIELD_NUMBER: builtins.int
    DIELECTRIC_FIELD_NUMBER: builtins.int
    COLOR_FIELD_NUMBER: builtins.int
    MATERIAL_NAME_FIELD_NUMBER: builtins.int
    USER_NAME_FIELD_NUMBER: builtins.int
    layer: board.board_types_pb2.BoardLayer.ValueType
    enabled: builtins.bool
    type: global___BoardStackupLayerType.ValueType
    material_name: builtins.str
    user_name: builtins.str
    'The name of the layer shown in the KiCad GUI, which may be a default value like "F.Cu" or may\n    have been customized by the user.  This field does not apply to dielectric layers.\n    '

    @property
    def thickness(self) -> common.types.base_types_pb2.Distance:
        ...

    @property
    def dielectric(self) -> global___BoardStackupDielectricLayer:
        ...

    @property
    def color(self) -> common.types.base_types_pb2.Color:
        ...

    def __init__(self, *, thickness: common.types.base_types_pb2.Distance | None=..., layer: board.board_types_pb2.BoardLayer.ValueType=..., enabled: builtins.bool=..., type: global___BoardStackupLayerType.ValueType=..., dielectric: global___BoardStackupDielectricLayer | None=..., color: common.types.base_types_pb2.Color | None=..., material_name: builtins.str=..., user_name: builtins.str=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['color', b'color', 'dielectric', b'dielectric', 'thickness', b'thickness']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['color', b'color', 'dielectric', b'dielectric', 'enabled', b'enabled', 'layer', b'layer', 'material_name', b'material_name', 'thickness', b'thickness', 'type', b'type', 'user_name', b'user_name']) -> None:
        ...
global___BoardStackupLayer = BoardStackupLayer

@typing.final
class BoardStackup(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    FINISH_FIELD_NUMBER: builtins.int
    IMPEDANCE_FIELD_NUMBER: builtins.int
    EDGE_FIELD_NUMBER: builtins.int
    LAYERS_FIELD_NUMBER: builtins.int

    @property
    def finish(self) -> global___BoardFinish:
        ...

    @property
    def impedance(self) -> global___BoardImpedanceControl:
        ...

    @property
    def edge(self) -> global___BoardEdgeSettings:
        """NOTE: m_HasThicknessConstrains appears to be unused"""

    @property
    def layers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BoardStackupLayer]:
        ...

    def __init__(self, *, finish: global___BoardFinish | None=..., impedance: global___BoardImpedanceControl | None=..., edge: global___BoardEdgeSettings | None=..., layers: collections.abc.Iterable[global___BoardStackupLayer] | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['edge', b'edge', 'finish', b'finish', 'impedance', b'impedance']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['edge', b'edge', 'finish', b'finish', 'impedance', b'impedance', 'layers', b'layers']) -> None:
        ...
global___BoardStackup = BoardStackup

@typing.final
class BoardLayerGraphicsDefaults(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    LAYER_FIELD_NUMBER: builtins.int
    TEXT_FIELD_NUMBER: builtins.int
    LINE_THICKNESS_FIELD_NUMBER: builtins.int
    layer: global___BoardLayerClass.ValueType

    @property
    def text(self) -> common.types.base_types_pb2.TextAttributes:
        ...

    @property
    def line_thickness(self) -> common.types.base_types_pb2.Distance:
        ...

    def __init__(self, *, layer: global___BoardLayerClass.ValueType=..., text: common.types.base_types_pb2.TextAttributes | None=..., line_thickness: common.types.base_types_pb2.Distance | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['line_thickness', b'line_thickness', 'text', b'text']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['layer', b'layer', 'line_thickness', b'line_thickness', 'text', b'text']) -> None:
        ...
global___BoardLayerGraphicsDefaults = BoardLayerGraphicsDefaults

@typing.final
class GraphicsDefaults(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    LAYERS_FIELD_NUMBER: builtins.int

    @property
    def layers(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___BoardLayerGraphicsDefaults]:
        ...

    def __init__(self, *, layers: collections.abc.Iterable[global___BoardLayerGraphicsDefaults] | None=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['layers', b'layers']) -> None:
        ...
global___GraphicsDefaults = GraphicsDefaults

@typing.final
class BoardSettings(google.protobuf.message.Message):
    """Anything that isn't stackup or design rules"""
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    GRAPHICS_DEFAULTS_FIELD_NUMBER: builtins.int

    @property
    def graphics_defaults(self) -> global___GraphicsDefaults:
        """Dimension default settings"""

    def __init__(self, *, graphics_defaults: global___GraphicsDefaults | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['graphics_defaults', b'graphics_defaults']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['graphics_defaults', b'graphics_defaults']) -> None:
        ...
global___BoardSettings = BoardSettings

@typing.final
class BoardDesignRules(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    def __init__(self) -> None:
        ...
global___BoardDesignRules = BoardDesignRules