"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file

This program source code file is part of KiCad, a free EDA CAD application.

Copyright (C) 2024 KiCad Developers, see AUTHORS.txt for contributors.

This program is free software: you can redistribute it and/or modify it
under the terms of the GNU General Public License as published by the
Free Software Foundation, either version 3 of the License, or (at your
option) any later version.

This program is distributed in the hope that it will be useful, but
WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
General Public License for more details.

You should have received a copy of the GNU General Public License along
with this program.  If not, see <http://www.gnu.org/licenses/>.
"""
import builtins
import google.protobuf.any_pb2
import google.protobuf.descriptor
import google.protobuf.internal.enum_type_wrapper
import google.protobuf.message
import sys
import typing
if sys.version_info >= (3, 10):
    import typing as typing_extensions
else:
    import typing_extensions
DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

class _ApiStatusCode:
    ValueType = typing.NewType('ValueType', builtins.int)
    V: typing_extensions.TypeAlias = ValueType

class _ApiStatusCodeEnumTypeWrapper(google.protobuf.internal.enum_type_wrapper._EnumTypeWrapper[_ApiStatusCode.ValueType], builtins.type):
    DESCRIPTOR: google.protobuf.descriptor.EnumDescriptor
    AS_UNKNOWN: _ApiStatusCode.ValueType
    AS_OK: _ApiStatusCode.ValueType
    'Request succeeded'
    AS_TIMEOUT: _ApiStatusCode.ValueType
    'Request timed out'
    AS_BAD_REQUEST: _ApiStatusCode.ValueType
    'The request had invalid parameters or otherwise was illegal'
    AS_NOT_READY: _ApiStatusCode.ValueType
    'KiCad has recently started and cannot handle API requests yet'
    AS_UNHANDLED: _ApiStatusCode.ValueType
    'The request was not handled by KiCad'
    AS_TOKEN_MISMATCH: _ApiStatusCode.ValueType
    "The kicad_token in the request didn't match this KiCad's token"
    AS_BUSY: _ApiStatusCode.ValueType
    "KiCad is busy performing an operation and can't accept API commands"
    AS_UNIMPLEMENTED: _ApiStatusCode.ValueType
    'The requested API call has not yet been implemented'

class ApiStatusCode(_ApiStatusCode, metaclass=_ApiStatusCodeEnumTypeWrapper):
    ...
AS_UNKNOWN: ApiStatusCode.ValueType
AS_OK: ApiStatusCode.ValueType
'Request succeeded'
AS_TIMEOUT: ApiStatusCode.ValueType
'Request timed out'
AS_BAD_REQUEST: ApiStatusCode.ValueType
'The request had invalid parameters or otherwise was illegal'
AS_NOT_READY: ApiStatusCode.ValueType
'KiCad has recently started and cannot handle API requests yet'
AS_UNHANDLED: ApiStatusCode.ValueType
'The request was not handled by KiCad'
AS_TOKEN_MISMATCH: ApiStatusCode.ValueType
"The kicad_token in the request didn't match this KiCad's token"
AS_BUSY: ApiStatusCode.ValueType
"KiCad is busy performing an operation and can't accept API commands"
AS_UNIMPLEMENTED: ApiStatusCode.ValueType
'The requested API call has not yet been implemented'
global___ApiStatusCode = ApiStatusCode

@typing.final
class ApiRequestHeader(google.protobuf.message.Message):
    """
    For future expansion: any header fields that should be sent with a request
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    KICAD_TOKEN_FIELD_NUMBER: builtins.int
    CLIENT_NAME_FIELD_NUMBER: builtins.int
    kicad_token: builtins.str
    "An opaque string identifying a running instance of KiCad.  If this is set to a non-empty\n    string in an API request, KiCad will reject the request if the value doesn't match its own\n    token.  This can be used to let API clients make sure they are still talking to the same\n    instance of KiCad if they are long-running.\n    "
    client_name: builtins.str
    'A string identifying an API client.  Should be set by the client to a value that is unique\n    to a specific instance of a client, for example the package name of the client plus its\n    process ID or a random string, e.g. "com.github.me.my_awesome_plugin-73951".  The main purpose\n    of this name is to identify the client in debug logs.\n    '

    def __init__(self, *, kicad_token: builtins.str=..., client_name: builtins.str=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['client_name', b'client_name', 'kicad_token', b'kicad_token']) -> None:
        ...
global___ApiRequestHeader = ApiRequestHeader

@typing.final
class ApiRequest(google.protobuf.message.Message):
    """
    The top-level envelope container for an API request (message from a client to the KiCad API server)
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    HEADER_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int

    @property
    def header(self) -> global___ApiRequestHeader:
        ...

    @property
    def message(self) -> google.protobuf.any_pb2.Any:
        ...

    def __init__(self, *, header: global___ApiRequestHeader | None=..., message: google.protobuf.any_pb2.Any | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['header', b'header', 'message', b'message']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['header', b'header', 'message', b'message']) -> None:
        ...
global___ApiRequest = ApiRequest

@typing.final
class ApiResponseHeader(google.protobuf.message.Message):
    """
    For future expansion: any header fields that should be sent with a response
    """
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    KICAD_TOKEN_FIELD_NUMBER: builtins.int
    kicad_token: builtins.str
    '/ An opaque string identifying a running instance of KiCad.'

    def __init__(self, *, kicad_token: builtins.str=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['kicad_token', b'kicad_token']) -> None:
        ...
global___ApiResponseHeader = ApiResponseHeader

@typing.final
class ApiResponse(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    HEADER_FIELD_NUMBER: builtins.int
    STATUS_FIELD_NUMBER: builtins.int
    MESSAGE_FIELD_NUMBER: builtins.int

    @property
    def header(self) -> global___ApiResponseHeader:
        ...

    @property
    def status(self) -> global___ApiResponseStatus:
        ...

    @property
    def message(self) -> google.protobuf.any_pb2.Any:
        ...

    def __init__(self, *, header: global___ApiResponseHeader | None=..., status: global___ApiResponseStatus | None=..., message: google.protobuf.any_pb2.Any | None=...) -> None:
        ...

    def HasField(self, field_name: typing.Literal['header', b'header', 'message', b'message', 'status', b'status']) -> builtins.bool:
        ...

    def ClearField(self, field_name: typing.Literal['header', b'header', 'message', b'message', 'status', b'status']) -> None:
        ...
global___ApiResponse = ApiResponse

@typing.final
class ApiResponseStatus(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor
    STATUS_FIELD_NUMBER: builtins.int
    ERROR_MESSAGE_FIELD_NUMBER: builtins.int
    status: global___ApiStatusCode.ValueType
    '/ A code describing the category of error (or AS_OK if no error)'
    error_message: builtins.str
    '/ A human-readable description of the error, if any'

    def __init__(self, *, status: global___ApiStatusCode.ValueType=..., error_message: builtins.str=...) -> None:
        ...

    def ClearField(self, field_name: typing.Literal['error_message', b'error_message', 'status', b'status']) -> None:
        ...
global___ApiResponseStatus = ApiResponseStatus