from collections.abc import Mapping
from dataclasses import asdict, dataclass
from functools import cached_property
from typing import Optional, Union

from atoti_core import keyword_only_dataclass
from typeguard import typeguard_ignore


@keyword_only_dataclass
@typeguard_ignore
@dataclass(frozen=True)
class MeasureMetadata:
    description: Optional[str] = None
    folder: Optional[str] = None
    formatter: Optional[str] = None
    visible: Optional[bool] = None

    @cached_property
    def defined_properties(
        self,
    ) -> Mapping[str, Optional[Union[str, bool]]]:
        return asdict(
            self,
            dict_factory=lambda items: {
                key: str(value) for key, value in items if value is not None
            },
        )
