from __future__ import annotations

import os

from atoti_core import LICENSE_KEY_ENV_VAR_NAME, get_env_flag

from .import_event import ImportEvent
from .send_event import send_event
from .send_heartbeat import send_heartbeat
from .track_calls import track_calls

_DISABLE_TELEMETRY_ENV_VAR_NAME = "_ATOTI_DISABLE_TELEMETRY"


def telemeter() -> None:
    if os.environ.get(LICENSE_KEY_ENV_VAR_NAME) or get_env_flag(
        _DISABLE_TELEMETRY_ENV_VAR_NAME
    ):
        return

    send_event(ImportEvent())
    send_heartbeat()
    track_calls()
