# python build stubs for package whatsapp
# File is generated by gopy. Do not edit.
# gopy build -output=generated -no-make=true -build-tags="mupdf extlib" .

from pybindgen import retval, param, Function, Module
import sys

class CheckedFunction(Function):
    def __init__(self, *a, **kw):
        super(CheckedFunction, self).__init__(*a, **kw)
        self._failure_expression = kw.get('failure_expression', '')
        self._failure_cleanup = kw.get('failure_cleanup', '')

    def set_failure_expression(self, expr):
        self._failure_expression = expr

    def set_failure_cleanup(self, expr):
        self._failure_cleanup = expr

    def generate_call(self):
        super(CheckedFunction, self).generate_call()
        check = "PyErr_Occurred()"
        if self._failure_expression:
            check = "{} && {}".format(self._failure_expression, check)
        failure_cleanup = self._failure_cleanup or None
        self.before_call.write_error_check(check, failure_cleanup)

def add_checked_function(mod, name, retval, params, failure_expression='', *a, **kw):
    fn = CheckedFunction(name, retval, params, *a, **kw)
    fn.set_failure_expression(failure_expression)
    mod._add_function_obj(fn)
    return fn

def add_checked_string_function(mod, name, retval, params, failure_expression='', *a, **kw):
    fn = CheckedFunction(name, retval, params, *a, **kw)
    fn.set_failure_cleanup('if (retval != NULL) free(retval);')
    fn.after_call.add_cleanup_code('free(retval);')
    fn.set_failure_expression(failure_expression)
    mod._add_function_obj(fn)
    return fn

mod = Module('_whatsapp')
mod.add_include('"whatsapp_go.h"')
mod.add_function('GoPyInit', None, [])
mod.add_function('DecRef', None, [param('int64_t', 'handle')])
mod.add_function('IncRef', None, [param('int64_t', 'handle')])
mod.add_function('NumHandles', retval('int'), [])
mod.add_function('Slice_bool_CTor', retval('int64_t'), [])
mod.add_function('Slice_bool_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_bool_elem', retval('bool'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_bool_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_bool_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('bool', 'value')])
mod.add_function('Slice_bool_append', None, [param('int64_t', 'handle'), param('bool', 'value')])
mod.add_function('Slice_byte_CTor', retval('int64_t'), [])
mod.add_function('Slice_byte_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_byte_elem', retval('uint8_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_byte_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_byte_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('uint8_t', 'value')])
mod.add_function('Slice_byte_append', None, [param('int64_t', 'handle'), param('uint8_t', 'value')])
mod.add_function('Slice_byte_from_bytes', retval('int64_t'), [param('PyObject*', 'o', transfer_ownership=False)])
mod.add_function('Slice_byte_to_bytes', retval('PyObject*', caller_owns_return=True), [param('int64_t', 'handle')])
mod.add_function('Slice_error_CTor', retval('int64_t'), [])
mod.add_function('Slice_error_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_error_elem', retval('char*'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_error_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_error_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('char*', 'value')])
mod.add_function('Slice_error_append', None, [param('int64_t', 'handle'), param('char*', 'value')])
mod.add_function('Slice_float32_CTor', retval('int64_t'), [])
mod.add_function('Slice_float32_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_float32_elem', retval('float'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_float32_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_float32_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('float', 'value')])
mod.add_function('Slice_float32_append', None, [param('int64_t', 'handle'), param('float', 'value')])
mod.add_function('Slice_float64_CTor', retval('int64_t'), [])
mod.add_function('Slice_float64_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_float64_elem', retval('double'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_float64_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_float64_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('double', 'value')])
mod.add_function('Slice_float64_append', None, [param('int64_t', 'handle'), param('double', 'value')])
mod.add_function('Slice_int_CTor', retval('int64_t'), [])
mod.add_function('Slice_int_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_int_elem', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_int_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_int_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int64_t', 'value')])
mod.add_function('Slice_int_append', None, [param('int64_t', 'handle'), param('int64_t', 'value')])
mod.add_function('Slice_int16_CTor', retval('int64_t'), [])
mod.add_function('Slice_int16_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_int16_elem', retval('int16_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_int16_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_int16_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int16_t', 'value')])
mod.add_function('Slice_int16_append', None, [param('int64_t', 'handle'), param('int16_t', 'value')])
mod.add_function('Slice_int32_CTor', retval('int64_t'), [])
mod.add_function('Slice_int32_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_int32_elem', retval('int32_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_int32_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_int32_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int32_t', 'value')])
mod.add_function('Slice_int32_append', None, [param('int64_t', 'handle'), param('int32_t', 'value')])
mod.add_function('Slice_int64_CTor', retval('int64_t'), [])
mod.add_function('Slice_int64_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_int64_elem', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_int64_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_int64_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int64_t', 'value')])
mod.add_function('Slice_int64_append', None, [param('int64_t', 'handle'), param('int64_t', 'value')])
mod.add_function('Slice_int8_CTor', retval('int64_t'), [])
mod.add_function('Slice_int8_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_int8_elem', retval('int8_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_int8_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_int8_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int8_t', 'value')])
mod.add_function('Slice_int8_append', None, [param('int64_t', 'handle'), param('int8_t', 'value')])
mod.add_function('Slice_rune_CTor', retval('int64_t'), [])
mod.add_function('Slice_rune_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_rune_elem', retval('int32_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_rune_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_rune_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int32_t', 'value')])
mod.add_function('Slice_rune_append', None, [param('int64_t', 'handle'), param('int32_t', 'value')])
mod.add_function('Slice_string_CTor', retval('int64_t'), [])
mod.add_function('Slice_string_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_string_elem', retval('char*'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_string_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_string_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('char*', 'value')])
mod.add_function('Slice_string_append', None, [param('int64_t', 'handle'), param('char*', 'value')])
mod.add_function('Slice_uint_CTor', retval('int64_t'), [])
mod.add_function('Slice_uint_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_uint_elem', retval('uint64_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_uint_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_uint_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('uint64_t', 'value')])
mod.add_function('Slice_uint_append', None, [param('int64_t', 'handle'), param('uint64_t', 'value')])
mod.add_function('Slice_uint16_CTor', retval('int64_t'), [])
mod.add_function('Slice_uint16_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_uint16_elem', retval('uint16_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_uint16_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_uint16_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('uint16_t', 'value')])
mod.add_function('Slice_uint16_append', None, [param('int64_t', 'handle'), param('uint16_t', 'value')])
mod.add_function('Slice_uint32_CTor', retval('int64_t'), [])
mod.add_function('Slice_uint32_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_uint32_elem', retval('uint32_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_uint32_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_uint32_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('uint32_t', 'value')])
mod.add_function('Slice_uint32_append', None, [param('int64_t', 'handle'), param('uint32_t', 'value')])
mod.add_function('Slice_uint64_CTor', retval('int64_t'), [])
mod.add_function('Slice_uint64_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_uint64_elem', retval('uint64_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_uint64_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_uint64_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('uint64_t', 'value')])
mod.add_function('Slice_uint64_append', None, [param('int64_t', 'handle'), param('uint64_t', 'value')])
mod.add_function('Slice_uint8_CTor', retval('int64_t'), [])
mod.add_function('Slice_uint8_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_uint8_elem', retval('uint8_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_uint8_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_uint8_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('uint8_t', 'value')])
mod.add_function('Slice_uint8_append', None, [param('int64_t', 'handle'), param('uint8_t', 'value')])
mod.add_function('Slice_whatsapp_Attachment_CTor', retval('int64_t'), [])
mod.add_function('Slice_whatsapp_Attachment_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_whatsapp_Attachment_elem', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_whatsapp_Attachment_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_whatsapp_Attachment_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int64_t', 'value')])
mod.add_function('Slice_whatsapp_Attachment_append', None, [param('int64_t', 'handle'), param('int64_t', 'value')])
mod.add_function('Slice_whatsapp_Contact_CTor', retval('int64_t'), [])
mod.add_function('Slice_whatsapp_Contact_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_whatsapp_Contact_elem', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_whatsapp_Contact_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_whatsapp_Contact_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int64_t', 'value')])
mod.add_function('Slice_whatsapp_Contact_append', None, [param('int64_t', 'handle'), param('int64_t', 'value')])
mod.add_function('Slice_whatsapp_Group_CTor', retval('int64_t'), [])
mod.add_function('Slice_whatsapp_Group_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_whatsapp_Group_elem', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_whatsapp_Group_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_whatsapp_Group_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int64_t', 'value')])
mod.add_function('Slice_whatsapp_Group_append', None, [param('int64_t', 'handle'), param('int64_t', 'value')])
mod.add_function('Slice_whatsapp_GroupParticipant_CTor', retval('int64_t'), [])
mod.add_function('Slice_whatsapp_GroupParticipant_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_whatsapp_GroupParticipant_elem', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_whatsapp_GroupParticipant_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_whatsapp_GroupParticipant_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int64_t', 'value')])
mod.add_function('Slice_whatsapp_GroupParticipant_append', None, [param('int64_t', 'handle'), param('int64_t', 'value')])
mod.add_function('Slice_whatsapp_Message_CTor', retval('int64_t'), [])
mod.add_function('Slice_whatsapp_Message_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_whatsapp_Message_elem', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_whatsapp_Message_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_whatsapp_Message_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int64_t', 'value')])
mod.add_function('Slice_whatsapp_Message_append', None, [param('int64_t', 'handle'), param('int64_t', 'value')])
mod.add_function('Slice_whatsapp_PollOption_CTor', retval('int64_t'), [])
mod.add_function('Slice_whatsapp_PollOption_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_whatsapp_PollOption_elem', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_whatsapp_PollOption_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_whatsapp_PollOption_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int64_t', 'value')])
mod.add_function('Slice_whatsapp_PollOption_append', None, [param('int64_t', 'handle'), param('int64_t', 'value')])
mod.add_function('Slice_whatsapp_Receipt_CTor', retval('int64_t'), [])
mod.add_function('Slice_whatsapp_Receipt_len', retval('int'), [param('int64_t', 'handle')])
mod.add_function('Slice_whatsapp_Receipt_elem', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'idx')])
mod.add_function('Slice_whatsapp_Receipt_subslice', retval('int64_t'), [param('int64_t', 'handle'), param('int', 'st'), param('int', 'ed')])
mod.add_function('Slice_whatsapp_Receipt_set', None, [param('int64_t', 'handle'), param('int', 'idx'), param('int64_t', 'value')])
mod.add_function('Slice_whatsapp_Receipt_append', None, [param('int64_t', 'handle'), param('int64_t', 'value')])
mod.add_function('whatsapp_Connect_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_Connect_JID_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Connect_JID_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Connect_Error_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Connect_Error_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_EventPayload_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_EventPayload_QRCode_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_EventPayload_QRCode_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_EventPayload_PairDeviceID_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_EventPayload_PairDeviceID_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_EventPayload_Connect_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_EventPayload_Connect_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_EventPayload_LoggedOut_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_EventPayload_LoggedOut_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_EventPayload_Contact_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_EventPayload_Contact_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_EventPayload_Presence_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_EventPayload_Presence_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_EventPayload_Message_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_EventPayload_Message_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_EventPayload_ChatState_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_EventPayload_ChatState_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_EventPayload_Receipt_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_EventPayload_Receipt_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_EventPayload_Group_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_EventPayload_Group_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_EventPayload_Call_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_EventPayload_Call_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Message_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_Message_Kind_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_Kind_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Message_ID_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_ID_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Message_JID_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_JID_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Message_GroupJID_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_GroupJID_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Message_OriginJID_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_OriginJID_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Message_Body_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_Body_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Message_Timestamp_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_Timestamp_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Message_IsCarbon_Get', retval('bool'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_IsCarbon_Set', None, [param('int64_t', 'handle'), param('bool', 'val')])
mod.add_function('whatsapp_Message_IsForwarded_Get', retval('bool'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_IsForwarded_Set', None, [param('int64_t', 'handle'), param('bool', 'val')])
mod.add_function('whatsapp_Message_ReplyID_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_ReplyID_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Message_ReplyBody_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_ReplyBody_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Message_Attachments_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_Attachments_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Message_Preview_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_Preview_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Message_Location_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_Location_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Message_Poll_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_Poll_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Message_Album_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_Album_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Message_GroupInvite_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_GroupInvite_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Message_MentionJIDs_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_MentionJIDs_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Message_Receipts_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_Receipts_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Message_Reactions_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_Reactions_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Message_IsHistory_Get', retval('bool'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Message_IsHistory_Set', None, [param('int64_t', 'handle'), param('bool', 'val')])
mod.add_function('whatsapp_Presence_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_Presence_JID_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Presence_JID_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Presence_Kind_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Presence_Kind_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Presence_LastSeen_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Presence_LastSeen_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Session_CTor', retval('int64_t'), [])
add_checked_function(mod, 'whatsapp_Session_Login', retval('char*'), [param('int64_t', '_handle')])
add_checked_function(mod, 'whatsapp_Session_Logout', retval('char*'), [param('int64_t', '_handle')])
add_checked_function(mod, 'whatsapp_Session_Disconnect', retval('char*'), [param('int64_t', '_handle')])
add_checked_string_function(mod, 'whatsapp_Session_PairPhone', retval('char*'), [param('int64_t', '_handle'), param('char*', 'phone')])
add_checked_function(mod, 'whatsapp_Session_SendMessage', retval('char*'), [param('int64_t', '_handle'), param('int64_t', 'message')])
add_checked_string_function(mod, 'whatsapp_Session_GenerateMessageID', retval('char*'), [param('int64_t', '_handle')])
add_checked_function(mod, 'whatsapp_Session_SendChatState', retval('char*'), [param('int64_t', '_handle'), param('int64_t', 'state')])
add_checked_function(mod, 'whatsapp_Session_SendReceipt', retval('char*'), [param('int64_t', '_handle'), param('int64_t', 'receipt')])
add_checked_function(mod, 'whatsapp_Session_SendPresence', retval('char*'), [param('int64_t', '_handle'), param('int64_t', 'presence'), param('char*', 'statusMessage')])
add_checked_function(mod, 'whatsapp_Session_GetContacts', retval('int64_t'), [param('int64_t', '_handle'), param('bool', 'refresh')])
add_checked_function(mod, 'whatsapp_Session_GetGroups', retval('int64_t'), [param('int64_t', '_handle')])
add_checked_function(mod, 'whatsapp_Session_CreateGroup', retval('int64_t'), [param('int64_t', '_handle'), param('char*', 'name'), param('int64_t', 'participants')])
add_checked_function(mod, 'whatsapp_Session_LeaveGroup', retval('char*'), [param('int64_t', '_handle'), param('char*', 'resourceID')])
add_checked_function(mod, 'whatsapp_Session_GetAvatar', retval('int64_t'), [param('int64_t', '_handle'), param('char*', 'resourceID'), param('char*', 'avatarID')])
add_checked_string_function(mod, 'whatsapp_Session_SetAvatar', retval('char*'), [param('int64_t', '_handle'), param('char*', 'resourceID'), param('int64_t', 'avatar')])
add_checked_function(mod, 'whatsapp_Session_SetGroupName', retval('char*'), [param('int64_t', '_handle'), param('char*', 'resourceID'), param('char*', 'name')])
add_checked_function(mod, 'whatsapp_Session_SetGroupTopic', retval('char*'), [param('int64_t', '_handle'), param('char*', 'resourceID'), param('char*', 'topic')])
add_checked_function(mod, 'whatsapp_Session_UpdateGroupParticipants', retval('int64_t'), [param('int64_t', '_handle'), param('char*', 'resourceID'), param('int64_t', 'participants')])
add_checked_function(mod, 'whatsapp_Session_FindContact', retval('int64_t'), [param('int64_t', '_handle'), param('char*', 'phone')])
add_checked_function(mod, 'whatsapp_Session_RequestMessageHistory', retval('char*'), [param('int64_t', '_handle'), param('char*', 'resourceID'), param('int64_t', 'oldestMessage')])
add_checked_function(mod, 'whatsapp_Session_SetEventHandler', None, [param('int64_t', '_handle'), param('PyObject*', 'h', transfer_ownership=False), param('bool', 'goRun')])
mod.add_function('whatsapp_Attachment_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_Attachment_MIME_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Attachment_MIME_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Attachment_Filename_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Attachment_Filename_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Attachment_Caption_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Attachment_Caption_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Attachment_Data_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Attachment_Data_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
add_checked_function(mod, 'whatsapp_Attachment_GetSpec', retval('int64_t'), [param('int64_t', '_handle'), param('int64_t', 'ctx')])
mod.add_function('whatsapp_Group_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_Group_JID_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Group_JID_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Group_Name_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Group_Name_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Group_Subject_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Group_Subject_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Group_Nickname_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Group_Nickname_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Group_Participants_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Group_Participants_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Group_InviteCode_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Group_InviteCode_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_GroupParticipant_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_GroupParticipant_JID_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_GroupParticipant_JID_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_GroupParticipant_Nickname_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_GroupParticipant_Nickname_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_GroupParticipant_Affiliation_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_GroupParticipant_Affiliation_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_GroupParticipant_Action_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_GroupParticipant_Action_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Receipt_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_Receipt_Kind_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Receipt_Kind_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Receipt_MessageIDs_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Receipt_MessageIDs_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Receipt_JID_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Receipt_JID_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Receipt_GroupJID_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Receipt_GroupJID_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Receipt_Timestamp_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Receipt_Timestamp_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Receipt_IsCarbon_Get', retval('bool'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Receipt_IsCarbon_Set', None, [param('int64_t', 'handle'), param('bool', 'val')])
mod.add_function('whatsapp_Album_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_Album_IsAlbum_Get', retval('bool'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Album_IsAlbum_Set', None, [param('int64_t', 'handle'), param('bool', 'val')])
mod.add_function('whatsapp_Album_ImageCount_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Album_ImageCount_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Album_VideoCount_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Album_VideoCount_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Call_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_Call_State_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Call_State_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Call_JID_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Call_JID_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Call_Timestamp_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Call_Timestamp_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Gateway_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_Gateway_DBPath_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Gateway_DBPath_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Gateway_Name_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Gateway_Name_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Gateway_LogLevel_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Gateway_LogLevel_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Gateway_TempDir_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Gateway_TempDir_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
add_checked_function(mod, 'whatsapp_Gateway_Init', retval('char*'), [param('int64_t', '_handle')])
add_checked_function(mod, 'whatsapp_Gateway_NewSession', retval('int64_t'), [param('int64_t', '_handle'), param('int64_t', 'device')])
add_checked_function(mod, 'whatsapp_Gateway_CleanupSession', retval('char*'), [param('int64_t', '_handle'), param('int64_t', 'device')])
mod.add_function('whatsapp_GroupSubject_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_GroupSubject_Subject_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_GroupSubject_Subject_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_GroupSubject_SetAt_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_GroupSubject_SetAt_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_GroupSubject_SetBy_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_GroupSubject_SetBy_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_LinkedDevice_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_LinkedDevice_ID_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_LinkedDevice_ID_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
add_checked_function(mod, 'whatsapp_LinkedDevice_JID', retval('int64_t'), [param('int64_t', '_handle')])
mod.add_function('whatsapp_Location_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_Location_Latitude_Get', retval('double'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Location_Latitude_Set', None, [param('int64_t', 'handle'), param('double', 'val')])
mod.add_function('whatsapp_Location_Longitude_Get', retval('double'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Location_Longitude_Set', None, [param('int64_t', 'handle'), param('double', 'val')])
mod.add_function('whatsapp_Location_Accuracy_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Location_Accuracy_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Location_IsLive_Get', retval('bool'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Location_IsLive_Set', None, [param('int64_t', 'handle'), param('bool', 'val')])
mod.add_function('whatsapp_Location_Name_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Location_Name_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Location_Address_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Location_Address_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Location_URL_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Location_URL_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_PollOption_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_PollOption_Title_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_PollOption_Title_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Preview_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_Preview_Kind_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Preview_Kind_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Preview_URL_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Preview_URL_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Preview_Title_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Preview_Title_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Preview_Description_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Preview_Description_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Preview_Thumbnail_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Preview_Thumbnail_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_ChatState_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_ChatState_Kind_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_ChatState_Kind_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_ChatState_JID_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_ChatState_JID_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_ChatState_GroupJID_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_ChatState_GroupJID_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Contact_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_Contact_JID_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Contact_JID_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Contact_Name_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Contact_Name_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_LoggedOut_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_LoggedOut_Reason_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_LoggedOut_Reason_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Poll_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_Poll_Title_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Poll_Title_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Poll_Options_Get', retval('int64_t'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Poll_Options_Set', None, [param('int64_t', 'handle'), param('int64_t', 'val')])
mod.add_function('whatsapp_Avatar_CTor', retval('int64_t'), [])
mod.add_function('whatsapp_Avatar_ID_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Avatar_ID_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
mod.add_function('whatsapp_Avatar_URL_Get', retval('char*'), [param('int64_t', 'handle')])
mod.add_function('whatsapp_Avatar_URL_Set', None, [param('int64_t', 'handle'), param('char*', 'val')])
add_checked_function(mod, 'whatsapp_NewGateway', retval('int64_t'), [])
add_checked_function(mod, 'whatsapp_IsAnonymousJID', retval('bool'), [param('char*', 'id')])

mod.generate(open('whatsapp.c', 'w'))

