import logging

from investing_algorithm_framework.infrastructure.models import \
    SQLTradeStopLoss

from .repository import Repository

logger = logging.getLogger("investing_algorithm_framework")


class SQLTradeStopLossRepository(Repository):
    base_class = SQLTradeStopLoss
    DEFAULT_NOT_FOUND_MESSAGE = "The requested trade stop loss was not found"

    def _apply_query_params(self, db, query, query_params):
        trade_query_param = self.get_query_param("trade_id", query_params)
        triggered_query_param = self.get_query_param(
            "triggered", query_params
        )

        if trade_query_param:
            query = query.filter(
                SQLTradeStopLoss.trade_id == trade_query_param
            )

        if triggered_query_param is not None:
            query = query.filter_by(triggered=triggered_query_param)

        return query
