# AUTOGENERATED! DO NOT EDIT! File to edit: ../nbs/api/08_oauth.ipynb.

# %% auto 0
__all__ = ['GoogleAppClient', 'GitHubAppClient', 'HuggingFaceClient', 'DiscordAppClient']

# %% ../nbs/api/08_oauth.ipynb
from .common import *
from oauthlib.oauth2 import WebApplicationClient
from urllib.parse import urlencode, parse_qs, quote, unquote
from httpx import get, post
import secrets

# %% ../nbs/api/08_oauth.ipynb
class _AppClient(WebApplicationClient):
    def __init__(self, client_id, client_secret, redirect_uri, code=None, scope=None, **kwargs):
        super().__init__(client_id, code=code, scope=scope, **kwargs)
        self.client_secret,self.redirect_uri = client_secret,redirect_uri

# %% ../nbs/api/08_oauth.ipynb
class GoogleAppClient(_AppClient):
    "A `WebApplicationClient` for Google oauth2"
    base_url = "https://accounts.google.com/o/oauth2/v2/auth"
    token_url = "https://www.googleapis.com/oauth2/v4/token"
    info_url = "https://www.googleapis.com/oauth2/v3/userinfo"
    id_key = 'sub'
    
    def __init__(self, client_id, client_secret, redirect_uri=None, redirect_uris=None, code=None, scope=None, **kwargs):
        if redirect_uris and not redirect_uri: redirect_uri = redirect_uris[0]
        scope_pre = "https://www.googleapis.com/auth/userinfo"
        if not scope: scope=["openid", f"{scope_pre}.email", f"{scope_pre}.profile"]
        super().__init__(client_id, client_secret, redirect_uri, code=code, scope=scope, **kwargs)

# %% ../nbs/api/08_oauth.ipynb
class GitHubAppClient(_AppClient):
    "A `WebApplicationClient` for GitHub oauth2"
    base_url = "https://github.com/login/oauth/authorize"
    token_url = "https://github.com/login/oauth/access_token"
    info_url = "https://api.github.com/user"
    id_key = 'id'

    def __init__(self, client_id, client_secret, redirect_uri, code=None, scope=None, **kwargs):
        if not scope: scope="user"
        super().__init__(client_id, client_secret, redirect_uri, code=code, scope=scope, **kwargs)

# %% ../nbs/api/08_oauth.ipynb
class HuggingFaceClient(_AppClient):
    "A `WebApplicationClient` for HuggingFace oauth2"

    base_url = "https://huggingface.co/oauth/authorize"
    token_url = "https://huggingface.co/oauth/token"
    info_url = "https://huggingface.co/oauth/userinfo"
    id_key = 'sub'
    
    def __init__(self, client_id, client_secret, redirect_uri=None, redirect_uris=None, code=None, scope=None, state=None, **kwargs):
        if redirect_uris and not redirect_uri: redirect_uri = redirect_uris[0]
        if not scope: scope=["openid","profile"]
        if not state: state=secrets.token_urlsafe(16)
        super().__init__(client_id, client_secret, redirect_uri, code=code, scope=scope, state=state, **kwargs)

# %% ../nbs/api/08_oauth.ipynb
class DiscordAppClient(_AppClient):
    "A `WebApplicationClient` for Discord oauth2"
    base_url = "https://discord.com/oauth2/authorize"
    token_url = "https://discord.com/api/oauth2/token"
    revoke_url = "https://discord.com/api/oauth2/token/revoke"
    id_key = 'id'

    def __init__(self, client_id, client_secret, redirect_uri, is_user=False, perms=0, scope=None, **kwargs):
        if not scope: scope="applications.commands applications.commands.permissions.update identify"
        self.integration_type = 1 if is_user else 0
        self.perms = perms
        super().__init__(client_id, client_secret, redirect_uri, scope=scope, **kwargs)

    def login_link(self):
        d = dict(response_type='code', client_id=self.client_id,
                 integration_type=self.integration_type, scope=self.scope,
                 redirect_uri=self.redirect_uri) #, permissions=self.perms, prompt='consent')
        return f'{self.base_url}?' + urlencode(d)

    def parse_response(self, code):
        headers = {'Content-Type': 'application/x-www-form-urlencoded'}
        data = dict(grant_type='authorization_code', code=code, redirect_uri=self.redirect_uri)
        r = post(self.token_url, data=data, headers=headers, auth=(self.client_id, self.client_secret))
        r.raise_for_status()
        self.parse_request_body_response(r.text)

# %% ../nbs/api/08_oauth.ipynb
@patch
def login_link(self:WebApplicationClient, scope=None):
    "Get a login link for this client"
    if not scope: scope=self.scope
    return self.prepare_request_uri(self.base_url, self.redirect_uri, scope)

# %% ../nbs/api/08_oauth.ipynb
@patch
def login_link_with_state(self:WebApplicationClient, scope=None, state=None):
    "Get a login link for this client"
    if not scope: scope=self.scope
    if not state: state=self.state
    return self.prepare_request_uri(self.base_url, self.redirect_uri, scope, state)

# %% ../nbs/api/08_oauth.ipynb
@patch
def parse_response(self:_AppClient, code):
    "Get the token from the oauth2 server response"
    payload = dict(code=code, redirect_uri=self.redirect_uri, client_id=self.client_id,
                   client_secret=self.client_secret, grant_type='authorization_code')
    r = post(self.token_url, json=payload)
    r.raise_for_status()
    self.parse_request_body_response(r.text)

# %% ../nbs/api/08_oauth.ipynb
@patch
def get_info(self:_AppClient):
    "Get the info for authenticated user"
    headers = {'Authorization': f'Bearer {self.token["access_token"]}'}
    return get(self.info_url, headers=headers).json()

# %% ../nbs/api/08_oauth.ipynb
@patch
def retr_info(self:_AppClient, code):
    "Combines `parse_response` and `get_info`"
    self.parse_response(code)
    return self.get_info()

# %% ../nbs/api/08_oauth.ipynb
@patch
def retr_id(self:_AppClient, code):
    "Call `retr_info` and then return id/subscriber value"
    return self.retr_info(code)[self.id_key]
