/*
 * Decompiled with CFR 0.152.
 */
package com.javonet.core.delegatecache;

import java.lang.reflect.Method;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class DelegatesCache {
    private static final DelegatesCache INSTANCE = new DelegatesCache();
    private static final ConcurrentMap<String, Method> DELEGATES_CACHE = new ConcurrentHashMap<String, Method>();

    private DelegatesCache() {
    }

    public static DelegatesCache getInstance() {
        return INSTANCE;
    }

    public String addDelegate(Method delegateInstance) {
        String delegateId = UUID.randomUUID().toString();
        DELEGATES_CACHE.put(delegateId, delegateInstance);
        return delegateId;
    }

    public Method getDelegate(String delegateId) {
        Method delegateInstance = (Method)DELEGATES_CACHE.get(delegateId);
        if (delegateInstance == null) {
            throw new IllegalArgumentException("Delegate not found");
        }
        return delegateInstance;
    }
}

