# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetComputeCapacityTopologyResult',
    'AwaitableGetComputeCapacityTopologyResult',
    'get_compute_capacity_topology',
    'get_compute_capacity_topology_output',
]

@pulumi.output_type
class GetComputeCapacityTopologyResult:
    """
    A collection of values returned by getComputeCapacityTopology.
    """
    def __init__(__self__, availability_domain=None, capacity_sources=None, compartment_id=None, compute_capacity_topology_id=None, defined_tags=None, display_name=None, freeform_tags=None, id=None, state=None, time_created=None, time_updated=None):
        if availability_domain and not isinstance(availability_domain, str):
            raise TypeError("Expected argument 'availability_domain' to be a str")
        pulumi.set(__self__, "availability_domain", availability_domain)
        if capacity_sources and not isinstance(capacity_sources, list):
            raise TypeError("Expected argument 'capacity_sources' to be a list")
        pulumi.set(__self__, "capacity_sources", capacity_sources)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compute_capacity_topology_id and not isinstance(compute_capacity_topology_id, str):
            raise TypeError("Expected argument 'compute_capacity_topology_id' to be a str")
        pulumi.set(__self__, "compute_capacity_topology_id", compute_capacity_topology_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The availability domain of the compute capacity topology.  Example: `Uocm:US-CHICAGO-1-AD-2`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="capacitySources")
    def capacity_sources(self) -> Sequence['outputs.GetComputeCapacityTopologyCapacitySourceResult']:
        """
        A capacity source of bare metal hosts.
        """
        return pulumi.get(self, "capacity_sources")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment that contains the compute capacity topology.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="computeCapacityTopologyId")
    def compute_capacity_topology_id(self) -> str:
        return pulumi.get(self, "compute_capacity_topology_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, str]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, str]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute capacity topology.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the compute capacity topology.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time that the compute capacity topology was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The date and time that the compute capacity topology was updated, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetComputeCapacityTopologyResult(GetComputeCapacityTopologyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetComputeCapacityTopologyResult(
            availability_domain=self.availability_domain,
            capacity_sources=self.capacity_sources,
            compartment_id=self.compartment_id,
            compute_capacity_topology_id=self.compute_capacity_topology_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            freeform_tags=self.freeform_tags,
            id=self.id,
            state=self.state,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_compute_capacity_topology(compute_capacity_topology_id: Optional[str] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetComputeCapacityTopologyResult:
    """
    This data source provides details about a specific Compute Capacity Topology resource in Oracle Cloud Infrastructure Core service.

    Gets information about the specified compute capacity topology.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_capacity_topology = oci.Core.get_compute_capacity_topology(compute_capacity_topology_id=test_compute_capacity_topology_oci_core_compute_capacity_topology["id"])
    ```


    :param str compute_capacity_topology_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute capacity topology.
    """
    __args__ = dict()
    __args__['computeCapacityTopologyId'] = compute_capacity_topology_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getComputeCapacityTopology:getComputeCapacityTopology', __args__, opts=opts, typ=GetComputeCapacityTopologyResult).value

    return AwaitableGetComputeCapacityTopologyResult(
        availability_domain=pulumi.get(__ret__, 'availability_domain'),
        capacity_sources=pulumi.get(__ret__, 'capacity_sources'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compute_capacity_topology_id=pulumi.get(__ret__, 'compute_capacity_topology_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))
def get_compute_capacity_topology_output(compute_capacity_topology_id: Optional[pulumi.Input[str]] = None,
                                         opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetComputeCapacityTopologyResult]:
    """
    This data source provides details about a specific Compute Capacity Topology resource in Oracle Cloud Infrastructure Core service.

    Gets information about the specified compute capacity topology.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_compute_capacity_topology = oci.Core.get_compute_capacity_topology(compute_capacity_topology_id=test_compute_capacity_topology_oci_core_compute_capacity_topology["id"])
    ```


    :param str compute_capacity_topology_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compute capacity topology.
    """
    __args__ = dict()
    __args__['computeCapacityTopologyId'] = compute_capacity_topology_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Core/getComputeCapacityTopology:getComputeCapacityTopology', __args__, opts=opts, typ=GetComputeCapacityTopologyResult)
    return __ret__.apply(lambda __response__: GetComputeCapacityTopologyResult(
        availability_domain=pulumi.get(__response__, 'availability_domain'),
        capacity_sources=pulumi.get(__response__, 'capacity_sources'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        compute_capacity_topology_id=pulumi.get(__response__, 'compute_capacity_topology_id'),
        defined_tags=pulumi.get(__response__, 'defined_tags'),
        display_name=pulumi.get(__response__, 'display_name'),
        freeform_tags=pulumi.get(__response__, 'freeform_tags'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated')))
