# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetWorkspaceApplicationPatchesResult',
    'AwaitableGetWorkspaceApplicationPatchesResult',
    'get_workspace_application_patches',
    'get_workspace_application_patches_output',
]

@pulumi.output_type
class GetWorkspaceApplicationPatchesResult:
    """
    A collection of values returned by getWorkspaceApplicationPatches.
    """
    def __init__(__self__, application_key=None, fields=None, filters=None, id=None, identifiers=None, name=None, patch_summary_collections=None, workspace_id=None):
        if application_key and not isinstance(application_key, str):
            raise TypeError("Expected argument 'application_key' to be a str")
        pulumi.set(__self__, "application_key", application_key)
        if fields and not isinstance(fields, list):
            raise TypeError("Expected argument 'fields' to be a list")
        pulumi.set(__self__, "fields", fields)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if identifiers and not isinstance(identifiers, list):
            raise TypeError("Expected argument 'identifiers' to be a list")
        pulumi.set(__self__, "identifiers", identifiers)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if patch_summary_collections and not isinstance(patch_summary_collections, list):
            raise TypeError("Expected argument 'patch_summary_collections' to be a list")
        pulumi.set(__self__, "patch_summary_collections", patch_summary_collections)
        if workspace_id and not isinstance(workspace_id, str):
            raise TypeError("Expected argument 'workspace_id' to be a str")
        pulumi.set(__self__, "workspace_id", workspace_id)

    @property
    @pulumi.getter(name="applicationKey")
    def application_key(self) -> str:
        return pulumi.get(self, "application_key")

    @property
    @pulumi.getter
    def fields(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetWorkspaceApplicationPatchesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def identifiers(self) -> Optional[Sequence[str]]:
        """
        Value can only contain upper case letters, underscore and numbers. It should begin with upper case letter or underscore. The value can be modified.
        """
        return pulumi.get(self, "identifiers")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Free form text without any restriction on permitted characters. Name can have letters, numbers, and special characters. The value is editable and is restricted to 1000 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="patchSummaryCollections")
    def patch_summary_collections(self) -> Sequence['outputs.GetWorkspaceApplicationPatchesPatchSummaryCollectionResult']:
        """
        The list of patch_summary_collection.
        """
        return pulumi.get(self, "patch_summary_collections")

    @property
    @pulumi.getter(name="workspaceId")
    def workspace_id(self) -> str:
        return pulumi.get(self, "workspace_id")


class AwaitableGetWorkspaceApplicationPatchesResult(GetWorkspaceApplicationPatchesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetWorkspaceApplicationPatchesResult(
            application_key=self.application_key,
            fields=self.fields,
            filters=self.filters,
            id=self.id,
            identifiers=self.identifiers,
            name=self.name,
            patch_summary_collections=self.patch_summary_collections,
            workspace_id=self.workspace_id)


def get_workspace_application_patches(application_key: Optional[str] = None,
                                      fields: Optional[Sequence[str]] = None,
                                      filters: Optional[Sequence[Union['GetWorkspaceApplicationPatchesFilterArgs', 'GetWorkspaceApplicationPatchesFilterArgsDict']]] = None,
                                      identifiers: Optional[Sequence[str]] = None,
                                      name: Optional[str] = None,
                                      workspace_id: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetWorkspaceApplicationPatchesResult:
    """
    This data source provides the list of Workspace Application Patches in Oracle Cloud Infrastructure Data Integration service.

    Retrieves a list of patches in an application and provides options to filter the list. For listing changes based on a period and logical objects changed, see ListPatchChanges API.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_workspace_application_patches = oci.DataIntegration.get_workspace_application_patches(application_key=workspace_application_patch_application_key,
        workspace_id=test_workspace["id"],
        fields=workspace_application_patch_fields,
        identifiers=workspace_application_patch_identifier,
        name=workspace_application_patch_name)
    ```


    :param str application_key: The application key.
    :param Sequence[str] fields: Specifies the fields to get for an object.
    :param Sequence[str] identifiers: Used to filter by the identifier of the published object.
    :param str name: Used to filter by the name of the object.
    :param str workspace_id: The workspace ID.
    """
    __args__ = dict()
    __args__['applicationKey'] = application_key
    __args__['fields'] = fields
    __args__['filters'] = filters
    __args__['identifiers'] = identifiers
    __args__['name'] = name
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataIntegration/getWorkspaceApplicationPatches:getWorkspaceApplicationPatches', __args__, opts=opts, typ=GetWorkspaceApplicationPatchesResult).value

    return AwaitableGetWorkspaceApplicationPatchesResult(
        application_key=pulumi.get(__ret__, 'application_key'),
        fields=pulumi.get(__ret__, 'fields'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        identifiers=pulumi.get(__ret__, 'identifiers'),
        name=pulumi.get(__ret__, 'name'),
        patch_summary_collections=pulumi.get(__ret__, 'patch_summary_collections'),
        workspace_id=pulumi.get(__ret__, 'workspace_id'))
def get_workspace_application_patches_output(application_key: Optional[pulumi.Input[str]] = None,
                                             fields: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                             filters: Optional[pulumi.Input[Optional[Sequence[Union['GetWorkspaceApplicationPatchesFilterArgs', 'GetWorkspaceApplicationPatchesFilterArgsDict']]]]] = None,
                                             identifiers: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                             name: Optional[pulumi.Input[Optional[str]]] = None,
                                             workspace_id: Optional[pulumi.Input[str]] = None,
                                             opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetWorkspaceApplicationPatchesResult]:
    """
    This data source provides the list of Workspace Application Patches in Oracle Cloud Infrastructure Data Integration service.

    Retrieves a list of patches in an application and provides options to filter the list. For listing changes based on a period and logical objects changed, see ListPatchChanges API.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_workspace_application_patches = oci.DataIntegration.get_workspace_application_patches(application_key=workspace_application_patch_application_key,
        workspace_id=test_workspace["id"],
        fields=workspace_application_patch_fields,
        identifiers=workspace_application_patch_identifier,
        name=workspace_application_patch_name)
    ```


    :param str application_key: The application key.
    :param Sequence[str] fields: Specifies the fields to get for an object.
    :param Sequence[str] identifiers: Used to filter by the identifier of the published object.
    :param str name: Used to filter by the name of the object.
    :param str workspace_id: The workspace ID.
    """
    __args__ = dict()
    __args__['applicationKey'] = application_key
    __args__['fields'] = fields
    __args__['filters'] = filters
    __args__['identifiers'] = identifiers
    __args__['name'] = name
    __args__['workspaceId'] = workspace_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataIntegration/getWorkspaceApplicationPatches:getWorkspaceApplicationPatches', __args__, opts=opts, typ=GetWorkspaceApplicationPatchesResult)
    return __ret__.apply(lambda __response__: GetWorkspaceApplicationPatchesResult(
        application_key=pulumi.get(__response__, 'application_key'),
        fields=pulumi.get(__response__, 'fields'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        identifiers=pulumi.get(__response__, 'identifiers'),
        name=pulumi.get(__response__, 'name'),
        patch_summary_collections=pulumi.get(__response__, 'patch_summary_collections'),
        workspace_id=pulumi.get(__response__, 'workspace_id')))
