# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetFleetDiagnosesResult',
    'AwaitableGetFleetDiagnosesResult',
    'get_fleet_diagnoses',
    'get_fleet_diagnoses_output',
]

@pulumi.output_type
class GetFleetDiagnosesResult:
    """
    A collection of values returned by getFleetDiagnoses.
    """
    def __init__(__self__, filters=None, fleet_diagnosis_collections=None, fleet_id=None, id=None):
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if fleet_diagnosis_collections and not isinstance(fleet_diagnosis_collections, list):
            raise TypeError("Expected argument 'fleet_diagnosis_collections' to be a list")
        pulumi.set(__self__, "fleet_diagnosis_collections", fleet_diagnosis_collections)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetFleetDiagnosesFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter(name="fleetDiagnosisCollections")
    def fleet_diagnosis_collections(self) -> Sequence['outputs.GetFleetDiagnosesFleetDiagnosisCollectionResult']:
        """
        The list of fleet_diagnosis_collection.
        """
        return pulumi.get(self, "fleet_diagnosis_collections")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> str:
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetFleetDiagnosesResult(GetFleetDiagnosesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetDiagnosesResult(
            filters=self.filters,
            fleet_diagnosis_collections=self.fleet_diagnosis_collections,
            fleet_id=self.fleet_id,
            id=self.id)


def get_fleet_diagnoses(filters: Optional[Sequence[Union['GetFleetDiagnosesFilterArgs', 'GetFleetDiagnosesFilterArgsDict']]] = None,
                        fleet_id: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetDiagnosesResult:
    """
    This data source provides the list of Fleet Diagnoses in Oracle Cloud Infrastructure Jms service.

    List potential diagnoses that would put a fleet into FAILED or NEEDS_ATTENTION lifecycle state.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_diagnoses = oci.Jms.get_fleet_diagnoses(fleet_id=test_fleet["id"])
    ```


    :param str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getFleetDiagnoses:getFleetDiagnoses', __args__, opts=opts, typ=GetFleetDiagnosesResult).value

    return AwaitableGetFleetDiagnosesResult(
        filters=pulumi.get(__ret__, 'filters'),
        fleet_diagnosis_collections=pulumi.get(__ret__, 'fleet_diagnosis_collections'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        id=pulumi.get(__ret__, 'id'))
def get_fleet_diagnoses_output(filters: Optional[pulumi.Input[Optional[Sequence[Union['GetFleetDiagnosesFilterArgs', 'GetFleetDiagnosesFilterArgsDict']]]]] = None,
                               fleet_id: Optional[pulumi.Input[str]] = None,
                               opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetFleetDiagnosesResult]:
    """
    This data source provides the list of Fleet Diagnoses in Oracle Cloud Infrastructure Jms service.

    List potential diagnoses that would put a fleet into FAILED or NEEDS_ATTENTION lifecycle state.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_diagnoses = oci.Jms.get_fleet_diagnoses(fleet_id=test_fleet["id"])
    ```


    :param str fleet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Fleet.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['fleetId'] = fleet_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Jms/getFleetDiagnoses:getFleetDiagnoses', __args__, opts=opts, typ=GetFleetDiagnosesResult)
    return __ret__.apply(lambda __response__: GetFleetDiagnosesResult(
        filters=pulumi.get(__response__, 'filters'),
        fleet_diagnosis_collections=pulumi.get(__response__, 'fleet_diagnosis_collections'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        id=pulumi.get(__response__, 'id')))
